/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.common.TransportConstants;
import com.ibm.ws.websvcs.transport.policyset.PolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.SSLPolicyTypeProvider;
import com.ibm.ws.websvcs.transport.policyset.jaxb.Policy;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.axis2.AxisFault;

public class PolicyValidation {
    private static PolicyValidation instance = new PolicyValidation();
    private static final TraceComponent _tc = Tr.register(PolicyValidation.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String CLASSNAME = SSLPolicyTypeProvider.class.getCanonicalName();
    private Policy _policy = null;

    public static PolicyValidation getInstance() {
        return instance;
    }

    public boolean validateFullPolicy(Properties existingAttrs) throws Exception {
        boolean valid = false;
        boolean invalid = false;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "PolicyValidation.validateFullPolicy()...");
        }
        if (existingAttrs != null && !existingAttrs.isEmpty()) {
            for (Object obj : existingAttrs.keySet()) {
                valid = false;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found attribute: " + obj);
                }
                for (int i = 0; i < TransportConstants.policyElements.length; ++i) {
                    if (!obj.toString().contains(TransportConstants.policyElements[i])) continue;
                    valid = true;
                    break;
                }
                int colonIndex = obj.toString().lastIndexOf(58);
                if (obj.toString().startsWith("properties_") && colonIndex != -1 && (obj.toString().substring(colonIndex + 1).equals("name") || obj.toString().substring(colonIndex + 1).equals("value"))) {
                    valid = true;
                }
                if (valid) continue;
                invalid = true;
                Tr.warning(_tc, "invalidAttr00", obj);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "PolicyValidation.validateFullPolicy()... : " + !invalid);
        }
        return !invalid;
    }

    protected boolean loadPolicy(String fileName) throws AxisFault {
        block7: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "loadPolicy fileName : " + fileName);
            }
            try {
                final ClassLoader cl = PolicyTypeFileHelper.class.getClassLoader();
                FileInputStream policyFileStream = new FileInputStream(fileName);
                JAXBContext jc = null;
                try {
                    jc = (JAXBContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            return JAXBContext.newInstance((String)"com.ibm.ws.websvcs.transport.policyset.jaxb", (ClassLoader)cl);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
                Unmarshaller um = jc.createUnmarshaller();
                Object obj = um.unmarshal((InputStream)policyFileStream);
                this._policy = null;
                if (!(obj instanceof Policy)) {
                    Object[] inserts = new Object[]{fileName};
                    String msg = NLSProvider.getNLS().getFormattedMessage("unmarObjNotPolicySet00", inserts, "The {0} unmarshaled object is not a policy object.");
                    Tr.error(_tc, "unmarObjNotPolicySet00", inserts);
                    throw new AxisFault(msg);
                }
                this._policy = (Policy)obj;
            }
            catch (Exception e) {
                FFDCFilter.processException(e, CLASSNAME, "1:207:1.2");
                if (!_tc.isDebugEnabled()) break block7;
                Tr.debug(_tc, "loadPolicy", "Exception caught during unmarshalling: " + e);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "loadPolicy returns true");
        }
        return true;
    }
}

