/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.ws.policyset.admin.PolicyTypeProvider;
import com.ibm.ws.websvcs.transport.policyset.JMSPolicyTypeFileHelper;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.websvcs.transport.policyset.PolicyValidation;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSPolicyTypeProvider
implements PolicyTypeProvider {
    private static final TraceComponent _tc = Tr.register(JMSPolicyTypeProvider.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public String getType() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSPolicyTypeProvider.getType()...", "JMSTransport");
        }
        return "JMSTransport";
    }

    @Override
    public Properties getAttributes(String policyFileName, Properties attributes, Map context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.getAttributes()...");
        }
        Properties result = this.performRead(policyFileName, attributes, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.getAttributes()", new Object[]{result});
        }
        return result;
    }

    @Override
    public Properties getBinding(String bindingFileName, Properties attributes, Map context) throws Exception {
        boolean filePresent = true;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.getBinding()...");
        }
        Properties result = new Properties();
        File file = new File(bindingFileName);
        if (file.length() == 0L) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "JMSPolicyTypeProvider.getBinding() - binding file is empty, returning without trying to load");
            }
            filePresent = false;
        }
        if (filePresent) {
            result = this.performRead(bindingFileName, attributes, true);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.getBinding()", new Object[]{result});
        }
        return result;
    }

    @Override
    public boolean setAttributes(String policyFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.setAttributes()...");
        }
        boolean success = this.performWrite(policyFileName, attributes, replace, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.setAttributes()", new Object[]{success});
        }
        return success;
    }

    @Override
    public boolean setBinding(String bindingFileName, Properties attributes, boolean replace, Map context) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.setBinding()...");
        }
        boolean success = this.performWrite(bindingFileName, attributes, replace, true);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.setBinding()", new Object[]{success});
        }
        return success;
    }

    @Override
    public boolean validate(String policySetFileName, String policyFileName, Session session, Map context) throws Exception {
        boolean result = false;
        Properties existingAttrs = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.validate()...", new Object[]{policySetFileName, policyFileName, session});
        }
        PolicyValidation policyValidate = PolicyValidation.getInstance();
        policyValidate.loadPolicy(policyFileName);
        existingAttrs = JMSPolicyTypeFileHelper.readPolicy(policyFileName);
        result = policyValidate.validateFullPolicy(existingAttrs);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.validate()", new Object[]{result});
        }
        return result;
    }

    private boolean performWrite(String filename, Properties attrs, boolean replace, boolean isBinding) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.performWrite()...", new Object[]{filename, replace, isBinding, PolicySetUtils.maskPasswords(attrs)});
        }
        boolean success = false;
        if (replace) {
            success = isBinding ? JMSPolicyTypeFileHelper.writePolicyBinding(filename, attrs) : JMSPolicyTypeFileHelper.writePolicy(filename, attrs);
        } else {
            Properties existingAttrs = null;
            Properties resultAttrs = new Properties();
            boolean filePresent = true;
            File file = new File(filename);
            if (file.length() == 0L) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "JMSPolicyTypeProvider.performWrite() - binding file is empty");
                }
                filePresent = false;
            }
            if (filePresent) {
                existingAttrs = isBinding ? JMSPolicyTypeFileHelper.readBinding(filename) : JMSPolicyTypeFileHelper.readPolicy(filename);
            }
            if (existingAttrs != null && !existingAttrs.isEmpty()) {
                for (Object key : existingAttrs.keySet()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found existing attribute: " + key);
                    }
                    resultAttrs.put(key, existingAttrs.get(key));
                }
                for (Object key : attrs.keySet()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting specified attribute: " + key);
                    }
                    resultAttrs.put(key, attrs.get(key));
                }
                success = isBinding ? JMSPolicyTypeFileHelper.writePolicyBinding(filename, resultAttrs) : JMSPolicyTypeFileHelper.writePolicy(filename, resultAttrs);
            } else {
                for (Object key : attrs.keySet()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Setting specified attribute: " + key);
                    }
                    resultAttrs.put(key, attrs.get(key));
                }
                success = isBinding ? JMSPolicyTypeFileHelper.writePolicyBinding(filename, attrs) : JMSPolicyTypeFileHelper.writePolicy(filename, attrs);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.performWrite()");
        }
        return success;
    }

    private Properties performRead(String filename, Properties attrs, boolean isBinding) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.performRead()...", new Object[]{filename, isBinding, PolicySetUtils.maskPasswords(attrs)});
        }
        Properties existingAttributes = null;
        existingAttributes = isBinding ? JMSPolicyTypeFileHelper.readBinding(filename) : JMSPolicyTypeFileHelper.readPolicy(filename);
        Properties resultAttributes = null;
        if (attrs != null && !attrs.isEmpty()) {
            resultAttributes = new Properties();
            for (Object key : attrs.keySet()) {
                if (existingAttributes.containsKey(key)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Copying attribute: " + key);
                    }
                    resultAttributes.put(key, existingAttributes.get(key));
                    continue;
                }
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug(_tc, "Attribute requested but not available: " + key);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No attributes specified. Copying all " + existingAttributes.size() + "of the available attributes.");
            }
            resultAttributes = existingAttributes;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.performRead()", new Object[]{PolicySetUtils.maskPasswords(resultAttributes)});
        }
        return resultAttributes;
    }

    @Override
    public InputStream downgradeBinding(InputStream bindingFileStream, Map<String, String> context) throws Exception {
        return bindingFileStream;
    }

    @Override
    public InputStream downgradePolicy(InputStream policyFileStream, Map<String, String> context) throws Exception {
        return policyFileStream;
    }

    @Override
    public boolean mergeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        return true;
    }

    @Override
    public boolean upgradeBinding(String oldBindingFilePath, String newBindingFilePath) throws Exception {
        return true;
    }

    @Override
    public boolean upgradePolicy(String oldPolicyFilePath, String newPolicyFilePath) throws Exception {
        return true;
    }

    @Override
    public boolean upgradeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.upgradeBinding()...");
        }
        boolean success = JMSPolicyTypeFileHelper.updatePolicyOrBinding(oldBindingFile, newBindingFile, resultBindingFile, true);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.upgradeBinding() : " + success);
        }
        return success;
    }

    @Override
    public boolean mergeBinding(InputStream oldBindingFile, InputStream newBindingFile, OutputStream resultBindingFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.mergeBinding()...");
        }
        boolean success = JMSPolicyTypeFileHelper.updatePolicyOrBinding(oldBindingFile, newBindingFile, resultBindingFile, true);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.mergeBinding() : " + success);
        }
        return success;
    }

    @Override
    public boolean upgradePolicy(InputStream oldPolicyFile, InputStream newPolicyFile, OutputStream resultPolicyFile) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSPolicyTypeProvider.upgradePolicy()...");
        }
        boolean success = JMSPolicyTypeFileHelper.updatePolicyOrBinding(oldPolicyFile, newPolicyFile, resultPolicyFile, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSPolicyTypeProvider.upgradePolicy() : " + success);
        }
        return success;
    }
}

