/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.LogFilterInputStream;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.transport.jms.JMSEffectiveConfig;
import com.ibm.ws.websvcs.transport.jms.JMSUtils;
import com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public class SOAPOverJMSSenderSpecURL
extends SOAPOverJMSSenderHelper {
    private static final TraceComponent _tc = Tr.register(SOAPOverJMSSenderSpecURL.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private boolean isTopic = false;
    private static final int defaultRequestTimeout = 300;
    private JMSEffectiveConfig jConfig = null;
    private String contentType = null;
    private String charSetEncoding = null;

    public SOAPOverJMSSenderSpecURL() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL()");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        JMSConnectionData connData = new JMSConnectionData();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.invoke()");
        }
        try {
            try {
                this.initialize(msgContext, connData);
                this.sendMessage(msgContext, connData);
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.invoke", "130", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.invoke", "138", this);
                AxisFault wsf = AxisFault.makeFault(e);
                throw wsf;
            }
            Object var6_3 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.invoke()");
            throw throwable;
        }
        Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.invoke()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(MessageContext msgContext, JMSConnectionData connData) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.initialize()");
        }
        this.jConfig = new JMSEffectiveConfig(msgContext);
        try {
            try {
                EndpointReference epr = msgContext.getTo();
                URL targetURL = new URL(epr.getAddress());
                this.parseURL(connData, targetURL);
                this.getJMSObjects(msgContext, connData);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.initialize", "317", this);
                throw AxisFault.makeFault(e);
            }
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.initialize()");
            throw throwable;
        }
        Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.initialize()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(MessageContext msgContext, JMSConnectionData cd) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.getJMSObjects()");
        }
        try {
            try {
                block15: {
                    try {
                        cd.jndiContext = SOAPOverJMSSenderSpecURL.getInitialContext(cd.initialContextFactory, cd.jndiProviderURL);
                    }
                    catch (NamingException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.getJMSObjects", "478", this);
                        Object[] inserts = new Object[]{e.toString()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError01", inserts, "An error occurred while trying to create a JNDI InitialContext object. {0}");
                        Tr.error(_tc, msg);
                        throw new AxisFault(msg);
                    }
                    try {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Getting : connectionFactoryName: [" + cd.connectionFactoryName + "]");
                        }
                        cd.connectionFactory = (ConnectionFactory)this.getJNDIObject(cd, cd.connectionFactoryName);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Getting destinationName: [" + cd.destinationName + "]");
                        }
                        cd.destination = this.getJNDIObject(cd, cd.destinationName);
                        if (cd.destination instanceof Topic) {
                            this.isTopic = true;
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Destination is of type Topic");
                            }
                            break block15;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Destination is of type Queue");
                        }
                    }
                    catch (NamingException ne) {
                        FFDCFilter.processException((Throwable)ne, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.getJMSObjects", "520", this);
                        Object[] inserts = new Object[]{ne.toString()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                        Tr.error(_tc, msg);
                        throw new AxisFault(msg);
                    }
                }
                Object var7_12 = null;
                if (!_tc.isEntryEnabled()) return;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.getJMSObjects", "536", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                throw new AxisFault(msg);
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.getJMSObjects()");
            throw throwable;
        }
        Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.getJMSObjects()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData cd) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.closeConnection()");
        }
        try {
            block5: {
                try {
                    if (cd.connection == null) break block5;
                    cd.connection.close();
                }
                catch (JMSException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.closeConnection", "723", this);
                    Object[] inserts = new Object[]{e.toString()};
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                    Tr.error(_tc, msg);
                    throw new AxisFault(msg);
                }
            }
            Object var6_2 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.closeConnection()");
            return;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.closeConnection()");
            throw throwable;
        }
    }

    private void cleanUp(JMSConnectionData cd) throws AxisFault {
        if (!this.connectionManagementIsDesired()) {
            this.closeConnection(cd);
        } else {
            try {
                if (cd.session != null) {
                    cd.session.close();
                    cd.session = null;
                }
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.cleanUp", "765", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                Tr.error(_tc, msg);
                throw new AxisFault(msg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(MessageContext msgContext, JMSConnectionData connData) throws AxisFault, IOException, SOAPException {
        block107: {
            TransactionSuspender tranSuspender;
            block108: {
                Integer tTimeToLive;
                Integer tPriority;
                Integer tDeliveryMode;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.sendMessage()");
                }
                Queue asyncReplyQueue = null;
                URL targetURL = new URL(msgContext.getTo().getAddress());
                boolean enableTransactionalOneWay = false;
                if (this.jConfig != null) {
                    enableTransactionalOneWay = this.jConfig.getAllowTransactionalAsyncMessaging(msgContext);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "enableTransactionalOneWay : " + enableTransactionalOneWay);
                }
                connData.enableTranOneWay = enableTransactionalOneWay;
                boolean isTwoWay = InvocationPatternHelper.isTwoWayInvocation(msgContext);
                if (isTwoWay) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Two way...");
                    }
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "One way...");
                }
                boolean async = false;
                Boolean nonBlockTransport = (Boolean)msgContext.getProperty("transportNonBlocking");
                EndpointReference epr = msgContext.getReplyTo();
                if (epr != null && !msgContext.getTo().hasAnonymousAddress() && nonBlockTransport != null && nonBlockTransport.booleanValue()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "In Send Asynchronous Request flow...");
                    }
                    async = true;
                    JMSConnectionData connDataAsync = new JMSConnectionData();
                    URL targetURLAsync = new URL(msgContext.getReplyTo().getAddress());
                    try {
                        this.parseURL(connDataAsync, targetURLAsync);
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSPEC.sendMessage", "433", this);
                        throw AxisFault.makeFault(e);
                    }
                    this.getJMSObjects(msgContext, connDataAsync);
                    asyncReplyQueue = (Queue)connDataAsync.destination;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "asyncReplyQueue : " + asyncReplyQueue);
                        Tr.debug(_tc, "connectionFactoryName : " + connDataAsync.connectionFactoryName);
                        Tr.debug(_tc, "queueConnectionFactory : " + connDataAsync.queueConnectionFactory);
                    }
                }
                if (isTwoWay && this.isTopic) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsNoTwoWay", new Object[0], "Two way message exchange pattern is set for Topic.");
                    Tr.error(_tc, msg);
                    throw new AxisFault(msg);
                }
                tranSuspender = null;
                boolean transactionalSession = false;
                if (!isTwoWay && connData.enableTranOneWay) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Bypassing transaction suspension...");
                    }
                } else {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Initiating transaction suspension...");
                    }
                    tranSuspender = new TransactionSuspender();
                    tranSuspender.suspendTransaction();
                    transactionalSession = TransactionSuspender.isTxnServiceEnabled();
                }
                String user = null;
                String password = null;
                if (this.jConfig != null && JavaUtils.hasValue(this.jConfig.getOutRequestUserID(msgContext))) {
                    user = this.jConfig.getOutRequestUserID(msgContext);
                    password = this.jConfig.getOutRequestPassword(msgContext);
                }
                if (_tc.isDebugEnabled()) {
                    String tpassword;
                    Tr.debug(_tc, "Raw Userid: " + (user == null ? "null" : user));
                    Tr.debug(_tc, "Raw Password: " + (password == null ? "null" : password));
                    String tuser = user == null || user.length() == 0 ? "<not-specified>" : user;
                    if (password == null || password.length() == 0) {
                        tpassword = "<not-specified>";
                    } else {
                        StringBuffer buf = new StringBuffer();
                        for (int i = 0; i < password.length(); ++i) {
                            buf.append('*');
                        }
                        tpassword = buf.toString();
                    }
                    Tr.debug(_tc, "Userid: " + tuser);
                    Tr.debug(_tc, "Password: " + tpassword);
                }
                if ((tDeliveryMode = (Integer)msgContext.getProperty("deliveryMode")) != null) {
                    connData.deliveryMode = tDeliveryMode;
                }
                if ((tPriority = (Integer)msgContext.getProperty("priority")) != null) {
                    connData.priority = tPriority;
                }
                if ((tTimeToLive = (Integer)msgContext.getProperty("timeToLive")) != null) {
                    connData.timeToLive = tTimeToLive;
                }
                int requestTimeout = 300;
                if (this.jConfig != null) {
                    requestTimeout = this.jConfig.getRequestTimeout(msgContext);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Request timeout: " + requestTimeout + " ms");
                }
                if (requestTimeout > 0 && (connData.timeToLive <= 0 || connData.timeToLive > requestTimeout)) {
                    connData.timeToLive = requestTimeout;
                }
                HashMap requestTransportHeaders = null;
                requestTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
                HashMap responseTransportHeaders = null;
                responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                MessageProducer Sender2 = null;
                BytesMessage jmsMessage = null;
                try {
                    block105: {
                        try {
                            String id;
                            String id2;
                            MessageContext msgCtx;
                            OperationContext opCtx;
                            this.getConnectionAndSession(connData, user, password, transactionalSession);
                            Sender2 = connData.session.createProducer((Destination)connData.destination);
                            msgContext.setProperty("JMS_MESSAGE_TYPE", "JMS_BYTE_MESSAGE");
                            jmsMessage = connData.session.createBytesMessage();
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            this.contentType = JMSUtils.writeMessage(baos, msgContext);
                            baos.flush();
                            jmsMessage.writeBytes(baos.toByteArray());
                            if (MessageTrace.isTraceEnabled()) {
                                try {
                                    ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
                                    String str = new String("OUTBOUND_JMS_REQUEST");
                                    new LogFilterInputStream(in, _tc, 100000, str, this.contentType);
                                }
                                catch (Throwable t) {
                                    Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                }
                            }
                            jmsMessage.setStringProperty("SOAPJMS_contentType", this.contentType);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting SOAPJMS_contentType on JMSMessage to : " + jmsMessage.getStringProperty("SOAPJMS_contentType"));
                            }
                            jmsMessage.setStringProperty("SOAPJMS_targetService", connData.targetService);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting SOAPJMS_targetService on JMSMessage to : " + jmsMessage.getStringProperty("SOAPJMS_targetService"));
                            }
                            jmsMessage.setStringProperty("SOAPJMS_requestIRI", targetURL.toString());
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting SOAPJMS_requestIRI on JMSMessage to : " + jmsMessage.getStringProperty("SOAPJMS_requestIRI"));
                            }
                            jmsMessage.setStringProperty("SOAPJMS_bindingVersion", "1.0");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting SOAPJMS_bindingVersion on JMSMessage to : " + jmsMessage.getStringProperty("SOAPJMS_bindingVersion"));
                            }
                            if (!isTwoWay && connData.enableTranOneWay) {
                                jmsMessage.setStringProperty("enableTransaction", "true");
                            }
                            jmsMessage.setStringProperty("SOAPJMS_soapAction", JMSUtils.findSOAPAction(msgContext));
                            if (requestTransportHeaders != null) {
                                this.setRequestUserTransportProperties(jmsMessage, requestTransportHeaders);
                            }
                            Queue replyQueue = null;
                            MessageConsumer queueRcvr = null;
                            String replySelectorID = null;
                            String pr2q = null;
                            if (async) {
                                jmsMessage.setJMSReplyTo(asyncReplyQueue);
                                if (baos != null) {
                                    this.setPMIResponseLength(msgContext, baos.size());
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Set the Async reply-to queue on JmsMessage replyQueue : " + asyncReplyQueue);
                                }
                            } else if (isTwoWay) {
                                String prq = (String)msgContext.getProperty("JMSReplyQueueJndiName");
                                if (prq != null) {
                                    connData.permanentReplyToQueueJNDI = prq;
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Permanent reply queue (stub or client-binding) JNDI name property is " + connData.permanentReplyToQueueJNDI);
                                }
                                if ((pr2q = this.getPermanentReplyQueueJNDI(connData.permanentReplyToQueueJNDI)) != null) {
                                    connData.permanentReplyToQueueJNDI = pr2q;
                                    try {
                                        replyQueue = (Queue)connData.jndiContext.lookup(connData.permanentReplyToQueueJNDI);
                                    }
                                    catch (NamingException ne) {
                                        FFDCFilter.processException((Throwable)ne, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.sendMessage", "1028", this);
                                        Object[] inserts = new Object[]{ne.toString()};
                                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                                        Tr.error(_tc, msg);
                                        throw new AxisFault(msg);
                                    }
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Using permanent reply-to queue " + pr2q);
                                    }
                                } else {
                                    replyQueue = connData.session.createTemporaryQueue();
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "Temporary Queue : " + replyQueue);
                                    }
                                }
                                jmsMessage.setJMSReplyTo(replyQueue);
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Set the reply-to queue and started the queue connection in preparation for the reply message.");
                                }
                            }
                            if ((opCtx = msgContext.getOperationContext()) != null && (msgCtx = opCtx.getMessageContext("In")) != null && (id2 = (String)msgCtx.getProperty("asyncCorrelationID")) != null) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "jmsMessage setting correlation id : " + id2);
                                }
                                jmsMessage.setJMSCorrelationID(id2);
                            }
                            if (msgContext != null && (id = (String)msgContext.getProperty("asyncCorrelationID")) != null) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "FAULT msgContext : " + msgContext + " jmsMessage setting correlation id : " + id);
                                }
                                jmsMessage.setJMSCorrelationID(id);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to send message:\n" + jmsMessage.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + connData.deliveryMode + ", priority=" + connData.priority + ", timeToLive=" + connData.timeToLive);
                            }
                            this.charSetEncoding = HTTPTransportUtils.getCharSetEncoding(msgContext);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "CHARACTER_SET_ENCODING : " + this.charSetEncoding);
                            }
                            Sender2.send(jmsMessage, connData.deliveryMode, connData.priority, connData.timeToLive);
                            String requestMessageId = jmsMessage.getJMSMessageID();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Sent the message, messageID=" + requestMessageId);
                            }
                            if (async && AsyncEPRSet.isEPRinSet(epr.getAddress())) {
                                this.saveContextToMap(msgContext, requestMessageId);
                            }
                            if (transactionalSession) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "About to commit QueueSession (send)");
                                }
                                connData.session.commit();
                            }
                            if (replyQueue == null) break block105;
                            if (pr2q != null) {
                                replySelectorID = "JMSCorrelationID = '" + requestMessageId + "'";
                            }
                            try {
                                queueRcvr = connData.session.createConsumer(replyQueue, replySelectorID);
                            }
                            catch (Exception e) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", new Object[0], "The specified error occurred during a JNDI 'lookup' operation. {0}");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Created the queue receiver with selector " + replySelectorID);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to receive response message, requestTimeout=" + requestTimeout + "ms.");
                            }
                            Message replyMsg = queueRcvr.receive(requestTimeout);
                            if (_tc.isDebugEnabled()) {
                                if (replyMsg != null) {
                                    Tr.debug(_tc, "Received JMS response message:\n" + replyMsg.toString());
                                } else {
                                    Tr.debug(_tc, "Received null response message :-(");
                                }
                            }
                            if (replyMsg == null) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsRequestTimeOut", new Object[0], "The request timed out.");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            if (transactionalSession) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "About to commit QueueSession (receive)");
                                }
                                connData.session.commit();
                            }
                            String replyCorrelationId = replyMsg.getJMSCorrelationID();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Reply message contains correlation id: " + replyCorrelationId);
                            }
                            if (replyCorrelationId == null || !replyCorrelationId.equals(requestMessageId)) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsMismatchedReply", new Object[0], "The reply message Correlation ID does not match with the request messageID");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            this.contentType = replyMsg.getStringProperty("SOAPJMS_contentType");
                            String string = this.contentType = this.contentType == null ? null : this.contentType.trim();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "contentType from replyMsg : " + this.contentType);
                            }
                            if (replyMsg instanceof BytesMessage) {
                                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                                byte[] chunk = new byte[4096];
                                int numBytes = 1;
                                while (numBytes > 0) {
                                    numBytes = ((BytesMessage)replyMsg).readBytes(chunk);
                                    if (numBytes <= 0) continue;
                                    ostrm.write(chunk, 0, numBytes);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Extracted the following SOAP Bytes message from the JMS response message:\n" + ostrm.toString());
                                }
                                ostrm.flush();
                                ByteArrayInputStream byteInpS = new ByteArrayInputStream(ostrm.toByteArray());
                                if (byteInpS == null) {
                                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsInputStreamNull", new Object[0], "The input stream of the reply message is NULL.");
                                    throw new AxisFault(msg);
                                }
                                OperationContext opContext = msgContext.getOperationContext();
                                if (opContext != null) {
                                    opContext.setProperty("ContentType", this.contentType);
                                    if (this.charSetEncoding != null) {
                                        opContext.setProperty("CHARACTER_SET_ENCODING", this.charSetEncoding);
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "CHARACTER_SET_ENCODING : " + this.charSetEncoding);
                                        }
                                    }
                                    opContext.setProperty("TRANSPORT_IN", byteInpS);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "received message : " + byteInpS.toString());
                                }
                                if (MessageTrace.isTraceEnabled()) {
                                    try {
                                        ByteArrayInputStream in = new ByteArrayInputStream(ostrm.toByteArray());
                                        String str = new String("INBOUND_JMS_RESPONSE");
                                        new LogFilterInputStream(in, _tc, 100000, str, this.contentType);
                                    }
                                    catch (Throwable t) {
                                        Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                    }
                                }
                            } else {
                                ByteArrayInputStream byteInpS;
                                if (!(replyMsg instanceof TextMessage)) {
                                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidReplyMsgType", new Object[0], "The reply message has invalid type of message type.");
                                    Tr.error(_tc, msg);
                                    throw new AxisFault(msg);
                                }
                                String replyString = ((TextMessage)replyMsg).getText();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Extracted the following SOAP Text message from the JMS response message:\n" + replyString);
                                }
                                if ((byteInpS = new ByteArrayInputStream(replyString.getBytes())) == null) {
                                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsInputStreamNull", new Object[0], "The input stream of the reply message is NULL.");
                                    throw new AxisFault(msg);
                                }
                                if (msgContext.getOperationContext() != null) {
                                    msgContext.getOperationContext().setProperty("TRANSPORT_IN", byteInpS);
                                }
                            }
                            if (responseTransportHeaders != null) {
                                this.getResponseUserTransportProperties(responseTransportHeaders, replyMsg);
                            }
                        }
                        catch (JMSException je) {
                            StringBuffer exceptionInfo;
                            block106: {
                                FFDCFilter.processException((Throwable)je, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL.sendMessage", "1275", this);
                                exceptionInfo = new StringBuffer("JMS.JMSError01 : ");
                                Object[] inserts = new Object[]{je.toString()};
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                                exceptionInfo.append(msg);
                                Exception e = je.getLinkedException();
                                while (e != null) {
                                    exceptionInfo.append("\n");
                                    Object[] inserts1 = new Object[]{e.toString()};
                                    String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                                    e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                                    exceptionInfo.append(msg1);
                                }
                                if (transactionalSession) {
                                    try {
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Doing rollback of session due to JMSException.");
                                        }
                                        if (connData.session == null) break block106;
                                        connData.session.rollback();
                                        if (_tc.isDebugEnabled()) {
                                            Tr.debug(_tc, "Rolled back session.");
                                        }
                                    }
                                    catch (Throwable t) {
                                        if (!_tc.isDebugEnabled()) break block106;
                                        Tr.debug(_tc, "Session rollback failed with exception: " + t.toString());
                                    }
                                }
                            }
                            Tr.error(_tc, exceptionInfo.toString());
                            if (!_tc.isDebugEnabled()) throw new AxisFault("JMS ", exceptionInfo.toString());
                            Tr.debug(_tc, exceptionInfo.toString());
                            throw new AxisFault("JMS ", exceptionInfo.toString());
                        }
                    }
                    Object var38_62 = null;
                    if (tranSuspender == null) break block107;
                    if (!_tc.isDebugEnabled()) break block108;
                }
                catch (Throwable throwable) {
                    Object var38_63 = null;
                    if (tranSuspender != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Initiating transaction resumption...");
                        }
                        tranSuspender.resumeTransaction();
                    }
                    this.cleanUp(connData);
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.sendMessage()");
                    throw throwable;
                }
                Tr.debug(_tc, "Initiating transaction resumption...");
            }
            tranSuspender.resumeTransaction();
        }
        this.cleanUp(connData);
        if (!_tc.isEntryEnabled()) return;
        Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.sendMessage()");
    }

    void setPMIResponseLength(MessageContext msgContext, long responseLength) {
        MessagePMIContext pmiContext = (MessagePMIContext)msgContext.getProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT");
        if (pmiContext != null) {
            pmiContext.setResponseSize(responseLength);
        }
    }

    public String printBytes(byte[] array) {
        StringBuffer sb = new StringBuffer();
        for (int k = 0; k < array.length; ++k) {
            sb.append((char)array[k]);
        }
        return sb.toString();
    }

    private void createConnection(JMSConnectionData cd, String user, String password) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.createConnection()");
        }
        if (user != null && user.length() != 0 && password != null && password.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating connection with user [" + user + "] and password.");
            }
            cd.connection = cd.connectionFactory.createConnection(user, password);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating connection without user/password.");
            }
            cd.connection = cd.connectionFactory.createConnection();
        }
        if (cd.connection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting Connection...");
            }
            cd.connection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.createConnection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getConnectionAndSession(JMSConnectionData cd, String user, String password, boolean transactionalSession) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderSpecURL.getConnectionAndSession()");
        }
        cd.connection = null;
        cd.session = null;
        if (!this.connectionManagementIsDesired()) {
            this.createConnection(cd, user, password);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData cData;
                String key = this.getKey(cd, user);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for connection in cache, key=[" + key + "].");
                }
                if ((cData = this.activeConnections.get(key)) != null) {
                    cd.connection = cData.getConnection();
                }
                if (cd.connection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Connection found: " + cd.connection.toString());
                    }
                    try {
                        cd.session = cd.connection.createSession(transactionalSession, 1);
                    }
                    catch (JMSException e) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createSession threw JMSException, must create fresh Connection.");
                        }
                        cd.connection.close();
                        cd.connection = null;
                        cd.session = null;
                    }
                }
                if (cd.connection == null) {
                    this.createConnection(cd, user, password);
                    this.activeConnections.put(key, cd.connection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Connection added to cache, key=[" + this.getKey(cd, user) + "].");
                    }
                }
            }
        }
        if (cd.session == null) {
            cd.session = cd.connection.createSession(transactionalSession, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderSpecURL.getConnectionAndSession()");
        }
    }
}

