/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.transport.TransactionSuspender;
import com.ibm.ws.webservices.engine.transport.jms.JMSCacheData;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.LogFilterInputStream;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.AsyncEPRSet;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.transport.jms.JMSEffectiveConfig;
import com.ibm.ws.websvcs.transport.jms.JMSUtils;
import com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.naming.NamingException;
import javax.xml.soap.SOAPException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public class SOAPOverJMSSenderIBM
extends SOAPOverJMSSenderHelper {
    private static final TraceComponent _tc = Tr.register(SOAPOverJMSSenderIBM.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final int defaultRequestTimeout = 60;
    private JMSEffectiveConfig jConfig = null;

    public void SOAPOverJMSSenderIBM() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.ctor");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.ctor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        JMSConnectionData connData = new JMSConnectionData();
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.invoke()");
        }
        try {
            try {
                this.initialize(msgContext, connData);
                this.sendMessage(msgContext, connData);
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.invoke", "180", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.invoke", "188", this);
                AxisFault wsf = AxisFault.makeFault(e);
                throw wsf;
            }
            Object var6_3 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.invoke()");
            throw throwable;
        }
        Tr.exit(_tc, "SOAPOverJMSSenderIBM.invoke()");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void initialize(MessageContext mc, JMSConnectionData connData) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.initialize()");
        }
        this.jConfig = new JMSEffectiveConfig(mc);
        try {
            try {
                EndpointReference epr = mc.getTo();
                URL targetURL = new URL(epr.getAddress());
                this.parseURL(connData, targetURL);
                this.getJMSObjects(mc, connData);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.initialize", "259", this);
                throw AxisFault.makeFault(e);
            }
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.initialize()");
            throw throwable;
        }
        Tr.exit(_tc, "SOAPOverJMSSenderIBM.initialize()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getJMSObjects(MessageContext msgContext, JMSConnectionData cd) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.getJMSObjects()");
        }
        try {
            try {
                try {
                    cd.jndiContext = SOAPOverJMSSenderIBM.getInitialContext(cd.initialContextFactory, cd.jndiProviderURL);
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.getJMSObjects", "422", this);
                    Object[] inserts = new Object[]{e.toString()};
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError01", inserts, "An error occurred while trying to create a JNDI InitialContext object. {0}");
                    Tr.error(_tc, msg);
                    throw new AxisFault(msg);
                }
                switch (cd.messageMode) {
                    case 0: 
                    case 1: {
                        try {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Getting : connectionFactoryName: [" + cd.connectionFactoryName + "]");
                            }
                            cd.queueConnectionFactory = (QueueConnectionFactory)this.getJNDIObject(cd, cd.connectionFactoryName);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Getting destinationName: [" + cd.destinationName + "]");
                            }
                            cd.queue = (Queue)this.getJNDIObject(cd, cd.destinationName);
                            break;
                        }
                        catch (NamingException ne) {
                            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.getJMSObjects", "457", this);
                            Object[] inserts = new Object[]{ne.toString()};
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                            Tr.error(_tc, msg);
                            throw new AxisFault(msg);
                        }
                    }
                    case 2: {
                        try {
                            cd.topicConnectionFactory = (TopicConnectionFactory)this.getJNDIObject(cd, cd.connectionFactoryName);
                            cd.topic = (Topic)this.getJNDIObject(cd, cd.destinationName);
                            break;
                        }
                        catch (NamingException ne) {
                            FFDCFilter.processException((Throwable)ne, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.getJMSObjects", "482", this);
                            Object[] inserts = new Object[]{ne.toString()};
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                            Tr.error(_tc, msg);
                            throw new AxisFault(msg);
                        }
                    }
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.getJMSObjects", "498", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                throw new AxisFault(msg);
            }
            {
            }
            Object var7_15 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.getJMSObjects()");
            return;
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.getJMSObjects()");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeConnection(JMSConnectionData cd) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.closeConnection()");
        }
        try {
            try {
                switch (cd.messageMode) {
                    case 1: {
                        if (cd.queueConnection != null) {
                            cd.queueConnection.close();
                        }
                        break;
                    }
                    case 2: {
                        if (cd.topicConnection != null) {
                            cd.topicConnection.close();
                        }
                        break;
                    }
                }
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.closeConnection", "695", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                Tr.error(_tc, msg);
                throw new AxisFault(msg);
            }
            {
            }
            Object var6_2 = null;
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.closeConnection()");
            return;
        }
        catch (Throwable throwable) {
            Object var6_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.closeConnection()");
            throw throwable;
        }
    }

    private void cleanUp(JMSConnectionData cd) throws AxisFault {
        if (!this.connectionManagementIsDesired()) {
            this.closeConnection(cd);
        } else {
            try {
                if (cd.topicSession != null) {
                    cd.topicSession.close();
                    cd.topicSession = null;
                }
                if (cd.queueSession != null) {
                    cd.queueSession.close();
                    cd.queueSession = null;
                }
            }
            catch (JMSException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.cleanUp", "740", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                Tr.error(_tc, msg);
                throw new AxisFault(msg);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(MessageContext msgContext, JMSConnectionData connData) throws AxisFault, IOException, SOAPException {
        String prq;
        Integer tTimeToLive;
        Integer tPriority;
        Integer tDeliveryMode;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.sendMessage()");
        }
        Queue asyncReplyQueue = null;
        QueueConnectionFactory asyncCF = null;
        URL targetURL = new URL(msgContext.getTo().getAddress());
        boolean enableTransactionalOneWay = false;
        if (this.jConfig != null) {
            enableTransactionalOneWay = this.jConfig.getAllowTransactionalAsyncMessaging(msgContext);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "enableTransactionalOneWay : " + enableTransactionalOneWay);
        }
        connData.enableTranOneWay = enableTransactionalOneWay;
        boolean isTwoWay = InvocationPatternHelper.isTwoWayInvocation(msgContext);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "is TwoWay : " + isTwoWay);
        }
        if (isTwoWay && connData.messageMode == 2) {
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsNoTwoWay", new Object[0], "Two way message exchange pattern is set for Topic.");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        boolean async = false;
        Boolean nonBlockTransport = (Boolean)msgContext.getProperty("transportNonBlocking");
        EndpointReference epr = msgContext.getReplyTo();
        if (epr != null && !msgContext.getTo().hasAnonymousAddress() && nonBlockTransport != null && nonBlockTransport.booleanValue()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "In Send Asynchronous Request flow...: repyTo : " + msgContext.getReplyTo());
            }
            async = true;
            JMSConnectionData connDataAsync = new JMSConnectionData();
            URL targetURLAsync = new URL(msgContext.getReplyTo().getAddress());
            try {
                this.parseURL(connDataAsync, targetURLAsync);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.sendMessage", "259", this);
                throw AxisFault.makeFault(e);
            }
            this.getJMSObjects(msgContext, connDataAsync);
            asyncReplyQueue = connDataAsync.queue;
            asyncCF = connDataAsync.queueConnectionFactory;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "asyncReplyQueue : " + asyncReplyQueue);
                Tr.debug(_tc, "connectionFactoryName : " + connDataAsync.connectionFactoryName);
                Tr.debug(_tc, "queueConnectionFactory : " + connDataAsync.queueConnectionFactory);
            }
        }
        TransactionSuspender tranSuspender = null;
        boolean transactionalSession = false;
        if (!isTwoWay && connData.enableTranOneWay) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Bypassing transaction suspension...");
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Initiating transaction suspension...");
            }
            tranSuspender = new TransactionSuspender();
            tranSuspender.suspendTransaction();
            transactionalSession = TransactionSuspender.isTxnServiceEnabled();
        }
        String user = null;
        String password = null;
        if (this.jConfig != null && JavaUtils.hasValue(this.jConfig.getOutRequestUserID(msgContext))) {
            user = this.jConfig.getOutRequestUserID(msgContext);
            password = this.jConfig.getOutRequestPassword(msgContext);
        }
        if (_tc.isDebugEnabled()) {
            String tpassword;
            Tr.debug(_tc, "Raw Userid: " + (user == null ? "null" : user));
            Tr.debug(_tc, "Raw Password: " + (password == null ? "null" : "*******"));
            String tuser = user == null || user.length() == 0 ? "<not-specified>" : user;
            if (password == null || password.length() == 0) {
                tpassword = "<not-specified>";
            } else {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < password.length(); ++i) {
                    buf.append('*');
                }
                tpassword = buf.toString();
            }
            Tr.debug(_tc, "Userid: " + tuser);
            Tr.debug(_tc, "Password: " + tpassword);
        }
        if ((tDeliveryMode = (Integer)msgContext.getProperty("deliveryMode")) != null) {
            connData.deliveryMode = tDeliveryMode;
        }
        if ((tPriority = (Integer)msgContext.getProperty("priority")) != null) {
            connData.priority = tPriority;
        }
        if ((tTimeToLive = (Integer)msgContext.getProperty("timeToLive")) != null) {
            connData.timeToLive = tTimeToLive;
        }
        int requestTimeout = 60;
        if (this.jConfig != null) {
            requestTimeout = this.jConfig.getRequestTimeout(msgContext);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Request timeout: " + requestTimeout + " ms");
        }
        if (requestTimeout > 0 && (connData.timeToLive <= 0 || connData.timeToLive > requestTimeout)) {
            connData.timeToLive = requestTimeout;
        }
        if ((prq = (String)msgContext.getProperty("JMSReplyQueueJndiName")) != null) {
            connData.permanentReplyToQueueJNDI = prq;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (stub or client-binding) JNDI name property is " + connData.permanentReplyToQueueJNDI);
        }
        HashMap requestTransportHeaders = null;
        requestTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.requestTransportProperties");
        HashMap responseTransportHeaders = null;
        responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
        QueueSender queueSender = null;
        TopicPublisher topicPublisher = null;
        BytesMessage jmsMessage = null;
        try {
            try {
                switch (connData.messageMode) {
                    case 1: {
                        String id;
                        MessageContext msgCtx;
                        OperationContext opCtx;
                        this.getQueueConnectionAndSession(connData, user, password, transactionalSession);
                        queueSender = connData.queueSession.createSender(connData.queue);
                        msgContext.setProperty("JMS_MESSAGE_TYPE", "JMS_BYTE_MESSAGE");
                        jmsMessage = connData.queueSession.createBytesMessage();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        String contentType = JMSUtils.writeMessage(baos, msgContext);
                        baos.flush();
                        jmsMessage.writeBytes(baos.toByteArray());
                        if (MessageTrace.isTraceEnabled()) {
                            try {
                                ByteArrayInputStream in = new ByteArrayInputStream(baos.toByteArray());
                                String str = new String("OUTBOUND_JMS_REQUEST");
                                new LogFilterInputStream(in, _tc, 100000, str, contentType);
                            }
                            catch (Throwable t) {
                                Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                            }
                        }
                        jmsMessage.setStringProperty("contentType", contentType);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "contentType : " + jmsMessage.getStringProperty("contentType"));
                        }
                        jmsMessage.setStringProperty("targetService", connData.targetService);
                        jmsMessage.setStringProperty("endpointURL", targetURL.toString());
                        jmsMessage.setStringProperty("transportVersion", "1");
                        if (!isTwoWay && connData.enableTranOneWay) {
                            jmsMessage.setStringProperty("enableTransaction", "true");
                        }
                        jmsMessage.setStringProperty("soapAction", JMSUtils.findSOAPAction(msgContext));
                        if (requestTransportHeaders != null) {
                            this.setRequestUserTransportProperties(jmsMessage, requestTransportHeaders);
                        }
                        Queue replyQueue = null;
                        QueueReceiver queueRcvr = null;
                        String replySelectorID = null;
                        String pr2q = null;
                        if (async) {
                            jmsMessage.setJMSReplyTo(asyncReplyQueue);
                            if (baos != null) {
                                this.setPMIResponseLength(msgContext, baos.size());
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set the Async reply-to queue on JmsMessage replyQueue : " + asyncReplyQueue);
                            }
                        } else if (isTwoWay) {
                            pr2q = this.getPermanentReplyQueueJNDI(connData.permanentReplyToQueueJNDI);
                            if (pr2q != null) {
                                connData.permanentReplyToQueueJNDI = pr2q;
                                try {
                                    replyQueue = (Queue)connData.jndiContext.lookup(connData.permanentReplyToQueueJNDI);
                                }
                                catch (NamingException ne) {
                                    FFDCFilter.processException((Throwable)ne, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.sendMessage", "1005", this);
                                    Object[] inserts = new Object[]{ne.toString()};
                                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", inserts, "The specified error occurred during a JNDI 'lookup' operation. {0}");
                                    Tr.error(_tc, msg);
                                    throw new AxisFault(msg);
                                }
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Using permanent reply-to queue " + pr2q);
                                }
                            } else {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Permanent reply-to queue is null. Creating temporary Queue");
                                }
                                replyQueue = connData.queueSession.createTemporaryQueue();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Temporary Queue : " + replyQueue);
                                }
                            }
                            jmsMessage.setJMSReplyTo(replyQueue);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set the reply-to queue and started the queue connection in preparation for the reply message.");
                            }
                        }
                        if ((opCtx = msgContext.getOperationContext()) != null && (msgCtx = opCtx.getMessageContext("In")) != null && (id = (String)msgCtx.getProperty("asyncCorrelationID")) != null) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "jmsMessage setting correlation id : " + id);
                            }
                            jmsMessage.setJMSCorrelationID(id);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to send message:\n" + jmsMessage.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + connData.deliveryMode + ", priority=" + connData.priority + ", timeToLive=" + connData.timeToLive);
                        }
                        String charSetEncoding = HTTPTransportUtils.getCharSetEncoding(msgContext);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "CHARACTER_SET_ENCODING : " + charSetEncoding);
                        }
                        queueSender.send(jmsMessage, connData.deliveryMode, connData.priority, connData.timeToLive);
                        String requestMessageId = jmsMessage.getJMSMessageID();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Sent the message, messageID=" + requestMessageId);
                        }
                        if (async && AsyncEPRSet.isEPRinSet(epr.getAddress())) {
                            this.saveContextToMap(msgContext, requestMessageId);
                        }
                        if (transactionalSession) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to commit QueueSession (send)");
                            }
                            connData.queueSession.commit();
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "replyQueue " + replyQueue);
                        }
                        if (replyQueue == null) break;
                        if (pr2q != null) {
                            replySelectorID = "JMSCorrelationID = '" + requestMessageId + "'";
                        }
                        try {
                            queueRcvr = connData.queueSession.createReceiver(replyQueue, replySelectorID);
                        }
                        catch (Exception e) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsJNDIError02", new Object[0], "The specified error occurred during a JNDI 'lookup' operation. {0}");
                            Tr.error(_tc, msg);
                            throw new AxisFault(msg);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the queue receiver with selector " + replySelectorID);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to receive response message, requestTimeout=" + requestTimeout + "ms.");
                        }
                        Message replyMsg = queueRcvr.receive(requestTimeout);
                        if (_tc.isDebugEnabled()) {
                            if (replyMsg != null) {
                                Tr.debug(_tc, "Received JMS response message:\n" + replyMsg.toString());
                            } else {
                                Tr.debug(_tc, "Received null response message :-(");
                            }
                        }
                        if (replyMsg == null) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsRequestTimeOut", new Object[0], "The request timed out.");
                            Tr.error(_tc, msg);
                            throw new AxisFault(msg);
                        }
                        if (transactionalSession) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to commit QueueSession (receive)");
                            }
                            connData.queueSession.commit();
                        }
                        String replyCorrelationId = replyMsg.getJMSCorrelationID();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Reply message contains correlation id: " + replyCorrelationId);
                        }
                        if (replyCorrelationId == null || !replyCorrelationId.equals(requestMessageId)) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsMismatchedReply", new Object[0], "The reply message Correlation ID does not match with the request messageID");
                            Tr.error(_tc, msg);
                            throw new AxisFault(msg);
                        }
                        contentType = replyMsg.getStringProperty("contentType");
                        String string = contentType = contentType == null ? null : contentType.trim();
                        if (replyMsg instanceof BytesMessage) {
                            ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                            byte[] chunk = new byte[4096];
                            int numBytes = 1;
                            while (numBytes > 0) {
                                numBytes = ((BytesMessage)replyMsg).readBytes(chunk);
                                if (numBytes <= 0) continue;
                                ostrm.write(chunk, 0, numBytes);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Extracted the following SOAP Bytes message from the JMS response message:\n" + ostrm.toString());
                            }
                            ostrm.flush();
                            ByteArrayInputStream byteInpS = new ByteArrayInputStream(ostrm.toByteArray());
                            if (byteInpS == null) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsInputStreamNull", new Object[0], "The input stream of the reply message is NULL.");
                                throw new AxisFault(msg);
                            }
                            OperationContext opContext = msgContext.getOperationContext();
                            if (opContext != null) {
                                opContext.setProperty("ContentType", contentType);
                                if (charSetEncoding != null) {
                                    opContext.setProperty("CHARACTER_SET_ENCODING", charSetEncoding);
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, "CHARACTER_SET_ENCODING : " + charSetEncoding);
                                    }
                                }
                                opContext.setProperty("TRANSPORT_IN", byteInpS);
                            }
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "received message : " + byteInpS.toString());
                            }
                            if (MessageTrace.isTraceEnabled()) {
                                try {
                                    ByteArrayInputStream in = new ByteArrayInputStream(ostrm.toByteArray());
                                    String str = new String("INBOUND_JMS_RESPONSE");
                                    new LogFilterInputStream(in, _tc, 100000, str, contentType);
                                }
                                catch (Throwable t) {
                                    Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                                }
                            }
                        } else {
                            ByteArrayInputStream byteInpS;
                            if (!(replyMsg instanceof TextMessage)) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidReplyMsgType", new Object[0], "The reply message has invalid type of message type.");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            String replyString = ((TextMessage)replyMsg).getText();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Extracted the following SOAP Text message from the JMS response message:\n" + replyString);
                            }
                            if ((byteInpS = new ByteArrayInputStream(replyString.getBytes())) == null) {
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsInputStreamNull", new Object[0], "The input stream of the reply message is NULL.");
                                throw new AxisFault(msg);
                            }
                            if (msgContext.getOperationContext() != null) {
                                msgContext.getOperationContext().setProperty("TRANSPORT_IN", byteInpS);
                            }
                        }
                        if (responseTransportHeaders == null) break;
                        this.getResponseUserTransportProperties(responseTransportHeaders, replyMsg);
                        break;
                    }
                    case 2: {
                        this.getTopicConnectionAndSession(connData, user, password, transactionalSession);
                        topicPublisher = connData.topicSession.createPublisher(connData.topic);
                        jmsMessage = connData.queueSession.createBytesMessage();
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        String contentType = JMSUtils.writeMessage(baos, msgContext);
                        baos.flush();
                        jmsMessage.writeBytes(baos.toByteArray());
                        if (MessageTrace.isTraceEnabled()) {
                            MessageTrace.log(MessageTrace.OUTBOUND_JMS_REQUEST, contentType, baos.toByteArray());
                        }
                        if (connData.enableTranOneWay) {
                            jmsMessage.setStringProperty("enableTransaction", "true");
                        }
                        this.setSoapAction(jmsMessage, msgContext, "soapAction");
                        jmsMessage.setStringProperty("contentType", contentType);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "contentType : " + jmsMessage.getStringProperty("contentType"));
                        }
                        jmsMessage.setStringProperty("targetService", connData.targetService);
                        jmsMessage.setStringProperty("endpointURL", targetURL.toString());
                        jmsMessage.setStringProperty("transportVersion", "1");
                        if (requestTransportHeaders != null) {
                            this.setRequestUserTransportProperties(jmsMessage, requestTransportHeaders);
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to publish message:\n" + jmsMessage.toString());
                        }
                        topicPublisher.publish(jmsMessage);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Published the message.");
                        }
                        if (transactionalSession) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "About to commit TopicSession (publish)");
                            }
                            connData.topicSession.commit();
                        }
                        break;
                    }
                }
            }
            catch (JMSException je) {
                StringBuffer exceptionInfo;
                block113: {
                    FFDCFilter.processException((Throwable)je, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM.sendMessage", "1317", this);
                    exceptionInfo = new StringBuffer();
                    Object[] inserts = new Object[]{je.toString()};
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                    exceptionInfo.append(msg);
                    Exception e = je.getLinkedException();
                    while (e != null) {
                        exceptionInfo.append("\n");
                        Object[] inserts1 = new Object[]{e.toString()};
                        String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                        e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                        exceptionInfo.append(msg1);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, exceptionInfo.toString());
                    }
                    if (transactionalSession) {
                        try {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Doing rollback of session due to JMSException.");
                            }
                            if (connData.queueSession != null) {
                                connData.queueSession.rollback();
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "Rolled back queue session.");
                                }
                            }
                            if (connData.topicSession == null) break block113;
                            connData.topicSession.rollback();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Rolled back topic session.");
                            }
                        }
                        catch (Throwable t) {
                            if (!_tc.isDebugEnabled()) break block113;
                            Tr.debug(_tc, "Session rollback failed with exception: " + t.toString());
                        }
                    }
                }
                Tr.error(_tc, exceptionInfo.toString());
                if (!_tc.isDebugEnabled()) throw new AxisFault("JMS ", exceptionInfo.toString());
                Tr.debug(_tc, exceptionInfo.toString());
                throw new AxisFault("JMS ", exceptionInfo.toString());
            }
            {
            }
            Object var43_70 = null;
            if (tranSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Initiating transaction resumption...");
                }
                tranSuspender.resumeTransaction();
            }
            this.cleanUp(connData);
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.sendMessage()");
            return;
        }
        catch (Throwable throwable) {
            Object var43_71 = null;
            if (tranSuspender != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Initiating transaction resumption...");
                }
                tranSuspender.resumeTransaction();
            }
            this.cleanUp(connData);
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.sendMessage()");
            throw throwable;
        }
    }

    void setPMIResponseLength(MessageContext msgContext, long responseLength) {
        MessagePMIContext pmiContext = (MessagePMIContext)msgContext.getProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT");
        if (pmiContext != null) {
            pmiContext.setResponseSize(responseLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getQueueConnectionAndSession(JMSConnectionData cd, String user, String password, boolean transactionalSession) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.getQueueConnectionAndSession()");
        }
        cd.queueConnection = null;
        cd.queueSession = null;
        if (!this.connectionManagementIsDesired()) {
            this.createQueueConnection(cd, user, password);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData cData;
                String key = this.getKey(cd, user);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for Queue connection in cache, key=[" + key + "].");
                }
                if ((cData = this.activeConnections.get(key)) != null) {
                    cd.queueConnection = (QueueConnection)cData.getConnection();
                }
                if (cd.queueConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue connection found: " + cd.queueConnection.toString());
                    }
                    try {
                        cd.queueSession = cd.queueConnection.createQueueSession(transactionalSession, 1);
                    }
                    catch (JMSException badQ) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createQueueSession threw JMSException, must create fresh QueueConnection.");
                        }
                        cd.queueConnection.close();
                        cd.queueConnection = null;
                        cd.queueSession = null;
                    }
                }
                if (cd.queueConnection == null) {
                    this.createQueueConnection(cd, user, password);
                    this.activeConnections.put(key, cd.queueConnection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Queue connection added to cache, key=[" + key + "].");
                        Tr.debug(_tc, "Queue connection added: " + cd.queueConnection.toString());
                    }
                }
            }
        }
        if (cd.queueSession == null) {
            cd.queueSession = cd.queueConnection.createQueueSession(transactionalSession, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.getQueueConnectionAndSession()");
        }
    }

    private void createQueueConnection(JMSConnectionData cd, String user, String password) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.createQueueConnection()");
        }
        if (user != null && user.length() != 0 && password != null && password.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating queue connection with user [" + user + "] and password.");
            }
            cd.queueConnection = cd.queueConnectionFactory.createQueueConnection(user, password);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating queue connection without user/password.");
            }
            cd.queueConnection = cd.queueConnectionFactory.createQueueConnection();
        }
        if (cd.queueConnection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting queue connection...");
            }
            cd.queueConnection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.createQueueConnection()");
        }
    }

    private void createTopicConnection(JMSConnectionData cd, String user, String password) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.createTopicConnection()");
        }
        if (user != null && user.length() != 0 && password != null && password.length() != 0) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating topic connection with user [" + user + "] and password.");
            }
            cd.topicConnection = cd.topicConnectionFactory.createTopicConnection(user, password);
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating topic connection without user/password.");
            }
            cd.topicConnection = cd.topicConnectionFactory.createTopicConnection();
        }
        if (cd.topicConnection != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Starting topic connection...");
            }
            cd.topicConnection.start();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.createTopicConnection()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getTopicConnectionAndSession(JMSConnectionData cd, String user, String password, boolean transactionalSession) throws JMSException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderIBM.getTopicConnectionAndSession()");
        }
        cd.topicConnection = null;
        cd.topicSession = null;
        if (!this.connectionManagementIsDesired()) {
            this.createTopicConnection(cd, user, password);
        } else {
            JMSConnectionCache jMSConnectionCache = this.activeConnections;
            synchronized (jMSConnectionCache) {
                JMSCacheData cData;
                String key = this.getKey(cd, user);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for Topic connection in cache, key=[" + key + "].");
                }
                if ((cData = this.activeConnections.get(key)) != null) {
                    cd.topicConnection = (TopicConnection)cData.getConnection();
                }
                if (cd.topicConnection != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Topic connection found: " + cd.topicConnection.toString());
                    }
                    try {
                        cd.topicSession = cd.topicConnection.createTopicSession(transactionalSession, 1);
                    }
                    catch (JMSException e) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "createTopicSession threw JMSException, must create fresh TopicConnection.");
                        }
                        cd.topicConnection.close();
                        cd.topicConnection = null;
                        cd.topicSession = null;
                    }
                }
                if (cd.topicConnection == null) {
                    this.createTopicConnection(cd, user, password);
                    this.activeConnections.put(key, cd.topicConnection);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Topic connection added to cache, key=[" + this.getKey(cd, user) + "].");
                    }
                }
            }
        }
        if (cd.topicSession == null) {
            cd.topicSession = cd.topicConnection.createTopicSession(transactionalSession, 1);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSenderIBM.getTopicConnectionAndSession()");
        }
    }
}

