/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionCache;
import com.ibm.ws.webservices.engine.transport.jms.JMSConnectionData;
import com.ibm.ws.webservices.engine.transport.jms.JMSURLParser;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.AsyncResponseContextMap;
import com.ibm.ws.websvcs.transport.jms.BasicHandler;
import com.ibm.ws.websvcs.transport.jms.JMSAsyncResponseContext;
import com.ibm.ws.websvcs.transport.jms.JMSUtils;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

public class SOAPOverJMSSenderHelper
extends BasicHandler {
    private static Hashtable icTable = new Hashtable();
    private HashMap jndiCache = new HashMap();
    private static final TraceComponent _tc = Tr.register(SOAPOverJMSSenderHelper.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    public JMSConnectionCache activeConnections = JMSConnectionCache.newInstance();
    private boolean connectionManagementChecked = false;
    private boolean connectionManagementDesired = false;
    private static boolean JNDICacheExpirationTimeRetrieved = false;
    private static long JNDICacheExpirationTime = 0L;

    public void saveContextToMap(MessageContext mc, String hashKey) {
        EndpointReference epr;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSenderHelper.saveContextToMap()...");
        }
        if ((epr = mc.getReplyTo()) == null) {
            epr = mc.getFaultTo();
        }
        if (epr != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "hashKey: " + hashKey);
            }
            if (hashKey != null) {
                String messageID = mc.getOptions().getMessageId();
                AxisOperation ao = mc.getAxisOperation();
                AxisService as = mc.getAxisService();
                ConfigurationContext cc = mc.getConfigurationContext();
                AsyncResponseContextMap aRCMap = AsyncResponseContextMap.getInstance();
                AsyncResponseContext aRC = aRCMap.getContext(hashKey);
                if (aRC == null) {
                    aRC = new JMSAsyncResponseContext(messageID, ao, as, cc, hashKey);
                    aRCMap.putContext(hashKey, aRC);
                    if (_tc.isEventEnabled()) {
                        Tr.debug(_tc, "Creating and adding async response context " + aRC + " to cache with key: " + hashKey);
                    }
                } else if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "Already cached async response context " + aRC + " with key: " + hashKey);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...SOAPOverJMSSenderHelper.saveContextToMap()");
        }
    }

    protected void parseURL(JMSConnectionData cd, URL url) throws AxisFault, Exception {
        Integer i;
        String s;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "parseURL");
        }
        JMSURLParser urlParser = new JMSURLParser(url);
        cd.messageMode = urlParser.getDestinationType();
        cd.connectionFactoryName = urlParser.getConnectionFactory();
        cd.destinationName = urlParser.getDestination();
        cd.targetService = urlParser.getTargetService();
        if (cd.connectionFactoryName == null || cd.connectionFactoryName.length() == 0 || cd.destinationName == null || cd.destinationName.length() == 0 || cd.targetService == null || cd.targetService.length() == 0) {
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsMissingRequiredProperties", new Object[0], "The JMS URL is missing some properties..");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        try {
            s = urlParser.getDeliveryMode();
            if (s != null) {
                i = new Integer(s);
                cd.deliveryMode = i;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper.parseURL", "323", this);
            Object[] inserts = new Object[]{"deliveryMode", JavaUtils.stackToString(e)};
            String msg = NLSProvider.getNLS().getFormattedMessage("BadValue", inserts, "The following exception is encountered in the {0} property {1}");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        try {
            s = urlParser.getPriority();
            if (s != null) {
                i = new Integer(s);
                cd.priority = i;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper.parseURL", "344", this);
            Object[] inserts = new Object[]{"priority", JavaUtils.stackToString(e)};
            String msg = NLSProvider.getNLS().getFormattedMessage("BadValue", inserts, "The following exception is encountered in the {0} property {1}");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        try {
            s = urlParser.getTimeToLive();
            if (s != null) {
                i = new Integer(s);
                cd.timeToLive = i;
            }
        }
        catch (NumberFormatException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper.parseURL", "365", this);
            Object[] inserts = new Object[]{"timeToLive", JavaUtils.stackToString(e)};
            String msg = NLSProvider.getNLS().getFormattedMessage("BadValue", inserts, "The following exception is encountered in the {0} property {1}");
            Tr.error(_tc, msg);
            throw new AxisFault(msg);
        }
        cd.initialContextFactory = urlParser.getInitialContextFactory();
        cd.jndiProviderURL = urlParser.getJndiProviderURL();
        cd.permanentReplyToQueueJNDI = urlParser.getReplyTo();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (URL) JNDI name property is " + cd.permanentReplyToQueueJNDI);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "message mode: [" + cd.messageMode + "], connectionFactoryName: [" + cd.connectionFactoryName + "], destinationName: [" + cd.destinationName + "], targetService: [" + cd.targetService + "]");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "parseURL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static InitialContext getInitialContext(String icFactory, String providerURL) throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        InitialContext ic = null;
        String key = (providerURL != null ? providerURL : "<null>") + (icFactory != null ? icFactory : "<null>");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "InitialContext key=[" + key + "].");
        }
        Hashtable hashtable = icTable;
        synchronized (hashtable) {
            ic = (InitialContext)icTable.get(key);
            if (ic == null) {
                Hashtable<String, String> icProps = new Hashtable<String, String>();
                if (icFactory != null) {
                    icProps.put("java.naming.factory.initial", icFactory);
                }
                if (providerURL != null) {
                    icProps.put("java.naming.provider.url", providerURL);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "About to create an InitialContext with the following properties:" + icProps.toString());
                }
                ic = new InitialContext(icProps);
                icTable.put(key, ic);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Re-using existing InitialContext with key=[" + key + "].");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getInitialContext " + ic.toString());
        }
        return ic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getJNDIObject(JMSConnectionData cd, String jndiName) throws NamingException {
        JNDICacheObject jcObj;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getJNDIObject, jndiName=" + jndiName);
        }
        Object obj = null;
        try {
            String key = jndiName + "#" + (cd.jndiProviderURL != null ? cd.jndiProviderURL : "<null>") + "#" + (cd.initialContextFactory != null ? cd.initialContextFactory : "<null>");
            HashMap hashMap = this.jndiCache;
            synchronized (hashMap) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Looking for object in JNDI cache, key=[" + key + "].");
                }
                if ((jcObj = (JNDICacheObject)this.jndiCache.get(key)) == null || jcObj.cacheObjectIsStale()) {
                    if (_tc.isDebugEnabled()) {
                        if (jcObj == null) {
                            Tr.debug(_tc, "Object not in cache, performing JNDI lookup()...");
                        } else if (jcObj.cacheObjectIsStale()) {
                            Tr.debug(_tc, "Object in cache but stale, performing JNDI lookup()...");
                        }
                    }
                    obj = cd.jndiContext.lookup(jndiName);
                    jcObj = new JNDICacheObject(obj);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Adding object to cache, key=[" + key + "], object=" + (obj != null ? obj.toString() : "<null>"));
                    }
                    this.jndiCache.put(key, jcObj);
                }
            }
            Object var9_8 = null;
            if (!_tc.isEntryEnabled()) return jcObj.getObject();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getJNDIObject");
            throw throwable;
        }
        Tr.exit(_tc, "getJNDIObject");
        return jcObj.getObject();
    }

    protected void setSoapAction(Message jmsMessage, MessageContext msgContext, String soapString) throws JMSException {
        String soapAction = JMSUtils.getSOAPAction(msgContext);
        if (soapAction == null) {
            jmsMessage.setStringProperty(soapString, "");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting " + soapString + " on JMSMessage to empty string...");
            }
        } else {
            jmsMessage.setStringProperty(soapString, "\"" + soapAction + "\"");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting " + soapString + " on JMSMessage to: " + "\"" + soapAction + "\"");
            }
        }
    }

    protected boolean connectionManagementIsDesired() {
        if (!this.connectionManagementChecked) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connectionManagementIsDesired() raw System property = " + System.getProperty("com.ibm.ws.webservices.JMSUseConnectionManagement"));
            }
            this.connectionManagementDesired = JavaUtils.isTrueExplicitly(System.getProperty("com.ibm.ws.webservices.JMSUseConnectionManagement"), false);
            this.connectionManagementChecked = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "connectionManagementIsDesired() desired = " + this.connectionManagementDesired);
            }
        }
        return this.connectionManagementDesired;
    }

    protected String getKey(JMSConnectionData cd, String user) {
        String key = cd.connectionFactoryName + "#" + (user != null && user.length() != 0 ? user : "<null>") + (cd.initialContextFactory != null && cd.initialContextFactory.length() != 0 ? cd.initialContextFactory : "<null>") + (cd.jndiProviderURL != null && cd.jndiProviderURL.length() != 0 ? cd.jndiProviderURL : "<null>");
        return key;
    }

    public void _init() {
        super._init();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOAPOverJMSSenderHelper _init() " + this.toString());
        }
    }

    public void _destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOAPOverJMSSenderHelper _destroy() " + this.toString());
        }
        try {
            if (this.connectionManagementIsDesired()) {
                this.activeConnections.closeConnections();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper._destroy", "1816", this);
        }
        super._destroy();
    }

    protected String getPermanentReplyQueueJNDI(String prqSoFar) {
        String retString = null;
        if (prqSoFar != null) {
            if (!prqSoFar.equals("") && !prqSoFar.equals("Transient")) {
                retString = prqSoFar;
            }
            return retString;
        }
        String sp = System.getProperty("com.ibm.websphere.webservices.JMSReplyQueueJndiName");
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Permanent reply queue (System property) is " + sp);
        }
        if (sp != null && !sp.equals("") && !sp.equals("Transient")) {
            retString = sp;
        }
        return retString;
    }

    protected static long getJNDICacheExpirationTime() {
        if (!JNDICacheExpirationTimeRetrieved) {
            Integer intObj = Integer.getInteger(System.getProperty("com.ibm.websphere.webservices.transport.jms.JNDICacheExpirationThreshhold"), 600);
            JNDICacheExpirationTimeRetrieved = true;
            JNDICacheExpirationTime = intObj.longValue() * 1000L;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting JNDI Cache Expiration time to: " + intObj + " seconds");
            }
        }
        return JNDICacheExpirationTime;
    }

    protected void setRequestUserTransportProperties(Message jmsMessage, HashMap requestTransportHeaders) throws AxisFault {
        try {
            if (requestTransportHeaders != null) {
                for (Map.Entry headerMapEntry : requestTransportHeaders.entrySet()) {
                    String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                    if (!JavaUtils.hasValue(transportHeaderKey)) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidHeaderKey", new Object[0], "The request transportheader key is invalid");
                        Tr.warning(_tc, msg);
                        continue;
                    }
                    String transportHeaderValue = ((String)headerMapEntry.getValue()).trim();
                    if (!JavaUtils.hasValue(transportHeaderValue)) {
                        Object[] inserts1 = new Object[]{new Object[]{transportHeaderKey}};
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidHeaderKey", inserts1, "The request transportheader key is invalid");
                        Tr.warning(_tc, msg);
                        continue;
                    }
                    if (jmsMessage.propertyExists(transportHeaderKey)) continue;
                    jmsMessage.setStringProperty(transportHeaderKey, transportHeaderValue);
                }
            }
        }
        catch (JMSException je) {
            FFDCFilter.processException((Throwable)je, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper.setRequestUserTransportProperties", "1945", this);
            StringBuffer exceptionInfo = new StringBuffer();
            Object[] inserts = new Object[]{je.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
            exceptionInfo.append(msg);
            Exception e = je.getLinkedException();
            while (e != null) {
                exceptionInfo.append("\n");
                Object[] inserts1 = new Object[]{e.toString()};
                String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                exceptionInfo.append(msg1);
            }
            Tr.error(_tc, exceptionInfo.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, exceptionInfo.toString());
            }
            throw new AxisFault("JMS ", exceptionInfo.toString());
        }
    }

    protected void getResponseUserTransportProperties(HashMap responseTransportHeaders, Message replyMsg) throws AxisFault {
        if (responseTransportHeaders != null) {
            try {
                if (responseTransportHeaders.isEmpty()) {
                    Enumeration enumm = replyMsg.getPropertyNames();
                    while (enumm.hasMoreElements()) {
                        String transportHeaderKey = ((String)enumm.nextElement()).trim();
                        if (!JavaUtils.hasValue(transportHeaderKey)) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidHeaderKey", new Object[0], "The request transportheader key is invalid");
                            Tr.warning(_tc, msg);
                            continue;
                        }
                        String value = null;
                        value = replyMsg.getStringProperty(transportHeaderKey);
                        responseTransportHeaders.put(transportHeaderKey, value);
                    }
                } else {
                    for (Map.Entry headerMapEntry : responseTransportHeaders.entrySet()) {
                        String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                        if (!JavaUtils.hasValue(transportHeaderKey)) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("jmsInvalidHeaderKey", new Object[0], "The request transportheader key is invalid");
                            Tr.warning(_tc, msg);
                            continue;
                        }
                        String value = null;
                        value = replyMsg.getStringProperty(transportHeaderKey);
                        responseTransportHeaders.put(transportHeaderKey, value);
                    }
                }
            }
            catch (JMSException je) {
                FFDCFilter.processException((Throwable)je, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderHelper.getResponseUserTransportProperties", "2035", this);
                StringBuffer exceptionInfo = new StringBuffer();
                Object[] inserts = new Object[]{je.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
                exceptionInfo.append(msg);
                Exception e = je.getLinkedException();
                while (e != null) {
                    exceptionInfo.append("\n");
                    Object[] inserts1 = new Object[]{e.toString()};
                    String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                    e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                    exceptionInfo.append(msg1);
                }
                Tr.error(_tc, exceptionInfo.toString());
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, exceptionInfo.toString());
                }
                throw new AxisFault("JMS ", exceptionInfo.toString());
            }
        }
    }

    private static class JNDICacheObject {
        private long timeCreated = System.currentTimeMillis();
        private Object data = null;

        JNDICacheObject(Object newData) {
            this.data = newData;
        }

        private Object getObject() {
            return this.data;
        }

        private boolean cacheObjectIsStale() {
            return SOAPOverJMSSenderHelper.getJNDICacheExpirationTime() != 0L && System.currentTimeMillis() - this.timeCreated > SOAPOverJMSSenderHelper.getJNDICacheExpirationTime();
        }
    }
}

