/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.jms.BasicHandler;
import com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderIBM;
import com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSenderSpecURL;
import java.net.URL;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;

public class SOAPOverJMSSender
extends BasicHandler {
    private static final TraceComponent _tc = Tr.register(SOAPOverJMSSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private SOAPOverJMSSenderIBM ibmSender = null;
    private SOAPOverJMSSenderSpecURL specSender = null;

    public SOAPOverJMSSender() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "SOAPOverJMSSender ctor");
        }
        this.ibmSender = new SOAPOverJMSSenderIBM();
        this.specSender = new SOAPOverJMSSenderSpecURL();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "SOAPOverJMSSender ctor");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "invoke");
        }
        try {
            try {
                EndpointReference epr = msgContext.getTo();
                URL targetURL = new URL(epr.getAddress());
                if (targetURL == null) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("jmsNoEndPoint", new Object[0], "Target URL is not set. Nowhere to send.");
                    throw new AxisFault(msg);
                }
                if (targetURL.toString().startsWith("jms:jndi")) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "SPEC protocol Target URL string is [" + targetURL.toString() + "]");
                    }
                    this.specSender.invoke(msgContext);
                } else {
                    if (!targetURL.toString().startsWith("jms")) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmswrongEndpoint", new Object[0], "Target URL is not JMS.");
                        throw new AxisFault(msg);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "IBM protocol Target URL string is [" + targetURL.toString() + "]");
                    }
                    this.ibmSender.invoke(msgContext);
                }
                Object var6_9 = null;
                if (!_tc.isEntryEnabled()) return;
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSender.invoke", "178", this);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSender.invoke", "183", this);
                AxisFault wsf = AxisFault.makeFault(e);
                throw wsf;
            }
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "invoke");
            throw throwable;
        }
        Tr.exit(_tc, "invoke");
    }

    public void _init() {
        super._init();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOAPOverJMSSender._init() " + this.toString());
        }
    }

    public void _destroy() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "SOAPOverJMSSender._destroy() " + this.toString());
        }
        try {
            if (this.ibmSender != null) {
                this.ibmSender._destroy();
            }
            if (this.specSender != null) {
                this.specSender._destroy();
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.jms.SOAPOverJMSSender._destroy", "1436", this);
        }
        super._destroy();
    }
}

