/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.JavaUtils;

public class JMSUtils {
    private static final TraceComponent _tc = Tr.register(JMSUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final int VERSION_UNKNOWN = 0;
    private static final int VERSION_SOAP11 = 1;
    private static final int VERSION_SOAP12 = 2;

    public static boolean isJMSService(AxisService service) {
        boolean process = service.isEnableAllTransports();
        if (process) {
            return true;
        }
        List transports = service.getExposedTransports();
        for (int i = 0; i < transports.size(); ++i) {
            if (!"jms".equals(transports.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getSOAPAction(MessageContext msgCtx) {
        String soapActionString = msgCtx.getSoapAction();
        if (soapActionString == null || soapActionString.trim().length() == 0) {
            soapActionString = msgCtx.getWSAAction();
        }
        Object disableSoapAction = msgCtx.getOptions().getProperty("disableSoapAction");
        if (soapActionString == null || JavaUtils.isTrueExplicitly(disableSoapAction)) {
            soapActionString = "";
        }
        return soapActionString;
    }

    public static Message createJMSMessage(MessageContext msgContext, Session session) throws JMSException, AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createJMSMessage");
        }
        Message message = null;
        String msgType = (String)msgContext.getProperty("JMS_MESSAGE_TYPE");
        OMElement msgElement = msgContext.getEnvelope();
        if (msgContext.isDoingREST()) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DoingRest is true");
            }
            msgElement = msgContext.getEnvelope().getBody().getFirstElement();
        }
        if (msgType != null && "JMS_BYTE_MESSAGE".equals(msgType)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "msgType : JMS_BYTE_MESSAGE");
            }
            message = session.createBytesMessage();
            BytesMessage bytesMsg = (BytesMessage)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OMOutputFormat format = new OMOutputFormat();
            format.setCharSetEncoding((String)msgContext.getProperty("CHARACTER_SET_ENCODING"));
            format.setDoOptimize(msgContext.isDoingMTOM());
            try {
                msgElement.serializeAndConsume(baos, format);
                baos.flush();
            }
            catch (XMLStreamException e) {
                throw new AxisFault("XML serialization error creating BytesMessage", e);
            }
            catch (IOException e) {
                throw new AxisFault("IO Error while creating BytesMessage", e);
            }
            bytesMsg.writeBytes(baos.toByteArray());
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "msgType : JMS_TEXT_MESSAGE");
            }
            message = session.createTextMessage();
            TextMessage txtMsg = message;
            txtMsg.setText(((Object)msgElement).toString());
        }
        String correlationId = (String)msgContext.getProperty("JMS_COORELATION_ID");
        if (correlationId != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "correlationId : " + correlationId);
            }
            message.setJMSCorrelationID(correlationId);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ServerSide : " + msgContext.isServerSide());
        }
        if (msgContext.isServerSide()) {
            JMSUtils.setProperty(message, msgContext, "soapAction");
            JMSUtils.setProperty(message, msgContext, "contentType");
        } else {
            String action = msgContext.getOptions().getAction();
            if (action != null) {
                message.setStringProperty("SOAPAction", action);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createJMSMessage");
        }
        return message;
    }

    public static String findSOAPAction(MessageContext messageContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "findSOAPAction");
        }
        String soapActionString = null;
        Object disableSoapAction = messageContext.getOptions().getProperty("disableSoapAction");
        if (!JavaUtils.isTrueExplicitly(disableSoapAction)) {
            soapActionString = messageContext.getSoapAction();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Got this soapAction from MessageContext.getSoapAction: " + soapActionString);
            }
            if (soapActionString == null || soapActionString.length() == 0) {
                soapActionString = messageContext.getWSAAction();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Got this soapAction from MessageContext.getWSAAction: " + soapActionString);
                }
                if (messageContext.getAxisOperation() != null && (soapActionString == null || soapActionString.length() == 0)) {
                    soapActionString = messageContext.getAxisOperation().getSoapAction();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Got this soapAction from AxisOperation.getSoapAction: " + soapActionString);
                    }
                }
            }
        }
        if (soapActionString == null) {
            soapActionString = "\"\"";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findSOAPAction, soapActionString= " + soapActionString);
        }
        return soapActionString;
    }

    public static String writeMessage(OutputStream os, MessageContext msgContext) throws AxisFault {
        MessageFormatter messageFormatter;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "writeMessage()");
        }
        OMOutputFormat format = new OMOutputFormat();
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        String charSetEncoding = HTTPTransportUtils.getCharSetEncoding(msgContext);
        format.setCharSetEncoding(charSetEncoding);
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        if ((messageFormatter = TransportUtils.getMessageFormatter(msgContext)) == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
            throw new AxisFault(msg);
        }
        String contentType = messageFormatter.getContentType(msgContext, format, JMSUtils.findSOAPAction(msgContext));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "contentType " + contentType);
        }
        format.setIgnoreXMLDeclaration(true);
        format.setContentType(contentType);
        format.setAutoCloseWriter(true);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Writing to MessagEFormatter with following format options " + format.toString());
        }
        messageFormatter.writeTo(msgContext, format, os, false);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "writeMessage()");
        }
        return contentType;
    }

    public static int getSoapVersion(MessageContext msgContext, String contentType) {
        int soapVersion = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getSoapVersion");
        }
        if (contentType != null) {
            if (contentType.indexOf("application/soap+xml") > -1) {
                soapVersion = 2;
                TransportUtils.processContentTypeForAction(contentType, msgContext);
            } else if (contentType.indexOf("text/xml") > -1) {
                soapVersion = 1;
            } else if (HTTPTransportUtils.isRESTRequest(contentType)) {
                soapVersion = 1;
                msgContext.setDoingREST(true);
            }
            if (soapVersion == 1) {
                Parameter enableREST = msgContext.getParameter("enableREST");
                if (JMSUtils.findSOAPAction(msgContext) == null && enableREST != null && "true".equals(enableREST.getValue())) {
                    msgContext.setDoingREST(true);
                }
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getSoapVersion : " + soapVersion);
        }
        return soapVersion;
    }

    public static void setProperty(Message message, MessageContext msgCtx, String key) {
        String value = (String)msgCtx.getProperty(key);
        if (value != null) {
            try {
                message.setStringProperty(key, value);
            }
            catch (JMSException e) {
                Tr.warning(_tc, "Couldn't set message property : " + key + " = " + value, e);
            }
        }
    }
}

