/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.CommonUtils;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.jms.JMSOutTransportInfo;
import com.ibm.ws.websvcs.transport.jms.SOAPOverJMSSender;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPTransportUtils;

public class JMSSender
extends AbstractHandler
implements TransportSender {
    private static final TraceComponent _tc = Tr.register(JMSSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block15: {
            Handler.InvocationResponse invocationResponse;
            block14: {
                SOAPOverJMSSender sender = null;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "invoke msgContext : " + msgContext);
                }
                try {
                    try {
                        String targetAddress = null;
                        targetAddress = (String)msgContext.getProperty("TransportURL");
                        if (targetAddress == null && msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                            targetAddress = msgContext.getTo().getAddress();
                            if (msgContext.getTo().hasNoneAddress()) {
                                invocationResponse = Handler.InvocationResponse.CONTINUE;
                                Object var8_8 = null;
                                if (!_tc.isEntryEnabled()) return invocationResponse;
                                break block14;
                            }
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "targetAddress: " + targetAddress);
                        }
                        if (targetAddress != null) {
                            try {
                                sender = new SOAPOverJMSSender();
                                sender.invoke(msgContext);
                                break block15;
                            }
                            catch (Exception e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSTransportSender.invoke", "160", this);
                                throw AxisFault.makeFault(e);
                            }
                        }
                        OMOutputFormat format = new OMOutputFormat();
                        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
                        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
                        msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
                        format.setSOAP11(msgContext.isSOAP11());
                        format.setDoOptimize(msgContext.isDoingMTOM());
                        format.setDoingSWA(msgContext.isDoingSwA());
                        format.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(msgContext));
                        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
                        if (mimeBoundaryProperty != null) {
                            format.setMimeBoundary((String)mimeBoundaryProperty);
                        }
                        if (msgContext.getProperty("TRANSPORT_OUT") == null) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("nullTOTransportOut00", new Object[0], "Both the TransportOut and property MessageContext.TRANSPORT_OUT values are null.");
                            throw new AxisFault(msg);
                        }
                        this.sendUsingOutputStream(msgContext, format);
                        break block15;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSSender.invoke", "200", this);
                        throw AxisFault.makeFault(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (!_tc.isEntryEnabled()) throw throwable;
                    Tr.exit(_tc, "invoke");
                    throw throwable;
                }
            }
            Tr.exit(_tc, "invoke");
            return invocationResponse;
        }
        Object var8_9 = null;
        if (!_tc.isEntryEnabled()) return Handler.InvocationResponse.CONTINUE;
        Tr.exit(_tc, "invoke");
        return Handler.InvocationResponse.CONTINUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendUsingOutputStream(MessageContext msgContext, OMOutputFormat format) throws AxisFault, XMLStreamException, IOException {
        block46: {
            ByteArrayOutputStream out;
            boolean receivedBytesMessage = false;
            boolean specProtocol = false;
            String requestMessageId = null;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "sendUsingOutputStream");
            }
            if ((out = (ByteArrayOutputStream)msgContext.getProperty("TRANSPORT_OUT")) != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "outputStream : " + out.toString());
            }
            OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
            format.setAutoCloseWriter(true);
            MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(msgContext);
            if (messageFormatter == null) {
                String msg = NLSProvider.getNLS().getFormattedMessage("xxxxxx", new Object[0], "Response could not be written to output stream because a message formatter could not be found.");
                throw new AxisFault(msg);
            }
            String contentType = messageFormatter.getContentType(msgContext, format, JMSSender.findSOAPAction(msgContext));
            if (transportInfo != null) {
                transportInfo.setContentType(contentType);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "set contentType in transportInfo to : " + contentType);
                }
            }
            SOAPEnvelope envelope = msgContext.getEnvelope();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            envelope.serialize(baos, format);
            if (baos != null) {
                this.setPMIResponseLength(msgContext, baos.size());
            }
            if (MessageTrace.isTraceEnabled()) {
                this.traceMessage(msgContext, format);
            }
            messageFormatter.writeTo(msgContext, format, out, false);
            Message jmsMessage = null;
            if (msgContext.isFault()) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "fault msgContext ");
                }
                if (jmsMessage == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Fault msgContext : " + msgContext);
                    }
                    jmsMessage = (Message)msgContext.getProperty("JMSMESSAGE");
                }
            } else {
                MessageContext msgCtx;
                OperationContext opCtx = msgContext.getOperationContext();
                if (opCtx != null && (msgCtx = opCtx.getMessageContext("In")) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Request msgCtx : " + msgCtx);
                    }
                    jmsMessage = (Message)msgCtx.getProperty("JMSMESSAGE");
                }
            }
            try {
                Queue replyQueue = (Queue)jmsMessage.getJMSReplyTo();
                if (replyQueue != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "replyQueue : " + replyQueue);
                }
                if (replyQueue == null) break block46;
                QueueConnectionFactory qcf = this.getReplyQCF();
                QueueConnection qConnection = qcf.createQueueConnection();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Created the queue connection.");
                }
                try {
                    try {
                        String version;
                        QueueSession qSession = qConnection.createQueueSession(false, 1);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the queue session.");
                        }
                        QueueSender sender = qSession.createSender(replyQueue);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Created the queue sender.");
                        }
                        Message jmsReplyMsg = null;
                        JMSOutTransportInfo jmsOutTransportInfo = (JMSOutTransportInfo)msgContext.getProperty("OutTransportInfo");
                        if (jmsOutTransportInfo.getContentType() != null) {
                            contentType = jmsOutTransportInfo.getContentType();
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "contentType from jmsOutTransportInfo : " + contentType);
                            }
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "contentType : " + contentType);
                        }
                        if (jmsMessage instanceof BytesMessage) {
                            receivedBytesMessage = true;
                        }
                        if (receivedBytesMessage) {
                            jmsReplyMsg = qSession.createBytesMessage();
                            jmsReplyMsg.writeBytes(out.toByteArray());
                            if (MessageTrace.isTraceEnabled()) {
                                MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, contentType, out.toByteArray());
                            }
                        } else {
                            jmsReplyMsg = qSession.createTextMessage();
                            ((TextMessage)jmsReplyMsg).setText(out.toString());
                            if (MessageTrace.isTraceEnabled()) {
                                MessageTrace.log(MessageTrace.OUTBOUND_JMS_RESPONSE, contentType, out.toString());
                            }
                        }
                        if ((version = jmsMessage.getStringProperty("SOAPJMS_bindingVersion")) != null && version.length() != 0) {
                            if (version.compareTo("1.0") != 0) {
                                Object[] inserts = new Object[]{"1.0"};
                                String msg = NLSProvider.getNLS().getFormattedMessage("jmsunrecognizedBindingVersion", inserts, "The version {0} should be 1.0");
                                Tr.error(_tc, msg);
                                throw new AxisFault(msg);
                            }
                            specProtocol = true;
                        }
                        if (specProtocol) {
                            jmsReplyMsg.setStringProperty("SOAPJMS_contentType", contentType);
                            jmsReplyMsg.setStringProperty("SOAPJMS_bindingVersion", "1.0");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set SOAPJMS_contentType to : " + contentType + ", and " + "SOAPJMS_bindingVersion" + " to : " + "1.0" + " on the JMS reply message");
                            }
                        } else {
                            jmsReplyMsg.setStringProperty("contentType", contentType);
                            jmsReplyMsg.setStringProperty("transportVersion", "1");
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Set contentType to : " + contentType + ", and " + "transportVersion" + " to : " + "1" + " on the JMS reply message");
                            }
                        }
                        HashMap responseTransportHeaders = null;
                        responseTransportHeaders = (HashMap)msgContext.getProperty("com.ibm.websphere.webservices.responseTransportProperties");
                        if (responseTransportHeaders != null) {
                            this.setResponseHandlerTransportProperties(jmsReplyMsg, responseTransportHeaders);
                        }
                        requestMessageId = jmsMessage.getJMSMessageID();
                        jmsReplyMsg.setJMSCorrelationID(requestMessageId);
                        long replyTTL = jmsMessage.getJMSExpiration() - jmsMessage.getJMSTimestamp();
                        if (replyTTL < 0L) {
                            replyTTL = 0L;
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "About to send reply message:\n" + jmsReplyMsg.toString() + "\n" + "Message send options:\n" + "deliveryMode=" + jmsMessage.getJMSDeliveryMode() + ", priority=" + jmsMessage.getJMSPriority() + ", timeToLive=" + replyTTL);
                        }
                        sender.send(jmsReplyMsg, jmsMessage.getJMSDeliveryMode(), jmsMessage.getJMSPriority(), replyTTL);
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Sent the reply message.");
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.onMessage", "720", this);
                        Object[] inserts = new Object[]{e.toString()};
                        String msg = NLSProvider.getNLS().getFormattedMessage("jmsUnexpected", inserts, "Unexpected exception caught while sending reply message {0} ");
                        Tr.error(_tc, msg);
                        throw new AxisFault(msg);
                    }
                    Object var25_31 = null;
                }
                catch (Throwable throwable) {
                    Object var25_32 = null;
                    qConnection.close();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Closed the queue connection.");
                    }
                    throw throwable;
                }
                qConnection.close();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Closed the queue connection.");
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.onMessage", "737", this);
                Object[] inserts = new Object[]{e.toString()};
                String msg = NLSProvider.getNLS().getFormattedMessage("jmsUnexpected", inserts, "Unexpected exception caught while sending reply message {0} ");
                Tr.error(_tc, msg);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendUsingOutputStream");
        }
    }

    void setPMIResponseLength(MessageContext msgContext, long responseLength) {
        MessagePMIContext pmiContext = (MessagePMIContext)msgContext.getProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT");
        if (pmiContext != null) {
            pmiContext.setResponseSize(responseLength);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized QueueConnectionFactory getReplyQCF() throws Exception {
        QueueConnectionFactory replyQCF = null;
        try {
            block5: {
                try {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "getReplyQCF");
                    }
                    if (replyQCF != null) break block5;
                    InitialContext ic = this.getInitialContext();
                    String jndiName = "java:comp/env/jms/WebServicesReplyQCF";
                    replyQCF = (QueueConnectionFactory)ic.lookup(jndiName);
                    if (!_tc.isDebugEnabled()) break block5;
                    Tr.debug(_tc, "Found the QCF!");
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.getReplyQCF", "165", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to locate my reply QCF, exception = " + e.toString());
                    throw e;
                }
            }
            Object var5_5 = null;
            if (!_tc.isEntryEnabled()) return replyQCF;
            Tr.exit(_tc, "getReplyQCF");
            return replyQCF;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getReplyQCF");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getInitialContext");
        }
        InitialContext initialContext = null;
        try {
            block5: {
                try {
                    if (initialContext != null) break block5;
                    initialContext = new InitialContext();
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.getInitialContext", "114", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to create initial context!");
                    throw e;
                }
            }
            Object var4_2 = null;
            if (!_tc.isEntryEnabled()) return initialContext;
            Tr.exit(_tc, "getInitialContext");
            return initialContext;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "getInitialContext");
            throw throwable;
        }
    }

    private void setResponseHandlerTransportProperties(Message jmsMessage, HashMap responseTransportHeaders) throws AxisFault {
        try {
            if (responseTransportHeaders != null) {
                for (Map.Entry headerMapEntry : responseTransportHeaders.entrySet()) {
                    if (headerMapEntry.getKey() == null || !(headerMapEntry.getKey() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    String transportHeaderKey = ((String)headerMapEntry.getKey()).trim();
                    if (!JavaUtils.hasValue(transportHeaderKey)) {
                        Tr.warning(_tc, "invalid.transportheader.key");
                        continue;
                    }
                    if (headerMapEntry.getValue() == null || !(headerMapEntry.getValue() instanceof String)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{headerMapEntry.getValue()});
                        continue;
                    }
                    String transportHeaderValue = ((String)headerMapEntry.getValue()).trim();
                    if (!JavaUtils.hasValue(transportHeaderValue)) {
                        Tr.warning(_tc, "invalid.transportheader.value", new Object[]{transportHeaderValue});
                        continue;
                    }
                    if (jmsMessage.propertyExists(transportHeaderKey)) continue;
                    jmsMessage.setStringProperty(transportHeaderKey, transportHeaderValue);
                }
            }
        }
        catch (JMSException je) {
            FFDCFilter.processException((Throwable)je, "com.ibm.ws.websvcs.transport.jms.JMSProcessMessage.setResponseHandlerTransportProperties", "902", this);
            StringBuffer exceptionInfo = new StringBuffer();
            Object[] inserts = new Object[]{je.toString()};
            String msg = NLSProvider.getNLS().getFormattedMessage("jmsError01", inserts, "A JMS operation resulted in the specified JMSException {0}");
            exceptionInfo.append(msg);
            Exception e = je.getLinkedException();
            while (e != null) {
                exceptionInfo.append("\n");
                Object[] inserts1 = new Object[]{e.toString()};
                String msg1 = NLSProvider.getNLS().getFormattedMessage("jmsError02", inserts1, "{0}");
                e = e instanceof JMSException ? ((JMSException)e).getLinkedException() : null;
                exceptionInfo.append(msg1);
            }
            Tr.error(_tc, exceptionInfo.toString());
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, exceptionInfo.toString());
            }
            throw new AxisFault("JMS ", exceptionInfo.toString());
        }
    }

    private static String findSOAPAction(MessageContext messageContext) {
        String soapActionString = null;
        Object disableSoapAction = messageContext.getOptions().getProperty("disableSoapAction");
        if (!(JavaUtils.isTrueExplicitly(disableSoapAction) || (soapActionString = messageContext.getSoapAction()) != null && soapActionString.length() != 0)) {
            soapActionString = messageContext.getWSAAction();
            if (messageContext.getAxisOperation() != null && (soapActionString == null || soapActionString.length() == 0)) {
                soapActionString = messageContext.getAxisOperation().getSoapAction();
            }
        }
        if (soapActionString == null) {
            soapActionString = "\"\"";
        }
        return soapActionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceMessage(MessageContext msgContext, OMOutputFormat format) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceMessage");
        }
        try {
            try {
                String str = new String("OUTBOUND_JMS_RESPONSE");
                SOAPEnvelope envelope = msgContext.getEnvelope();
                CommonUtils.logDebug(envelope, _tc, 100000, format, str);
            }
            catch (Throwable t) {
                Tr.debug(_tc, "Response message could not be traced because of the following error: " + t.toString());
                Object var6_7 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "traceResponse");
                return;
            }
            Object var6_6 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "traceResponse");
            throw throwable;
        }
        Tr.exit(_tc, "traceResponse");
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }
}

