/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.common.ConfigFromJAX_WS;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.websvcs.transport.policyset.jms.jaxb.CustomProperty;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;

public class JMSEffectiveConfig
extends ConfigFromJAX_WS {
    private static final TraceComponent _tc = Tr.register(JMSEffectiveConfig.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final int defaultRequestTimeout = 300;
    private Properties policy = null;
    protected static final String emptyString = "";

    public JMSEffectiveConfig(MessageContext mc) {
        super(false);
        this.policy = this.extractEffectivePolicy(mc);
    }

    public boolean isPolicySetDefined() {
        return this.policy != null && !this.policy.isEmpty();
    }

    private Properties extractEffectivePolicy(MessageContext mc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSEffectiveConfig.extractEffectivePolicy()... ");
        }
        Properties p = null;
        try {
            AxisService service;
            PolicySetConfiguration policySet = null;
            AxisOperation operation = mc.getAxisOperation();
            if (operation != null && (policySet = (PolicySetConfiguration)Axis2Utils.getPolicySet(operation)) != null) {
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("JMS_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("JMS_BINDING");
                if (_tc.isDebugEnabled()) {
                    String result = PolicySetUtils.maskPasswords(bind);
                    Tr.debug(_tc, "JMS Policy Type " + type + " JMS Policy Binding " + result + " found for operation " + operation + "'.");
                }
                if (type != null && !type.isEmpty()) {
                    p = new Properties();
                    p.putAll((Map<?, ?>)type);
                    if (bind != null && !bind.isEmpty()) {
                        p.putAll((Map<?, ?>)bind);
                    }
                }
            }
            if (p == null && (service = mc.getAxisService()) != null && (policySet = (PolicySetConfiguration)Axis2Utils.getPolicySet(service)) != null) {
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("JMS_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("JMS_BINDING");
                if (_tc.isDebugEnabled()) {
                    String result = PolicySetUtils.maskPasswords(bind);
                    Tr.debug(_tc, "JMS Policy Type " + type + " JMS Policy Binding " + result + " found for service " + service + "'.");
                }
                if (type != null && !type.isEmpty()) {
                    p = new Properties();
                    p.putAll((Map<?, ?>)type);
                    if (bind != null && !bind.isEmpty()) {
                        p.putAll((Map<?, ?>)bind);
                    }
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.jms.JMSEffectiveConfig.extractEffectivePolicy", "179", this);
            Tr.error(_tc, JavaUtils.stackToString(ex));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSEffectiveConfig.extractEffectivePolicy()");
        }
        return p;
    }

    public int getRequestTimeout(MessageContext mc) {
        int result = 0;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("requestTimeout");
        }
        try {
            if (!JavaUtils.hasValue(policyValue)) {
                result = super.getRequestTimeout(mc);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Values retrieved from message context.");
                }
            } else {
                result = Integer.parseInt(policyValue);
            }
            if (result <= 0) {
                result = 300;
            }
        }
        catch (NumberFormatException nEX) {
            FFDCFilter.processException((Throwable)nEX, "com.ibm.ws.websvcs.transport.jms.JMSEffectiveConfig.getReadTimeout", "230", this);
            result = 300;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSEffectiveConfig.getRequestTimeout (sec): " + result);
        }
        return result * 1000;
    }

    public boolean getAllowTransactionalAsyncMessaging(MessageContext mc) {
        boolean result = false;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("allowTransactionalAsyncMessaging");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.getAllowTransactionalAsyncMessaging(mc);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Values retrieved from message context.");
            }
        } else {
            result = JavaUtils.isTrue(policyValue);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSEffectiveConfig.getAllowTransactionalAsyncMessaging: " + result);
        }
        return result;
    }

    public String getOutRequestPassword(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestBasicAuth:password");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestPassword(mc);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSEffectiveConfig.getOutRequestPassword()... : " + (JavaUtils.hasValue(result) ? "******" : emptyString));
        }
        if (result == null) {
            result = emptyString;
        }
        return result;
    }

    public String getOutRequestUserID(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestBasicAuth:userid");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestUserID(mc);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "JMSEffectiveConfig.getOutRequestUserID()... : " + result);
        }
        if (result == null) {
            result = emptyString;
        }
        return result;
    }

    public String getOutAsyncRespUserID(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseBasicAuth:userid");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespUserID(mc);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespUserID()... : " + result);
        }
        if (result == null) {
            result = emptyString;
        }
        return result;
    }

    public String getOutAsyncRespPassword(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseBasicAuth:password");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespPassword(mc);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespPassword()... : " + (JavaUtils.hasValue(result) ? "******" : emptyString));
        }
        if (result == null) {
            result = emptyString;
        }
        return result;
    }

    public String getCustomProperty(MessageContext mc, String propName) {
        com.ibm.ws.websvcs.transport.policyset.jms.jaxb.Properties jaxbP;
        String result = null;
        if (this.isPolicySetDefined() && (jaxbP = (com.ibm.ws.websvcs.transport.policyset.jms.jaxb.Properties)this.policy.get("properties")) != null) {
            List<CustomProperty> customProperties = jaxbP.getCustomProperty();
            for (CustomProperty prop : customProperties) {
                if (!propName.equals(prop.getName())) continue;
                result = prop.getValue();
                break;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...JMSEffectiveConfig.getCustomProperty() : " + result);
        }
        return result;
    }
}

