/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.jms;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.jms.AsyncMessageListener;
import com.ibm.wsspi.jms.JmsMessageListenerSupport;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;

public class JMSConnectionFactory {
    private static final TraceComponent _tc = Tr.register(JMSConnectionFactory.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String destinationName = null;
    private String jndiDestination = null;
    private String jndiCF = null;
    private Hashtable properties = null;
    private InitialContext context = null;
    private QueueConnectionFactory conFactory = null;
    private Queue destination = null;
    private QueueSession session = null;
    private QueueConnection connection = null;

    JMSConnectionFactory(String jndiCF, String jndiDestination) {
        this.jndiDestination = jndiDestination;
        this.jndiCF = jndiCF;
        this.properties = new Hashtable();
    }

    JMSConnectionFactory(String jndiDestination) {
        this(null, jndiDestination);
    }

    JMSConnectionFactory() {
        this(null, null);
    }

    public void connect() throws Exception {
        InitialContext ic = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSConnectionFactory.connect()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to look up QCF: " + this.jndiCF);
        }
        try {
            ic = this.getInitialContext();
            this.conFactory = (QueueConnectionFactory)ic.lookup(this.jndiCF);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSConnectionFactory.connect", "142", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Failed to locate my QCF, exception = " + e.toString());
            }
            throw e;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "About to look up destination: " + this.jndiDestination);
        }
        try {
            this.destination = (Queue)ic.lookup(this.jndiDestination);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSConnectionFactory.connect", "142", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Failed to locate destination : " + this.jndiDestination + " , exception = " + e.toString());
            }
            throw e;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSConnectionFactory.connect() connection factory : " + this.jndiCF + " destination : " + this.jndiDestination);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InitialContext getInitialContext() throws NamingException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSConnectionFactory.getInitialContext()...");
        }
        try {
            block5: {
                try {
                    if (this.context != null) break block5;
                    this.context = new InitialContext();
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.jms.JMSConnectionFactory.getInitialContext", "178", this);
                    if (!_tc.isDebugEnabled()) throw e;
                    Tr.debug(_tc, "Failed to create initial context!");
                    throw e;
                }
            }
            Object var3_1 = null;
            if (!_tc.isEntryEnabled()) return this.context;
            Tr.exit(_tc, "...JMSConnectionFactory.getInitialContext()");
            return this.context;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "...JMSConnectionFactory.getInitialContext()");
            throw throwable;
        }
    }

    public void setJndiCFName(String jndiCFName) {
        this.jndiCF = jndiCFName;
    }

    public void addProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public String getJndiDestination() {
        return this.jndiDestination;
    }

    public String getJndiCF() {
        return this.jndiCF;
    }

    public QueueConnectionFactory getConFactory() {
        return this.conFactory;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public String listen(AsyncMessageListener msgListener) throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSConnectionFactory.listen()");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Connection factory : " + this.conFactory.toString() + " initializing...");
        }
        if (this.conFactory == null || this.context == null) {
            this.handleException("Connection factory must be 'connected' before listening");
        } else {
            try {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Creating Queue connection");
                }
                this.connection = this.conFactory.createQueueConnection();
            }
            catch (JMSException e) {
                this.handleException("Error creating a JMS connection using the factory : " + this.jndiCF, e);
            }
        }
        try {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating session");
            }
            this.session = this.connection.createQueueSession(false, 1);
            if (this.destination == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Creating a Temperory Queue");
                }
                this.destination = this.session.createTemporaryQueue();
            }
            this.destinationName = this.destination.getQueueName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Creating consumer");
            }
            MessageConsumer consumer = this.session.createConsumer(this.destination);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created the queue session.");
            }
            JmsMessageListenerSupport.setMessageListener((MessageConsumer)consumer, (MessageListener)msgListener);
            this.start();
        }
        catch (JMSException e) {
            this.handleException("Error connecting using the factory : " + this.jndiCF, e);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...JMSConnectionFactory.listen(). Connection factory : " + this.conFactory.toString() + " initialized...");
        }
        return null;
    }

    public void start() throws AxisFault {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "JMSConnectionFactory.start()...");
        }
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            this.handleException("Error connecting using the factory : " + this.jndiCF, e);
        }
        Tr.exit(_tc, "...JMSConnectionFactory.start(). JMS Connection : " + this.connection.toString());
    }

    public void stop() {
        try {
            this.session.close();
            this.connection.close();
        }
        catch (JMSException e) {
            Tr.warning(_tc, "Error shutting down connection factory : " + this.destinationName, e);
        }
    }

    private void handleException(String msg) throws AxisFault {
        Tr.error(_tc, msg);
        throw new AxisFault(msg);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        Tr.error(_tc, msg, e);
        throw new AxisFault(msg, e);
    }
}

