/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http.out;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundLink;
import com.ibm.ws.http.channel.outbound.impl.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;
import java.util.ArrayList;
import org.apache.axis2.transport.http.HTTPConstants;

public abstract class HttpOutWriter {
    private static TraceComponent tc = Tr.register(HttpOutWriter.class, "HttpOutWriter", "com.ibm.ws.websvcs.transport.http.out");
    HttpOutboundServiceContext outboundServiceCtx = null;
    HttpOutboundLink outboundLink = null;
    ArrayList writeQueue = new ArrayList();
    boolean writing = false;
    boolean writingHeaders = false;
    boolean isHeaderWritten = false;
    boolean doClose = false;
    boolean doFinishBuffer = false;
    boolean hadError = false;
    boolean handledError = false;
    Exception closeException = null;
    boolean writeTypeSynch = true;
    int counter = 0;

    public HttpOutWriter(HttpOutboundServiceContext outboundServiceCtx) {
        this.outboundServiceCtx = outboundServiceCtx;
        HttpOutboundServiceContextImpl oscImpl = (HttpOutboundServiceContextImpl)outboundServiceCtx;
        this.outboundLink = oscImpl.getLink();
    }

    public abstract void writeHeaders();

    abstract void writeBufferRequest(WsByteBuffer[] var1);

    abstract void finishBufferRequest(WsByteBuffer[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBuffer(WsByteBuffer[] buffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBuffer");
        }
        this.writeHeader(buffer);
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            if (this.hadError) {
                if (this.handledError) {
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error state, ignoring write buffers");
                }
                this.releaseByteBuffers(buffer);
                this.handledError = true;
                this.complete(this.outboundLink.getVirtualConnection());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "writeBuffer");
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Writing = " + (this.writing ? "true" : "false"));
                Tr.debug(tc, "writeQueue isEmpty = " + (this.writeQueue.isEmpty() ? "true" : "false"));
            }
            if (this.writeQueue.isEmpty() && !this.writing) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Direct write");
                }
                if (buffer != null) {
                    this.writeQueue.add(buffer);
                }
                if (this.doFinishBuffer) {
                    this.finishBufferRequest(buffer);
                } else {
                    this.writeBufferRequest(buffer);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "writeBuffer, Adding to queue");
                }
                if (buffer != null) {
                    this.writeQueue.add(buffer);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBuffer");
        }
    }

    public Exception getCloseException() {
        return this.closeException;
    }

    public boolean handledError() {
        return this.handledError;
    }

    public void setDoFinishBuffer(boolean doFinishBuffer) {
        this.doFinishBuffer = doFinishBuffer;
    }

    void releaseByteBuffers(WsByteBuffer[] buffers) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseByteBuffers");
        }
        for (int i = 0; i < buffers.length; ++i) {
            if (buffers[i] == null) {
                return;
            }
            buffers[i].release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(VirtualConnection vc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Complete callback --> " + (vc == null ? "null" : vc.toString()));
        }
        boolean doClose_copy = false;
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            if (this.writingHeaders) {
                this.writingHeaders = false;
            } else if (!this.writeQueue.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Complete, remove the old byte buffer");
                }
                WsByteBuffer[] oldBuffer = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(oldBuffer);
            }
            if (this.writeQueue.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Complete, write queue is empty");
                }
                this.writing = false;
                if (this.doClose) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Indicate close to be called --> " + (vc == null ? "null" : vc.toString()));
                    }
                    doClose_copy = true;
                    this.doClose = false;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Complete, write queue is not empty, do another write");
                }
                WsByteBuffer[] buffer = (WsByteBuffer[])this.writeQueue.get(0);
                if (this.doFinishBuffer && this.writeQueue.size() == 1) {
                    this.finishBufferRequest(buffer);
                } else {
                    this.writeBufferRequest(buffer);
                }
            }
        }
        if (doClose_copy) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing in complete outside lock --> " + (vc == null ? "null" : vc.toString()));
            }
            doClose_copy = false;
            this.outboundLink.close(vc, this.closeException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Complete callback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(VirtualConnection vc, Throwable t) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Error callback --> " + vc.toString() + " exception --> " + t.getMessage());
        }
        boolean doClose_copy = false;
        ArrayList arrayList = this.writeQueue;
        synchronized (arrayList) {
            this.hadError = true;
            this.writing = false;
            while (!this.writeQueue.isEmpty()) {
                WsByteBuffer[] oldBuffer = (WsByteBuffer[])this.writeQueue.remove(0);
                this.releaseByteBuffers(oldBuffer);
            }
            this.closeException = (Exception)t;
            if (this.doClose) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Closing in error --> " + vc.toString());
                }
                doClose_copy = true;
                this.doClose = false;
            }
        }
        if (doClose_copy) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Closing in error --> " + vc.toString());
            }
            doClose_copy = false;
            this.outboundLink.close(vc, this.closeException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Error callback");
        }
    }

    private void writeHeader(WsByteBuffer[] buffer) {
        if (!this.isHeaderWritten) {
            int contentLength = WsByteBufferUtils.lengthOf(buffer);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Buffer length = " + contentLength);
            }
            if (contentLength < 32768 && this.outboundServiceCtx.isIncomingMessageFullyRead()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Setting Content-Length on Header");
                }
                HttpRequestMessage req = this.outboundServiceCtx.getRequest();
                req.removeHeader(HTTPConstants.HEADER_TRANSFER_ENCODING);
                req.setContentLength(contentLength);
            }
            this.writeHeaders();
            this.isHeaderWritten = true;
        }
    }
}

