/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http.out;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.websvcs.transport.http.out.ClosedConnectionException;
import com.ibm.ws.websvcs.transport.http.out.HttpOutWriter;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.IOException;
import java.io.OutputStream;

public class HttpOutByteBufferOutputStream
extends OutputStream {
    private static TraceComponent tc = Tr.register(HttpOutByteBufferOutputStream.class, "ByteBufferOutputStream", "com.ibm.ws.websvcs.transport.http.out");
    private HttpOutWriter outWriter;
    private boolean flushToWire;
    private WsByteBuffer[] buffersToWrite;
    private int arrayPos;
    private int arraySize;
    private int expectedRemaining;
    private boolean hadCorruptionError = false;
    private int bufferSize = 32768;
    private static final int useBufferSize = 8192;
    private long bytesWritten = -1L;

    public HttpOutByteBufferOutputStream(HttpOutWriter _outWriter) {
        this.outWriter = _outWriter;
        this.flushToWire = false;
        this.arraySize = this.bufferSize / 8192;
        if (this.bufferSize % 8192 != 0) {
            ++this.arraySize;
        }
        this.resetWriteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "HttpByteBufferOutputStream created :" + this);
        }
    }

    public void write(int ch) throws IOException {
        if (this.linkHandledError()) {
            Exception linkClosedException = this.outWriter.getCloseException();
            throw new ClosedConnectionException("OutputStream encountered error during write", linkClosedException);
        }
        if (!this.checkWriteArray()) {
            throw new IOException("Response buffer corruption detected : response terminated");
        }
        this.buffersToWrite[this.arrayPos].put((byte)ch);
        this.expectedRemaining = this.buffersToWrite[this.arrayPos].remaining();
        ++this.bytesWritten;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: write(int) new reamining = " + this.expectedRemaining + ", buffer : " + this.buffersToWrite[this.arrayPos]);
        }
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        int toWrite = 0;
        int hasWritten = 0;
        int remaining = 0;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: write, This = : " + this);
        }
        while (hasWritten != length) {
            if (this.linkHandledError()) {
                Exception linkClosedException = this.outWriter.getCloseException();
                throw new ClosedConnectionException("OutputStream encountered error during write", linkClosedException);
            }
            if (!this.checkWriteArray()) {
                throw new IOException("buffer corruption detected : request terminated");
            }
            toWrite = length - hasWritten;
            remaining = this.buffersToWrite[this.arrayPos].remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream:  To write len = " + toWrite + ", remaining = " + remaining + ", buffer : " + this.buffersToWrite[this.arrayPos]);
            }
            if (toWrite <= remaining) {
                this.buffersToWrite[this.arrayPos].put(buf, offset + hasWritten, toWrite);
                hasWritten += toWrite;
                this.expectedRemaining -= toWrite;
                this.bytesWritten += (long)toWrite;
                continue;
            }
            this.buffersToWrite[this.arrayPos].put(buf, offset + hasWritten, remaining);
            hasWritten += remaining;
            this.expectedRemaining -= remaining;
            this.bytesWritten += (long)remaining;
        }
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public final void print(char[] buf, int offset, int length) throws IOException {
        int toWrite = 0;
        int hasWritten = 0;
        int remaining = 0;
        while (hasWritten != length) {
            if (this.linkHandledError()) {
                Exception linkClosedException = this.outWriter.getCloseException();
                throw new ClosedConnectionException("OutputStream encountered error during write", linkClosedException);
            }
            if (!this.checkWriteArray()) {
                throw new IOException("Response buffer corruption detected : response terminated");
            }
            toWrite = length - hasWritten;
            remaining = this.buffersToWrite[this.arrayPos].remaining();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream: To write len = " + toWrite + ", remaining = " + remaining + ", buffer : " + this.buffersToWrite[this.arrayPos]);
            }
            if (toWrite <= remaining) {
                this.buffersToWrite[this.arrayPos].putChar(buf, offset + hasWritten, toWrite);
                hasWritten += toWrite;
                this.expectedRemaining -= toWrite;
                continue;
            }
            this.buffersToWrite[this.arrayPos].putChar(buf, offset + hasWritten, remaining);
            hasWritten += remaining;
            this.expectedRemaining -= remaining;
        }
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
    }

    public final void print(char ch) throws IOException {
        this.write(ch);
    }

    public final void print(char[] buffer) throws IOException {
        this.print(buffer, 0, buffer.length);
    }

    public final void print(String string) throws IOException {
        this.print(string, 0, string.length());
    }

    public final void print(String string, int off, int len) throws IOException {
        byte[] bytes = string.getBytes();
        this.write(bytes, off, len);
    }

    public final void print(boolean b) throws IOException {
        this.print(String.valueOf(b));
    }

    public final void print(int i) throws IOException {
        String s = Integer.toString(i);
        this.print(s);
    }

    public final void print(long i) throws IOException {
        String s = Long.toString(i);
        this.print(s);
    }

    public final void print(float f) throws IOException {
        String s = Float.toString(f);
        this.print(s);
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        this.print(o.toString());
    }

    public void setFlushMode(boolean _flushToWire) {
        this.flushToWire = _flushToWire;
    }

    public boolean getFlushMode() {
        return this.flushToWire;
    }

    public void writeHeaders() {
        this.outWriter.writeHeaders();
    }

    public boolean hasContentBuffered() {
        return this.buffersToWrite[0] != null;
    }

    private boolean checkWriteArray() {
        if (this.hadCorruptionError) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "CheckWriteArray returning false - response buffer corruption previously detected");
            }
            return false;
        }
        if (this.buffersToWrite[0] == null) {
            this.buffersToWrite[0] = this.getNewByteBuffer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream: First New buffer obtained : " + this.buffersToWrite[0]);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "OutputStream: Buffer remaining: Expected=" + this.expectedRemaining + ", actual=" + this.buffersToWrite[this.arrayPos].remaining() + ", arrayPos = " + this.arrayPos + ", buffer : " + this.buffersToWrite[this.arrayPos]);
            }
            if (this.buffersToWrite[this.arrayPos].remaining() != this.expectedRemaining) {
                this.hadCorruptionError = true;
                Tr.error(tc, "Response buffer corruption detected. Expected remaining=" + this.expectedRemaining + ", actual=" + this.buffersToWrite[this.arrayPos].remaining());
                for (int i = 0; i <= this.arrayPos; ++i) {
                    if (this.buffersToWrite[i] == null) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Releasing buffer :" + this.buffersToWrite[i]);
                    }
                    this.buffersToWrite[i].release();
                    this.buffersToWrite[i] = null;
                }
                return false;
            }
            if (this.buffersToWrite[this.arrayPos].hasRemaining()) {
                return true;
            }
            if (this.arrayPos + 1 == this.buffersToWrite.length) {
                this.flushWriteBuffer();
                this.buffersToWrite[0] = this.getNewByteBuffer();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OutputStream: Buffers flushed. New first buffer obtained : " + this.buffersToWrite[0]);
                }
            } else {
                this.buffersToWrite[this.arrayPos].flip();
                ++this.arrayPos;
                this.buffersToWrite[this.arrayPos] = this.getNewByteBuffer();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "OutputStream: array pos = " + this.arrayPos + ", New buffer obtained : " + this.buffersToWrite[this.arrayPos]);
                }
            }
        }
        return true;
    }

    public void flushWriteBuffer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flushWriteBuffer()");
        }
        if (this.buffersToWrite[0] != null && !this.linkHandledError() && !this.hadCorruptionError) {
            if (this.buffersToWrite[this.arrayPos] != null) {
                this.buffersToWrite[this.arrayPos].flip();
            }
            WsByteBuffer[] tmpBuffer = this.buffersToWrite;
            this.resetWriteArray();
            this.outWriter.writeBuffer(tmpBuffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flushWriteBuffer()");
        }
    }

    private void resetWriteArray() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "OutputStream: ResetWriteArray");
        }
        this.buffersToWrite = new WsByteBuffer[this.arraySize];
        this.arrayPos = 0;
    }

    private WsByteBuffer getNewByteBuffer() {
        this.expectedRemaining = 8192;
        return WsByteBufferPoolManagerImpl.getRef().allocateDirect(8192);
    }

    public boolean linkHandledError() {
        return this.outWriter.handledError();
    }

    public void finish() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finish()");
        }
        this.flushWriteBuffer();
        this.outWriter.setDoFinishBuffer(true);
        this.outWriter.writeBuffer(new WsByteBuffer[0]);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finish()");
        }
    }

    public void flush() throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "flush()");
        }
        super.flush();
        if (this.flushToWire) {
            this.flushWriteBuffer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "flush()");
        }
    }

    public HttpOutWriter getOutWriter() {
        return this.outWriter;
    }

    public long size() {
        return this.bytesWritten + 1L;
    }
}

