/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http.out;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.WSOutboundCFCallbackImpl;
import com.ibm.ws.websvcs.transport.http.out.HttpOutWriter;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.outbound.HttpOutboundServiceContext;

public class HttpOutAsyncWriter
extends HttpOutWriter
implements InterChannelCallback {
    private WSOutboundCFCallbackImpl responseProcessor = null;
    private boolean processResponse = false;
    private static TraceComponent tc = Tr.register(HttpOutAsyncWriter.class, "HttpOutAsyncWriter", "com.ibm.ws.websvcs.transport.http.out");

    public HttpOutAsyncWriter(HttpOutboundServiceContext outboundServiceCtx) {
        super(outboundServiceCtx);
    }

    public HttpOutAsyncWriter(HttpOutboundServiceContext outboundServiceCtx, WSOutboundCFCallbackImpl responseProcessor) {
        super(outboundServiceCtx);
        this.responseProcessor = responseProcessor;
    }

    void finishBufferRequest(WsByteBuffer[] buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "finishBufferRequest");
        }
        this.writing = true;
        try {
            VirtualConnection vc = null;
            this.processResponse = true;
            vc = this.outboundServiceCtx.finishRequestMessage(buffer, this, true);
            if (vc != null) {
                this.complete(vc);
            }
        }
        catch (Exception e) {
            this.error(this.outboundLink.getVirtualConnection(), e);
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.out.finishBufferRequest", "48", this);
            Tr.error(tc, "Exception in finishBufferRequest: " + e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "finishBufferRequest");
        }
    }

    void writeBufferRequest(WsByteBuffer[] buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeBufferRequest");
        }
        this.writing = true;
        boolean forceQueue = false;
        try {
            VirtualConnection vc;
            if (this.counter >= 10) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Now at 10 nested calls to writeBufferAsynch  - force an asynch write");
                }
                forceQueue = true;
            }
            if ((vc = this.outboundServiceCtx.sendRequestBody(buffer, this, forceQueue)) != null) {
                ++this.counter;
                this.complete(vc);
            }
            this.counter = 0;
        }
        catch (Exception e) {
            this.error(this.outboundLink.getVirtualConnection(), e);
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.out.HttpOutAsyncWriter", "72", this);
            Tr.error(tc, "Exception in writeBufferRequest: " + e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeBufferRequest");
        }
    }

    public void writeHeaders() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "writeHeaders");
        }
        this.writing = true;
        this.writingHeaders = true;
        try {
            VirtualConnection vc = null;
            vc = this.outboundServiceCtx.sendRequestHeaders(this, false);
            if (vc != null) {
                this.complete(vc);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.out.HttpOutAsyncWriter", "96", this);
            Tr.error(tc, "Exception in writeHeaders: " + e.getMessage());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "writeHeaders");
        }
    }

    public void complete(VirtualConnection vc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "complete");
        }
        if (this.processResponse) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process Response Complete");
            }
            this.responseProcessor.complete(vc);
        } else {
            super.complete(vc);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "complete");
        }
    }

    public void error(VirtualConnection vc, Throwable t) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "error");
        }
        if (this.processResponse) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Process Response Error");
            }
            this.responseProcessor.error(vc, t);
        } else {
            super.error(vc, t);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "exit");
        }
    }

    public void setResponseProcessor(WSOutboundCFCallbackImpl responseProcessor) {
        this.responseProcessor = responseProcessor;
    }
}

