/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.resources.NLSProvider;
import java.util.Map;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.spi.migrator.ApplicationContextMigrator;
import org.apache.axis2.jaxws.util.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSAppContextMigrator
implements ApplicationContextMigrator {
    private static final TraceComponent _tc = Tr.register(WSAppContextMigrator.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final int ASYNC_TIMEOUT_MILLISECONDS_DEFAULT = 90000;

    @Override
    public void migratePropertiesFromMessageContext(Map<String, Object> userContext, MessageContext mc) {
        this.getResponseTransportProperties(userContext, mc);
    }

    @Override
    public void migratePropertiesToMessageContext(Map<String, Object> userContext, MessageContext mc) {
        this.setAsyncTimeout(userContext, mc);
        this.setUseAsyncMep(userContext, mc);
    }

    private void setUseAsyncMep(Map<String, Object> userContext, MessageContext mc) {
        Object object = userContext.get("com.ibm.websphere.webservices.use.async.mep");
        if (object != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting USE_ASYNC_MEP to: " + String.valueOf(object));
            }
            mc.setProperty(Constants.USE_ASYNC_MEP, object);
        }
    }

    private void setAsyncTimeout(Map<String, Object> userContext, MessageContext mc) {
        Object value = userContext.get("com.ibm.websphere.webservices.jaxws.asynctimeout");
        if (value != null) {
            if (value instanceof Long) {
                Long timeout = (Long)value;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS property on Axis2 options to value: " + timeout);
                }
                mc.getAxisMessageContext().getOptions().setTimeOutInMilliSeconds(timeout);
            } else if (value instanceof Integer) {
                Long timeout = ((Integer)value).longValue();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS property on Axis2 options to value: " + timeout);
                }
                mc.getAxisMessageContext().getOptions().setTimeOutInMilliSeconds(timeout);
            } else {
                Tr.info(_tc, "Found property com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS but it was not of type Long or of type Integer.");
            }
        } else {
            mc.getAxisMessageContext().getOptions().setTimeOutInMilliSeconds(90000L);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting com.ibm.websphere.webservices.jaxws.Constants.ASYNC_TIMEOUT_MILLISECONDS property default value: 90000");
            }
        }
    }

    private void getResponseTransportProperties(Map<String, Object> userContext, MessageContext mc) {
        try {
            Object value;
            if (mc.getAxisMessageContext() == null || mc.getAxisMessageContext().getOperationContext() == null) {
                return;
            }
            org.apache.axis2.context.MessageContext context = mc.getAxisMessageContext().getOperationContext().getMessageContext("Out");
            if (context != null && (value = context.getProperty("com.ibm.websphere.webservices.responseTransportProperties")) != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting com.ibm.websphere.webservices.Constants.RESPONSE_TRANSPORT_PROPERTIES on user context: " + value.toString());
                }
                userContext.put("com.ibm.websphere.webservices.responseTransportProperties", value);
            }
        }
        catch (Throwable t) {
            String msg = NLSProvider.getNLS().getFormattedMessage("getRTPropsFail00", new Object[]{t}, "The following error occurred while attempting to retrieve the com.ibm.websphere.webservices.Constants.RESPONSE_TRANSPORT_PROPERTIES property from the response: {0}");
            Tr.error(_tc, msg);
        }
    }
}

