/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.webservices.management.Endpoint;
import com.ibm.ws.webservices.management.EndpointManagerMBeanImpl;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.webservices.utils.WebServiceUtils;
import com.ibm.ws.websvcs.exception.ConfigurationException;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.LogFilterInputStream;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.common.InvocationPatternHelper;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.wsdl.JaxWSCatalogAccessor;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.security.context.ContextManager;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.jaxws.description.builder.WsdlComposite;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.AxisServlet;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ListingAgent;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WASAxis2Servlet
extends AxisServlet {
    private static final TraceComponent _tc = Tr.register(WASAxis2Servlet.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private transient ListingAgent agent;
    private boolean closeReader = true;
    private EndpointManagerMBeanImpl endptMgrMBean = null;

    @Override
    public void init() throws ServletException {
        if (this.servletConfig != null) {
            this.init(this.servletConfig);
        }
    }

    @Override
    public void init(ServletConfig config2) throws ServletException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "init");
        }
        try {
            ServerModuleMetaData smmd;
            WASAxis2Service service = WsServiceRegistry.getService(this, WASAxis2Service.class);
            String servletContextName = config2.getServletContext().getServletContextName();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to get configContext from servlet with context name = " + servletContextName);
                Tr.debug(_tc, "WASAxis2Service= " + service.toString());
            }
            if ((smmd = (ServerModuleMetaData)service.getModuleMetaData()) == null) {
                throw new ConfigurationException("Could not retrieve server module metadata in Axis servlet for module: " + servletContextName);
            }
            this.configContext = smmd.getConfigurationContext();
            if (this.configContext == null) {
                throw new ConfigurationException("Could not retrieve configuration context in Axis servlet for module: " + servletContextName);
            }
            this.endptMgrMBean = (EndpointManagerMBeanImpl)Axis2Utils.getEndpointManagerMBean(this.configContext);
            if (this.endptMgrMBean == null) {
                Object[] inserts = new Object[]{Axis2Utils.getApplicationName(this.configContext.getAxisConfiguration()), Axis2Utils.getModuleName(this.configContext.getAxisConfiguration())};
                String msg = NLSProvider.getNLS().getFormattedMessage("mbeanNotFound00", inserts, "Could not find the Endpoint Manager MBean for the application {0}, module {1}.");
                Tr.error(_tc, "mbeanNotFound00", inserts);
                throw new ConfigurationException(msg);
            }
            this.servletConfig = config2;
            this.axisConfiguration = this.configContext.getAxisConfiguration();
            config2.getServletContext().setAttribute("CONFIGURATION_CONTEXT", this.configContext);
            ListenerManager listenerManager = new ListenerManager();
            listenerManager.init(this.configContext);
            TransportInDescription transportInDescription = new TransportInDescription("http");
            transportInDescription.setReceiver(this);
            listenerManager.addListener(transportInDescription, true);
            ListenerManager.defaultConfigurationContext = this.configContext;
            this.agent = new ListingAgent(this.configContext);
            Parameter parameter = this.axisConfiguration.getParameter("axis2.close.reader");
            if (parameter != null) {
                this.closeReader = JavaUtils.isTrueExplicitly(parameter.getValue());
            }
        }
        catch (ConfigurationException ce) {
            FFDCFilter.processException((Throwable)ce, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.init", "149", this);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ce.printStackTrace(pw);
            Tr.error(_tc, "The following exception was encountered while attempting to load the ConfigurationContext for the servlet:  " + ce.toString() + "\n" + sw.toString());
            throw new ServletException(ce);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.init", "159", this);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Tr.error(_tc, "The following exception was encountered while attempting to initialize the servlet: " + e.toString() + "\n" + sw.toString());
            throw new ServletException(e);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "init");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, FileNotFoundException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "doGet");
        }
        try {
            try {
                AxisService axisService;
                String requestURLString = req.getRequestURL().toString();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "requestURL = " + requestURLString);
                }
                String servletPath = req.getServletPath();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "servletPath = " + servletPath);
                }
                if ((axisService = this.findServiceForRequestURL(servletPath)) != null) {
                    Endpoint endpoint = this.endptMgrMBean.getEndpointListenerWithUrlPattern(Axis2Utils.getURLPattern(axisService));
                    if (endpoint == null) {
                        Object[] inserts = new Object[]{servletPath};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointNotFound00", inserts, "Could not find the endpoint for URL {0}.");
                        Tr.error(_tc, "endpointNotFound00", inserts);
                        throw new FileNotFoundException(msg);
                    }
                    if (endpoint.getState() != 2) {
                        Object[] inserts = new Object[]{servletPath};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointStopped00", inserts, "The endpoint is currently stopped for URL {0}.");
                        Tr.error(_tc, "endpointStopped00", inserts);
                        throw new FileNotFoundException(msg);
                    }
                    boolean forWSDL = false;
                    boolean forXSD = false;
                    String queryString = req.getQueryString();
                    forWSDL = queryString != null && queryString.equalsIgnoreCase("/wsdl".substring(1));
                    forWSDL = forWSDL || servletPath.endsWith("/wsdl") || servletPath.endsWith("/wsdl/");
                    forWSDL = forWSDL || requestURLString.toLowerCase().endsWith(".wsdl");
                    forXSD = requestURLString.toLowerCase().endsWith(".xsd");
                    if (forXSD) {
                        this.processXsdRequest(req, resp, axisService);
                    }
                    if (forWSDL) {
                        this.processWsdlRequest(req, resp, axisService);
                    }
                    this.reportAvailableServices(resp, axisService);
                }
                this.reportServiceNotExist(resp, req.getRequestURI());
            }
            catch (FileNotFoundException fnfe) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Endpoint was down, returning 404 exception...");
                }
                resp.setStatus(404);
                throw fnfe;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.doGet", "231", this);
                throw new ServletException(e);
            }
            Object var11_16 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "doGet");
            throw throwable;
        }
        Tr.exit(_tc, "doGet");
    }

    private AxisService findServiceForRequestURL(String servletPath) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "findServiceForRequestURL, servletPath=" + servletPath);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Trying to find Axis Service with URI: " + servletPath);
        }
        AxisService axisService = this.findServiceWithUrlPattern(this.configContext.getAxisConfiguration(), servletPath);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findServiceForRequestURL, axisService=" + (axisService == null ? "<not found>" : axisService.getName()));
        }
        return axisService;
    }

    private AxisService findServiceWithUrlPattern(AxisConfiguration axisCfg, String urlPattern) {
        Iterator svcGrpIter = axisCfg.getServiceGroups();
        while (svcGrpIter.hasNext()) {
            AxisServiceGroup svcGrp = (AxisServiceGroup)svcGrpIter.next();
            Iterator svcIter = svcGrp.getServices();
            while (svcIter.hasNext()) {
                AxisService svc = (AxisService)svcIter.next();
                String t = Axis2Utils.getURLPattern(svc);
                if (t == null || !urlPattern.equals(t) && !urlPattern.startsWith(t + "/") && !t.equals("/*")) continue;
                return svc;
            }
        }
        return null;
    }

    private void processWsdlRequest(HttpServletRequest req, HttpServletResponse resp, AxisService as) throws AxisFault, ServletException, IOException {
        String requestString = req.getRequestURL().toString();
        String pathInfo = req.getPathInfo();
        String serviceUriPath = Axis2Utils.getURLPattern(as);
        String wsdlFileRelativePath = Axis2Utils.getWSDLLocation(as);
        boolean isSCAAbsolute = false;
        JaxWSCatalogAccessor accessor = (JaxWSCatalogAccessor)this.configContext.getProperty("com.ibm.ws.websvcs.JAXWS_CATALOG_ACCESSOR");
        if (accessor != null) {
            wsdlFileRelativePath = accessor.resolveLocation(wsdlFileRelativePath);
        }
        if (serviceUriPath != null && serviceUriPath.equals("/*") && Axis2Utils.isAbsolutePath(wsdlFileRelativePath)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "WSDL being requested maps to SCA service with absolute WSDL location: " + wsdlFileRelativePath);
            }
            isSCAAbsolute = true;
        } else if ((pathInfo == null || pathInfo.equals("") || pathInfo.equals("/")) && !requestString.toLowerCase().endsWith(".wsdl") || req.getQueryString() != null && req.getQueryString().equals(".wsdl".substring(1))) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Attempting to determine redirect location");
            }
            if (wsdlFileRelativePath == null || "".equals(wsdlFileRelativePath)) {
                WsdlComposite composite;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Retrieving generated WSDL");
                }
                if ((composite = Axis2Utils.getWsdlComposite(as)) != null) {
                    wsdlFileRelativePath = composite.getWsdlFileName();
                    wsdlFileRelativePath = "/wsdl".substring(1) + "/" + wsdlFileRelativePath;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Retrieved generated WSDL: " + wsdlFileRelativePath);
                    }
                } else {
                    this.reportNoWsdl(resp);
                }
            } else {
                String wsdlSlash;
                if (!requestString.endsWith("/")) {
                    requestString = requestString + "/";
                }
                if (requestString.endsWith(wsdlSlash = "/wsdl/")) {
                    requestString = requestString.substring(0, requestString.length() - wsdlSlash.length() + 1);
                }
            }
            if (serviceUriPath != null && serviceUriPath.equals("/*")) {
                requestString = requestString + "path/" + wsdlFileRelativePath;
            } else if (Axis2Utils.isAbsolutePath(wsdlFileRelativePath)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Setting up redirect for WSDL located on file system: " + wsdlFileRelativePath);
                }
                requestString = requestString + Axis2Utils.getServletFilePath(wsdlFileRelativePath);
            } else {
                requestString = requestString + wsdlFileRelativePath;
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Redirecting WSDL query to actual URL: " + requestString);
            }
            resp.sendRedirect(requestString);
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Retrieving WSDL file for service " + as.getName());
        }
        String servletPath = req.getServletPath();
        String path = null;
        boolean isAbsolute = false;
        String urlPattern = Axis2Utils.getURLPattern(as);
        if (urlPattern.equals("/*")) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting location of packaged SCA WSDL");
            }
            int keyLength = requestString.indexOf("path/") + "path/".length();
            path = requestString.substring(keyLength);
        } else if (servletPath.endsWith(".wsdl") || servletPath.endsWith(".xsd")) {
            List mappings;
            Map filePathMappings;
            path = servletPath.substring(urlPattern.length());
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((filePathMappings = (Map)this.configContext.getProperty("com.ibm.ws.websvcs.FILE_PATH_SERVLET_MAPPINGS")) != null && filePathMappings.get(as.getName()) != null && (mappings = (List)filePathMappings.get(as.getName())).contains(path)) {
                String filePrefix = (String)Axis2Utils.getParameterValue(as, "com.ibm.ws.websvcs.FILE_PATH_PREFIX");
                if (filePrefix != null && !"".equals(filePrefix)) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Found servlet mapping for WSDL location on file system: " + path);
                    }
                    path = filePrefix + path;
                    isAbsolute = true;
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found servlet mapping for WSDL location in application: " + path);
                }
            }
        } else if (!isSCAAbsolute) {
            this.reportNoWsdl(resp);
            return;
        }
        if (isSCAAbsolute) {
            path = wsdlFileRelativePath;
        } else if (path.startsWith("/") && !isAbsolute) {
            path = path.substring(1);
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Constructed path to metadata document: " + path);
        }
        if (path != null && path.equals(wsdlFileRelativePath)) {
            this.printWsdlDefintion(req, resp, as);
        } else if (path != null) {
            this.printImportedWsdl(req, resp, as, path);
        } else {
            this.reportNoWsdl(resp);
        }
    }

    private void printImportedWsdl(HttpServletRequest req, HttpServletResponse resp, AxisService as, String wsdlPath) throws ServletException, IOException {
        ClassLoader cl;
        InputStream is;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WASAxis2Servlet.printImportedWsdl()...");
        }
        Definition def = null;
        WsdlComposite composite = Axis2Utils.getWsdlComposite(as);
        if (composite != null && composite.getWsdlDefinitionsMap() != null && (def = composite.getWsdlDefinitionsMap().get(wsdlPath)) instanceof WSDLDefinitionWrapper) {
            def = ((WSDLDefinitionWrapper)def).getUnwrappedDefinition();
        }
        if ((is = (cl = as.getClassLoader()).getResourceAsStream(wsdlPath)) != null || def != null) {
            HashMap prefixMap = this.getPrefixMap(req);
            HashMap urlMap = this.getURLMap(as);
            resp.setContentType("text/xml");
            ServletOutputStream out = resp.getOutputStream();
            try {
                if (is != null) {
                    StAXOMBuilder builder = new StAXOMBuilder(is);
                    this.updateEndpointURLS(builder.getDocument(), prefixMap, urlMap, as, req.getScheme());
                    builder.getDocument().serialize(out);
                } else if (def != null) {
                    this.updateEndpointURLS(prefixMap, urlMap, def, req.getScheme());
                    WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
                    writer.writeWSDL(def, resp.getOutputStream());
                }
            }
            catch (Throwable t) {
                Object[] inserts = new Object[]{wsdlPath, t};
                String msg = NLSProvider.getNLS().getFormattedMessage("wsdlDisplayFail00", inserts, "The WSDL file {0} could not be displayed: {1}");
                Tr.error(_tc, msg);
                throw new ServletException(t);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Retrieving WSDL file: " + wsdlPath);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Couldn't load WSDL file as resource: " + wsdlPath);
            }
            this.reportNoWsdl(resp);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...WASAxis2Servlet.printImportedWsdl()");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void printWsdlDefintion(HttpServletRequest req, HttpServletResponse resp, AxisService as) throws ServletException, IOException {
        if (WASAxis2Servlet._tc.isEntryEnabled()) {
            Tr.entry(WASAxis2Servlet._tc, "WASAxis2Servlet.printWsdlDefintion()...");
        }
        def = null;
        try {
            def = Axis2Utils.getAnnotatedWSDLDefinition(as, this.configContext, req);
            if (WASAxis2Servlet._tc.isDebugEnabled() && def != null) {
                Tr.debug(WASAxis2Servlet._tc, "Retrieved annotated WSDL file.");
            }
        }
        catch (Exception e) {
            inserts = new Object[]{Axis2Utils.getServiceName(as), e};
            Tr.error(WASAxis2Servlet._tc, "getAnnotatedWSDLFail", inserts);
            def = null;
        }
        if (def == null && (def = Axis2Utils.getWSDLDefinition(as)) != null) {
            if (def instanceof WSDLDefinitionWrapper) {
                def = ((WSDLDefinitionWrapper)def).getUnwrappedDefinition();
            }
            prefixMap = this.getPrefixMap(req);
            urlMap = this.getURLMap(as);
            this.updateEndpointURLS(prefixMap, urlMap, def, req.getScheme());
        }
        if (def != null) {
            try {
                resp.setContentType("text/xml");
                writer = WSDLFactory.newInstance().newWSDLWriter();
                writer.writeWSDL(def, resp.getOutputStream());
                if (!WASAxis2Servlet._tc.isDebugEnabled()) ** GOTO lbl35
                Tr.debug(WASAxis2Servlet._tc, "Retrieving generated WSDL file: " + def.getDocumentBaseURI());
            }
            catch (Throwable t) {
                inserts = new Object[]{def.getDocumentBaseURI(), t};
                msg = NLSProvider.getNLS().getFormattedMessage("wsdlDisplayFail00", inserts, "The WSDL file {0} could not be displayed: {1}");
                Tr.error(WASAxis2Servlet._tc, msg);
                throw new ServletException(t);
            }
        } else {
            if (WASAxis2Servlet._tc.isDebugEnabled()) {
                Tr.debug(WASAxis2Servlet._tc, "Definition was null.");
            }
            this.reportNoWsdl(resp);
        }
lbl35:
        // 3 sources

        if (WASAxis2Servlet._tc.isEntryEnabled()) {
            Tr.exit(WASAxis2Servlet._tc, "...WASAxis2Servlet.printWsdlDefintion()");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processXsdRequest(HttpServletRequest req, HttpServletResponse resp, AxisService as) throws ServletException, IOException {
        String serviceUriPath = Axis2Utils.getURLPattern(as);
        if (serviceUriPath != null) {
            String requestUri = req.getRequestURI();
            int index = (requestUri = requestUri.substring(requestUri.indexOf("/", 1))).indexOf(serviceUriPath);
            if (index != -1 || serviceUriPath.equals("/*")) {
                String relativeXsdPath = null;
                if (serviceUriPath.equals("/*")) {
                    int redirectIndex = requestUri.indexOf("path/");
                    if (redirectIndex != -1) {
                        relativeXsdPath = requestUri.substring(redirectIndex + "path/".length());
                    }
                } else {
                    relativeXsdPath = requestUri.substring(index + serviceUriPath.length());
                }
                WsdlComposite composite = Axis2Utils.getWsdlComposite(as);
                if (composite != null) {
                    HashMap<String, OMDocument> schemaMap = composite.getSchemaMap();
                    if (schemaMap != null) {
                        String schemaFileName = null;
                        if (relativeXsdPath.indexOf("/") != -1 && relativeXsdPath.lastIndexOf("/") != relativeXsdPath.length()) {
                            schemaFileName = relativeXsdPath.substring(relativeXsdPath.lastIndexOf("/") + 1, relativeXsdPath.length());
                        }
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Looking for schema file: " + schemaFileName);
                        }
                        try {
                            resp.setContentType("text/xml");
                            OMDocument document = schemaMap.get(schemaFileName);
                            if (document != null) {
                                document.serialize(resp.getOutputStream());
                            } else {
                                this.reportNoXsd(resp);
                            }
                            if (!_tc.isDebugEnabled()) return;
                            Tr.debug(_tc, "Retrieving generated schema file: " + relativeXsdPath);
                            return;
                        }
                        catch (Throwable t) {
                            Object[] inserts = new Object[]{schemaFileName, t};
                            String msg = NLSProvider.getNLS().getFormattedMessage("xsdDisplayFail00", inserts, "The schema file {0} could not be displayed: {1}");
                            Tr.error(_tc, msg);
                            throw new ServletException(t);
                        }
                    } else {
                        this.reportNoXsd(resp);
                    }
                    return;
                }
                try {
                    InputStream is = null;
                    if (Axis2Utils.isAbsolutePath(Axis2Utils.getWSDLLocation(as))) {
                        String filePrefix = (String)Axis2Utils.getParameterValue(as, "com.ibm.ws.websvcs.FILE_PATH_PREFIX");
                        relativeXsdPath = filePrefix + relativeXsdPath;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Constructed file system path to XSD document: " + relativeXsdPath);
                        }
                        try {
                            URL url = new URL(relativeXsdPath);
                            is = url.openStream();
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        if (is == null) {
                            try {
                                File file = new File(relativeXsdPath);
                                if (WebServiceUtils.fileExists(file)) {
                                    is = new FileInputStream(file);
                                }
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                    }
                    if (is == null) {
                        ClassLoader cl = as.getClassLoader();
                        is = cl.getResourceAsStream(relativeXsdPath);
                    }
                    if (is != null) {
                        resp.setContentType("text/xml");
                        ServletOutputStream out = resp.getOutputStream();
                        out.write(this.readBytes(is));
                        out.flush();
                        out.close();
                        if (!_tc.isDebugEnabled()) return;
                        Tr.debug(_tc, "Retrieving schema file: " + relativeXsdPath);
                        return;
                    }
                    this.reportNoXsd(resp);
                    return;
                }
                catch (Throwable t) {
                    Object[] inserts = new Object[]{relativeXsdPath, t};
                    String msg = NLSProvider.getNLS().getFormattedMessage("xsdDisplayFail00", inserts, "The schema file {0} could not be displayed: {1}");
                    Tr.error(_tc, msg);
                    throw new ServletException(t);
                }
            }
            this.reportNoXsd(resp);
            return;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "URL pattern didn't exist for service.");
        }
        this.reportNoXsd(resp);
    }

    private void reportAvailableServices(HttpServletResponse resp, AxisService as) throws AxisFault, IOException {
        Service service;
        Map serviceMap;
        WsdlComposite composite;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting available Axis2 web services.");
        }
        PrintWriter writer = resp.getWriter();
        resp.setContentType("text/html");
        Definition wsdlDef = Axis2Utils.getWSDLDefinition(as);
        QName sQName = Axis2Utils.getServiceQName(as);
        if (wsdlDef == null && (composite = Axis2Utils.getWsdlComposite(as)) != null) {
            HashMap<String, Definition> map = composite.getWsdlDefinitionsMap();
            wsdlDef = composite.getRootWsdlDefinition();
        }
        if (wsdlDef != null && (serviceMap = wsdlDef.getServices()) != null && !serviceMap.isEmpty() && (service = (Service)serviceMap.get(sQName)) != null) {
            writer.println("<h2>" + service.getQName().toString() + "</h2>");
        }
        writer.println("<h3>Hello! This is an Axis2 Web Service!</h3>");
        writer.close();
    }

    private void reportServiceNotExist(HttpServletResponse resp, String requestURI) throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting error that Axis Service object couldn't be found.");
        }
        PrintWriter writer = resp.getWriter();
        resp.setStatus(404);
        resp.setContentType("text/html");
        writer.println("<h2>Error: Generic Error.</h2>");
        writer.println("<p>Could not find Axis2 service for request URI: " + requestURI + ".</p>");
        writer.close();
    }

    private void reportNoWsdl(HttpServletResponse resp) throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting that queried WSDL file does not exist.");
        }
        PrintWriter writer = resp.getWriter();
        resp.setStatus(404);
        resp.setContentType("text/html");
        writer.println("<h2>Error: Generic Error.</h2>");
        writer.println("<p>Could not generate WSDL!</p>");
        writer.close();
    }

    private void reportNoXsd(HttpServletResponse resp) throws IOException {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Reporting that queried XSD file does not exist.");
        }
        PrintWriter writer = resp.getWriter();
        resp.setStatus(404);
        resp.setContentType("text/html");
        writer.println("<h2>Error: Generic Error.</h2>");
        writer.println("<p>Could not generate specified XSD file!</p>");
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block62: {
            boolean async;
            ServletOutputStream out;
            Handler.InvocationResponse pi;
            MessageContext msgContext;
            block63: {
                block61: {
                    String servletPath;
                    Endpoint endpoint;
                    msgContext = null;
                    pi = null;
                    out = null;
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "doPost");
                    }
                    if (_tc.isDebugEnabled() && req != null) {
                        Tr.debug(_tc, "ServletRequest= " + req.getMethod());
                    }
                    if ((endpoint = this.endptMgrMBean.getEndpointListenerWithUrlPattern(servletPath = this.getServletPath(req))) == null) {
                        Object[] inserts = new Object[]{servletPath};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointNotFound00", inserts, "Could not find the endpoint for URL {0}.");
                        Tr.error(_tc, "endpointNotFound00", inserts);
                        throw new FileNotFoundException(msg);
                    }
                    if (endpoint.getState() != 2) {
                        Object[] inserts = new Object[]{servletPath};
                        String msg = NLSProvider.getNLS().getFormattedMessage("endpointStopped00", inserts, "The endpoint is currently stopped for URL {0}.");
                        Tr.error(_tc, "endpointStopped00", inserts);
                        throw new FileNotFoundException(msg);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Located the endpoint for URL pattern: " + servletPath);
                    }
                    String requestURL = req.getRequestURL().toString();
                    msgContext = this.createAndSetInitialParamsToMsgCtxt(msgContext, res, req, requestURL);
                    String contentType = req.getContentType();
                    msgContext.setProperty("ContentType", contentType);
                    String hashKey = req.getHeader("SAVECONNECTION");
                    if (hashKey != null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Setting SAVECONNECTION key : " + hashKey + " in MessageContext : " + msgContext);
                        }
                        msgContext.setProperty("SAVECONNECTION", hashKey);
                    }
                    out = res.getOutputStream();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Endpoint URL: " + requestURL);
                        Tr.debug(_tc, "Content-Type: " + contentType + " set in MessageContext " + "ContentType");
                    }
                    InputStream reqIS = req.getInputStream();
                    if (MessageTrace.isTraceEnabled()) {
                        try {
                            String str = new String("INBOUND_HTTP_REQUEST");
                            reqIS = new LogFilterInputStream(req.getInputStream(), _tc, 100000, str, req.getContentType());
                        }
                        catch (Throwable t) {
                            Tr.debug(_tc, "Message could not be traced because of the following error: " + t.toString());
                        }
                    }
                    pi = HTTPTransportUtils.processHTTPPostRequest(msgContext, reqIS, out, req.getContentType(), req.getHeader("SOAPAction"), requestURL);
                    RequestResponseTransport t = null;
                    Boolean holdResponse = (Boolean)msgContext.getProperty("HoldResponse");
                    if (Handler.InvocationResponse.SUSPEND.equals(pi) || holdResponse != null && Boolean.TRUE.equals(holdResponse)) {
                        t = (RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl");
                        t.awaitResponse();
                    }
                    if (!TransportUtils.isResponseWritten(msgContext) && t != null && t.getStatus() != RequestResponseTransport.RequestResponseTransportStatus.ACKED && t.getStatus() != RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED) {
                        res.setStatus(202);
                    }
                    if (t == null) {
                        t = (RequestResponseTransport)msgContext.getProperty("RequestResponseTransportControl");
                    }
                    if (t == null || !(t instanceof ServletRequestResponseTransport)) break block61;
                    ((ServletRequestResponseTransport)t).handleSessionInfo();
                }
                Object var15_28 = null;
                if (msgContext == null) break block62;
                if (!this.closeReader || Handler.InvocationResponse.SUSPEND.equals(pi)) break block63;
                try {
                    ((StAXBuilder)msgContext.getEnvelope().getBuilder()).close();
                }
                catch (Exception e2) {
                    if (!_tc.isDebugEnabled()) break block63;
                    Tr.debug(_tc, e2.getMessage());
                }
            }
            boolean oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
            boolean bl = async = msgContext.getReplyTo() != null && !msgContext.getReplyTo().hasAnonymousAddress();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "one way : " + oneWay + " async : " + async);
            }
            if (!oneWay && !async) {
                TransportUtils.deleteAttachments(msgContext);
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "doPost");
            }
            break block62;
            {
                catch (FileNotFoundException fnfe) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Endpoint was down, returning 404 exception...");
                    }
                    res.setStatus(404);
                    throw fnfe;
                }
                catch (AxisFault e) {
                    block65: {
                        block64: {
                            if (msgContext != null) {
                                boolean userException = false;
                                OperationContext opContext = msgContext.getOperationContext();
                                if (opContext != null) {
                                    try {
                                        MessageContext msgCtx = opContext.getMessageContext("Out");
                                        if (msgCtx != null && msgCtx.getProperty("org.apache.axis2.jaxws.checkedException") != null) {
                                            userException = true;
                                            if (_tc.isDebugEnabled()) {
                                                Tr.debug(_tc, "USER_EXCEPTION is set. Not throwing the exception.");
                                            }
                                        }
                                    }
                                    catch (AxisFault ex1) {
                                        // empty catch block
                                    }
                                }
                                if (!userException) {
                                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.doPost", "516", this);
                                }
                                try {
                                    if (AddressingHelper.isFaultRedirected(msgContext)) {
                                        res.setStatus(202);
                                    } else {
                                        res.setStatus(500);
                                    }
                                    this.handleFault(msgContext, out, e);
                                }
                                catch (AxisFault e2) {
                                    if (_tc.isDebugEnabled()) {
                                        Tr.debug(_tc, e.getMessage());
                                    }
                                    break block64;
                                }
                            }
                            throw new ServletException(e);
                        }
                        Object var15_29 = null;
                        if (msgContext == null) break block62;
                        if (this.closeReader && !Handler.InvocationResponse.SUSPEND.equals(pi)) {
                            try {
                                ((StAXBuilder)msgContext.getEnvelope().getBuilder()).close();
                            }
                            catch (Exception e2) {
                                if (!_tc.isDebugEnabled()) break block65;
                                Tr.debug(_tc, e2.getMessage());
                            }
                        }
                    }
                    oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
                    boolean bl2 = async = msgContext.getReplyTo() != null && !msgContext.getReplyTo().hasAnonymousAddress();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "one way : " + oneWay + " async : " + async);
                    }
                    if (!oneWay && !async) {
                        TransportUtils.deleteAttachments(msgContext);
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "doPost");
                    }
                    break block62;
                }
                catch (Throwable t) {
                    block66: {
                        FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.http.WASAxis2Servlet.doPost", "516", this);
                        if (msgContext != null) {
                            try {
                                if (AddressingHelper.isFaultRedirected(msgContext)) {
                                    res.setStatus(202);
                                } else {
                                    res.setStatus(500);
                                }
                                this.handleFault(msgContext, out, new AxisFault(t.toString(), t));
                            }
                            catch (AxisFault e2) {
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, t.getMessage());
                                }
                            }
                        } else {
                            throw new ServletException(t);
                        }
                        Object var15_30 = null;
                        if (msgContext == null) break block62;
                        if (this.closeReader && !Handler.InvocationResponse.SUSPEND.equals(pi)) {
                            try {
                                ((StAXBuilder)msgContext.getEnvelope().getBuilder()).close();
                            }
                            catch (Exception e2) {
                                if (!_tc.isDebugEnabled()) break block66;
                                Tr.debug(_tc, e2.getMessage());
                            }
                        }
                    }
                    oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
                    boolean bl3 = async = msgContext.getReplyTo() != null && !msgContext.getReplyTo().hasAnonymousAddress();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "one way : " + oneWay + " async : " + async);
                    }
                    if (!oneWay && !async) {
                        TransportUtils.deleteAttachments(msgContext);
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "doPost");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_31 = null;
                if (msgContext != null) {
                    block67: {
                        if (this.closeReader && !Handler.InvocationResponse.SUSPEND.equals(pi)) {
                            try {
                                ((StAXBuilder)msgContext.getEnvelope().getBuilder()).close();
                            }
                            catch (Exception e2) {
                                if (!_tc.isDebugEnabled()) break block67;
                                Tr.debug(_tc, e2.getMessage());
                            }
                        }
                    }
                    oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
                    boolean bl4 = async = msgContext.getReplyTo() != null && !msgContext.getReplyTo().hasAnonymousAddress();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "one way : " + oneWay + " async : " + async);
                    }
                    if (!oneWay && !async) {
                        TransportUtils.deleteAttachments(msgContext);
                    }
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "doPost");
                    }
                }
                throw throwable;
            }
        }
    }

    protected MessageContext createAndSetInitialParamsToMsgCtxt(MessageContext msgContext, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest, String requestURL) throws AxisFault, WSSecurityException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createAndSetInitialParamsToMsgCtxt");
        }
        msgContext = new MessageContext();
        msgContext.setConfigurationContext(this.configContext);
        msgContext.setTransportIn(this.axisConfiguration.getTransportIn("http"));
        msgContext.setTransportOut(this.axisConfiguration.getTransportOut("http"));
        msgContext.setProperty("OutTransportInfo", new ServletBasedOutTransportInfo(httpServletResponse));
        msgContext.setProperty("RequestResponseTransportControl", new ServletRequestResponseTransport(httpServletRequest, httpServletResponse, requestURL));
        Map headerMap = this.getTransportHeaders(httpServletRequest);
        headerMap.put("Content-Encoding", "");
        headerMap.put(HTTPConstants.HEADER_CONTENT_ENCODING_LOWERCASE, "");
        msgContext.setProperty("TRANSPORT_HEADERS", headerMap);
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null) {
            msgContext.setProperty("SessionId", session.getId());
        }
        msgContext.setProperty("TransportInURL", requestURL);
        msgContext.setIncomingTransportName("http");
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST, httpServletRequest);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE, httpServletResponse);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETCONTEXT, this.servletConfig.getServletContext());
        msgContext.setProperty("com.ibm.ws.websvcs.MsgContext_ContextRoot", httpServletRequest.getContextPath());
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            msgContext.setProperty("com.ibm.wsspi.websphere.security.SecurityContext", ContextManager.getContext());
        }
        msgContext.setProperty("com.ibm.ws.websvcs.INCOMING_SERVER_SIDE_REQUEST", new Boolean(true));
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Setting context root on message context: " + httpServletRequest.getContextPath());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createAndSetInitialParamsToMsgCtxt");
        }
        return msgContext;
    }

    private HashMap getPrefixMap(HttpServletRequest req) {
        HashMap<String, String> prefixMap = new HashMap<String, String>();
        String prefix = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + req.getContextPath();
        prefixMap.put(req.getScheme(), prefix);
        return prefixMap;
    }

    private HashMap getURLMap(AxisService as) {
        WsdlComposite composite;
        HashMap<String, String> urlMap = new HashMap<String, String>();
        Definition wsdlDef = Axis2Utils.getWSDLDefinition(as);
        if (wsdlDef == null && (composite = Axis2Utils.getWsdlComposite(as)) != null) {
            wsdlDef = composite.getRootWsdlDefinition();
        }
        if (wsdlDef == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "getURLMap(): WSDL def was null.");
            }
            return urlMap;
        }
        String tns = wsdlDef.getTargetNamespace();
        Map services = wsdlDef.getServices();
        Iterator serviceIter = services.values().iterator();
        Object[] serviceArray = this.getAxisServices();
        if (serviceArray.length > 0) {
            while (serviceIter.hasNext()) {
                Service service = (Service)serviceIter.next();
                ArrayList<AxisService> servicesByQName = this.getAxisServicesByQName(service.getQName(), serviceArray);
                Map ports = service.getPorts();
                for (Port port : ports.values()) {
                    String urlPattern = this.matchesRequestedAxisService(as, service.getQName().toString(), port.getName()) ? Axis2Utils.getURLPattern(as) : this.getAxisServiceByPort(servicesByQName, port.getName());
                    QName qName = new QName(tns, port.getName());
                    String key = service.getQName().toString() + qName.toString() + Axis2Utils.getWSDLLocation(as);
                    if (urlPattern != null && urlPattern.equals("/*")) {
                        urlPattern = "/";
                    }
                    urlMap.put(key, urlPattern);
                }
            }
        }
        return urlMap;
    }

    private void updateEndpointURLS(OMDocument document, Map prefixMap, Map urlMap, AxisService service, String protocol) throws Exception {
        OMElement root = document.getOMDocumentElement();
        Definition def = Axis2Utils.getWSDLDefinition(service);
        if (def == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "updateEndpointURLS(): WSDL Def was null.");
            }
            return;
        }
        String tns = def.getTargetNamespace();
        Iterator sElementIter = root.getChildrenWithName(new QName("service"));
        while (sElementIter.hasNext()) {
            OMElement serviceElement = (OMElement)sElementIter.next();
            String sName = serviceElement.getAttributeValue(new QName("name"));
            QName serviceQName = new QName(tns, sName);
            Iterator pElementIter = serviceElement.getChildrenWithName(new QName("port"));
            while (pElementIter.hasNext()) {
                OMElement portElement = (OMElement)pElementIter.next();
                this.fixPort(portElement, prefixMap, urlMap, tns, serviceQName, Axis2Utils.getWSDLLocation(service), protocol);
            }
        }
    }

    private void fixPort(OMElement portElement, Map prefixMap, Map urlMap, String tns, QName serviceQName, String wsdlFile, String protocol) throws Exception {
        OMAttribute nameAttribute = portElement.getAttribute(new QName("name"));
        if (nameAttribute != null) {
            String name = nameAttribute.getAttributeValue();
            String URLPrefix = (String)prefixMap.get(protocol);
            QName portQName = new QName(tns, name);
            String key = serviceQName.toString() + portQName.toString() + wsdlFile;
            String URLEndpoint = (String)urlMap.get(key);
            if (URLEndpoint != null && !URLEndpoint.equals("")) {
                String fullURL = URLEndpoint.equals("IMPLEMENTATION NOT PROVIDED") ? URLEndpoint : URLPrefix + URLEndpoint;
                Iterator aElementIter = portElement.getChildrenWithName(new QName("address"));
                while (aElementIter.hasNext()) {
                    OMElement addressElement = (OMElement)aElementIter.next();
                    OMAttribute locationAttribute = addressElement.getAttribute(new QName("location"));
                    if (locationAttribute == null) continue;
                    locationAttribute.setAttributeValue(fullURL);
                }
            }
        }
    }

    private byte[] readBytes(InputStream is) throws IOException {
        int chunksize = 1024;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
        int totalBytesRead = 0;
        int bytesFromRead = 0;
        while (bytesFromRead >= 0) {
            byte[] chunkBA = new byte[1024];
            bytesFromRead = is.read(chunkBA, 0, 1024);
            if (bytesFromRead < 0) continue;
            chunks.add(chunkBA);
            chunkSizes.add(new Integer(bytesFromRead));
            totalBytesRead += bytesFromRead;
        }
        byte[] reqBa = new byte[totalBytesRead];
        int offset = 0;
        for (int i = 0; i < chunks.size(); ++i) {
            byte[] chunk = (byte[])chunks.get(i);
            int chunkSize = (Integer)chunkSizes.get(i);
            System.arraycopy(chunk, 0, reqBa, offset, chunkSize);
            offset += chunkSize;
        }
        return reqBa;
    }

    private Object[] getAxisServices() {
        HashMap serviceMap = this.configContext.getAxisConfiguration().getServices();
        if (!serviceMap.isEmpty()) {
            return serviceMap.values().toArray();
        }
        return null;
    }

    private ArrayList<AxisService> getAxisServicesByQName(QName qName, Object[] services) {
        ArrayList<AxisService> servicesByQName = new ArrayList<AxisService>();
        for (int i = 0; i < services.length; ++i) {
            AxisService service = (AxisService)services[i];
            QName serviceQName = Axis2Utils.getServiceQName(service);
            if (serviceQName == null || !serviceQName.toString().equals(qName.toString())) continue;
            servicesByQName.add(service);
        }
        return servicesByQName;
    }

    private String getAxisServiceByPort(ArrayList<AxisService> services, String portName) {
        Iterator<AxisService> serviceIter = services.iterator();
        String name = null;
        while (serviceIter.hasNext()) {
            AxisService service = serviceIter.next();
            String pName = Axis2Utils.getPortName(service);
            if (!portName.equals(pName)) continue;
            name = Axis2Utils.getURLPattern(service);
        }
        if (name == null || name.equals("")) {
            name = "IMPLEMENTATION NOT PROVIDED";
        }
        return name;
    }

    private boolean matchesRequestedAxisService(AxisService as, String sName, String pName) {
        return Axis2Utils.getServiceQName(as).toString().equals(sName) && Axis2Utils.getPortName(as).equals(pName);
    }

    private void updateEndpointURLS(Map prefixMap, Map urlMap, Definition def, String protocol) {
        HashMap servicesMap = this.configContext.getAxisConfiguration().getServices();
        if (servicesMap != null && !servicesMap.isEmpty()) {
            for (AxisService axisService : servicesMap.values()) {
                String portName;
                Port port;
                Service service;
                QName serviceQName = Axis2Utils.getServiceQName(axisService);
                String prefix = (String)prefixMap.get(protocol);
                if (serviceQName == null || (service = def.getService(serviceQName)) == null || (port = service.getPort(portName = Axis2Utils.getPortName(axisService))) == null) continue;
                String tns = def.getTargetNamespace();
                QName portQName = new QName(tns, portName);
                String key = serviceQName.toString() + portQName.toString() + Axis2Utils.getWSDLLocation(axisService);
                String endpointURL = (String)urlMap.get(key);
                if (endpointURL == null || "".equals(endpointURL)) continue;
                List elements = port.getExtensibilityElements();
                for (ExtensibilityElement element : elements) {
                    ExtensibilityElement address;
                    if (element instanceof SOAPAddress) {
                        address = (SOAPAddress)element;
                        address.setLocationURI(prefix + endpointURL);
                        continue;
                    }
                    if (!(element instanceof SOAP12Address)) continue;
                    address = (SOAP12Address)element;
                    address.setLocationURI(prefix + endpointURL);
                }
            }
        }
    }

    private String getContentType(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getContentType");
        }
        OMOutputFormat format = new OMOutputFormat();
        msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
        msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
        msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
        format.setSOAP11(msgContext.isSOAP11());
        format.setDoOptimize(msgContext.isDoingMTOM());
        format.setDoingSWA(msgContext.isDoingSwA());
        format.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(msgContext));
        Object mimeBoundaryProperty = msgContext.getProperty("mimeBoundary");
        if (mimeBoundaryProperty != null) {
            format.setMimeBoundary((String)mimeBoundaryProperty);
        }
        String encoding = format.getCharSetEncoding();
        String contentType = format.getContentType();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getContentType : " + contentType);
        }
        return contentType;
    }

    private void traceBytes(byte[] bytes, String contentType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceBytes");
        }
        if (bytes != null) {
            MessageTrace.log(MessageTrace.INBOUND_HTTP_REQUEST, contentType, bytes);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "traceBytes");
        }
    }

    private byte[] extractRequestBytesForTrace(HttpServletRequest req, InputStream reqIs) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "Start copying HTTP request to trace buffer");
        }
        byte[] reqBa = null;
        String lenStr = req.getHeader("Content-Length");
        if (lenStr != null) {
            int len;
            block13: {
                len = 0;
                try {
                    len = Integer.parseInt(lenStr);
                }
                catch (NumberFormatException e) {
                    if (!_tc.isDebugEnabled()) break block13;
                    Tr.debug(_tc, "Incoming request message to server could not be traced due to following error: " + e.toString());
                }
            }
            reqBa = new byte[len];
            int leftToRead = len;
            int offset = 0;
            while (leftToRead > 0) {
                int bytesRead = reqIs.read(reqBa, offset, leftToRead);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Trace buffer needs " + leftToRead + " bytes at offset " + offset + " got " + bytesRead + " bytes");
                }
                if (bytesRead < 0) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "End of stream with " + leftToRead + " bytes still " + "expected");
                    }
                    leftToRead = 0;
                    continue;
                }
                leftToRead -= bytesRead;
                offset += bytesRead;
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Incoming message is using chunking");
            }
            int chunksize = 1024;
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            ArrayList<Integer> chunkSizes = new ArrayList<Integer>();
            int totalBytesRead = 0;
            int bytesFromRead = 0;
            while (bytesFromRead >= 0) {
                byte[] chunkBA = new byte[1024];
                bytesFromRead = reqIs.read(chunkBA, 0, 1024);
                if (bytesFromRead < 0) continue;
                chunks.add(chunkBA);
                chunkSizes.add(new Integer(bytesFromRead));
                totalBytesRead += bytesFromRead;
            }
            reqBa = new byte[totalBytesRead];
            int offset = 0;
            for (int i = 0; i < chunks.size(); ++i) {
                byte[] chunk = (byte[])chunks.get(i);
                int chunkSize = (Integer)chunkSizes.get(i);
                System.arraycopy(chunk, 0, reqBa, offset, chunkSize);
                offset += chunkSize;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "Done copying HTTP request to trace buffer");
        }
        return reqBa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceResponse(MessageContext msgContext, String contentType) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceResponse");
        }
        try {
            try {
                SOAPEnvelope envelope = msgContext.getEnvelope();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                envelope.serialize(baos);
                byte[] bytes = baos.toByteArray();
                MessageTrace.log(MessageTrace.OUTBOUND_HTTP_RESPONSE, contentType, bytes);
            }
            catch (Throwable t) {
                Tr.debug(_tc, "Response message could not be traced because of the following error: " + t.toString());
                Object var7_8 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "traceResponse");
                return;
            }
            Object var7_7 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "traceResponse");
            throw throwable;
        }
        Tr.exit(_tc, "traceResponse");
    }

    protected String getServletPath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.endsWith("/")) {
            servletPath = servletPath.substring(0, servletPath.length() - 1);
        }
        return servletPath;
    }

    class ServletRequestResponseTransport
    implements RequestResponseTransport {
        private HttpServletResponse response;
        private HttpServletRequest request;
        private boolean responseWritten = false;
        private String requestURL = null;
        private boolean handledSessionInfo = false;
        private CountDownLatch responseReadySignal = new CountDownLatch(1);
        private RequestResponseTransport.RequestResponseTransportStatus status = RequestResponseTransport.RequestResponseTransportStatus.WAITING;
        private AxisFault faultToBeThrownOut = null;

        ServletRequestResponseTransport(HttpServletRequest request, HttpServletResponse response, String requestURL) {
            this.request = request;
            this.response = response;
            this.requestURL = requestURL;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport ctor...  requestURL=" + requestURL);
            }
        }

        public void acknowledgeMessage(MessageContext msgContext) throws AxisFault {
            String viaStr;
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "acknowledgeMessage");
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Acking one-way request");
            }
            this.response.setContentType("text/xml; charset=" + msgContext.getProperty("CHARACTER_SET_ENCODING"));
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Content type: " + this.response.getContentType());
            }
            if (!TransportUtils.isResponseWritten(msgContext)) {
                this.response.setContentLength(0);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Content length set to 0.");
                }
            }
            this.response.setStatus(202);
            String hashKey = (String)msgContext.getProperty("SAVECONNECTION");
            if (hashKey != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Got key : " + hashKey + " from MessageContext : " + msgContext);
                    Tr.debug(_tc, "setting SAVECONNECTION header to : " + hashKey);
                }
                this.response.setHeader("SAVECONNECTION", hashKey);
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Hash Key is null. So not setting on header for 202");
            }
            boolean oneWay = InvocationPatternHelper.isOneWayInvocation(msgContext);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "one way : " + oneWay);
            }
            if (oneWay) {
                this.response.setHeader("Connection", HTTPConstants.HEADER_CONNECTION_CLOSE);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set the response header to close connection for one way");
                }
            }
            if (JavaUtils.hasValue(viaStr = this.request.getHeader("Via"))) {
                this.response.setHeader("Connection", HTTPConstants.HEADER_CONNECTION_CLOSE);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Set the response header to close connection for proxy");
                }
            }
            this.handleSessionInfo();
            try {
                this.response.flushBuffer();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Response flushed");
                }
            }
            catch (IOException e) {
                throw new AxisFault("Error sending acknowledgement", e);
            }
            this.status = RequestResponseTransport.RequestResponseTransportStatus.ACKED;
            this.responseReadySignal.countDown();
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "acknowledgeMessage");
            }
        }

        public synchronized void handleSessionInfo() {
            if (!this.handledSessionInfo) {
                HttpSession session;
                if (_tc.isEntryEnabled()) {
                    Tr.entry(_tc, "handleSessionInfo");
                }
                if ((session = this.request.getSession(false)) != null) {
                    String encodedURL;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Detected an HTTP session: " + session.toString());
                    }
                    if (!(encodedURL = this.response.encodeURL(this.requestURL)).equals(this.requestURL)) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "original request URL: " + this.requestURL);
                            Tr.debug(_tc, "encoded URL: " + encodedURL);
                            Tr.debug(_tc, "Setting encoded URL in HTTP header: Location");
                        }
                        this.response.setHeader("Location", encodedURL);
                    }
                }
                this.handledSessionInfo = true;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "handleSessionInfo");
                }
            } else if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "handleSessionInfo called again for this request: " + this.requestURL);
            }
        }

        public void awaitResponse() throws InterruptedException {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.Blocking servlet thread -- awaiting response : " + this.toString());
            }
            this.responseReadySignal.await();
        }

        public void signalResponseReady() {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.Signalling response available : " + this.toString());
            }
            this.status = RequestResponseTransport.RequestResponseTransportStatus.SIGNALLED;
            this.responseReadySignal.countDown();
        }

        public void signalFaultReady(AxisFault fault) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.Signalling Fault available : " + this.toString());
            }
            this.faultToBeThrownOut = fault;
            this.signalResponseReady();
        }

        public RequestResponseTransport.RequestResponseTransportStatus getStatus() {
            return this.status;
        }

        public boolean isResponseWritten() {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.isResponseWritten() : " + this.responseWritten);
            }
            return this.responseWritten;
        }

        public void setResponseWritten(boolean responseWritten) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "ServletRequestResponseTransport.setResponseWritten() : " + responseWritten);
            }
            this.responseWritten = responseWritten;
        }
    }
}

