/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.channel.AsyncInResponseConnLink;
import com.ibm.ws.websvcs.transport.http.HttpByteBufferInputStream;
import com.ibm.wsspi.channel.InterChannelCallback;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.util.ArrayList;

public class HttpReadCallback
implements InterChannelCallback {
    private static final TraceComponent _tc = Tr.register(HttpReadCallback.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private AsyncInResponseConnLink connlink = null;
    private HttpInboundServiceContext httpInSC = null;
    private VirtualConnection vc = null;
    private ArrayList bodyBuffers = null;
    private boolean haveAllBuffers = false;
    private int requestBytes;

    public void init(AsyncInResponseConnLink _connlink, HttpInboundServiceContext _httpInSC, VirtualConnection _vc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpReadCallback.init()...");
        }
        this.connlink = _connlink;
        this.httpInSC = _httpInSC;
        this.vc = _vc;
        this.bodyBuffers = new ArrayList();
        this.haveAllBuffers = false;
        this.requestBytes = 0;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpReadCallback.init().");
        }
    }

    public ArrayList getRequestBodyBuffers() {
        return this.bodyBuffers;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readRequest() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpReadCallback.readRequest()...");
        }
        try {
            try {
                HttpByteBufferInputStream in = new HttpByteBufferInputStream(this.httpInSC);
                this.connlink.requestReady(this.vc, in);
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.websvcs.transport.http.HttpReadCallback.readRequest", "103", this);
                String[] inserts = new String[]{t.toString()};
                String msg = JavaUtils.stackToString(t);
                Tr.error(_tc, "caughtException", t);
                throw new RuntimeException(msg, t);
            }
            Object var5_3 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "...HttpReadCallback.readRequest()");
            throw throwable;
        }
        Tr.exit(_tc, "...HttpReadCallback.readRequest()");
    }

    public void complete(VirtualConnection vc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpReadCallback.complete()...");
        }
        this.readRequest();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpReadCallback.complete().");
        }
    }

    public void error(VirtualConnection vc, Throwable t) {
        Tr.error(_tc, "caughtException7", t);
        this.connlink.close(vc, (Exception)t);
    }
}

