/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.common.ConfigFromJAX_WS;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import com.ibm.ws.websvcs.transport.policyset.jaxb.CustomProperty;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.transport.http.HTTPConstants;

public class HttpEffectiveConfig
extends ConfigFromJAX_WS {
    private static final TraceComponent _tc = Tr.register(HttpEffectiveConfig.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final int defaultConnTimeout = 180;
    private static final int defaultWriteTimeout = 300;
    private static final int defaultReadTimeout = 300;
    private Properties policy = null;
    protected static final String emptyString = "";

    public HttpEffectiveConfig(boolean sslEnabled, MessageContext mc) {
        super(sslEnabled);
        this.policy = this.extractEffectivePolicy(mc);
    }

    public boolean isPolicySetDefined() {
        return this.policy != null && !this.policy.isEmpty();
    }

    private Properties extractEffectivePolicy(MessageContext mc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpEffectiveConfig.extractEffectivePolicy()... ");
        }
        Properties p = null;
        try {
            Parameter configParam;
            AxisService service;
            PolicySetConfiguration policySet = null;
            AxisOperation operation = mc.getAxisOperation();
            if (operation != null && (policySet = (PolicySetConfiguration)Axis2Utils.getPolicySet(operation)) != null) {
                String result;
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("HTTP_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("HTTP_BINDING");
                if (_tc.isDebugEnabled()) {
                    result = PolicySetUtils.maskPasswords(bind);
                    Tr.debug(_tc, "HTTP Policy Type " + type + " HTTP Policy Binding " + result + " found for operation " + operation + "'.");
                }
                if (type != null && !type.isEmpty()) {
                    p = new Properties();
                    p.putAll((Map<?, ?>)type);
                    if (bind != null && !bind.isEmpty()) {
                        p.putAll((Map<?, ?>)bind);
                    }
                }
                type = (Properties)policySet.getPolicyTypeConfiguration("SSL_POLICY");
                bind = (Properties)policySet.getPolicyTypeBinding("SSL_BINDING");
                if (_tc.isDebugEnabled()) {
                    result = PolicySetUtils.maskPasswords(bind);
                    Tr.debug(_tc, "SSL Policy Type " + type + " SSL Policy Binding " + result + " found for operation " + operation + "'.");
                }
                if (type != null && !type.isEmpty()) {
                    if (p == null) {
                        p = new Properties();
                    }
                    p.putAll((Map<?, ?>)type);
                    if (bind != null && !bind.isEmpty()) {
                        p.putAll((Map<?, ?>)bind);
                    }
                }
            }
            if (p == null && (service = mc.getAxisService()) != null && (configParam = service.getParameter("WASAxis2PolicySet")) != null && configParam.getValue() != null && (policySet = (PolicySetConfiguration)configParam.getValue()) != null) {
                String result;
                Properties type = (Properties)policySet.getPolicyTypeConfiguration("HTTP_POLICY");
                Properties bind = (Properties)policySet.getPolicyTypeBinding("HTTP_BINDING");
                if (_tc.isDebugEnabled()) {
                    result = PolicySetUtils.maskPasswords(bind);
                    Tr.debug(_tc, "HTTP Policy Type " + type + " HTTP Policy Binding " + result + " found for service " + service + "'.");
                }
                if (type != null && !type.isEmpty()) {
                    p = new Properties();
                    p.putAll((Map<?, ?>)type);
                    if (bind != null && !bind.isEmpty()) {
                        p.putAll((Map<?, ?>)bind);
                    }
                }
                type = (Properties)policySet.getPolicyTypeConfiguration("SSL_POLICY");
                bind = (Properties)policySet.getPolicyTypeBinding("SSL_BINDING");
                if (_tc.isDebugEnabled()) {
                    result = PolicySetUtils.maskPasswords(bind);
                    Tr.debug(_tc, "SSL Policy Type " + type + " SSL Policy Binding " + result + " found for service " + service + "'.");
                }
                if (type != null && !type.isEmpty()) {
                    if (p == null) {
                        p = new Properties();
                    }
                    p.putAll((Map<?, ?>)type);
                    if (bind != null && !bind.isEmpty()) {
                        p.putAll((Map<?, ?>)bind);
                    }
                }
            }
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.extractEffectivePolicy", "210", this);
            Tr.error(_tc, JavaUtils.stackToString(ex));
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpEffectiveConfig.extractEffectivePolicy()");
        }
        return p;
    }

    public int getConnectionTimeout(MessageContext mc) {
        int result = 180;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("connectTimeout");
        }
        try {
            if (!JavaUtils.hasValue(policyValue)) {
                result = super.getConnectionTimeout(mc);
            } else {
                result = Integer.parseInt(policyValue);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getConnectionTimeout() : " + result);
                }
            }
            if (result <= 0) {
                result = 180;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getConnectionTimeout() setting to default : " + result);
                }
            }
        }
        catch (NumberFormatException nEX) {
            FFDCFilter.processException((Throwable)nEX, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.getConnectionTimeout", "267", this);
            result = 180;
        }
        return result * 1000;
    }

    public int getWriteTimeout(MessageContext mc) {
        int result = 0;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("writeTimeout");
        }
        try {
            if (!JavaUtils.hasValue(policyValue)) {
                result = super.getWriteTimeout(mc);
            } else {
                result = Integer.parseInt(policyValue);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getWriteTimeout() : " + result);
                }
            }
            if (result <= 0) {
                result = 300;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getWriteTimeout() setting to default : " + result);
                }
            }
        }
        catch (NumberFormatException nEX) {
            FFDCFilter.processException((Throwable)nEX, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.getWriteTimeout", "326", this);
            result = 300;
        }
        return result * 1000;
    }

    public int getReadTimeout(MessageContext mc) {
        int result = 0;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("readTimeout");
        }
        try {
            if (!JavaUtils.hasValue(policyValue)) {
                result = super.getReadTimeout(mc);
            } else {
                result = Integer.parseInt(policyValue);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getReadTimeout() : " + result);
                }
            }
            if (result <= 0) {
                result = 300;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "...HttpEffectiveConfig.getReadTimeout() setting to default : " + result);
                }
            }
        }
        catch (NumberFormatException nEX) {
            FFDCFilter.processException((Throwable)nEX, "com.ibm.ws.websvcs.transport.http.HttpEffectiveConfig.getReadTimeout", "386", this);
            result = 300;
        }
        return result * 1000;
    }

    public String getProtocolVer(MessageContext mc) {
        String result = "HTTP/1.1";
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("protocolVersion");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.getProtocolVer(mc);
        } else {
            result = policyValue;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpEffectiveConfig.getProtocolVer() : " + result);
            }
        }
        if (!JavaUtils.hasValue(result)) {
            result = "HTTP/1.1";
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpEffectiveConfig.getProtocolVer() setting to : " + result);
            }
        }
        return result;
    }

    public boolean maintainSessionEnabled(MessageContext mc) {
        boolean result = false;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("maintainSession");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.maintainSessionEnabled(mc);
        } else if (policyValue.equalsIgnoreCase("yes")) {
            result = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "HttpEffectiveConfig.maintainSessionEnabled :  " + result);
            }
        }
        return result;
    }

    public boolean chunkedEncodingEnabled(MessageContext mc) {
        boolean result = true;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("chunkTransferEnc");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.chunkedEncodingEnabled(mc);
        } else if (policyValue.equalsIgnoreCase("no")) {
            result = false;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.chunkedEncodingEnabled() : " + result);
            }
        }
        if (!result) {
            result = this.isHeaderMapSetupForChunking(mc);
        }
        if (result && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.chunkedEncodingEnabled() : " + result);
        }
        return result;
    }

    private boolean isHeaderMapSetupForChunking(MessageContext mc) {
        Map headerMap = (Map)mc.getProperty("TRANSPORT_HEADERS");
        if (headerMap == null) {
            return false;
        }
        String value = (String)headerMap.get(HTTPConstants.HEADER_TRANSFER_ENCODING);
        return value != null && value.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED);
    }

    public boolean sendExpectHeaderEnabled(MessageContext mc) {
        boolean result = false;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("sendExpectHeader");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.sendExpectHeaderEnabled(mc);
        } else if (policyValue.equalsIgnoreCase("yes")) {
            result = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.sendExpectHeaderEnabled() : " + result);
            }
        }
        return result;
    }

    public boolean persistConnEnabled(MessageContext mc) {
        boolean result = true;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("persistConnection");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.persistConnEnabled(mc);
        } else if (policyValue.equalsIgnoreCase("no")) {
            result = false;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.persistConnEnabled() : " + result);
            }
        }
        return result;
    }

    public boolean msgResendOnceEnabled(MessageContext mc) {
        boolean result = false;
        String policyValue = null;
        if (this.isPolicySetDefined()) {
            policyValue = this.policy.getProperty("messageResendOnce");
        }
        if (!JavaUtils.hasValue(policyValue)) {
            result = super.msgResendOnceEnabled(mc);
        } else if (policyValue.equalsIgnoreCase("yes")) {
            result = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.msgResendOnceEnabled() : " + result);
            }
        }
        return result;
    }

    public String requestCompressEnabled(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("compressRequest:name");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.requestCompressEnabled(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.requestCompressEnabled() : " + result);
        }
        return result;
    }

    public String responseCompressEnabled(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("compressResponse:name");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.responseCompressEnabled(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.responseCompressEnabled() : " + result);
        }
        return result;
    }

    public String getOutRequestPassword(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestBasicAuth:password");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestPassword(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestPassword()... : " + (JavaUtils.hasValue(result) ? "******" : emptyString));
        }
        if (result == null) {
            result = emptyString;
        }
        return result;
    }

    public String getOutRequestUserID(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestBasicAuth:userid");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestUserID(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestUserID()... : " + result);
        }
        return result;
    }

    public String getOutAsyncRespPassword(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseBasicAuth:password");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespPassword(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespPassword()... : " + (JavaUtils.hasValue(result) ? "******" : emptyString));
        }
        if (result == null) {
            result = emptyString;
        }
        return result;
    }

    public String getOutAsyncRespUserID(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseBasicAuth:userid");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespUserID(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespUserID()... : " + result);
        }
        return result;
    }

    public String getOutRequestProxyPassword(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestProxy:password");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestProxyPassword(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyPassword()... : " + (JavaUtils.hasValue(result) ? "******" : emptyString));
        }
        return result;
    }

    public String getOutRequestProxyUserID(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestProxy:userid");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestProxyUserID(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyUserID()... " + result);
        }
        return result;
    }

    public String getOutAsyncRespProxyPassword(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseProxy:password");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespProxyPassword(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyPassword()... : " + (JavaUtils.hasValue(result) ? "******" : emptyString));
        }
        return result;
    }

    public String getOutAsyncRespProxyUserID(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseProxy:userid");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespProxyUserID(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyUserID()... : " + result);
        }
        return result;
    }

    public String getOutRequestProxyHost(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestProxy:host");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestProxyHost(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyHost()... : " + result);
        }
        return result;
    }

    public String getOutRequestProxyPort(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestProxy:port");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutRequestProxyPort(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutRequestProxyPort()... : " + result);
        }
        return result;
    }

    public String getOutAsyncRespProxyHost(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseProxy:host");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespProxyHost(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyHost()... : " + result);
        }
        return result;
    }

    public String getOutAsyncRespProxyPort(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponseProxy:port");
        }
        if (!JavaUtils.hasValue(result)) {
            result = super.getOutAsyncRespProxyPort(mc);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncRespProxyPort()... : " + result);
        }
        return result;
    }

    public boolean redirectURLEnabled(MessageContext mc) {
        boolean result = false;
        String redirect = null;
        if (this.isPolicySetDefined()) {
            redirect = this.policy.getProperty("acceptRedirectedURL");
        }
        if (!JavaUtils.hasValue(redirect)) {
            result = super.redirectURLEnabled(mc);
        } else if (redirect.equalsIgnoreCase("yes")) {
            result = true;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "...HttpEffectiveConfig.redirectURLEnabled() : " + result);
            }
        }
        return result;
    }

    public boolean getOutReqSSLEnabled(MessageContext mc) {
        String sslEnabled = null;
        boolean result = false;
        if (this.isPolicySetDefined()) {
            sslEnabled = (String)this.policy.get("outRequestSSLenabled");
        }
        if (JavaUtils.hasValue(sslEnabled) && sslEnabled.equalsIgnoreCase("yes")) {
            result = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutReqSSLEnabled()... : " + result);
        }
        return result;
    }

    public String getOutReqSSLAlias(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestwithSSL:configAlias");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutReqSSLAlias()... : " + result);
        }
        return result;
    }

    public String getOutReqSSLFile(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outRequestwithSSL:configFile");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutReqSSLFile()... : " + result);
        }
        return result;
    }

    public boolean getOutAsyncResponseSSLEnabled(MessageContext mc) {
        String sslEnabled = null;
        boolean result = false;
        if (this.isPolicySetDefined()) {
            sslEnabled = (String)this.policy.get("outAsyncResponseSSLenabled");
        }
        if (JavaUtils.hasValue(sslEnabled) && sslEnabled.equalsIgnoreCase("yes")) {
            result = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncResponseSSLEnabled()... : " + result);
        }
        return result;
    }

    public String getOutAsyncResponseSSLAlias(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponsewithSSL:configAlias");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncResponseSSLAlias()... : " + result);
        }
        return result;
    }

    public String getOutAsyncResponseSSLFile(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("outAsyncResponsewithSSL:configFile");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getOutAsyncResponseSSLFile()... : " + result);
        }
        return result;
    }

    public boolean getInAsyncResponseSSLEnabled(MessageContext mc) {
        String sslEnabled = null;
        boolean result = false;
        if (this.isPolicySetDefined()) {
            sslEnabled = (String)this.policy.get("inResponseSSLenabled");
        }
        if (JavaUtils.hasValue(sslEnabled) && sslEnabled.equalsIgnoreCase("yes")) {
            result = true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.getInAsyncResponseSSLEnabled()... : " + result);
        }
        return result;
    }

    public String getInAsyncResponseSSLAlias(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("inResponsewithSSL:configAlias");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.inResponseSSLAlias()... : " + result);
        }
        return result;
    }

    public String getInAsyncResponseSSLFile(MessageContext mc) {
        String result = null;
        if (this.isPolicySetDefined()) {
            result = (String)this.policy.get("inResponsewithSSL:configFile");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpEffectiveConfig.inResponseSSLFile()... : " + result);
        }
        return result;
    }

    public String getCustomProperty(MessageContext mc, String propName) {
        com.ibm.ws.websvcs.transport.policyset.jaxb.Properties jaxbP;
        String result = null;
        if (this.isPolicySetDefined() && (jaxbP = (com.ibm.ws.websvcs.transport.policyset.jaxb.Properties)this.policy.get("properties")) != null) {
            List<CustomProperty> customProperties = jaxbP.getCustomProperty();
            for (CustomProperty prop : customProperties) {
                if (!propName.equals(prop.getName())) continue;
                result = prop.getValue();
                break;
            }
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "...HttpEffectiveConfig.getCustomProperty() : " + result);
        }
        return result;
    }
}

