/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.ws.websvcs.transport.http.HttpWriteCallback;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.OutputStream;

public class HttpByteBufferOutputStream
extends OutputStream {
    private static final TraceComponent _tc = Tr.register(HttpByteBufferOutputStream.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private HttpInboundServiceContext httpInSC;
    private HttpWriteCallback writeCB;
    private boolean flushToWire;
    private WsByteBuffer[] bufferToWrite;
    private int totalBuffered;

    public HttpByteBufferOutputStream(HttpInboundServiceContext _httpInSC, HttpWriteCallback _writeCB) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "HttpByteBufferOutputStream ctor...");
        }
        this.httpInSC = _httpInSC;
        this.writeCB = _writeCB;
        this.flushToWire = true;
        this.bufferToWrite = null;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpByteBufferOutputStream ctor");
        }
    }

    public void write(int ch) throws IOException {
        WsByteBuffer bb = WsByteBufferPoolManagerImpl.getRef().allocateDirect(1);
        bb.put((byte)ch);
        bb.flip();
        this.addBufferToWriteBuffer(bb);
    }

    public void write(byte[] buf, int offset, int length) throws IOException {
        WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(length);
        buffer.put(buf, offset, length);
        buffer.flip();
        this.addBufferToWriteBuffer(buffer);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public final void print(char[] buf, int offset, int length) throws IOException {
        WsByteBuffer buffer = WsByteBufferPoolManagerImpl.getRef().allocateDirect(length);
        buffer.putChar(buf, offset, length);
        buffer.flip();
        this.addBufferToWriteBuffer(buffer);
    }

    public final void print(char ch) throws IOException {
        this.write(ch);
    }

    public final void print(char[] buffer) throws IOException {
        this.print(buffer, 0, buffer.length);
    }

    public final void print(String string) throws IOException {
        this.print(string, 0, string.length());
    }

    public final void print(String string, int off, int len) throws IOException {
        byte[] bytes = string.getBytes();
        this.write(bytes, off, len);
    }

    public final void print(boolean b) throws IOException {
        this.print(String.valueOf(b));
    }

    public final void print(int i) throws IOException {
        String s = Integer.toString(i);
        this.print(s);
    }

    public final void print(long i) throws IOException {
        String s = Long.toString(i);
        this.print(s);
    }

    public final void print(float f) throws IOException {
        String s = Float.toString(f);
        this.print(s);
    }

    public final void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    public final void print(Object o) throws IOException {
        this.print(o.toString());
    }

    public void setFlushMode(boolean _flushToWire) {
        this.flushToWire = _flushToWire;
    }

    public void flush() {
        this.flushWriteBuffer();
    }

    public void flushWriteBuffer() {
        if (this.hasContentBuffered()) {
            this.writeCB.writeBuffer(this.bufferToWrite);
            this.resetBuffer();
        }
    }

    public boolean hasContentBuffered() {
        return this.bufferToWrite != null;
    }

    private void addBufferToWriteBuffer(WsByteBuffer buffer) {
        this.totalBuffered += buffer.remaining();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Adding buffer to write --> " + buffer.remaining() + " buffered --> " + this.totalBuffered);
        }
        if (this.bufferToWrite == null) {
            this.bufferToWrite = new WsByteBuffer[1];
            this.bufferToWrite[0] = buffer;
        } else {
            WsByteBuffer[] oldBuffer = this.bufferToWrite;
            this.bufferToWrite = new WsByteBuffer[oldBuffer.length + 1];
            for (int i = 0; i < oldBuffer.length; ++i) {
                this.bufferToWrite[i] = oldBuffer[i];
            }
            this.bufferToWrite[oldBuffer.length] = buffer;
        }
        if (this.flushToWire) {
            this.writeCB.writeBuffer(this.bufferToWrite);
            this.resetBuffer();
        }
        if (this.totalBuffered > this.writeCB.getBufferSize()) {
            this.writeCB.writeBuffer(this.bufferToWrite);
            this.resetBuffer();
        }
    }

    private void resetBuffer() {
        this.bufferToWrite = null;
        this.totalBuffered = 0;
    }
}

