/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import com.ibm.wsspi.http.channel.inbound.HttpInboundServiceContext;
import java.io.IOException;
import java.io.InputStream;

public class HttpByteBufferInputStream
extends InputStream {
    private static final TraceComponent _tc = Tr.register(HttpByteBufferInputStream.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private HttpInboundServiceContext httpInSC = null;
    private WsByteBuffer curBuffer;

    public HttpByteBufferInputStream(HttpInboundServiceContext httpInSC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpByteBufferInputStream");
        }
        this.httpInSC = httpInSC;
        this.curBuffer = null;
        this.nextBuffer();
    }

    public int available() {
        if (this.moreData()) {
            return this.curBuffer.remaining();
        }
        return -1;
    }

    public int read() throws IOException {
        if (this.moreData()) {
            return this.curBuffer.get();
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "read(byte[]): b.length=" + b.length);
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "read(byte[],int,int): len=" + len + ", offset=" + off);
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (!this.moreData()) {
            return -1;
        }
        if (len > this.curBuffer.remaining()) {
            len = this.curBuffer.remaining();
        }
        this.curBuffer.get(b, off, len);
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "read(byte[],int,int)");
        }
        return len;
    }

    public boolean markSupported() {
        return false;
    }

    private boolean moreData() {
        if (this.curBuffer != null) {
            if (this.curBuffer.hasRemaining()) {
                return true;
            }
            this.nextBuffer();
            return this.moreData();
        }
        return false;
    }

    private void nextBuffer() {
        if (this.curBuffer == null || !this.curBuffer.hasRemaining()) {
            this.releaseBuffer();
            try {
                if (!this.httpInSC.isIncomingMessageFullyRead()) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Reading Next Response Body Buffer");
                    }
                    this.curBuffer = this.httpInSC.getRequestBodyBuffer();
                }
                if (this.curBuffer != null && _tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Buffer Value After Reading Response Body=" + new String(WsByteBufferUtils.asByteArray(this.curBuffer)));
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.in.HttpOutResponseInputStream", "92", this);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Failed to get next body buffer");
                }
                throw new RuntimeException(e);
            }
        }
    }

    public void releaseBuffer() {
        if (_tc.isDebugEnabled()) {
            Tr.entry(_tc, "releaseCurBuffer()");
        }
        if (this.curBuffer != null) {
            this.curBuffer.release();
            this.curBuffer = null;
        }
        if (_tc.isDebugEnabled()) {
            Tr.exit(_tc, "releaseCurBuffer()");
        }
    }
}

