/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import com.ibm.ws.websvcs.transport.TransportRequest;
import com.ibm.ws.websvcs.transport.TransportResponse;
import com.ibm.wsspi.http.channel.HttpConstants;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.util.UUIDGenerator;

public class HttpAsyncResponseContext
extends AsyncResponseContext {
    private static final TraceComponent _tc = Tr.register(HttpAsyncResponseContext.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public HttpAsyncResponseContext(AxisService as, ConfigurationContext cc, String key) {
        this.axisService = as;
        this.confContext = cc;
        this.hashKey = key;
    }

    public void handleRequest(TransportRequest request, TransportResponse response) throws Exception {
        String soapActionHeader;
        String contentType;
        MessageContext responseMC;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "HttpAsyncResponseContext.handleRequest()...");
        }
        Object msgID = null;
        if (this.confContext != null) {
            boolean soap11 = false;
            responseMC = new MessageContext();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting up message context...");
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting incoming transport...");
            }
            responseMC.setIncomingTransportName("http");
            TransportOutDescription transportOut = this.confContext.getAxisConfiguration().getTransportOut("http");
            TransportInDescription transportIn = this.confContext.getAxisConfiguration().getTransportIn("http");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Adding configuration context...");
            }
            responseMC.setConfigurationContext(this.confContext);
            responseMC.setTransportIn(transportIn);
            responseMC.setTransportOut(transportOut);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting service group context id...");
            }
            responseMC.setServiceGroupContextId(UUIDGenerator.getUUID());
            responseMC.setServerSide(true);
            responseMC.setProperty("TransportInURL", request.getRequestURLAsString());
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "Setting up HTTP header hashMap...");
            }
            HashMap<String, String> tmpHM = new HashMap<String, String>();
            Enumeration tmpE = request.getHeaderNames();
            while (tmpE.hasMoreElements()) {
                String value = (String)tmpE.nextElement();
                tmpHM.put(value, request.getHeader(value));
            }
            responseMC.setProperty("TRANSPORT_HEADERS", tmpHM);
            responseMC.setProperty("TRANSPORT_OUT", response.getOutputStream());
            responseMC.setProperty("OutTransportInfo", response.getOutputStream());
            contentType = request.getContentType();
            soapActionHeader = request.getHeader(HttpConstants.HDR_SOAPACTION.toString());
            if (this.axisService != null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "AxisService set on msg context.");
                }
                responseMC.setAxisService(this.axisService);
            }
        } else {
            String msg = NLSProvider.getNLS().getFormattedMessage("configNotFound00", new Object[0], "Web services configuration information was not available for an incoming request.");
            throw new Exception(msg);
        }
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        InputStream reqIS = request.getInputStream();
        HTTPTransportUtils.processHTTPPostRequest(responseMC, reqIS, response.getOutputStream(), contentType, soapActionHeader, request.getRequestURI());
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...HttpAsyncResponseContext.handleRequest()");
        }
    }
}

