/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.pmi.MessagePMIContext;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.trace.CommonUtils;
import com.ibm.ws.websvcs.trace.MessageTrace;
import com.ibm.ws.websvcs.transport.http.SOAPOverHTTPSender;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.ws.websvcs.utils.LowFlushFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.HTTPTransportUtils;
import org.apache.axis2.transport.http.ServletBasedOutTransportInfo;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.Header;

public class HTTPTransportSender
extends AbstractHandler
implements TransportSender {
    protected String httpVersion = "HTTP/1.1";
    private boolean chunked = false;
    int soTimeout = 60000;
    int connectionTimeout = 60000;
    private static final TraceComponent _tc = Tr.register(HTTPTransportSender.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public void cleanup(MessageContext msgContext) throws AxisFault {
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
        Parameter version = transportOut.getParameter("PROTOCOL");
        if (version != null) {
            if ("HTTP/1.1".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.1";
                Parameter transferEncoding = transportOut.getParameter(HTTPConstants.HEADER_TRANSFER_ENCODING);
                if (transferEncoding != null && HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED.equals(transferEncoding.getValue())) {
                    this.chunked = true;
                }
            } else if ("HTTP/1.0".equals(version.getValue())) {
                this.httpVersion = "HTTP/1.0";
            } else {
                Object[] inserts = new Object[]{"PROTOCOL"};
                String msg = NLSProvider.getNLS().getFormattedMessage("httpParameter00", inserts, "The {0} parameter can have values of only HTTP/1.0 or HTTP/1.1");
                throw new AxisFault(msg);
            }
        }
        try {
            Parameter tempSoTimeoutParam = transportOut.getParameter("SO_TIMEOUT");
            Parameter tempConnTimeoutParam = transportOut.getParameter("CONNECTION_TIMEOUT");
            if (tempSoTimeoutParam != null) {
                this.soTimeout = Integer.parseInt((String)tempSoTimeoutParam.getValue());
            }
            if (tempConnTimeoutParam != null) {
                this.connectionTimeout = Integer.parseInt((String)tempConnTimeoutParam.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            FFDCFilter.processException((Throwable)nfe, "com.ibm.ws.websvcs.transport.http.HTTPTransportSender.init", "183", this);
        }
    }

    public void stop() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        block29: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "invoke msgContext : ", msgContext);
            }
            try {
                try {
                    TransportOutDescription transportOut;
                    Object mimeBoundaryProperty;
                    OMOutputFormat format = new OMOutputFormat();
                    msgContext.setDoingMTOM(HTTPTransportUtils.doWriteMTOM(msgContext));
                    msgContext.setDoingSwA(HTTPTransportUtils.doWriteSwA(msgContext));
                    msgContext.setDoingREST(HTTPTransportUtils.isDoingREST(msgContext));
                    format.setSOAP11(msgContext.isSOAP11());
                    format.setDoOptimize(msgContext.isDoingMTOM());
                    format.setDoingSWA(msgContext.isDoingSwA());
                    format.setCharSetEncoding(HTTPTransportUtils.getCharSetEncoding(msgContext));
                    if (msgContext.isDoingREST()) {
                        String contentType;
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "This is a rest message.");
                        }
                        if ((contentType = (String)msgContext.getProperty("ContentType")) != null && contentType.length() > 0) {
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "Setting content type on the OMOutputFormat to: " + contentType);
                            }
                            format.setContentType(contentType);
                        } else if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "Processing rest message but could not find content type on MessageContext");
                        }
                    }
                    if ((mimeBoundaryProperty = msgContext.getProperty("mimeBoundary")) != null) {
                        format.setMimeBoundary((String)mimeBoundaryProperty);
                    }
                    if ((transportOut = msgContext.getConfigurationContext().getAxisConfiguration().getTransportOut("http")) != null) {
                        Parameter param = transportOut.getParameter("OmitSOAP12Action");
                        Object value = null;
                        if (param != null) {
                            value = param.getValue();
                        }
                        if (value != null && JavaUtils.isTrueExplicitly(value) && !msgContext.isSOAP11()) {
                            msgContext.setProperty("disableSoapAction", Boolean.TRUE);
                        }
                    }
                    EndpointReference epr = null;
                    if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
                        epr = msgContext.getTo();
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "epr : " + epr.toString());
                        }
                    } else {
                        String transportURL = (String)msgContext.getProperty("TransportURL");
                        if (transportURL != null) {
                            epr = new EndpointReference(transportURL);
                            msgContext.setTo(epr);
                            if (_tc.isDebugEnabled()) {
                                Tr.debug(_tc, "transportURL : ", transportURL);
                            }
                        }
                    }
                    if (epr != null) {
                        if (!epr.getAddress().equals("http://www.w3.org/2005/08/addressing/none")) {
                            SOAPOverHTTPSender sender = new SOAPOverHTTPSender(msgContext);
                            sender.setFormat(format);
                            sender.setSoapAction(HTTPTransportSender.findSOAPAction(msgContext));
                            boolean chunking = sender.getChunkingEnabled();
                            if (MessageTrace.isTraceEnabled()) {
                                if (chunking) {
                                    Tr.debug(MessageTrace.gettc(), "Sending the request in Chunking mode");
                                } else {
                                    Tr.debug(MessageTrace.gettc(), "Sending the request in Non-chunking mode");
                                }
                                this.traceResponse(msgContext, format);
                            }
                            sender.send(msgContext);
                        }
                    } else {
                        if (msgContext.getProperty("TRANSPORT_OUT") == null) {
                            String msg = NLSProvider.getNLS().getFormattedMessage("nullTOTransportOut00", new Object[0], "Both the TransportOut and property MessageContext.TRANSPORT_OUT values are null.");
                            throw new AxisFault(msg);
                        }
                        this.sendUsingOutputStream(msgContext, format);
                    }
                    TransportUtils.setResponseWritten(msgContext, true);
                }
                catch (Exception sox) {
                    FFDCFilter.processException((Throwable)sox, "com.ibm.ws.websvcs.transport.http.HTTPTransportSender.invoke", "344", this);
                    throw AxisFault.makeFault(sox);
                }
                Object var9_10 = null;
                if (!_tc.isEntryEnabled()) break block29;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "invoke");
                }
                TransportUtils.deleteAttachments(msgContext);
                throw throwable;
            }
            Tr.exit(_tc, "invoke");
        }
        TransportUtils.deleteAttachments(msgContext);
        return Handler.InvocationResponse.CONTINUE;
    }

    private void sendUsingOutputStream(MessageContext msgContext, OMOutputFormat format) throws AxisFault, XMLStreamException, IOException {
        OutputStream out;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sendUsingOutputStream");
        }
        if ((out = (OutputStream)msgContext.getProperty("TRANSPORT_OUT")) != null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "outputStream : " + out.toString());
        }
        OutTransportInfo transportInfo = (OutTransportInfo)msgContext.getProperty("OutTransportInfo");
        ServletBasedOutTransportInfo servletBasedOutTransportInfo = null;
        if (transportInfo != null && transportInfo instanceof ServletBasedOutTransportInfo) {
            servletBasedOutTransportInfo = (ServletBasedOutTransportInfo)transportInfo;
            Object customHeaders = msgContext.getProperty("HTTP_HEADERS");
            if (customHeaders != null) {
                if (customHeaders instanceof List) {
                    for (Header header : (List)customHeaders) {
                        if (header == null) continue;
                        servletBasedOutTransportInfo.addHeader(header.getName(), header.getValue());
                    }
                } else if (customHeaders instanceof Map) {
                    for (Map.Entry entry : ((Map)customHeaders).entrySet()) {
                        if (entry == null) continue;
                        servletBasedOutTransportInfo.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
            }
        }
        boolean isDoingCompression = this.isDoingCompression(msgContext);
        format.setAutoCloseWriter(true);
        MessageFormatter messageFormatter = TransportUtils.getMessageFormatter(msgContext);
        if (messageFormatter == null) {
            String string = NLSProvider.getNLS().getFormattedMessage("messageFormatterFail", new Object[0], "Internal error. A response could not be written to output stream because a message formatter could not be found.");
            throw new AxisFault(string);
        }
        if (transportInfo != null) {
            transportInfo.setContentType(messageFormatter.getContentType(msgContext, format, HTTPTransportSender.findSOAPAction(msgContext)));
        }
        if (MessageTrace.isTraceEnabled()) {
            this.traceResponse(msgContext, format);
        }
        LowFlushFilter lowFlushFilter = new LowFlushFilter(out);
        messageFormatter.writeTo(msgContext, format, lowFlushFilter, false);
        if (lowFlushFilter != null) {
            this.setPMIResponseLength(msgContext, lowFlushFilter.size());
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sendUsingOutputStream");
        }
    }

    void setPMIResponseLength(MessageContext msgContext, long responseLength) {
        MessagePMIContext pmiContext = (MessagePMIContext)msgContext.getProperty("com.ibm.ws.websvcs.MESSAGE_PMI_CONTEXT");
        if (pmiContext != null) {
            pmiContext.setResponseSize(responseLength);
        }
    }

    private boolean isDoingCompression(MessageContext msgContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "checkForCompression");
        }
        if (msgContext.getAxisOperation() == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No HTTP Policy Set. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        PolicySetConfiguration config2 = (PolicySetConfiguration)Axis2Utils.getPolicySet(msgContext.getAxisOperation());
        Properties props = (Properties)config2.getPolicyTypeConfiguration("HTTP_POLICY");
        if (props == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "No HTTP Policy Set. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        String compression = props.getProperty("compressResponse:name");
        if (compression == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Compression was null. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        if (!(msgContext.getProperty("OutTransportInfo") instanceof ServletBasedOutTransportInfo)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "TransportInfo not servlet based. Returning.");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "checkForCompression");
            }
            return false;
        }
        boolean isDoingCompression = false;
        ServletBasedOutTransportInfo transportInfo = (ServletBasedOutTransportInfo)msgContext.getProperty("OutTransportInfo");
        String contentHeader = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_CF_WSZIP;
        String gzip = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_C_ENC_GZIP;
        String xgzip = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_C_ENC_XGZIP;
        String deflate = com.ibm.ws.webservices.engine.transport.http.HTTPConstants.HEADER_C_ENC_DEFLATE;
        if (gzip.equalsIgnoreCase(compression)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "GZIP compression used.");
            }
            transportInfo.addHeader(contentHeader, gzip);
            isDoingCompression = true;
        } else if (xgzip.equalsIgnoreCase(compression)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "X-GZIP compression used.");
            }
            transportInfo.addHeader(contentHeader, xgzip);
            isDoingCompression = true;
        } else if (deflate.equalsIgnoreCase(compression)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Deflate compression used.");
            }
            transportInfo.addHeader(contentHeader, deflate);
            isDoingCompression = true;
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "No compression.");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "checkForCompression");
        }
        return isDoingCompression;
    }

    private static String findSOAPAction(MessageContext messageContext) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "findSOAPAction");
        }
        String soapActionString = null;
        Object disableSoapAction = messageContext.getOptions().getProperty("disableSoapAction");
        if (!JavaUtils.isTrueExplicitly(disableSoapAction)) {
            soapActionString = messageContext.getSoapAction();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Got this soapAction from MessageContext.getSoapAction: " + soapActionString);
            }
            if (soapActionString == null || soapActionString.length() == 0) {
                soapActionString = messageContext.getWSAAction();
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Got this soapAction from MessageContext.getWSAAction: " + soapActionString);
                }
                if (messageContext.getAxisOperation() != null && (soapActionString == null || soapActionString.length() == 0)) {
                    soapActionString = messageContext.getAxisOperation().getSoapAction();
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Got this soapAction from AxisOperation.getSoapAction: " + soapActionString);
                    }
                }
            }
        }
        if (soapActionString == null) {
            soapActionString = "\"\"";
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "findSOAPAction, soapActionString= " + soapActionString);
        }
        return soapActionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traceResponse(MessageContext msgContext, OMOutputFormat format) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "traceResponse");
        }
        String str = null;
        String mep = msgContext.getAxisOperation() != null ? msgContext.getAxisOperation().getMessageExchangePattern() : null;
        str = "http://www.w3.org/2006/01/wsdl/out-in".equals(mep) || "http://www.w3.org/2004/08/wsdl/out-in".equals(mep) || "http://www.w3.org/2006/01/wsdl/out-only".equals(mep) || "http://www.w3.org/2004/08/wsdl/out-only".equals(mep) || "http://www.w3.org/ns/wsdl/out-in".equals(mep) || "http://www.w3.org/ns/wsdl/out-only".equals(mep) ? new String("OUTBOUND_HTTP_REQUEST") : new String("OUTBOUND_HTTP_RESPONSE");
        try {
            try {
                SOAPEnvelope envelope = msgContext.getEnvelope();
                CommonUtils.logDebug(envelope, _tc, 100000, format, str);
            }
            catch (Throwable t) {
                Tr.debug(_tc, "Response message could not be traced because of the following error: " + t.toString());
                Object var7_8 = null;
                if (!_tc.isEntryEnabled()) return;
                Tr.exit(_tc, "traceResponse");
                return;
            }
            Object var7_7 = null;
            if (!_tc.isEntryEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!_tc.isEntryEnabled()) throw throwable;
            Tr.exit(_tc, "traceResponse");
            throw throwable;
        }
        Tr.exit(_tc, "traceResponse");
    }
}

