/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.http;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;

public class HTTPConnectionHandler
extends AbstractHandler {
    private static final TraceComponent tc = Tr.register(HTTPConnectionHandler.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private OutboundConnectionCache cache = null;

    public void init(HandlerDescription handlerdesc) {
        super.init(handlerdesc);
        this.cache = OutboundConnectionCache.getInstance();
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke");
        }
        try {
            OperationContext opCtx = msgContext.getOperationContext();
            if (opCtx == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Operation context not found in HTTPConnectionHandler");
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            MessageContext reqMsgCtx = opCtx.getMessageContext("Out");
            if (reqMsgCtx == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Request MessageContext not found in HTTPConnectionHandler");
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            HTTPConnection conn = (HTTPConnection)reqMsgCtx.getProperty("com.ibm.ws.websvcs.transport.http.asyncRequestConnection");
            if (conn != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Resetting the HTTPConnection instance: " + conn);
                }
                conn.reset();
                this.cache.findGroupAndReturnConnection(conn);
                reqMsgCtx.setProperty("com.ibm.ws.websvcs.transport.http.asyncRequestConnection", null);
                conn = null;
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.http.HTTPConnectionHandler", "72", this);
            throw AxisFault.makeFault(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke");
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

