/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.channel.framework.FlowType;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.channel.WSChannelConstants;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.ws.websvcs.transport.security.ConfigSSL;
import com.ibm.wsspi.buffermgmt.WsByteBufferPoolManager;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChannelFramework;
import com.ibm.wsspi.channel.framework.ChannelFrameworkFactory;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.OutboundVirtualConnection;
import com.ibm.wsspi.channel.framework.VirtualConnectionFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.axis2.AxisFault;

public final class WSChannelManager {
    private static final TraceComponent _tc = Tr.register(WSChannelManager.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static final String cfImplClass = "com.ibm.ws.channel.framework.impl.ChannelFrameworkImpl".intern();
    private static final String wbbpMgrImplClass = "com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl".intern();
    private static String tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.WSTCPChannelFactory";
    private static ChannelFramework cfS = null;
    private static WsByteBufferPoolManager wbbpMgr = null;
    private static WSChannelManager wMgr = null;
    private static Object o_RequestMapper = null;
    private static Object o_RequestFlowInfo = null;
    private static Method m_mapRequest = null;
    private static Method m_getClusterName = null;
    private static Method m_getVirtualHostName = null;
    private static Method m_getCellName = null;
    private static Method m_release = null;
    private static Class ac_UCFRoutingHelper = null;
    private static Method m_getHAClusterIdForDestinationEPR = null;
    private static Method m_getWLMClusterIdForDestinationEPR = null;
    private static Method m_getFragileClusterIdForDestinationEPR = null;
    private static Method m_isDestinationEPRFragile = null;
    private static Method m_getVirtualHostForDestinationEPR = null;
    private static boolean dwlmEnabled = true;
    public static int runtimeEnv = 3;

    private WSChannelManager() {
    }

    public static final synchronized WSChannelManager getInstance() {
        if (wMgr == null) {
            wMgr = new WSChannelManager();
        }
        return wMgr;
    }

    public int getRuntime() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "getRuntime Runtime ENV : " + runtimeEnv);
        }
        return runtimeEnv;
    }

    public void setManagedRuntime(boolean isServerSide) {
        if (isServerSide) {
            runtimeEnv = 1;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "setManagedRuntime Runtime ENV : " + runtimeEnv);
        }
    }

    public final void setChannelFramework(ChannelFrameworkService incfS) {
        cfS = incfS;
    }

    public final synchronized ChannelFramework getChannelFramework() throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (cfS == null) {
            cfS = (ChannelFramework)this.getRequiredService(cfImplClass);
        }
        return cfS;
    }

    public final void setWsByteBufferPoolManager(WsByteBufferPoolManager inwbbpMgr) {
        wbbpMgr = inwbbpMgr;
    }

    public final synchronized WsByteBufferPoolManager getWsByteBufferPoolManager() throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (wbbpMgr == null) {
            wbbpMgr = (WsByteBufferPoolManager)this.getRequiredService(wbbpMgrImplClass);
        }
        return wbbpMgr;
    }

    private Object getRequiredService(String serviceClassName) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getRequiredService() : " + serviceClassName);
        }
        Object retObj = null;
        InitialContext ctxt = null;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Runtime ENV : " + runtimeEnv);
        }
        try {
            ctxt = new InitialContext();
            if (serviceClassName == cfImplClass) {
                retObj = ctxt.lookup("services:websphere/ChannelFrameworkService");
            }
            if (serviceClassName == wbbpMgrImplClass) {
                retObj = ctxt.lookup("services:websphere/WsByteBufferPoolManager");
            }
            if (retObj != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found RequiredService in global namespace " + serviceClassName + (retObj == null ? null : retObj.toString()));
            }
        }
        catch (NamingException nex) {
        }
        catch (NoClassDefFoundError nex) {
            // empty catch block
        }
        if (retObj == null) {
            try {
                if (serviceClassName == cfImplClass) {
                    retObj = ctxt.lookup("websphere/ChannelFrameworkService");
                }
                if (serviceClassName == wbbpMgrImplClass) {
                    retObj = ctxt.lookup("websphere/WsByteBufferPoolManager");
                }
            }
            catch (NamingException nex) {
            }
            catch (NoClassDefFoundError nex) {
                // empty catch block
            }
            if (retObj != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Found RequiredService in local namespace " + serviceClassName + (retObj == null ? null : retObj.toString()));
            }
        }
        if (retObj == null) {
            if (serviceClassName.equals(cfImplClass)) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Using existing instance of ChannelFramework");
                }
                retObj = ChannelFrameworkFactory.getChannelFramework();
            } else {
                Class clazz;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "j2wLoadClass00 " + serviceClassName);
                }
                if ((clazz = ClassUtils.forName(serviceClassName)) != null) {
                    Constructor ct = null;
                    try {
                        ct = (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws NoSuchMethodException {
                                return clazz.getConstructor(null);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getRequiredService", "415", this);
                        Tr.error(_tc, "getrequiredservice : ", e);
                        throw (NoSuchMethodException)e.getException();
                    }
                    retObj = ct.newInstance(null);
                }
            }
            if (retObj != null && _tc.isDebugEnabled()) {
                Tr.debug(_tc, "Created RequiredService " + serviceClassName + (retObj == null ? null : retObj.toString()));
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getRequiredService()");
        }
        return retObj;
    }

    private boolean createChannel(String channelName, boolean sslEnabled, ConfigSSL sslProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createChannel()...");
        }
        boolean succeeded = false;
        if (cfS.getChannel(channelName) == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "createChannel00 : " + channelName);
            }
            if (channelName.equals("httpclient-http-outbound")) {
                Class<?> httpChannFactory;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doing HTTP_OUT class");
                }
                if ((httpChannFactory = Class.forName("com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory")) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + httpChannFactory.toString());
                    }
                    cfS.addChannel("httpclient-http-outbound", httpChannFactory, null);
                    succeeded = true;
                }
            } else if (channelName.equals("httpclient-ssl-outbound")) {
                Class<?> sslChannFactory;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doing SSL_OUT class");
                }
                if ((sslChannFactory = Class.forName(runtimeEnv == 3 ? "com.ibm.ws.ssl.channel.impl.SSLChannelFactory" : "com.ibm.ws.ssl.channel.impl.WSSSLChannelFactory")) != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + sslChannFactory.toString());
                    }
                    Hashtable<Object, Object> inProps = new Hashtable<Object, Object>(sslProps);
                    cfS.addChannel("httpclient-ssl-outbound", sslChannFactory, inProps);
                    succeeded = true;
                }
            } else if (channelName.equals("httpclient-tcp-outbound")) {
                Class<?> tcpChannFactory = null;
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "doing HTTP_TCP class");
                }
                try {
                    tcpChannFactory = Class.forName(tcpChannelFactoryName);
                }
                catch (ClassNotFoundException cEx) {
                    FFDCFilter.processException((Throwable)cEx, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.createChannel", "539", this);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "exception01 " + cEx.getLocalizedMessage());
                    }
                    tcpChannelFactoryName = "com.ibm.ws.tcp.channel.impl.TCPChannelFactory";
                    tcpChannFactory = Class.forName(tcpChannelFactoryName);
                }
                if (tcpChannFactory != null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Using: " + tcpChannFactory.toString());
                    }
                    cfS.addChannel("httpclient-tcp-outbound", tcpChannFactory, null);
                    succeeded = true;
                }
            }
        } else {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "createChannel01 " + channelName);
            }
            succeeded = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createChannel()...");
        }
        return succeeded;
    }

    private void createChannelChain(String channelChainName, boolean sslEnabled, ConfigSSL sslProps) throws Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "createChannelChain()...");
        }
        if (cfS.getChain(channelChainName) == null) {
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "createChannelChain00 : " + channelChainName);
            }
            if (sslEnabled) {
                if (this.createChannel("httpclient-tcp-outbound", sslEnabled, sslProps) && this.createChannel("httpclient-ssl-outbound", sslEnabled, sslProps) && this.createChannel("httpclient-http-outbound", sslEnabled, sslProps)) {
                    cfS.addChain(channelChainName, FlowType.OUTBOUND, WSChannelConstants.HTTPS_CHAIN_ARRAY);
                }
            } else if (this.createChannel("httpclient-tcp-outbound", sslEnabled, sslProps) && this.createChannel("httpclient-http-outbound", sslEnabled, sslProps)) {
                cfS.addChain(channelChainName, FlowType.OUTBOUND, WSChannelConstants.HTTP_CHAIN_ARRAY);
            }
        } else if (_tc.isEventEnabled()) {
            Tr.event(_tc, "createChannelChain01 : " + channelChainName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "createChannelChain()...");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final VirtualConnectionFactory getVCFactory(WSAddress addrtoConnect) throws Exception {
        VirtualConnectionFactory vcF;
        block15: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getVCFactory(): " + addrtoConnect.toString());
            }
            vcF = null;
            try {
                CFEndPoint cPt;
                boolean useSSL = addrtoConnect.getSchema() == 2;
                ConfigSSL sslProps = null;
                if (useSSL) {
                    sslProps = (ConfigSSL)addrtoConnect.transportConfiguration();
                }
                if ((cPt = addrtoConnect.getCFEndPoint()) == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "CFEndPoint is null");
                    }
                    this.getChannelFramework();
                    if (cfS == null) {
                        Object[] inserts = new Object[]{"null ChannelFramework Service"};
                        String msg = NLSProvider.getNLS().getFormattedMessage("channelframework01", inserts, "The following errors occurred on the channel framework service: {0}");
                        throw new AxisFault(msg);
                    }
                    String activeChainName = addrtoConnect.keyValueforPool();
                    this.createChannelChain(activeChainName, useSSL, sslProps);
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "getVCFactory create channel done");
                    }
                    if ((vcF = cfS.getOutboundVCFactory(activeChainName)) == null) {
                        if (_tc.isDebugEnabled()) {
                            Tr.debug(_tc, "null VirtualConnectionFactory");
                        }
                        Object[] inserts = new Object[]{"null VirtualConnectionFactory"};
                        String msg = NLSProvider.getNLS().getFormattedMessage("channelframework01", inserts, "The following errors occurred on the channel framework service: {0}");
                        throw new AxisFault(msg);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "VirtualConnectionFactory : " + vcF.toString());
                    }
                    break block15;
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "CFEndPoint : " + cPt.toString());
                }
                if (useSSL) {
                    String sslalias = sslProps.configAliasProperty();
                    Hashtable<Object, Object> inProps = new Hashtable<Object, Object>(sslProps);
                    vcF = cPt.getOutboundVCFactory(inProps, true);
                } else {
                    vcF = cPt.getOutboundVCFactory();
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getVCFactory", "757", this);
                Tr.error(_tc, "getVCFactory Exception: ", ex);
                throw ex;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getVCFactory(): " + addrtoConnect.toString());
        }
        return vcF;
    }

    public final HTTPConnection getWSOutboundConnection(String chainName, WSAddress addrtoConnect, VirtualConnectionFactory vcf) throws Exception {
        HTTPConnection wsOC;
        block7: {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "getWSOutboundConnection(): " + addrtoConnect.toString());
            }
            wsOC = null;
            try {
                OutboundVirtualConnection oVC;
                if (vcf != null) {
                    oVC = (OutboundVirtualConnection)vcf.createConnection();
                    if (oVC == null) {
                        Object[] inserts = new Object[]{"null OutboundVirtualConnection"};
                        String msg = NLSProvider.getNLS().getFormattedMessage("channelframework01", inserts, "The following errors occurred on the channel framework service: {0}");
                        throw new AxisFault(msg);
                    }
                } else {
                    Object[] inserts = new Object[]{"null VirtualConnectionFactory"};
                    String msg = NLSProvider.getNLS().getFormattedMessage("channelframework01", inserts, "The following errors occurred on the channel framework service: {0}");
                    throw new AxisFault(msg);
                }
                wsOC = new HTTPConnection(oVC, addrtoConnect, chainName);
                int schemaType = addrtoConnect.getSchema();
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getWSOutboundConnection", "794", this);
                if (ex instanceof NamingException) break block7;
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.channel.WSChannelManager.getWSOutboundConnection", "857", this);
                throw ex;
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getWSOutboundConnection(): " + addrtoConnect.toString());
        }
        return wsOC;
    }
}

