/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.Config;
import com.ibm.ws.websvcs.transport.http.HttpChannelAddress;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.http.channel.outbound.HttpAddress;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;

public abstract class WSAddress
implements HttpAddress {
    protected int schemaType = 0;
    protected String keyforPool = null;
    protected CFEndPoint cfEndPt = null;
    protected Config cfg = null;
    protected static final String defaultOBChainName = "OutboundChain";
    private static boolean DONOT_CACHE_WSADDRESS = false;
    private static final TraceComponent _tc = Tr.register(WSAddress.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected int connTimeout = 180000;
    private static int MAX_WSADDRESS_ENTRIES = 0;
    public static Map<URL, HttpChannelAddress> wsAddrCache;

    public abstract String keyValueforPool();

    public abstract int getPort();

    public abstract String getOutboundChainName();

    public String defaultOutboundChainName() {
        return defaultOBChainName;
    }

    public void setTransportConfiguration(Config inCfg) {
        this.cfg = inCfg;
    }

    public Config transportConfiguration() {
        return this.cfg;
    }

    public String getHostname() {
        return null;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public int getSchema() {
        return this.schemaType;
    }

    public String getSchemaInString() {
        String retString = null;
        if (this.schemaType == 1) {
            retString = "http";
        }
        if (this.schemaType == 2) {
            retString = "https";
        }
        return retString;
    }

    public int getConnectTimeout() {
        return this.connTimeout;
    }

    public abstract void setConnectTimeout(int var1);

    public CFEndPoint getCFEndPoint() {
        return this.cfEndPt;
    }

    public void setCFEndPoint(CFEndPoint cfpt) {
        this.cfEndPt = cfpt;
    }

    public boolean isInProcess() {
        return this.cfEndPt == null ? false : this.cfEndPt.isLocal();
    }

    public static WSAddress getAddress(URL targetURL) throws URISyntaxException, AxisFault {
        HttpChannelAddress wsAddr = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "WSAddress.getAddress()...");
        }
        if (targetURL.getProtocol().compareToIgnoreCase("http") == 0 || targetURL.getProtocol().compareToIgnoreCase("https") == 0) {
            if (DONOT_CACHE_WSADDRESS) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Not caching WSADDRESS");
                }
                wsAddr = new HttpChannelAddress(targetURL);
            } else {
                wsAddr = null;
                wsAddr = wsAddrCache.get(targetURL);
                if (wsAddr == null) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "wsAddr : " + wsAddr + " not in cache. Putting in cache");
                    }
                    wsAddr = new HttpChannelAddress(targetURL);
                    wsAddrCache.put(targetURL, wsAddr);
                } else if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Found wsAddr : " + wsAddr + " in cache");
                }
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "WSAddress.getAddress() wsAddr : " + wsAddr);
            }
            return wsAddr;
        }
        Object[] inserts = new Object[]{targetURL.getProtocol()};
        String msg = NLSProvider.getNLS().getFormattedMessage("httpUnsupportedSchema", inserts, "The following schema for HTTP is not supported: {0}");
        throw new AxisFault(msg);
    }

    static {
        MAX_WSADDRESS_ENTRIES = Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "50"));
        DONOT_CACHE_WSADDRESS = Boolean.valueOf(System.getProperty("disableWSAddressCaching", "false"));
        wsAddrCache = Collections.synchronizedMap(new LinkedHashMap<URL, HttpChannelAddress>(MAX_WSADDRESS_ENTRIES + 1, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry<URL, HttpChannelAddress> eldest) {
                return this.size() > MAX_WSADDRESS_ENTRIES;
            }
        });
    }
}

