/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.transport.channel.OutboundConnectionGroup;
import com.ibm.ws.websvcs.transport.channel.WSAddress;
import com.ibm.ws.websvcs.transport.http.HTTPConnection;
import com.ibm.wsspi.channel.framework.exception.ChainException;
import com.ibm.wsspi.channel.framework.exception.ChannelException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.AxisFault;

public final class OutboundConnectionCache {
    private static final TraceNLS nls;
    private static final TraceComponent _tc;
    private static final TraceComponent _tc2;
    private static int REFRESHTIME;
    private static final int DELAYTIME = 1000;
    private static int CONN_TIMEOUT;
    private static int MAX_CONN;
    private ConcurrentHashMap chainlist = null;
    private static OutboundConnectionCache cache;
    private static Timer _timer;

    private OutboundConnectionCache() {
        _timer = new Timer(true);
        _timer.schedule((TimerTask)new CleanupTask(), 1000L, (long)REFRESHTIME);
        this.chainlist = new ConcurrentHashMap();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "com.ibm.websphere.webservices.http.connectionTimeout: " + CONN_TIMEOUT + " ms, " + "com.ibm.websphere.webservices.http.connectionPoolCleanUpTime" + ": " + REFRESHTIME + " ms, " + "com.ibm.websphere.webservices.http.maxConnection" + ": " + MAX_CONN);
        }
    }

    public static int maxConnection() {
        return MAX_CONN;
    }

    public static int connTimeout() {
        return CONN_TIMEOUT;
    }

    public static synchronized OutboundConnectionCache getInstance() {
        if (cache == null) {
            cache = new OutboundConnectionCache();
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnection findConnectionAndInvalidate(WSAddress addrtoConnect) throws AxisFault, InterruptedException, Exception {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        HTTPConnection wsOC = null;
        OutboundConnectionGroup oCGroup = null;
        String keyname = addrtoConnect.keyValueforPool();
        ConcurrentHashMap concurrentHashMap = this.chainlist;
        synchronized (concurrentHashMap) {
            oCGroup = (OutboundConnectionGroup)this.chainlist.get(keyname);
            if (oCGroup != null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "connTableKeyFound " + keyname + " true");
                }
                wsOC = oCGroup.invalidateConnection(addrtoConnect);
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "OutboundConnectionCache.findConnectionAndInvalidate()");
        }
        return wsOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public HTTPConnection findGroupAndGetConnection(WSAddress addrtoConnect) throws AxisFault, InterruptedException, Exception {
        Object[] inserts;
        int totalUsed;
        int totalSize;
        HTTPConnection wsOC;
        block27: {
            OutboundConnectionGroup oCGroup;
            block28: {
                block26: {
                    if (_tc.isEntryEnabled()) {
                        Tr.entry(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
                    }
                    wsOC = null;
                    oCGroup = null;
                    String keyname = addrtoConnect.keyValueforPool();
                    ConcurrentHashMap concurrentHashMap = this.chainlist;
                    // MONITORENTER : concurrentHashMap
                    totalSize = this.poolSize();
                    totalUsed = this.connectionsInUse();
                    if (_tc.isEventEnabled()) {
                        inserts = new Object[]{String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN)};
                        Tr.event(_tc, "connPoolStatus00", inserts);
                    }
                    if ((oCGroup = (OutboundConnectionGroup)this.chainlist.get(keyname)) == null) {
                        oCGroup = new OutboundConnectionGroup();
                        this.chainlist.put(keyname, oCGroup);
                        if (_tc.isEventEnabled()) {
                            Tr.event(_tc, "outConnGroupCreated " + keyname);
                        }
                    } else if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "connTableKeyFound " + keyname + " true");
                    }
                    if (MAX_CONN != 0) break block26;
                    wsOC = oCGroup.createConnection(addrtoConnect);
                    break block27;
                }
                int sizeForGroup = oCGroup.currPoolSize();
                int inUseForGroup = oCGroup.getTotalInUse();
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, oCGroup + " has size of " + sizeForGroup + " with " + inUseForGroup + " objects used.");
                }
                if (totalSize >= MAX_CONN) break block28;
                if (totalUsed == totalSize) {
                    wsOC = oCGroup.createConnection(addrtoConnect);
                    break block27;
                } else {
                    if (totalUsed >= totalSize) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                        throw new AxisFault(msg);
                    }
                    if (inUseForGroup > sizeForGroup) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                        throw new AxisFault(msg);
                    }
                    if (inUseForGroup < sizeForGroup || inUseForGroup == 0 && sizeForGroup == 0) {
                        wsOC = oCGroup.getConnection(addrtoConnect);
                    }
                    if (wsOC == null) {
                        wsOC = oCGroup.createConnection(addrtoConnect);
                    }
                }
                break block27;
            }
            if (totalSize != MAX_CONN) {
                String msg = NLSProvider.getNLS().getFormattedMessage("connectionPoolIntegrity00", new Object[0], "An integrity problem occurred with the connection pool.");
                throw new AxisFault(msg);
            }
            wsOC = oCGroup.getConnection(addrtoConnect);
            long actualWaitTime = 0L;
            long targetWaitTime = CONN_TIMEOUT;
            if (wsOC == null && this.purgeUnused()) {
                wsOC = oCGroup.createConnection(addrtoConnect);
            }
            while (wsOC == null) {
                Object[] inserts2;
                if (CONN_TIMEOUT == 0) {
                    if (_tc.isEventEnabled()) {
                        inserts2 = new Object[]{Thread.currentThread().toString()};
                        Tr.event(_tc, "connectionWait00", inserts2);
                    }
                    this.chainlist.wait();
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "connectionNotify01 " + Thread.currentThread().toString());
                    }
                    if ((wsOC = oCGroup.getConnection(addrtoConnect)) == null && this.purgeUnused()) {
                        wsOC = oCGroup.createConnection(addrtoConnect);
                    }
                    if (wsOC == null) continue;
                    break;
                }
                if (_tc.isEventEnabled()) {
                    inserts2 = new Object[]{Thread.currentThread().toString(), String.valueOf(targetWaitTime)};
                    Tr.event(_tc, "connectionWait01", inserts2);
                }
                long start = System.currentTimeMillis();
                this.chainlist.wait(targetWaitTime);
                actualWaitTime = System.currentTimeMillis() - start;
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "connectionNotify01 currentThread : " + Thread.currentThread().toString());
                }
                if ((wsOC = oCGroup.getConnection(addrtoConnect)) == null && this.purgeUnused()) {
                    wsOC = oCGroup.createConnection(addrtoConnect);
                }
                if (wsOC != null) break;
                if (targetWaitTime - actualWaitTime > 0L) continue;
                String msg = NLSProvider.getNLS().getFormattedMessage("connectionTimedOut", new Object[0], "The connection wait has timed out.");
                throw new AxisFault(msg);
            }
        }
        if (_tc.isEventEnabled()) {
            totalSize = this.poolSize();
            totalUsed = this.connectionsInUse();
            inserts = new Object[]{String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN)};
            Tr.event(_tc, "connPoolStatus00", inserts);
        }
        // MONITOREXIT : concurrentHashMap
        if (!_tc.isEntryEnabled()) return wsOC;
        Tr.exit(_tc, "OutboundConnectionCache.findGroupAndGetConnection()");
        return wsOC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findGroupAndReturnConnection(HTTPConnection wOC) throws ChainException, ChannelException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
        }
        String activeChainName = wOC.getTargetAddress().keyValueforPool();
        OutboundConnectionGroup ocgroup = null;
        ConcurrentHashMap concurrentHashMap = this.chainlist;
        synchronized (concurrentHashMap) {
            Object[] inserts;
            int totalUsed;
            int totalSize;
            if (_tc.isEventEnabled()) {
                totalSize = this.poolSize();
                totalUsed = this.connectionsInUse();
                inserts = new Object[]{String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN)};
                Tr.event(_tc, "connPoolStatus00", inserts);
            }
            if ((ocgroup = (OutboundConnectionGroup)this.chainlist.get(activeChainName)) == null) {
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "connTableKeyFound " + activeChainName + " false");
                }
                return;
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "connTableKeyFound " + activeChainName + " true");
            }
            ocgroup.returnConnection(wOC);
            if (_tc.isEventEnabled()) {
                totalSize = this.poolSize();
                totalUsed = this.connectionsInUse();
                inserts = new Object[]{String.valueOf(totalSize), String.valueOf(totalUsed), String.valueOf(MAX_CONN)};
                Tr.event(_tc, "connPoolStatus00", inserts);
            }
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "connectionNotify00");
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "OutboundConnectionCache.findGroupAndReturnConnection()");
            }
            this.chainlist.notify();
        }
    }

    private boolean purgeUnused() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "purgeUnused()");
        }
        boolean foundUnused = false;
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        boolean purgedOne = false;
        while (it.hasNext() && !(foundUnused = (oCG = (OutboundConnectionGroup)this.chainlist.get(it.next())).findUnused())) {
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "purgeUnused()");
        }
        return foundUnused;
    }

    protected int poolSize() {
        int result = 0;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "poolSize()");
        }
        Iterator it = this.chainlist.keySet().iterator();
        OutboundConnectionGroup oCG = null;
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            result += oCG.currPoolSize();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "poolSize()");
        }
        return result;
    }

    protected int connectionsInUse() {
        int result = 0;
        OutboundConnectionGroup oCG = null;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "connectionsInUse()");
        }
        Iterator it = this.chainlist.keySet().iterator();
        while (it.hasNext()) {
            oCG = (OutboundConnectionGroup)this.chainlist.get(it.next());
            result += oCG.getTotalInUse().intValue();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "connectionsInUse()");
        }
        return result;
    }

    static {
        Exception cause;
        nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.resources.websvcsMessages");
        _tc = Tr.register(OutboundConnectionCache.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
        _tc2 = Tr.register(CleanupTask.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
        REFRESHTIME = 0;
        CONN_TIMEOUT = 0;
        MAX_CONN = 0;
        cache = null;
        _timer = null;
        try {
            CONN_TIMEOUT = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionTimeout", "300")) * 1000;
                }
            });
        }
        catch (PrivilegedActionException e) {
            cause = e;
            if (e.getException() != null) {
                cause = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause.toString() + " defaulting HTTP connection timeout");
            }
            CONN_TIMEOUT = 300000;
        }
        try {
            REFRESHTIME = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.connectionPoolCleanUpTime", "180")) * 1000;
                }
            });
        }
        catch (PrivilegedActionException e) {
            cause = e;
            if (e.getException() != null) {
                cause = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause.toString() + " defaulting HTTP connection " + "pool cleanup time");
            }
            REFRESHTIME = 180000;
        }
        try {
            MAX_CONN = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return (int)Integer.valueOf(System.getProperty("com.ibm.websphere.webservices.http.maxConnection", "50"));
                }
            });
        }
        catch (PrivilegedActionException e) {
            cause = e;
            if (e.getException() != null) {
                cause = e.getException();
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Caught exception: " + cause.toString() + " defaulting HTTP connection " + "pool maximum connections");
            }
            MAX_CONN = 50;
        }
    }

    private class CleanupTask
    extends TimerTask {
        private CleanupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                OutboundConnectionGroup ocgroup = null;
                try {
                    if (_tc2.isEntryEnabled()) {
                        Tr.entry(_tc2, "CleanupTask.run()");
                    }
                    ConcurrentHashMap concurrentHashMap = OutboundConnectionCache.this.chainlist;
                    synchronized (concurrentHashMap) {
                        if (OutboundConnectionCache.this.chainlist.size() > 0) {
                            Iterator it = OutboundConnectionCache.this.chainlist.keySet().iterator();
                            Object key = null;
                            while (it.hasNext()) {
                                key = it.next();
                                ocgroup = (OutboundConnectionGroup)OutboundConnectionCache.this.chainlist.get(key);
                                ocgroup.cleanup();
                                if (!ocgroup.isEmpty()) continue;
                                if (_tc2.isDebugEnabled()) {
                                    Tr.debug(_tc2, "OutboundConnectionGroup.isEmpty(): true");
                                }
                                ocgroup.release();
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    FFDCFilter.processException((Throwable)ex, "com.ibm.ws.websvcs.transport.channel.OutboundConnectionCache.run", "159", this);
                    if (!_tc2.isEventEnabled()) break block9;
                    Tr.event(_tc2, "exception01 " + JavaUtils.stackToString(ex));
                }
            }
        }
    }
}

