/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.TransportClientProperties;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import java.util.Iterator;
import java.util.Properties;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.http.HttpTransportProperties;

public class DefaultHTTPTransportClientProperties
implements TransportClientProperties {
    protected static final String ANONYMOUS = "anonymous";
    protected static final String PROXY_HOST_NAME = "proxy_host";
    protected static final String PROXY_PORT = "proxy_port";
    private MessageContext localmsgContext;
    protected TransportOutDescription proxySetting = null;
    protected TransportOutDescription proxyOutSetting = null;
    private static final TraceComponent _tc = Tr.register(DefaultHTTPTransportClientProperties.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    protected static final String emptyString = "";
    protected String proxyHost = null;
    protected String nonProxyHosts = null;
    protected String proxyHostName = null;
    protected String proxyPort = null;
    protected String proxyUser = null;
    protected String proxyPassword = null;
    protected String reqContentEncoding = null;
    protected boolean commonValsInitialized = false;
    protected boolean initialized = false;

    public void setProxyHost(String in) {
        this.proxyHost = in == null ? emptyString : in;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyHost: " + this.proxyHost);
        }
    }

    public void setProxyPort(String in) {
        this.proxyPort = in == null ? emptyString : in;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPort: " + this.proxyPort);
        }
    }

    public void setProxyUser(String in) {
        this.proxyUser = in == null ? emptyString : in;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyUser: " + this.proxyUser);
        }
    }

    public void setProxyPassword(String in) {
        if (in == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ");
            }
            this.proxyPassword = emptyString;
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ****");
            }
            this.proxyPassword = in;
        }
    }

    public void setNonProxyHosts(String in) {
        this.nonProxyHosts = in == null ? emptyString : in;
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setNonProxyHosts: " + this.nonProxyHosts);
        }
    }

    public String getProxyHost() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getProxyHost: " + this.proxyHost);
        }
        return this.proxyHost;
    }

    public String getNonProxyHosts() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getNonProxyProxyHosts: " + this.nonProxyHosts);
        }
        return this.nonProxyHosts;
    }

    public String getProxyPort() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getProxyPort: " + this.proxyPort);
        }
        return this.proxyPort;
    }

    public String getProxyUser() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::getProxyUser: " + this.proxyUser);
        }
        return this.proxyUser;
    }

    public String getProxyPassword() {
        if (JavaUtils.hasValue(this.proxyPassword)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ****");
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::setProxyPassword: ");
        }
        return this.proxyPassword;
    }

    public String encodeRequestMessage() {
        this.reqContentEncoding = (String)this.localmsgContext.getProperty("com.ibm.websphere.webservices.http.requestContentEncoding");
        if (this.reqContentEncoding == null) {
            this.reqContentEncoding = emptyString;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::encodeRequestMessage: " + this.reqContentEncoding);
        }
        return this.reqContentEncoding;
    }

    public String ucfCallbackTimeout() {
        String result = (String)this.localmsgContext.getProperty("com.ibm.websphere.webservices.UCFSelectionTimeout");
        if (!JavaUtils.hasValue(result)) {
            result = emptyString;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPTransportClientProperties::ucfCallbackTimeout: " + result);
        }
        return result;
    }

    public boolean isProxyListed(MessageContext msgCtx) throws AxisFault {
        HttpTransportProperties.ProxyProperties proxyProperties;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "DefaultHTTPTransportClientProperties::isProxyListed");
        }
        boolean returnValue = false;
        Parameter par = null;
        this.proxyOutSetting = msgCtx.getConfigurationContext().getAxisConfiguration().getTransportOut("http");
        if (this.proxyOutSetting != null) {
            par = this.proxyOutSetting.getParameter("PROXY");
        }
        OMElement hostElement = null;
        if (par != null) {
            hostElement = par.getParameterElement();
        }
        if (hostElement != null) {
            Iterator ite = hostElement.getAllAttributes();
            while (ite.hasNext()) {
                OMAttribute attribute = (OMAttribute)ite.next();
                if (!attribute.getLocalName().equalsIgnoreCase(PROXY_HOST_NAME)) continue;
                returnValue = true;
            }
        }
        if ((proxyProperties = (HttpTransportProperties.ProxyProperties)msgCtx.getProperty("PROXY")) != null && proxyProperties.getProxyHostName() != null) {
            returnValue = true;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "DefaultHTTPTransportClientProperties::isProxyListed: " + returnValue);
        }
        return returnValue;
    }

    public void setSSLConfigurationName(String sslConfigName) {
    }

    public void setSSLClientPropsName(String sslPropsFileName) {
    }

    public String getSSLConfigurationName() {
        return emptyString;
    }

    public String getSSLCertificateAliasName() {
        return emptyString;
    }

    public DefaultHTTPTransportClientProperties(MessageContext msgContext) throws AxisFault {
        Properties props;
        this.localmsgContext = msgContext;
        this.proxySetting = this.localmsgContext.getConfigurationContext().getAxisConfiguration().getTransportOut("http");
        Parameter proxyParam = this.proxySetting.getParameter("http.proxyHost");
        if (proxyParam != null) {
            this.proxyHost = (String)proxyParam.getValue();
        }
        if ((proxyParam = this.proxySetting.getParameter("http.proxyPort")) != null) {
            this.proxyPort = (String)proxyParam.getValue();
        }
        if ((proxyParam = this.proxySetting.getParameter("http.proxyUser")) != null) {
            this.proxyUser = (String)proxyParam.getValue();
        }
        if ((proxyParam = this.proxySetting.getParameter("http.proxyPassword")) != null) {
            this.proxyPassword = (String)proxyParam.getValue();
        }
        if ((props = PolicySetUtils.getHTTPBindings(msgContext.getAxisService())) != null) {
            this.nonProxyHosts = PolicySetUtils.getCustomBindingValue(props, "http.nonProxyHosts");
        }
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = System.getProperty("http.nonProxyHosts");
        }
    }

    protected String getCommonValues() {
        StringBuffer sb = new StringBuffer();
        if (!this.commonValsInitialized) {
            if (!JavaUtils.hasValue(this.reqContentEncoding)) {
                this.encodeRequestMessage();
            }
            this.commonValsInitialized = true;
        }
        sb.append("requestContentEncoding=" + this.reqContentEncoding + "\n");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nWebservices Transport Connection HTTP:\n");
        sb.append("proxyHost=" + this.getProxyHost() + "\n");
        sb.append("proxyPort=" + this.getProxyPort() + "\n");
        sb.append("proxyUser=" + this.getProxyUser() + "\n");
        if (JavaUtils.hasValue(this.proxyPassword)) {
            sb.append("proxyPassword=*****\n");
        } else {
            sb.append("proxyPassword=" + this.getProxyPassword() + "\n");
        }
        sb.append("nonProxyHosts=" + this.getNonProxyHosts() + "\n");
        sb.append(this.getCommonValues());
        return sb.toString();
    }
}

