/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.utils.JavaUtils;
import com.ibm.ws.websvcs.transport.SecureTransportClientProperties;
import com.ibm.ws.websvcs.transport.channel.DefaultHTTPTransportClientProperties;
import com.ibm.ws.websvcs.transport.policyset.PolicySetUtils;
import java.util.Properties;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;

public class DefaultHTTPSTransportClientProperties
extends DefaultHTTPTransportClientProperties
implements SecureTransportClientProperties {
    private static final TraceComponent _tc = Tr.register(DefaultHTTPSTransportClientProperties.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private String sslCfgName = null;
    private String sslPropsName = null;

    public void setProxyHost(String in) {
        super.setProxyHost(in);
    }

    public void setProxyPort(String in) {
        super.setProxyPort(in);
    }

    public void setProxyUser(String in) {
        super.setProxyUser(in);
    }

    public void setProxyPassword(String in) {
        super.setProxyPassword(in);
    }

    public void setNonProxyHosts(String in) {
        super.setNonProxyHosts(in);
    }

    public String getProxyHost() {
        return super.getProxyHost();
    }

    public String getNonProxyHosts() {
        return super.getNonProxyHosts();
    }

    public String getProxyPort() {
        return super.getProxyPort();
    }

    public String getProxyUser() {
        return super.getProxyUser();
    }

    public String getProxyPassword() {
        return super.getProxyPassword();
    }

    public void setSSLConfigurationName(String sslConfigName) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::setSSLConfigurationName: " + sslConfigName);
        }
        this.sslCfgName = sslConfigName;
    }

    public void setSSLClientPropsName(String sslPropsFileName) {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::setSSLClientPropsName: " + sslPropsFileName);
        }
        this.sslPropsName = sslPropsFileName;
    }

    public String getSSLConfigurationName() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::getSSLConfigurationName: " + this.sslCfgName);
        }
        return this.sslCfgName == null ? "" : this.sslCfgName;
    }

    public String getSSLClientPropsName() {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "DefaultHTTPSTransportClientProperties::getSSLClientPropsName: " + this.sslPropsName);
        }
        return this.sslPropsName == null ? "" : this.sslPropsName;
    }

    public DefaultHTTPSTransportClientProperties(MessageContext msgContext) throws AxisFault {
        super(msgContext);
        Properties props;
        String tmpValue = null;
        Parameter proxyParam = this.proxySetting.getParameter("https.proxyHost");
        if (proxyParam != null && JavaUtils.hasValue(tmpValue = (String)proxyParam.getValue())) {
            this.proxyHost = tmpValue;
        }
        if ((proxyParam = this.proxySetting.getParameter("https.proxyPort")) != null) {
            tmpValue = null;
            tmpValue = (String)proxyParam.getValue();
            if (JavaUtils.hasValue(tmpValue)) {
                this.proxyPort = tmpValue;
            }
        }
        if ((proxyParam = this.proxySetting.getParameter("https.proxyUser")) != null) {
            tmpValue = null;
            tmpValue = (String)proxyParam.getValue();
            if (JavaUtils.hasValue(tmpValue)) {
                this.proxyUser = tmpValue;
            }
        }
        if ((proxyParam = this.proxySetting.getParameter("https.proxyPassword")) != null) {
            tmpValue = null;
            tmpValue = (String)proxyParam.getValue();
            if (JavaUtils.hasValue(tmpValue)) {
                this.proxyPassword = tmpValue;
            }
        }
        if ((props = PolicySetUtils.getHTTPBindings(msgContext.getAxisService())) != null) {
            this.nonProxyHosts = PolicySetUtils.getCustomBindingValue(props, "https.nonProxyHosts");
        }
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = System.getProperty("https.nonProxyHosts");
        }
        if (this.nonProxyHosts == null) {
            this.nonProxyHosts = super.getNonProxyHosts();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nWebservices Transport Connection HTTPS:\n");
        sb.append("SSLConfigurationName=" + this.getSSLConfigurationName() + "\n");
        sb.append("proxyHost=" + this.getProxyHost() + "\n");
        sb.append("proxyPort=" + this.getProxyPort() + "\n");
        sb.append("proxyUser=" + this.getProxyUser() + "\n");
        if (JavaUtils.hasValue(this.proxyPassword)) {
            sb.append("proxyPassword=*****\n");
        } else {
            sb.append("proxyPassword=" + this.getProxyPassword() + "\n");
        }
        sb.append("nonProxyHosts=" + this.getNonProxyHosts() + "\n");
        sb.append(this.getCommonValues());
        return sb.toString();
    }
}

