/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.utils.PluginUtils;
import com.ibm.wsspi.websvcs.TransportShutdownPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TransportShutdownPluginMgr {
    private static final TraceComponent _tc = Tr.register(TransportShutdownPluginMgr.class, "WebServices.Shared", "com.ibm.ws.webservices.resources.WSMessages");
    private static final String WSFP_THINCLIENT_BUNDLE = "com.ibm.wsfp.thinclient";
    private static final String EXTENSION_NAME = "ibmaxis2-transport-shutdown-plugin";
    private static final String MAIN_EXTENSION = "com.ibm.wsfp.main.ibmaxis2-transport-shutdown-plugin";
    private static final String THINCLIENT_EXTENSION = "com.ibm.wsfp.thinclient.ibmaxis2-transport-shutdown-plugin";
    private List<TransportShutdownPlugin> plugins;
    private static TransportShutdownPluginMgr instance = null;

    private TransportShutdownPluginMgr() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "TransportShutdownPluginMgr ctor");
        }
        this.plugins = new ArrayList<TransportShutdownPlugin>();
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "TransportShutdownPluginMgr ctor");
        }
    }

    public static synchronized TransportShutdownPluginMgr getInstance() {
        if (instance == null) {
            instance = new TransportShutdownPluginMgr();
            instance.discoverPlugins();
        }
        return instance;
    }

    public void discoverPlugins() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "discoverPlugins");
        }
        PluginUtils.discoverExtensions(TransportShutdownPlugin.class.getName(), MAIN_EXTENSION, this.plugins);
        if (this.plugins.isEmpty()) {
            PluginUtils.discoverExtensions(TransportShutdownPlugin.class.getName(), THINCLIENT_EXTENSION, this.plugins);
        }
        this.sortPlugins();
        if (_tc.isDebugEnabled()) {
            this.printPluginList();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "discoverPlugins");
        }
    }

    public void sortPlugins() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "sortPlugins");
        }
        if (!this.plugins.isEmpty()) {
            TSPComparator comparator = new TSPComparator();
            Collections.sort(this.plugins, comparator);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "sortPlugins");
        }
    }

    public void printPluginList() {
        if (this.plugins.isEmpty()) {
            Tr.debug(_tc, "TransportShutdownPlugin list is empty.");
        } else {
            Tr.debug(_tc, "TransportShutdownPlugin list:");
            for (TransportShutdownPlugin tsp : this.plugins) {
                Tr.debug(_tc, tsp.toString());
            }
            Tr.debug(_tc, "End of list...");
        }
    }

    public void drivePreShutdown() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "drivePreShutdown");
        }
        for (TransportShutdownPlugin tsp : this.plugins) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Calling preShutdown() for TransportShutdownPlugin: " + tsp.getName());
            }
            try {
                tsp.preShutdown();
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName(), "152");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "drivePreShutdown");
        }
    }

    public void drivePostShutdown() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "drivePostShutdown");
        }
        for (TransportShutdownPlugin tsp : this.plugins) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Calling postShutdown() for TransportShutdownPlugin: " + tsp.getName());
            }
            try {
                tsp.postShutdown();
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, this.getClass().getName(), "176");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "drivePostShutdown");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TSPComparator
    implements Comparator<TransportShutdownPlugin> {
        TSPComparator() {
        }

        @Override
        public int compare(TransportShutdownPlugin plugin1, TransportShutdownPlugin plugin2) {
            if (plugin1.getWeight() < plugin2.getWeight()) {
                return -1;
            }
            if (plugin1.getWeight() > plugin2.getWeight()) {
                return 1;
            }
            return 0;
        }
    }
}

