/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.transport;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.transport.AsyncResponseContext;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.ConfigurationContext;

public final class AsyncResponseContextMap
implements Constants {
    private static final TraceComponent _tc = Tr.register(AsyncResponseContextMap.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static ConcurrentHashMap<String, AsyncResponseContext> hmap = null;
    private static AsyncResponseContextMap asyncRCMap = null;

    private AsyncResponseContextMap() {
        hmap = new ConcurrentHashMap(131, 0.75f);
    }

    public static final synchronized AsyncResponseContextMap getInstance() {
        if (asyncRCMap == null) {
            asyncRCMap = new AsyncResponseContextMap();
        }
        return asyncRCMap;
    }

    public synchronized void putContext(String hashKey, AsyncResponseContext asyRespC) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseContextMap.putContext()...");
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Related objects: " + asyRespC.getConfCtxt() + ", " + asyRespC.getAxisService() + ", " + asyRespC.getAxisOperation() + ", " + asyRespC.getMessageID() + ", " + asyRespC.gethashKey());
        }
        if (!hmap.containsKey(hashKey)) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Puting " + asyRespC + " in map with key: " + hashKey);
            }
            hmap.put(hashKey, asyRespC);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseContextMap.putContext()");
        }
    }

    public AsyncResponseContext getContext(String hashKey) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseContextMap.getContext()...");
        }
        AsyncResponseContext asyRespC = hmap.get(hashKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Got " + asyRespC + " in map with key: " + hashKey);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseContextMap.getContext()");
        }
        return asyRespC;
    }

    public synchronized void removeContext(String hashKey) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseContextMap.removeContext()...");
        }
        if (hmap.containsKey(hashKey)) {
            AsyncResponseContext asyRespC = hmap.get(hashKey);
            asyRespC = hmap.remove(hashKey);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Removed " + asyRespC + " in map with key: " + hashKey);
                Tr.debug(_tc, "Current map size: " + hmap.size());
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseContextMap.removeContext()");
        }
    }

    public synchronized boolean containsKey(String hashKey) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseContextMap.containsKey()...");
        }
        boolean doesContain = hmap.containsKey(hashKey);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Contains key: " + hashKey + "? " + doesContain);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseContextMap.containsKey()");
        }
        return doesContain;
    }

    public synchronized void removeConfigCtxt(ConfigurationContext cc) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "AsyncResponseContextMap.removeConfigCtxt()...");
        }
        if (hmap == null || cc == null) {
            return;
        }
        for (String key : hmap.keySet()) {
            AsyncResponseContext arc = hmap.get(key);
            if (cc != arc.getConfCtxt()) continue;
            hmap.remove(key);
            if (!_tc.isDebugEnabled()) continue;
            Tr.debug(_tc, "Match found, removing key: " + key);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "...AsyncResponseContextMap.removeConfigCtxt()");
        }
    }
}

