/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.trace.LogOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LogFilterInputStream
extends FilterInputStream {
    private static final TraceComponent tc = Tr.register(LogFilterInputStream.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    LogOutputStream logOutput = null;

    public LogFilterInputStream(InputStream in, TraceComponent tc1, int limit, String message, String contentType) {
        super(in);
        this.logOutput = new LogOutputStream(tc, limit, message, contentType);
    }

    public int read() throws IOException {
        int value = this.in.read();
        if (value != -1) {
            this.logOutput.write(new byte[]{(byte)value}, 0, 1);
            this.logOutput.flush();
        }
        return value;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int totalRead = this.in.read(b, off, len);
        if (totalRead > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total Bytes Read = " + totalRead);
            }
            try {
                this.logOutput.write(b, off, totalRead);
                this.logOutput.flush();
            }
            catch (Exception e) {
                Tr.debug(tc, e.getMessage());
                Tr.debug(tc, "dataLength = " + b.length + " offset = " + off + " len = " + totalRead);
            }
        }
        return totalRead;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public void close() throws IOException {
        this.in.close();
        this.logOutput.close();
    }
}

