/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;

public class ConfigTrace {
    private static TraceComponent tc = Tr.register(ConfigTrace.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");

    public static void log(ConfigurationContext configurationContext) {
        if (configurationContext != null) {
            StringBuffer buffer = new StringBuffer();
            boolean gotSomeEndpoints = false;
            boolean didClassPathOnce = false;
            AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
            if (axisConfiguration == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Axis Configuration does not exist. Exiting.");
                }
                return;
            }
            String appName = null;
            if (Axis2Utils.getApplicationName(axisConfiguration) != null) {
                appName = Axis2Utils.getApplicationName(axisConfiguration);
            }
            String moduleName = null;
            if (Axis2Utils.getModuleName(axisConfiguration) != null) {
                moduleName = Axis2Utils.getModuleName(axisConfiguration);
            }
            buffer.append("\nThe Webservices configuration for module ").append(moduleName).append(", application ").append(appName);
            HashMap allServices = axisConfiguration.getServices();
            Iterator iter = allServices.keySet().iterator();
            while (iter.hasNext()) {
                gotSomeEndpoints = true;
                String name = (String)iter.next();
                AxisService service = (AxisService)allServices.get(name);
                if (!didClassPathOnce) {
                    didClassPathOnce = true;
                    ClassLoader cl = service.getClassLoader();
                    buffer.append("\n\nClassLoader: ");
                    buffer.append(cl.toString());
                    buffer.append("\n\nEndpoints: ");
                }
                QName servQN = Axis2Utils.getServiceQName(service);
                QName portQN = new QName(servQN.getNamespaceURI(), Axis2Utils.getPortName(service));
                buffer.append("\n\tEndpoint: portName = \t").append(portQN.toString()).append("\n\t\t  serviceName = ").append(servQN.toString()).append("\n\tPort-component:    ").append(Axis2Utils.getPortComponentName(service)).append("\n\tService Impl Bean: ").append(Axis2Utils.getServiceImplClass(service)).append("\n\tContext Root:      ").append(Axis2Utils.getContextRoot(configurationContext)).append("\n\tURL pattern:       ").append(Axis2Utils.getURLPattern(service));
                if (Axis2Utils.getWSDLLocation(service) != null) {
                    buffer.append("\n\tWSDL location:     ").append(Axis2Utils.getWSDLLocation(service));
                }
                buffer.append("\n\tOperations: ");
                Iterator iterO = service.getOperations();
                while (iterO.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)iterO.next();
                    buffer.append("\n\t\tOperation: ").append(axisOperation.getName().toString());
                }
                buffer.append("\n");
            }
            if (gotSomeEndpoints) {
                Tr.info(tc, buffer.toString());
            }
        }
    }
}

