/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.trace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.trace.LogOutputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;

public class CommonUtils {
    private static final TraceComponent _tc = Tr.register(CommonUtils.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    private CommonUtils() {
    }

    public static long logDebug(OMElement om, TraceComponent tc) {
        return CommonUtils.logDebug(om, _tc, Integer.MAX_VALUE);
    }

    public static long logDebug(OMElement om, TraceComponent tc, int limit) {
        OMOutputFormat format = new OMOutputFormat();
        format.setDoOptimize(true);
        format.setAutoCloseWriter(true);
        format.setIgnoreXMLDeclaration(true);
        return CommonUtils.logDebug(om, _tc, limit, format);
    }

    public static long logDebug(OMElement om, TraceComponent tc, int limit, OMOutputFormat format) {
        LogOutputStream logStream = new LogOutputStream(_tc, limit, null, format.getContentType());
        try {
            om.serialize(logStream, format);
            logStream.flush();
            logStream.close();
        }
        catch (Throwable t) {
            Tr.debug(_tc, "SOAP Message could not be logged due to the following error: " + t.toString());
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.utils.CommonUtils.logDebug", "85");
        }
        return logStream.getLength();
    }

    public static long logDebug(OMElement om, TraceComponent tc, int limit, OMOutputFormat format, String msg) {
        LogOutputStream logStream = new LogOutputStream(_tc, limit, msg, format.getContentType());
        try {
            om.serialize(logStream, format);
            logStream.flush();
            logStream.close();
        }
        catch (Throwable t) {
            Tr.debug(_tc, "SOAP Message could not be logged due to the following error: " + t.toString());
            FFDCFilter.processException(t, "com.ibm.ws.websvcs.utils.CommonUtils.logDebug", "85");
        }
        return logStream.getLength();
    }
}

