/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.server;

import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.ws.runtime.service.EJBContainer;
import com.ibm.ws.webservices.utils.ClassUtils;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.ejbcontainer.WSEJBEndpointManager;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.ws.Provider;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;
import org.apache.axis2.jaxws.server.EndpointInvocationContext;
import org.apache.axis2.jaxws.server.InvocationListener;
import org.apache.axis2.jaxws.server.InvocationListenerBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSInvocationListener
implements InvocationListener {
    private static final TraceComponent tc = Tr.register(WSInvocationListener.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private static EJBContainer ejbContainer = null;
    private static boolean retrieved = false;

    @Override
    public void notify(InvocationListenerBean bean) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notify, state= " + (Object)((Object)bean.getState()));
        }
        if (bean.getState().equals((Object)InvocationListenerBean.State.REQUEST)) {
            this.requestReceived(bean.getEndpointInvocationContext());
        } else {
            this.responseReady(bean.getEndpointInvocationContext());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notify, state= " + (Object)((Object)bean.getState()));
        }
    }

    @Override
    public void notifyOnException(InvocationListenerBean bean) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyOnException");
        }
        WSEJBEndpointManager manager = (WSEJBEndpointManager)bean.getEndpointInvocationContext().getRequestMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_WSEJBENDPOINTMANAGER");
        Boolean preInvokeComplete = (Boolean)bean.getEndpointInvocationContext().getRequestMessageContext().getProperty("com.ibm.ws.websvcs.EJB_PREINVOKE_COMPLETE");
        if (manager == null) {
            Throwable t;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSEJBEndpointManager instance not found on MessageContext. Error occurred before preInvoke successfully completed");
            }
            if ((t = bean.getThrowable()) instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)t;
                if (ite.getCause() != null) {
                    t = ite.getCause();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unwrapped InvocationTargetException: " + t);
                }
            }
            this.setMappedException(bean, t);
            return;
        }
        org.apache.axis2.jaxws.core.MessageContext currentContext = null;
        Boolean postInvokeComplete = null;
        if (bean.getEndpointInvocationContext().getResponseMessageContext() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current context is response context");
            }
            currentContext = bean.getEndpointInvocationContext().getResponseMessageContext();
            postInvokeComplete = (Boolean)currentContext.getProperty("com.ibm.ws.websvcs.EJB_POSTINVOKE_COMPLETE");
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Current context is request context");
            }
            currentContext = bean.getEndpointInvocationContext().getRequestMessageContext();
        }
        if (currentContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not determine whether to use request or response MessageContext...");
            }
            return;
        }
        Boolean exceptionSet = (Boolean)currentContext.getProperty("com.ibm.ws.websvcs.EJB_EXCEPTION_SET");
        if (preInvokeComplete != null && preInvokeComplete.booleanValue()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "preInvoke is complete on EJB invocation");
            }
            if (postInvokeComplete == null || !postInvokeComplete.booleanValue()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "postInvoke is not complete on EJB invocation");
                }
                if (exceptionSet == null || !exceptionSet.booleanValue()) {
                    Throwable t;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwable is not set on EJB invocation");
                    }
                    if ((t = bean.getThrowable()) instanceof InvocationTargetException) {
                        InvocationTargetException ite = (InvocationTargetException)t;
                        if (ite.getCause() != null) {
                            t = ite.getCause();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Unwrapped InvocationTargetException, passing this exception to EJB Container: " + t);
                        }
                    }
                    Throwable ejbException = manager.setException(t);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception set on EJB Container, exception returned is: " + ejbException);
                    }
                    currentContext.setProperty("com.ibm.ws.websvcs.EJB_EXCEPTION_SET", true);
                    this.setMappedException(bean, ejbException);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception already set with EJB Container");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "postInvoke already called on EJB Container... not setting exception");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "preInvoke not yet called on EJB Container... not setting exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyOnException");
        }
    }

    void requestReceived(EndpointInvocationContext eic) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestReceived");
        }
        WSInvocationListener.getEJBContainer(this);
        if (ejbContainer != null) {
            MessageContext axis2Context = eic.getRequestMessageContext().getAxisMessageContext();
            AxisService service = axis2Context.getAxisService();
            J2EEName j2EEName = (J2EEName)Axis2Utils.getParameterValue(service, "EJB_J2EE_NAME");
            Class implClass = ClassUtils.forName(Axis2Utils.getServiceImplClass(service), false, service.getClassLoader());
            EJSContainer ejsContainer = EJSContainer.getDefaultContainer();
            if (Provider.class.isAssignableFrom(implClass)) {
                Method method;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating WebServiceEndpoint for Provider endpoint in EJB");
                }
                if ((method = this.getProviderMethod(implClass)) == null) {
                    String msg = NLSProvider.getNLS().getFormattedMessage("ejbInvokeFail01", new Object[]{implClass.getName()}, "The {0} web service implementation in an Enterprise Java Beans module could not be invoked because a target method could not be found.");
                    throw new Exception(msg);
                }
                WSEJBEndpointManager endpointManager = ejbContainer.createWebServiceEndpointManager(j2EEName, implClass);
                Object instance = null;
                try {
                    try {
                        instance = endpointManager.ejbPreInvoke(method, (Map)((Object)eic.getRequestMessageContext().getMEPContext()));
                    }
                    catch (RemoteException e) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Exception occurred when attempting ejbPreInvoke: " + e);
                        }
                        throw e;
                    }
                    Object var12_14 = null;
                    eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.EJB_PREINVOKE_COMPLETE", true);
                }
                catch (Throwable throwable) {
                    Object var12_15 = null;
                    eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.EJB_PREINVOKE_COMPLETE", true);
                    eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSEJBENDPOINTMANAGER", endpointManager);
                    throw throwable;
                }
                eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSEJBENDPOINTMANAGER", endpointManager);
                eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE", instance);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Called preInvoke on EJB Container for EJB: " + j2EEName);
                }
            } else {
                Parameter param = service.getParameter("org.apache.axis2.jaxws.description.EndpointDescription");
                if (param != null) {
                    EndpointDescription endpointDesc = (EndpointDescription)param.getValue();
                    Method[] methods = this.getMethods(endpointDesc, implClass);
                    if (methods == null) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("ejbInvokeFail01", new Object[]{implClass.getName()}, "The {0} web service implementation in an Enterprise Java Beans module could not be invoked because a target method could not be found.");
                        throw new Exception(msg);
                    }
                    WSEJBEndpointManager endpointManager = ejbContainer.createWebServiceEndpointManager(j2EEName, methods);
                    Method method = this.getTargetMethod(axis2Context.getAxisOperation(), implClass);
                    if (method == null) {
                        String msg = NLSProvider.getNLS().getFormattedMessage("ejbInvokeFail01", new Object[]{implClass.getName()}, "The {0} web service implementation in an Enterprise Java Beans module could not be invoked because a target method could not be found.");
                        throw new Exception(msg);
                    }
                    Object instance = null;
                    try {
                        try {
                            instance = endpointManager.ejbPreInvoke(method, (Map)((Object)eic.getRequestMessageContext().getMEPContext()));
                        }
                        catch (RemoteException e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Exception occurred when attempting ejbPreInvoke: " + e);
                            }
                            throw e;
                        }
                        Object var15_23 = null;
                        eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.EJB_PREINVOKE_COMPLETE", true);
                    }
                    catch (Throwable throwable) {
                        Object var15_24 = null;
                        eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.EJB_PREINVOKE_COMPLETE", true);
                        eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSEJBENDPOINTMANAGER", endpointManager);
                        throw throwable;
                    }
                    eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSEJBENDPOINTMANAGER", endpointManager);
                    eic.getRequestMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE", instance);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Called preInvoke on EJB Container for EJB: " + j2EEName);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Did not find EndpointDescription on AxisService object");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestReceived");
        }
    }

    void responseReady(EndpointInvocationContext eic) throws Exception {
        org.apache.axis2.jaxws.core.MessageContext context;
        WSEJBEndpointManager endpointManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "responseReady");
        }
        if ((endpointManager = (WSEJBEndpointManager)eic.getRequestMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_WSEJBENDPOINTMANAGER")) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nothing to do in responseReady because an endpoint manager was not found on the message context");
            }
            return;
        }
        org.apache.axis2.jaxws.core.MessageContext messageContext = context = eic.getResponseMessageContext() != null ? eic.getResponseMessageContext() : eic.getRequestMessageContext();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Calling postInvoke on EJBContainer");
        }
        try {
            try {
                endpointManager.ejbPostInvoke();
            }
            catch (RemoteException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occurred when attempting ejbPostInvoke: " + e);
                }
                throw e;
            }
            Object var6_4 = null;
            context.setProperty("com.ibm.ws.websvcs.EJB_POSTINVOKE_COMPLETE", true);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            context.setProperty("com.ibm.ws.websvcs.EJB_POSTINVOKE_COMPLETE", true);
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "responseReady");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void getEJBContainer(WSInvocationListener listener) {
        if (!retrieved) {
            try {
                try {
                    ejbContainer = WsServiceRegistry.getService(listener, EJBContainer.class);
                }
                catch (Exception e) {
                    if (tc.isDebugEnabled()) {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        e.printStackTrace(pw);
                        Tr.debug(tc, "The following error occurred when attempting to retrieve the EJB Container service: \n" + sw.toString());
                    }
                    Object var5_2 = null;
                    retrieved = true;
                }
                Object var5_1 = null;
                retrieved = true;
            }
            catch (Throwable throwable) {
                Object var5_3 = null;
                retrieved = true;
                throw throwable;
            }
        }
    }

    protected Method[] getMethods(EndpointDescription endpointDesc, Class<?> serviceClass) throws Exception {
        OperationDescription[] opDescs;
        EndpointInterfaceDescription eid = endpointDesc.getEndpointInterfaceDescription();
        if (eid != null && (opDescs = eid.getDispatchableOperations()) != null && opDescs.length > 0) {
            LinkedList<Method> methodsToAdd = new LinkedList<Method>();
            for (OperationDescription opDesc : opDescs) {
                Method methodToAdd = opDesc.getMethodFromServiceImpl(serviceClass);
                if (methodToAdd == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Did not find method from OperationDescription: " + opDesc.getName());
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added method for OperationDescription: " + opDesc.getName());
                }
                methodsToAdd.add(methodToAdd);
            }
            Method[] methods = new Method[methodsToAdd.size()];
            int i = 0;
            Iterator i$ = methodsToAdd.iterator();
            while (i$.hasNext()) {
                Method method;
                methods[i] = method = (Method)i$.next();
                ++i;
            }
            return methods;
        }
        return null;
    }

    protected Method getProviderMethod(final Class providerClass) {
        Method providerMethod = null;
        Method[] methods = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return providerClass.getMethods();
            }
        });
        if (methods != null) {
            for (Method method : methods) {
                if (!method.getName().equals("invoke")) continue;
                providerMethod = method;
                break;
            }
        }
        return providerMethod;
    }

    protected Method getTargetMethod(AxisOperation axisOperation, Class implClass) {
        Method targetMethod = null;
        OperationDescription opDesc = (OperationDescription)Axis2Utils.getParameterValue(axisOperation, "org.apache.axis2.jaxws.description.OperationDescription.axisOperationParameter");
        targetMethod = opDesc.getMethodFromServiceImpl(implClass);
        return targetMethod;
    }

    protected void setMappedException(InvocationListenerBean bean, Throwable ejbException) {
        if (tc.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ejbException.printStackTrace(pw);
            Tr.debug(tc, "Setting mapped exception: \n" + sw.toString());
        }
        org.apache.axis2.jaxws.core.MessageContext requestContext = bean.getEndpointInvocationContext().getRequestMessageContext();
        org.apache.axis2.jaxws.core.MessageContext responseContext = bean.getEndpointInvocationContext().getResponseMessageContext();
        requestContext.setProperty("org.apache.axis2.jaxws.spi.MAPPED_EXCEPTION", ejbException);
        if (responseContext != null) {
            responseContext.setProperty("org.apache.axis2.jaxws.spi.MAPPED_EXCEPTION", ejbException);
        }
    }
}

