/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.server;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.annotations.injection.WebServiceContextImplFacade;
import com.ibm.ws.websvcs.annotations.injection.WebServiceContextTLS;
import javax.xml.ws.WebServiceContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.injection.ResourceInjectionException;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.server.endpoint.injection.ResourceInjector;
import org.apache.axis2.jaxws.server.endpoint.injection.factory.ResourceInjectionFactory;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.EndpointLifecycleManager;
import org.apache.axis2.jaxws.server.endpoint.lifecycle.impl.EndpointLifecycleManagerImpl;

public class WSEndpointLifecycleManager
extends EndpointLifecycleManagerImpl
implements EndpointLifecycleManager {
    private static final TraceComponent tc = Tr.register(WSEndpointLifecycleManager.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public WSEndpointLifecycleManager() {
    }

    public WSEndpointLifecycleManager(Object instance) {
        super(instance);
    }

    protected Object retrieveServiceInstance(MessageContext mc) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveServiceInstance");
        }
        Object instance = null;
        if (mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found EJB instance stored on MessageContext");
            }
            instance = mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE");
        } else if (mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE") != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found WAR instance stored on MessageContext");
            }
            instance = mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE");
        } else {
            instance = super.retrieveServiceInstance(mc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveServiceInstance");
        }
        return instance;
    }

    protected void injectWebServiceContext(MessageContext mc, WebServiceContext wsContext, Object serviceInstance) throws ResourceInjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "injectWebServiceContext");
        }
        WebServiceContextTLS.set(wsContext);
        mc.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSCONTEXTINSTANCE", wsContext);
        mc.getAxisMessageContext().getServiceContext().setProperty("javax.xml.ws.WebServiceContext", wsContext);
        ResourceInjector ri = ResourceInjectionFactory.createResourceInjector(WebServiceContext.class);
        ri.inject(new WebServiceContextImplFacade(), serviceInstance);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "injectWebServiceContext");
        }
    }

    protected void performWebServiceContextUpdate(MessageContext mc) throws ResourceInjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performWebServiceContextUpdate");
        }
        if (mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE") != null) {
            ServiceContext serviceContext;
            WebServiceContext ws;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing WebServiceContext injection/update for EJB: " + mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE"));
            }
            if ((ws = (WebServiceContext)(serviceContext = mc.getAxisMessageContext().getServiceContext()).getProperty("javax.xml.ws.WebServiceContext")) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebServiceContext instance existed on ServiceContext... performing update");
                }
                javax.xml.ws.handler.MessageContext soapMessageContext = this.createSOAPMessageContext(mc);
                this.updateWebServiceContext(ws, soapMessageContext);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WebServiceContext instance did not exist for EJB... creating new one and storing on ThreadLocal");
                }
                WebServiceContext wsc = this.createWebServiceContext(mc);
                serviceContext.setProperty("javax.xml.ws.WebServiceContext", wsc);
                WebServiceContextTLS.set(wsc);
                mc.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSCONTEXTINSTANCE", wsc);
                mc.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE", null);
                mc.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE", null);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing WebServiceContext update for WAR endpoint");
            }
            if (mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE") != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Endpoint instance found on message context, creating new facade object.");
                }
                WebServiceContext wsc = this.createWebServiceContext(mc);
                ServiceContext serviceContext = mc.getAxisMessageContext().getServiceContext();
                serviceContext.setProperty("javax.xml.ws.WebServiceContext", wsc);
                WebServiceContextTLS.set(wsc);
                mc.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WSCONTEXTINSTANCE", wsc);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Endpoint instance not found on message context, delegating to super class for WebServiceContext update.");
                }
                super.performWebServiceContextUpdate(mc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performWebServiceContextUpdate");
        }
    }

    public Object createServiceInstance(MessageContext mc, Class serviceImplClass) throws LifecycleException, ResourceInjectionException {
        Object instance = super.createServiceInstance(mc, serviceImplClass);
        if (mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE") != null && instance != null) {
            ServiceDescription serviceDesc;
            ResourceInjectionServiceRuntimeDescription injectionDesc;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checking for @PostConstruct on service impl instance: " + instance);
            }
            if ((injectionDesc = this.getInjectionDesc(serviceDesc = mc.getEndpointDescription().getServiceDescription(), serviceImplClass)) != null && injectionDesc.getPostConstructMethod() != null) {
                this.invokePostConstruct(injectionDesc.getPostConstructMethod());
            }
            mc.getAxisMessageContext().setProperty("com.ibm.ws.websvcs.MsgContext_WARINSTANCE", null);
        } else if (mc.getAxisMessageContext().getProperty("com.ibm.ws.websvcs.MsgContext_EJBINSTANCE") != null && instance != null) {
            ServiceContext serviceContext = mc.getAxisMessageContext().getServiceContext();
            if (WebServiceContextTLS.get() == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found EJB endpoint, sticking WebServiceContext on ThreadLocal");
                }
                this.performWebServiceContextUpdate(mc);
            } else if (serviceContext.getProperty("javax.xml.ws.WebServiceContext") == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found EJB endpoint and existing WebServiceContext on ThreadLocal, performing update of WebServiceContext");
                }
                this.performWebServiceContextUpdate(mc);
            }
        }
        return instance;
    }
}

