/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.addressing.AddressingConfigHelper;
import com.ibm.ws.websvcs.rm.policyset.RMBindingLoader;
import com.ibm.ws.websvcs.rm.policyset.WSRMPolicyPreferenceResolver;
import com.ibm.ws.websvcs.rm.policyset.gen.makeconnection.MCSupportedType;
import com.ibm.ws.websvcs.rm.policyset.gen.makeconnection.ObjectFactory;
import com.ibm.ws.websvcs.rm.policyset.gen.policy.OperatorContentType;
import com.ibm.ws.websvcs.rm.policyset.gen.policy.Policy;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.DeliveryAssurance;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ExactlyOnce;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.InOrder;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.RMAssertion;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.SequenceSTR;
import com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.SequenceTransportSecurity;
import com.ibm.ws.wsaddressing.jaxws.WSAConstants;
import com.ibm.ws.wspolicy.WSPolicyInternalException;
import com.ibm.ws.wspolicy.domain.Assertion;
import com.ibm.ws.wspolicy.domain.PolicyInputStreamHolder;
import com.ibm.ws.wspolicy.domain.WSPolicyAssertionProcessor;
import com.ibm.ws.wspolicy.domain.WSPolicyPreferenceResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSRMWSPolicyAssertionProcessor
implements WSPolicyAssertionProcessor {
    private static final TraceComponent tc = Tr.register(WSRMWSPolicyAssertionProcessor.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    public static final String rm_man_wsa_man_async_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man_wsa_man_async.xml";
    public static final String rm_man_wsa_man_dc_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man_wsa_man_dc.xml";
    public static final String rm_man_wsa_man_sync_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man_wsa_man_sync.xml";
    public static final String rm_man_wsa_opt_async_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man_wsa_opt_async.xml";
    public static final String rm_man_wsa_opt_dc_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man_wsa_opt_dc.xml";
    public static final String rm_man_wsa_opt_sync_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man_wsa_opt_sync.xml";
    public static final String rm_man_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_man.xml";
    public static final String rm_opt_wsa_man_async_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt_wsa_man_async.xml";
    public static final String rm_opt_wsa_man_dc_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt_wsa_man_dc.xml";
    public static final String rm_opt_wsa_man_sync_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt_wsa_man_sync.xml";
    public static final String rm_opt_wsa_opt_async_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt_wsa_opt_async.xml";
    public static final String rm_opt_wsa_opt_dc_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt_wsa_opt_dc.xml";
    public static final String rm_opt_wsa_opt_sync_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt_wsa_opt_sync.xml";
    public static final String rm_opt_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/rm_opt.xml";
    public static final String wsa_man_async_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/wsa_man_async.xml";
    public static final String wsa_man_dc_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/wsa_man_dc.xml";
    public static final String wsa_man_sync_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/wsa_man_sync.xml";
    public static final String wsa_opt_async_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/wsa_opt_async.xml";
    public static final String wsa_opt_dc_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/wsa_opt_dc.xml";
    public static final String wsa_opt_sync_policy_file = "com/ibm/ws/websvcs/rm/policyset/policy/wsa_opt_sync.xml";
    private static WSRMPolicyPreferenceResolver resolver = new WSRMPolicyPreferenceResolver();
    private ArrayList<QName> assertions = new ArrayList();

    public WSRMWSPolicyAssertionProcessor() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSRMWSPolicyAssertionProcessor");
        }
        this.assertions.add(new QName("specLevel", "RMAssertion"));
        this.assertions.add(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "RMAssertion"));
        this.assertions.add(new QName("RMAssertion", "InactivityTimeout"));
        this.assertions.add(new QName("RMAssertion", "BaseRetransmissionInterval"));
        this.assertions.add(new QName("RMAssertion", "ExponentialBackoff"));
        this.assertions.add(new QName("RMAssertion", "AcknowledgementInterval"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "RMAssertion"));
        this.assertions.add(new QName("RMAssertion", "SequenceSTR"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "DeliveryAssurance"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "ExactlyOnce"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "AtLeastOnce"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "AtMostOnce"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "InOrder"));
        this.assertions.add(new QName("http://docs.oasis-open.org/ws-rx/wsmc/200702", "MCSupported"));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSRMWSPolicyAssertionProcessor", this);
        }
    }

    public ArrayList<QName> getSupportedWSPolicyAssertions() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedWSPolicyAssertions", this);
        }
        ArrayList<QName> qNameArray = new ArrayList<QName>(this.assertions);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedWSPolicyAssertions", qNameArray);
        }
        return qNameArray;
    }

    public ArrayList<QName> getWSPolicyAssertionsWithCombineBehaviour() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyAssertionsWithCombineBehaviour");
            Tr.exit(tc, "getWSPolicyAssertionsWithCombineBehaviour");
        }
        return null;
    }

    @Override
    public Assertion combine(Assertion assertion1, Assertion assertion2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "combine", new Object[]{assertion1, assertion2});
        }
        Assertion clientsidePSetAssertion = null;
        Assertion serversidePSetAssertion = null;
        try {
            if (assertion1 == null && assertion2 == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No assertions to combine");
                }
                throw new WSPolicyInternalException(nls.getFormattedMessage("NO_ASSESRTIONS_ERROR_CWSKA0801", null, null));
            }
            if (assertion1 != null && assertion1.getAttributeValue(new QName("qualityOfService")) != null) {
                clientsidePSetAssertion = assertion1;
                serversidePSetAssertion = assertion2;
            } else if (assertion2 != null && assertion2.getAttributeValue(new QName("qualityOfService")) != null) {
                clientsidePSetAssertion = assertion2;
                serversidePSetAssertion = assertion1;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "two non client side PSET unsupported");
                }
                throw new WSPolicyInternalException(nls.getFormattedMessage("TWO_SERVERSIDE_ASSESRTIONS_ERROR_CWSKA0802", null, null));
            }
            if (serversidePSetAssertion != null && serversidePSetAssertion.getAttributeValue(new QName("qualityOfService")) != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "two client side policy sets unsupported");
                }
                throw new WSPolicyInternalException(nls.getFormattedMessage("TWO_CLIENTSIDE_ASSESRTIONS_ERROR_CWSKA0803", null, null));
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "clientside pset assertion=" + clientsidePSetAssertion);
                Tr.debug(tc, "serverside pset assertion=" + serversidePSetAssertion);
            }
        }
        catch (WSPolicyInternalException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.WSRMWSPolicyAssertionProcessor.combine", "1:238:1.36", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "combine error");
            }
            return null;
        }
        Assertion returnAssertion = null;
        if (serversidePSetAssertion == null) {
            returnAssertion = clientsidePSetAssertion;
        } else if (clientsidePSetAssertion == null) {
            returnAssertion = serversidePSetAssertion;
            returnAssertion.setAttribute(new QName("qualityOfService"), "unmanagedNonPersistent");
            returnAssertion.setAttribute(new QName("inOrderDelivery"), "true");
            returnAssertion.setAttribute(new QName("useMakeConnection"), "false");
        } else {
            returnAssertion = serversidePSetAssertion;
            String QOS2 = clientsidePSetAssertion.getAttributeValue(new QName("qualityOfService"));
            returnAssertion.setAttribute(new QName("qualityOfService"), QOS2);
            String IOD = clientsidePSetAssertion.getAttributeValue(new QName("inOrderDelivery"));
            returnAssertion.setAttribute(new QName("inOrderDelivery"), IOD);
            String UMC = clientsidePSetAssertion.getAttributeValue(new QName("useMakeConnection"));
            returnAssertion.setAttribute(new QName("useMakeConnection"), UMC);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "combine", returnAssertion);
        }
        return returnAssertion;
    }

    public ArrayList<QName> getWSPolicyAssertionsWithSupportBehaviour() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyAssertionsWithSupportBehaviour");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSPolicyAssertionsWithSupportBehaviour");
        }
        return null;
    }

    @Override
    public boolean supports(Assertion assertion, Map bindings) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "supports", assertion);
        }
        boolean supports = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "supports", supports);
        }
        return supports;
    }

    @Override
    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
            Tr.exit(tc, "getType");
        }
        return "WSReliableMessaging";
    }

    public Object getAssertionFromPolicy(InputStream policy) throws Exception {
        OperatorContentType exactlyOne;
        JAXBElement allElem;
        JAXBElement exactlyOneElem;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssertionFromPolicy");
        }
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0:com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1:com.ibm.ws.websvcs.rm.policyset.gen.policy:com.ibm.ws.websvcs.rm.policyset.gen", (ClassLoader)RMBindingLoader.class.getClassLoader());
        Unmarshaller unmarshaller = jc.createUnmarshaller();
        Object policyProps = null;
        Object abstractRMAssertion = null;
        Policy unmarshalledPolicy = (Policy)unmarshaller.unmarshal(policy);
        if (unmarshalledPolicy != null && (exactlyOneElem = (JAXBElement)unmarshalledPolicy.getPolicyOrAllOrExactlyOne().get(0)) != null && (allElem = (JAXBElement)(exactlyOne = (OperatorContentType)exactlyOneElem.getValue()).getPolicyOrAllOrExactlyOne().get(0)) != null) {
            OperatorContentType all = (OperatorContentType)allElem.getValue();
            abstractRMAssertion = all.getPolicyOrAllOrExactlyOne().get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAssertionFromPolicy");
        }
        return abstractRMAssertion;
    }

    @Override
    public InputStream transformForClientConfiguration(final PolicyInputStreamHolder policy, Map<String, Object> transformOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientConfiguration", new Object[]{policy, transformOptions});
        }
        InputStream policySetFormatInputStream = null;
        try {
            if (policy != null) {
                policySetFormatInputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws Exception {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.entry(tc, "run");
                        }
                        Iterator<Object> policyProps = null;
                        Object abstractRMAssertion = WSRMWSPolicyAssertionProcessor.this.getAssertionFromPolicy(policy.getMain());
                        if (abstractRMAssertion == null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "could not find RM in policy!");
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "run", "exit without RM assertion");
                            }
                            return null;
                        }
                        if (abstractRMAssertion instanceof RMAssertion) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Version 1.1 detected");
                            }
                            RMAssertion rm1_1Assertion = (RMAssertion)abstractRMAssertion;
                            policyProps = rm1_1Assertion.getAny().iterator();
                        } else if (abstractRMAssertion instanceof com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Version 1.0 detected");
                            }
                            policyProps = ((com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion)abstractRMAssertion).getAny().iterator();
                        } else {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                Tr.exit(tc, "run", abstractRMAssertion);
                            }
                            throw new RuntimeException(nls.getFormattedMessage("INVALID_POLICY_ERROR_CWSKA0355", null, null));
                        }
                        while (policyProps != null && policyProps.hasNext()) {
                            Object currPolicyProp = policyProps.next();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "found element " + currPolicyProp);
                            }
                            if (currPolicyProp instanceof RMAssertion.AcknowledgementInterval || currPolicyProp instanceof RMAssertion.BaseRetransmissionInterval || currPolicyProp instanceof DeliveryAssurance || currPolicyProp instanceof RMAssertion.ExponentialBackoff || currPolicyProp instanceof InOrder || currPolicyProp instanceof RMAssertion.InactivityTimeout || currPolicyProp instanceof SequenceSTR || currPolicyProp instanceof SequenceTransportSecurity || currPolicyProp instanceof Policy) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "supported policy from RM policy assertion " + currPolicyProp);
                                continue;
                            }
                            if (currPolicyProp instanceof JAXBElement && ("inOrderDelivery".equals(((JAXBElement)currPolicyProp).getName().getLocalPart()) || "qualityOfService".equals(((JAXBElement)currPolicyProp).getName().getLocalPart()) || "useMakeConnection".equals(((JAXBElement)currPolicyProp).getName().getLocalPart()))) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "supported policy from IBM policy set " + currPolicyProp);
                                continue;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "unsupported policy " + currPolicyProp);
                            }
                            Tr.warning(tc, "UNSUPPORTED_POLICY_PROPERTY_CWSKA0804", abstractRMAssertion.toString());
                            policyProps.remove();
                        }
                        InputStream inputStream = WSRMWSPolicyAssertionProcessor.this.wrapAssertionIntoPolicy(abstractRMAssertion, null);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "run", inputStream);
                        }
                        return inputStream;
                    }
                });
            }
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.WSRMWSPolicyAssertionProcessor.transformForClientConfiguration", "1:486:1.36", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientConfiguration", policySetFormatInputStream);
        }
        return policySetFormatInputStream;
    }

    private JAXBElement<OperatorContentType> getServerRM_1_1_Assertion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerRM_1_1_Assertion");
        }
        com.ibm.ws.websvcs.rm.policyset.gen.policy.ObjectFactory policyFactory = new com.ibm.ws.websvcs.rm.policyset.gen.policy.ObjectFactory();
        OperatorContentType content1_1 = policyFactory.createOperatorContentType();
        com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ObjectFactory rm1_1Factory = new com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ObjectFactory();
        RMAssertion rm1_1Assertion = rm1_1Factory.createRMAssertion();
        com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ObjectFactory factory = new com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ObjectFactory();
        DeliveryAssurance assurance = factory.createDeliveryAssurance();
        ExactlyOnce exactlyOnce = factory.createExactlyOnce();
        Policy policy = policyFactory.createPolicy();
        policy.getPolicyOrAllOrExactlyOne().add(exactlyOnce);
        assurance.getAny().add(policy);
        Policy assurancePolicy = policyFactory.createPolicy();
        assurancePolicy.getPolicyOrAllOrExactlyOne().add(assurance);
        rm1_1Assertion.getAny().add(assurancePolicy);
        JAXBElement<OperatorContentType> optionalMakeConnectionJaxB = null;
        ObjectFactory mcObjectFactory = new ObjectFactory();
        JAXBElement<MCSupportedType> makeConnectionJaxB = mcObjectFactory.createMCSupported(mcObjectFactory.createMCSupportedType());
        OperatorContentType optionalMakeConnection = policyFactory.createOperatorContentType();
        optionalMakeConnection.getPolicyOrAllOrExactlyOne().add(makeConnectionJaxB);
        optionalMakeConnection.getPolicyOrAllOrExactlyOne().add(policyFactory.createAll(policyFactory.createOperatorContentType()));
        optionalMakeConnectionJaxB = policyFactory.createExactlyOne(optionalMakeConnection);
        OperatorContentType content = policyFactory.createOperatorContentType();
        content.getPolicyOrAllOrExactlyOne().add(rm1_1Assertion);
        content.getPolicyOrAllOrExactlyOne().add(optionalMakeConnectionJaxB);
        JAXBElement<OperatorContentType> all = policyFactory.createAll(content);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerRM_1_1_Assertion", all);
        }
        return all;
    }

    private JAXBElement<OperatorContentType> getServerRM_1_0_Assertion() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerRM_1_0_Assertion");
        }
        com.ibm.ws.websvcs.rm.policyset.gen.policy.ObjectFactory policyFactory = new com.ibm.ws.websvcs.rm.policyset.gen.policy.ObjectFactory();
        com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.ObjectFactory rm1_0Factory = new com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.ObjectFactory();
        com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion rm1_0Assertion = rm1_0Factory.createRMAssertion();
        RMAssertion.InactivityTimeout inactivityTimeout = new RMAssertion.InactivityTimeout();
        inactivityTimeout.setMilliseconds(new BigInteger("86400000"));
        rm1_0Assertion.setInactivityTimeout(inactivityTimeout);
        RMAssertion.BaseRetransmissionInterval baseRetran = new RMAssertion.BaseRetransmissionInterval();
        baseRetran.setMilliseconds(new BigInteger("15000"));
        rm1_0Assertion.setBaseRetransmissionInterval(baseRetran);
        RMAssertion.AcknowledgementInterval ackInterval = new RMAssertion.AcknowledgementInterval();
        ackInterval.setMilliseconds(new BigInteger("3000"));
        rm1_0Assertion.setAcknowledgementInterval(ackInterval);
        OperatorContentType content = policyFactory.createOperatorContentType();
        content.getPolicyOrAllOrExactlyOne().add(rm1_0Assertion);
        JAXBElement<OperatorContentType> all = policyFactory.createAll(content);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerRM_1_0_Assertion", all);
        }
        return all;
    }

    private Object removeIBMSpecificsFromRMAssertion(Policy rootPolicy) {
        OperatorContentType exactlyOne;
        JAXBElement allElem;
        JAXBElement exactlyOneElem;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeIBMSpecificsFromRMAssertion", rootPolicy);
        }
        Object abstractRMAssertion = null;
        if (rootPolicy != null && (exactlyOneElem = (JAXBElement)rootPolicy.getPolicyOrAllOrExactlyOne().get(0)) != null && (allElem = (JAXBElement)(exactlyOne = (OperatorContentType)exactlyOneElem.getValue()).getPolicyOrAllOrExactlyOne().get(0)) != null) {
            OperatorContentType all = (OperatorContentType)allElem.getValue();
            abstractRMAssertion = all.getPolicyOrAllOrExactlyOne().get(0);
            if (abstractRMAssertion instanceof RMAssertion || abstractRMAssertion instanceof com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0.RMAssertion) {
                rootPolicy.getPolicyOrAllOrExactlyOne().remove(0);
            } else {
                RuntimeException e = new RuntimeException(nls.getFormattedMessage("INVALID_POLICY_ERROR_CWSKA0355", null, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "removeIBMSpecificsFromRMAssertion", e);
                }
                throw e;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeIBMSpecificsFromRMAssertion", abstractRMAssertion);
        }
        return abstractRMAssertion;
    }

    @Override
    public PolicyInputStreamHolder transformForPublish(final Map<String, Object> transformOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForPublish", new Object[]{transformOptions});
        }
        PolicyInputStreamHolder policyInputStreamHolder = null;
        try {
            policyInputStreamHolder = (PolicyInputStreamHolder)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.entry(tc, "run");
                    }
                    InputStream is = null;
                    PolicySetConfiguration psetConfig = (PolicySetConfiguration)transformOptions.get("com.ibm.ws.wspolicy.PolicySetConfiguration");
                    int addressingMode = AddressingConfigHelper.getAddressingMode(psetConfig);
                    boolean isRMEnabled = false;
                    boolean isRMMandatory = false;
                    if (psetConfig != null) {
                        isRMEnabled = psetConfig.getPolicyTypeConfiguration("Sandesha2RMSpecVersion") != null;
                        isRMMandatory = WSRMModule.isWSRMMandatory(null, null);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "config addressing:" + addressingMode + " : rm on : " + isRMEnabled + " : rmMandatory :" + isRMMandatory);
                    }
                    switch (addressingMode) {
                        case 0: {
                            if (!isRMEnabled) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.wsa_opt_sync_policy_file);
                                break;
                            }
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_wsa_opt_sync_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_wsa_opt_sync_policy_file);
                            break;
                        }
                        case 1: {
                            if (!isRMEnabled) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.wsa_opt_async_policy_file);
                                break;
                            }
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_wsa_opt_async_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_wsa_opt_async_policy_file);
                            break;
                        }
                        case 2: {
                            if (!isRMEnabled) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.wsa_opt_dc_policy_file);
                                break;
                            }
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_wsa_opt_dc_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_wsa_opt_dc_policy_file);
                            break;
                        }
                        case 3: {
                            if (!isRMEnabled) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.wsa_man_sync_policy_file);
                                break;
                            }
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_wsa_man_sync_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_wsa_man_sync_policy_file);
                            break;
                        }
                        case 4: {
                            if (!isRMEnabled) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.wsa_man_async_policy_file);
                                break;
                            }
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_wsa_man_async_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_wsa_man_async_policy_file);
                            break;
                        }
                        case 5: {
                            if (!isRMEnabled) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.wsa_man_dc_policy_file);
                                break;
                            }
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_wsa_man_dc_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_wsa_man_dc_policy_file);
                            break;
                        }
                        case 6: {
                            if (!isRMEnabled) break;
                            if (isRMMandatory) {
                                is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_man_policy_file);
                                break;
                            }
                            is = this.getClass().getClassLoader().getResourceAsStream(WSRMWSPolicyAssertionProcessor.rm_opt_policy_file);
                            break;
                        }
                        default: {
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                            Tr.debug(tc, "unknown policy options");
                        }
                    }
                    PolicyInputStreamHolder returnPolicy = null;
                    if (is != null) {
                        returnPolicy = new PolicyInputStreamHolder();
                        returnPolicy.setMain(is);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "run", returnPolicy);
                    }
                    return returnPolicy;
                }
            });
        }
        catch (PrivilegedActionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.WSRMWSPolicyAssertionProcessor.transformForPublish", "1:803:1.36", this);
            e.printStackTrace();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForPublish", policyInputStreamHolder);
        }
        return policyInputStreamHolder;
    }

    private InputStream wrapAssertionIntoPolicy(Object abstractRMAssertion, String specLevel) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "wrapAssertionIntoPolicy", specLevel);
        }
        com.ibm.ws.websvcs.rm.policyset.gen.policy.ObjectFactory pFactory = new com.ibm.ws.websvcs.rm.policyset.gen.policy.ObjectFactory();
        if ("1.1".equals(specLevel)) {
            RMAssertion rm1_1Assertion = (RMAssertion)abstractRMAssertion;
            com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ObjectFactory factory = new com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1.ObjectFactory();
            DeliveryAssurance assurance = factory.createDeliveryAssurance();
            Policy policy2 = pFactory.createPolicy();
            policy2.getPolicyOrAllOrExactlyOne().add(assurance);
            ExactlyOnce exactlyOnce = factory.createExactlyOnce();
            Policy policy = pFactory.createPolicy();
            policy.getPolicyOrAllOrExactlyOne().add(exactlyOnce);
            assurance.getAny().add(policy);
            rm1_1Assertion.getAny().add(policy2);
        }
        OperatorContentType content = pFactory.createOperatorContentType();
        content.getPolicyOrAllOrExactlyOne().add(abstractRMAssertion);
        JAXBElement<OperatorContentType> all = pFactory.createAll(content);
        content = pFactory.createOperatorContentType();
        content.getPolicyOrAllOrExactlyOne().add(all);
        JAXBElement<OperatorContentType> exactlyOne = pFactory.createExactlyOne(content);
        Policy wrappedPolicy = pFactory.createPolicy();
        wrappedPolicy.getPolicyOrAllOrExactlyOne().add(exactlyOne);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        JAXBContext jc = JAXBContext.newInstance((String)"com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_0:com.ibm.ws.websvcs.rm.policyset.gen.wsrm1_1:com.ibm.ws.websvcs.rm.policyset.gen.policy:com.ibm.ws.websvcs.rm.policyset.gen:com.ibm.ws.websvcs.rm.policyset.gen.makeconnection", (ClassLoader)RMBindingLoader.class.getClassLoader());
        Marshaller marshaller = jc.createMarshaller();
        marshaller.marshal((Object)wrappedPolicy, (OutputStream)baos);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "wrapAssertionIntoPolicy");
        }
        return inputStream;
    }

    @Override
    public PolicyInputStreamHolder transformForClientIntersection(InputStream policy, Map<String, Object> transformOptions) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "transformForClientIntersection", new Object[]{policy, transformOptions});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "transformForClientIntersection");
        }
        return null;
    }

    @Override
    public List<Integer> getAssertionAttachPoints(QName assertionQName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAssertionAttachPoints", new Object[]{assertionQName});
        }
        ArrayList<Integer> attachPoints = new ArrayList<Integer>();
        if (assertionQName != null) {
            if (assertionQName.equals(new QName("http://docs.oasis-open.org/ws-rx/wsrmp/200702", "RMAssertion"))) {
                attachPoints.add(2);
            } else if (assertionQName.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/rm/policy", "RMAssertion"))) {
                attachPoints.add(2);
            } else if (assertionQName.equals(new QName("http://docs.oasis-open.org/ws-rx/wsmc/200702", "MCSupported"))) {
                attachPoints.add(2);
            } else if (assertionQName.equals(WSAConstants.ADDRESSING_ASSERTION_QNAME)) {
                attachPoints.add(2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAssertionAttachPoints", attachPoints);
        }
        return attachPoints;
    }

    @Override
    public WSPolicyPreferenceResolver getWSPolicyPreferenceResolver() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSPolicyPreferenceResolver");
            Tr.exit(tc, "getWSPolicyPreferenceResolver", resolver);
        }
        return resolver;
    }

    @Override
    public List<QName> getProviderVocabularyRequired() {
        return null;
    }

    @Override
    public List<QName> getAssertionsWithConditionalClientCapability() {
        return null;
    }

    @Override
    public String getPreferredPrefix(QName assertionQName) {
        return "wsrm";
    }
}

