/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetConfigurationWrapper;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.wsspi.websvcs.Axis2ServiceConfigPluginBase;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;

public class RMServiceConfigPlugin
extends Axis2ServiceConfigPluginBase {
    private static final TraceComponent tc = Tr.register(RMServiceConfigPlugin.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");

    public static boolean isManagedPersistentQOS(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedPersistentQOS", config2);
        }
        boolean managedOQS = false;
        String qos = null;
        Parameter temp = config2.getParameter("qualityOfService");
        if (temp != null) {
            qos = (String)temp.getValue();
        }
        if ("managedPersistent".equals(qos)) {
            managedOQS = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedPersistentQOS", new Boolean(managedOQS));
        }
        return managedOQS;
    }

    public static boolean isManagedQOS(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isManagedQOS", config2);
        }
        boolean managedOQS = false;
        String qos = null;
        Parameter temp = config2.getParameter("qualityOfService");
        if (temp != null) {
            qos = (String)temp.getValue();
        }
        if ("managedPersistent".equals(qos) || "managedNonPersistent".equals(qos)) {
            managedOQS = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isManagedQOS", new Boolean(managedOQS));
        }
        return managedOQS;
    }

    public static boolean isUnManagedQOS(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isUnManagedQOS", config2);
        }
        boolean unmanagedOQS = false;
        String qos = null;
        Parameter temp = config2.getParameter("qualityOfService");
        if (temp != null) {
            qos = (String)temp.getValue();
        }
        if ("unmanagedNonPersistent".equals(qos)) {
            unmanagedOQS = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isUnManagedQOS", unmanagedOQS);
        }
        return unmanagedOQS;
    }

    public static boolean isInorder(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isInorder", config2);
        }
        boolean inorder = false;
        String inorderStr = null;
        Parameter temp = config2.getParameter("inOrderDelivery");
        if (temp != null) {
            inorderStr = (String)temp.getValue();
        }
        if (inorderStr != null && "true".equalsIgnoreCase(inorderStr)) {
            inorder = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isInorder", new Boolean(inorder));
        }
        return inorder;
    }

    public static boolean isUseMakeConnection(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isUseMakeConnection", config2);
        }
        boolean useMakeConnection = false;
        String useMakeConnectionStr = null;
        Parameter temp = config2.getParameter("useMakeConnection");
        if (temp != null) {
            useMakeConnectionStr = (String)temp.getValue();
        }
        if (useMakeConnectionStr != null && "true".equalsIgnoreCase(useMakeConnectionStr)) {
            useMakeConnection = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isUseMakeConnection", new Boolean(useMakeConnection));
        }
        return useMakeConnection;
    }

    public static String getBusName(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getBusName", config2);
        }
        String busName = null;
        Parameter temp = config2.getParameter("busName");
        if (temp != null) {
            busName = (String)temp.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getBusName", busName);
        }
        return busName;
    }

    public static String getMessagingEngineName(AxisConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessagingEngineName", config2);
        }
        String messagingEngineName = null;
        Parameter temp = config2.getParameter("messagingEngineName");
        if (temp != null) {
            messagingEngineName = (String)temp.getValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessagingEngineName", messagingEngineName);
        }
        return messagingEngineName;
    }

    public RMServiceConfigPlugin() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMServiceConfigPlugin");
            Tr.exit(tc, "RMServiceConfigPlugin", this);
        }
    }

    public void config(HashMap hm) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "config", hm);
        }
        AxisService service = (AxisService)hm.get("com.ibm.wsspi.websvcs.AxisServiceKey");
        this.configureService(service);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "config");
        }
    }

    private void disableRMForAllServices(AxisService service) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "disableRMForAllServices", service);
        }
        this.turnRMOffForService(service);
        Iterator it = service.getAxisConfiguration().getServices().values().iterator();
        while (it.hasNext()) {
            this.turnRMOffForService((AxisService)it.next());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "disableRMForAllServices", service);
        }
    }

    private void turnRMOffForService(AxisService service) throws AxisFault {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "turnRMOffForService", service);
        }
        Parameter noRM = new Parameter("Sandesha2UnreliableMessage", "true");
        service.addParameter(noRM);
        Parameter disableAcks = new Parameter("DisableResponseAck", null);
        service.removeParameter(disableAcks);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "turnRMOffForService");
        }
    }

    private void configureService(AxisService service) throws AxisFault {
        Parameter param;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "configureService", service);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "service details ", new Object[]{service.getBindingName(), service.getAxisConfiguration(), service.getAxisConfiguration().getKey(), service.getClassLoader(), service.getKey(), service.getDocumentation(), service.getName(), service.getTargetNamespace()});
        }
        Parameter policySetParameter = service.getParameter("WASAxis2PolicySet");
        AxisConfiguration config2 = service.getAxisConfiguration();
        PolicySetConfiguration policySet = null;
        String qos = null;
        String inorder = null;
        String useMakeConnection = null;
        String specVersion = null;
        boolean removeUnusuedStorageManagers = false;
        Boolean wsPolicy = null;
        if (policySetParameter != null) {
            policySet = (PolicySetConfiguration)policySetParameter.getValue();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved policy set " + policySet);
            }
            if ((policySet = (PolicySetConfiguration)policySetParameter.getValue()) != null && policySet instanceof PolicySetConfigurationWrapper) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "policySet instance of  PolicySetConfigurationWrapper - perform wspolicy lookup of service");
                }
                if (policySet.getPolicyTypeConfiguration("Sandesha2RMSpecVersion") != null) {
                    wsPolicy = Boolean.TRUE;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "WSPolicy has enabled RM at the service level");
                    }
                    policySet = this.getPolicySetFromOperation(policySet, service);
                } else {
                    wsPolicy = (policySet = this.getPolicySetFromOperation(policySet, service)).getPolicyTypeConfiguration("Sandesha2RMSpecVersion") != null ? Boolean.TRUE : Boolean.FALSE;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "wspolicy operation-level enabling of RM is:" + wsPolicy);
                    }
                }
                if (wsPolicy.booleanValue()) {
                    Parameter noRM = new Parameter("Sandesha2UnreliableMessage", "true");
                    service.removeParameter(noRM);
                }
            }
            qos = (String)policySet.getPolicyTypeConfiguration("qualityOfService");
            inorder = (String)policySet.getPolicyTypeConfiguration("inOrderDelivery");
            useMakeConnection = (String)policySet.getPolicyTypeConfiguration("useMakeConnection");
            specVersion = (String)policySet.getPolicyTypeConfiguration("Sandesha2RMSpecVersion");
            if (wsPolicy != null && wsPolicy.booleanValue()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Updating storage information as policy is enabled");
                }
                if (qos == null) {
                    qos = "unmanagedNonPersistent";
                }
                if (useMakeConnection == null) {
                    useMakeConnection = "true";
                }
                if (inorder == null) {
                    inorder = "false";
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieved Qos " + qos + " inorder = " + inorder + " useMakeConnection = " + useMakeConnection + " specVersion = " + specVersion);
            }
        } else {
            removeUnusuedStorageManagers = true;
        }
        Parameter specVersionParam = new Parameter("Sandesha2RMSpecVersion", specVersion);
        if (wsPolicy == null || !wsPolicy.booleanValue()) {
            Iterator operationIterator = service.getOperations();
            while (operationIterator.hasNext()) {
                PolicySetConfiguration operationPolicySet;
                AxisOperation operation = (AxisOperation)operationIterator.next();
                Parameter param2 = operation.getParameter("WASAxis2PolicySet");
                if (param2 == null || (operationPolicySet = (PolicySetConfiguration)param2.getValue()) == null || operationPolicySet.getPolicyTypeConfiguration("qualityOfService") == null) continue;
                String operationQos = (String)policySet.getPolicyTypeConfiguration("qualityOfService");
                String operationInOrder = (String)policySet.getPolicyTypeConfiguration("inOrderDelivery");
                String operationUseMakeConnection = (String)policySet.getPolicyTypeConfiguration("useMakeConnection");
                String operationSpecVersion = (String)policySet.getPolicyTypeConfiguration("Sandesha2RMSpecVersion");
                if (!(qos == null && operationQos != null || qos != null && !qos.equals(operationQos) || inorder == null && operationInOrder != null || inorder != null && !inorder.equals(operationInOrder) || useMakeConnection == null && useMakeConnection != null || useMakeConnection != null && !useMakeConnection.equals(operationUseMakeConnection) || specVersion == null && specVersion != null) && (specVersion == null || specVersion.equals(operationSpecVersion))) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", "IllegalStateException");
                }
                throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"RMServiceConfigPlugin", "1:451:1.26.1.18"}, null));
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "policySetParameter=" + policySetParameter + ", qos=" + qos + ", wsPolicy=" + wsPolicy);
        }
        if (policySetParameter == null || qos == null && wsPolicy == null || wsPolicy != null && !wsPolicy.booleanValue()) {
            this.turnRMOffForService(service);
        }
        if (qos != null) {
            AxisFault fault;
            if (config2.getParameter("qualityOfService") != null && !Boolean.TRUE.equals(wsPolicy) && !config2.getParameter("qualityOfService").getValue().equals(qos)) {
                this.disableRMForAllServices(service);
                fault = new AxisFault(nls.getFormattedMessage("POLSET_CONFLICT_CWSKA0110", new Object[]{"qualityOfService", config2.getParameter("qualityOfService").getValue(), qos}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", fault);
                }
                throw fault;
            }
            if (config2.getParameter("qualityOfService") == null) {
                config2.addParameter(new Parameter("qualityOfService", qos));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addParameter " + qos + "," + config2);
                }
            }
            if (config2.getParameter("inOrderDelivery") != null && !Boolean.TRUE.equals(wsPolicy) && !config2.getParameter("inOrderDelivery").getValue().equals(inorder)) {
                this.disableRMForAllServices(service);
                fault = new AxisFault(nls.getFormattedMessage("POLSET_CONFLICT_CWSKA0110", new Object[]{"inOrderDelivery", config2.getParameter("inOrderDelivery").getValue(), inorder}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", fault);
                }
                throw fault;
            }
            if (config2.getParameter("inOrderDelivery") == null) {
                config2.addParameter(new Parameter("inOrderDelivery", inorder));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addParameter " + inorder + "," + config2);
                }
            }
            if (config2.getParameter("useMakeConnection") != null && !Boolean.TRUE.equals(wsPolicy) && !config2.getParameter("useMakeConnection").getValue().equals(useMakeConnection)) {
                this.disableRMForAllServices(service);
                fault = new AxisFault(nls.getFormattedMessage("POLSET_CONFLICT_CWSKA0110", new Object[]{"useMakeConnection", config2.getParameter("useMakeConnection").getValue(), useMakeConnection}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", fault);
                }
                throw fault;
            }
            if (config2.getParameter("useMakeConnection") == null) {
                config2.addParameter(new Parameter("useMakeConnection", useMakeConnection));
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "addParameter " + useMakeConnection + "," + config2);
                }
            }
            if (config2.getParameter("Sandesha2RMSpecVersion") != null && !Boolean.TRUE.equals(wsPolicy) && config2.getParameter("Sandesha2RMSpecVersion").getValue() != null && !config2.getParameter("Sandesha2RMSpecVersion").getValue().equals(specVersion)) {
                this.disableRMForAllServices(service);
                fault = new AxisFault(nls.getFormattedMessage("POLSET_CONFLICT_CWSKA0110", new Object[]{"Sandesha2RMSpecVersion", config2.getParameter("Sandesha2RMSpecVersion").getValue(), specVersion}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", fault);
                }
                throw fault;
            }
            config2.addParameter(specVersionParam);
        }
        if (policySet != null && config2 != null) {
            String busName = (String)policySet.getPolicyTypeBinding("busName");
            if (qos != null && config2.getParameter("busName") != null && config2.getParameter("busName").getValue() != null && !config2.getParameter("busName").getValue().equals(busName)) {
                this.disableRMForAllServices(service);
                AxisFault fault = new AxisFault(nls.getFormattedMessage("POLSET_CONFLICT_CWSKA0110", new Object[]{"busName", config2.getParameter("busName").getValue(), busName}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", fault);
                }
                throw fault;
            }
            config2.addParameter(new Parameter("busName", busName));
            String messagingEngineName = (String)policySet.getPolicyTypeBinding("messagingEngineName");
            if (qos != null && config2.getParameter("messagingEngineName") != null && config2.getParameter("messagingEngineName").getValue() != null && !config2.getParameter("messagingEngineName").getValue().equals(messagingEngineName)) {
                this.disableRMForAllServices(service);
                AxisFault fault = new AxisFault(nls.getFormattedMessage("POLSET_CONFLICT_CWSKA0110", new Object[]{"messagingEngineName", config2.getParameter("messagingEngineName").getValue(), messagingEngineName}, null));
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "configureService", fault);
                }
                throw fault;
            }
            config2.addParameter(new Parameter("messagingEngineName", messagingEngineName));
        }
        if ((param = service.getAxisConfiguration().getParameter("_WSRM_MODULE_")) != null) {
            if (qos != null) {
                WSRMModule wsrmModule = (WSRMModule)param.getValue();
                wsrmModule.doInitialization(removeUnusuedStorageManagers);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "configureService", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"RMServiceConfigPlugin", "1:628:1.26.1.18"}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "configureService");
        }
    }

    private PolicySetConfiguration getPolicySetFromOperation(PolicySetConfiguration policySetObj, AxisService service) {
        AxisOperation operation;
        Iterator operationIterator;
        PolicySetConfiguration policySet;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPolicySetFromOperation", policySetObj);
        }
        if ((String)(policySet = policySetObj).getPolicyTypeConfiguration("qualityOfService") == null) {
            operationIterator = service.getOperations();
            while (operationIterator.hasNext()) {
                operation = (AxisOperation)operationIterator.next();
                Parameter param = operation.getParameter("WASAxis2PolicySet");
                if (param == null) continue;
                PolicySetConfiguration operationPolicySet = (PolicySetConfiguration)param.getValue();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got operation " + operation + ", " + operation.getName() + ", with policy set " + operationPolicySet);
                }
                if (operationPolicySet == null || operationPolicySet.getPolicyTypeConfiguration("Sandesha2RMSpecVersion") == null) continue;
                policySet = operationPolicySet;
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                Tr.debug(tc, "Identified a operation that has RM enabled " + policySet);
                break;
            }
        }
        operationIterator = service.getOperations();
        while (operationIterator.hasNext()) {
            operation = (AxisOperation)operationIterator.next();
            String name = null;
            QName qName = operation.getName();
            if (qName != null) {
                name = qName.getLocalPart();
            }
            if (name == null || !name.startsWith("Sandesha2Operation")) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding policy set " + policySet + " to operation " + operation + ", " + operation.getName());
            }
            try {
                if (operation.getParameter("WASAxis2PolicySet") == null) {
                    operation.addParameter("WASAxis2PolicySet", policySet);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug(tc, "existing policy set on oepration " + operation);
            }
            catch (AxisFault e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin.getPolicySetFromOperation", "1:710:1.26.1.18", this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPolicySetFromOperation", policySet);
        }
        return policySet;
    }
}

