/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.policyset;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.runtime.BindingLoader;
import com.ibm.ws.policyset.runtime.DefaultBinding;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.VariableExpander;
import com.ibm.ws.websvcs.rm.policyset.WSRMProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class RMBindingLoader
implements BindingLoader {
    private static final TraceComponent tc = Tr.register(RMBindingLoader.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private WSRMProvider helper;

    public RMBindingLoader() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "RMBindingLoader");
        }
        this.helper = new WSRMProvider();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "RMBindingLoader", this);
        }
    }

    public String getType() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getType");
            Tr.exit(tc, "getType", "WSReliableMessaging");
        }
        return "WSReliableMessaging";
    }

    public void init(Map properties) {
    }

    public void destroy() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy");
        }
        this.helper = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    public void loadDefault(ClassLoader sysCL, VariableExpander expander, InputStream input, DefaultBinding toComplete) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadDefault", new Object[]{sysCL, expander, input, toComplete});
        }
        try {
            if (input != null) {
                Properties attrs = this.helper.getBinding(input, null);
                String bus = attrs.getProperty("busName");
                String messagingEngine = attrs.getProperty("messagingEngineName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Bus, MessagingEngine:", new String[]{bus, messagingEngine});
                }
                toComplete.setDefaultBinding("busName", bus);
                toComplete.setDefaultBinding("messagingEngineName", messagingEngine);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "No default binding file to load");
                }
                toComplete.setDefaultBinding("busName", null);
                toComplete.setDefaultBinding("messagingEngineName", null);
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.RMBindingLoader.loadDefault", "1:140:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadDefault", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadDefault");
        }
    }

    public void loadCustom(ClassLoader appCL, ClassLoader sysCL, VariableExpander expander, InputStream input, DefaultBinding defaultBinding, PolicySetConfiguration toComplete) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadCustom", new Object[]{appCL, sysCL, expander, input, defaultBinding, toComplete});
        }
        String bus = null;
        String messagingEngine = null;
        try {
            if (input != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "custom binding found");
                }
                Properties attrs = this.helper.getBinding(input, null);
                bus = attrs.getProperty("busName");
                messagingEngine = attrs.getProperty("messagingEngineName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using custom {Bus, messagingEngine}: ", new String[]{bus, messagingEngine});
                }
            }
            if (bus == null || bus.trim().equals("")) {
                bus = (String)defaultBinding.getDefaultBinding("busName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "using default bus " + bus);
                }
            }
            if (messagingEngine == null || messagingEngine.trim().equals("")) {
                messagingEngine = (String)defaultBinding.getDefaultBinding("messagingEngineName");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "using default messaging engine " + messagingEngine);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Final {Bus, MesagingEngine}: ", new String[]{bus, messagingEngine});
            }
            toComplete.setPolicyTypeBinding("busName", bus);
            toComplete.setPolicyTypeBinding("messagingEngineName", messagingEngine);
            if (bus == null || messagingEngine == null) {
                String qos = (String)toComplete.getPolicyTypeConfiguration("qualityOfService");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "QOS is ", qos);
                }
                if ("managedPersistent".equals(qos) || "managedNonPersistent".equals(qos)) {
                    IllegalStateException e = new IllegalStateException(nls.getFormattedMessage("MISSING_PROPERTY_ERROR_CWSKA0351", null, null));
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "loadCustom", e);
                    }
                    throw e;
                }
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.policyset.RMBindingLoader.loadCustom", "1:215:1.16", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "loadCustom", e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadCustom");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/policyset/RMBindingLoader.java, WAS.rm, WAS70.SERV1, q0834.18 1.16");
        }
    }
}

