/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.mbeans.dao;

import com.ibm.websphere.websvcs.rm.SequenceData;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.sandesha2.util.SpecSpecificConstants;

public abstract class SequenceData
implements Serializable,
com.ibm.websphere.websvcs.rm.SequenceData {
    public final String sequenceID;
    public final String applicationName;
    public final String wsa_namespace;
    public final String wsrm_namespace;
    public final String wsrm_spec_version;
    public final SequenceState sequenceState;
    public final SequenceData.SequenceState theSequenceState;
    public final String acksToAddress;
    public final String targetAddress;
    public final String replyToAddress;
    public final List info_completedMessages;
    public static final String info_faultData = "NONE";
    public static final String info_reliability = "UNKNOWN DATA";
    public final String info_workKey;

    public SequenceData(String sequenceID, String applicationName, String wsa_namespace, String wsrm_spec_version, SequenceState currentState, SequenceData.SequenceState theSequenceState, String acksToEPR, String targetEPR, String replyToEPR, List completedMessages, String workKey) {
        this.sequenceID = sequenceID == null ? info_reliability : sequenceID;
        this.applicationName = applicationName;
        this.wsa_namespace = wsa_namespace;
        this.wsrm_spec_version = wsrm_spec_version;
        String namespace = null;
        try {
            namespace = SpecSpecificConstants.getRMNamespaceValue(wsrm_spec_version);
        }
        catch (Exception e) {
            namespace = null;
        }
        this.wsrm_namespace = namespace;
        this.sequenceState = currentState;
        this.theSequenceState = theSequenceState;
        this.acksToAddress = acksToEPR;
        this.targetAddress = targetEPR;
        this.replyToAddress = replyToEPR;
        this.info_completedMessages = completedMessages != null ? Collections.unmodifiableList(completedMessages) : null;
        this.info_workKey = workKey;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SequenceData)) {
            return false;
        }
        boolean matches = true;
        SequenceData sequenceData = (SequenceData)obj;
        if (!sequenceData.sequenceState.equals(this.sequenceState)) {
            matches = false;
        } else if (!this.sequenceID.equals(sequenceData.sequenceID)) {
            matches = false;
        } else if (!this.applicationName.equals(sequenceData.applicationName)) {
            matches = false;
        } else if (!this.targetAddress.equals(sequenceData.targetAddress)) {
            matches = false;
        }
        return matches;
    }

    public String toString() {
        return "Sequence  to " + this.targetAddress + " for application " + this.applicationName + " : " + this.sequenceState;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getWsa_namespace() {
        return this.wsa_namespace;
    }

    public String getWsrm_namespace() {
        return this.wsrm_namespace;
    }

    public String getWsrm_spec_version() {
        return this.wsrm_spec_version;
    }

    public SequenceState getSequenceState() {
        return this.sequenceState;
    }

    public String getAcksToAddress() {
        return this.acksToAddress;
    }

    public String getTargetAddress() {
        return this.targetAddress;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public List getInfo_completedMessages() {
        return this.info_completedMessages;
    }

    public static String getInfo_reliability() {
        return info_reliability;
    }

    public String getInfo_workKey() {
        return this.info_workKey;
    }

    public static class SequenceState
    extends SequenceData.SequenceState {
        private static final long serialVersionUID = 5107605189032968746L;

        public SequenceState(int state, String description, boolean is_error_state, boolean is_warning_state) {
            super(state, description, is_error_state, is_warning_state);
        }
    }
}

