/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage.beanmanagers;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;

public class InvokerBeanMgrImpl
implements InvokerBeanMgr {
    private static final TraceComponent tc = Tr.register(InvokerBeanMgrImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;

    public InvokerBeanMgrImpl(PersistentStorageManagerSingleton storageManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "InvokerBeanMgrImpl", storageManager);
        }
        this._storageManager = storageManager;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "InvokerBeanMgrImpl", this);
        }
    }

    public boolean insert(InvokerBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insert", bean);
        }
        boolean result = this._storageManager.getInUseTransaction().insertInvokerBean(bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insert", result);
        }
        return result;
    }

    public boolean delete(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "delete", key);
        }
        this._storageManager.getInUseTransaction().deleteInvokerBean(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "delete", Boolean.TRUE);
        }
        return true;
    }

    public InvokerBean retrieve(String key) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieve", key);
        }
        InvokerBean invokerBean = this._storageManager.getCommandInvoker().retrieveInvokerBean(new Object[]{key, this._storageManager.getWorkKey(), this._storageManager.getApplicationInstanceKey()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieve", invokerBean);
        }
        return invokerBean;
    }

    public List find(InvokerBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "find", bean);
        }
        List beans = this._storageManager.getCommandInvoker().findInvokerBeans(new Object[]{bean, this._storageManager.getWorkKey(), this._storageManager.getApplicationInstanceKey()});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "find", beans);
        }
        return beans;
    }

    public List findAll(InvokerBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findAll", bean);
        }
        List beans = this._storageManager.getCommandInvoker().findInvokerBeans(new Object[]{bean, this._storageManager.getWorkKey(), this._storageManager.getApplicationInstanceKey(), Boolean.TRUE});
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findAll", beans);
        }
        return beans;
    }

    public boolean update(InvokerBean bean) {
        throw new IllegalStateException("Internal error: InvokerBeanMgrImpl.update");
    }

    public InvokerBean findUnique(InvokerBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "findUnique", bean);
        }
        List beans = this.find(bean);
        InvokerBean temp = null;
        if (beans != null && beans.size() > 0) {
            temp = (InvokerBean)beans.get(0);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "findUnique", temp);
        }
        return temp;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/beanmanagers/InvokerBeanMgrImpl.java, WAS.rm, WAS70.SERV1, q0834.18 1.16");
        }
    }
}

