/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import java.util.HashMap;
import java.util.List;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMSBean;

public class WSReliableMessagingStorageManagerMap {
    private static final TraceComponent tc = Tr.register(WSReliableMessagingStorageManagerMap.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls;
    private static HashMap storageManagerMap;

    private WSReliableMessagingStorageManagerMap() {
    }

    public static synchronized boolean isStorageManagerInMap(String mapKey) {
        boolean returnValue;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isStorageManagerInMap", mapKey);
        }
        boolean bl = returnValue = storageManagerMap.get(mapKey) != null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isStorageManagerInMap", new Boolean(returnValue));
        }
        return returnValue;
    }

    public static synchronized StorageManager getStorageManagerAndIncrementUsageCount(String mapKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerAndIncrementUsageCount", mapKey);
        }
        StorageManagerWrapper storageManagerWrapper = (StorageManagerWrapper)storageManagerMap.get(mapKey);
        storageManagerWrapper.incrementUsageCount();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerAndIncrementUsageCount", storageManagerWrapper.storageManager);
        }
        return storageManagerWrapper.storageManager;
    }

    public static synchronized void putStorageManagerInMap(String mapKey, StorageManager manager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "putStorageManagerInMap", new Object[]{mapKey, manager});
        }
        StorageManagerWrapper wrapper = new StorageManagerWrapper(manager);
        storageManagerMap.put(mapKey, wrapper);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "putStorageManagerInMap");
        }
    }

    public static synchronized boolean shutdownStorageManagerInstance(String mapKey) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdownStorageManagerInstance", mapKey);
        }
        boolean performShutdown = false;
        StorageManagerWrapper wrapper = (StorageManagerWrapper)storageManagerMap.get(mapKey);
        if (wrapper != null && wrapper.decrementUsageCount()) {
            performShutdown = true;
            storageManagerMap.remove(mapKey);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdownStorageManagerInstance", new Boolean(performShutdown));
        }
        return performShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized StorageManagerWrapper getOwningStorageManagerForAcksToEPR(String acksToEPR) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getOwningStorageManagerForAcksToEPR", acksToEPR);
        }
        StorageManagerWrapper requiredWrapper = null;
        for (StorageManagerWrapper wrapper : storageManagerMap.values()) {
            SandeshaStorageException e2222;
            Object var8_8;
            Transaction sandeshaTran;
            block13: {
                sandeshaTran = null;
                sandeshaTran = wrapper.storageManager.getTransaction();
                RMSBean finderBean = new RMSBean();
                finderBean.setAcksToEPR(acksToEPR);
                List matchingSequences = wrapper.storageManager.getRMSBeanMgr().find(finderBean);
                if (matchingSequences.size() <= 0) break block13;
                requiredWrapper = wrapper;
                var8_8 = null;
                if (sandeshaTran == null || !sandeshaTran.isActive()) break;
                try {
                    sandeshaTran.commit();
                }
                catch (SandeshaStorageException e2222) {
                    FFDCFilter.processException(e2222, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:236:1.8");
                }
                break;
            }
            var8_8 = null;
            if (sandeshaTran == null || !sandeshaTran.isActive()) continue;
            try {
                sandeshaTran.commit();
            }
            catch (SandeshaStorageException e2222) {
                FFDCFilter.processException(e2222, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:236:1.8");
            }
            continue;
            {
                catch (SandeshaStorageException e3) {
                    FFDCFilter.processException(e3, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:219:1.8");
                    var8_8 = null;
                    if (sandeshaTran == null || !sandeshaTran.isActive()) continue;
                    try {
                        sandeshaTran.commit();
                    }
                    catch (SandeshaStorageException e2222) {
                        FFDCFilter.processException(e2222, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:236:1.8");
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                if (sandeshaTran != null && sandeshaTran.isActive()) {
                    try {
                        sandeshaTran.commit();
                    }
                    catch (SandeshaStorageException e2222) {
                        FFDCFilter.processException(e2222, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap.getOwningStorageManagerForAcksToEPR", "1:236:1.8");
                    }
                }
                throw throwable;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getOwningStorageManagerForAcksToEPR", requiredWrapper);
        }
        return requiredWrapper;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/WSReliableMessagingStorageManagerMap.java, WAS.rm, WAS70.SERV1, q0834.18 1.8");
        }
        nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
        storageManagerMap = new HashMap();
    }

    static final class StorageManagerWrapper {
        final StorageManager storageManager;
        final ClassLoader classLoader;
        int usageCount = 0;

        StorageManagerWrapper(StorageManager storageManager) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "StorageManagerWrapper", storageManager);
            }
            this.storageManager = storageManager;
            this.incrementUsageCount();
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "StorageManagerWrapper", storageManager);
            }
        }

        synchronized void incrementUsageCount() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "incrementUsageCount");
            }
            ++this.usageCount;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "incrementUsageCount");
            }
        }

        synchronized boolean decrementUsageCount() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "decrementUsageCount");
            }
            if (this.usageCount > 0) {
                --this.usageCount;
                if (this.usageCount == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "decrementUsageCount", Boolean.TRUE);
                    }
                    return true;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit(tc, "decrementUsageCount", Boolean.FALSE);
                }
                return false;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "decrementUsageCount", "IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"StorageManagerWrapper", "1:118:1.8"}, null));
        }
    }
}

