/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap;
import com.ibm.ws.websvcs.rm.mbeans.WSRMApplicationMBean;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import java.lang.reflect.Constructor;
import java.util.Locale;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.workers.SandeshaThread;

public abstract class WSReliableMessagingStorageManager
extends StorageManager {
    private static final TraceComponent tc = Tr.register(WSReliableMessagingStorageManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private Object _controller;
    private Object _applicationMBean;
    private String _serverClusterName;
    private String _workKey;

    public WSReliableMessagingStorageManager(ConfigurationContext context, boolean initMbean) {
        super(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "WSReliableMessagingStorageManager", new Object[]{context, initMbean});
        }
        if (initMbean) {
            this.initMbean();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "WSReliableMessagingStorageManager", this);
        }
    }

    void initMbean() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "initMbean");
            }
            if (!this.isRunningInClientContainer()) {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.websvcs.rm.storage.controller.ControllableStore");
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.websvcs.rm.impl.storage.ApplicationWSRMStoreController");
                    Constructor<?> constructor = clazz.getConstructor(WSReliableMessagingStorageManager.class);
                    this._controller = constructor.newInstance(this);
                    Class<?> mbeanClazz = Thread.currentThread().getContextClassLoader().loadClass("com.ibm.ws.websvcs.rm.mbeans.WSRMApplicationMBean");
                    Constructor<?> constructor2 = mbeanClazz.getConstructor(Class.forName("com.ibm.ws.websvcs.rm.storage.controller.ControllableStore"));
                    this._applicationMBean = constructor2.newInstance(this._controller);
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager.initMbean", "1:157:1.32", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Caught exception when loading Mbeans", e);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initMbean");
        }
    }

    public Object getController() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getController");
            Tr.exit(tc, "getController", this._controller);
        }
        return this._controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWorkKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkKey");
        }
        WSReliableMessagingStorageManager wSReliableMessagingStorageManager = this;
        synchronized (wSReliableMessagingStorageManager) {
            if (this._workKey == null) {
                if (this._serverClusterName == null) {
                    this._serverClusterName = WSRMModule.getClusterName();
                    if (this._serverClusterName == null) {
                        this._serverClusterName = WSRMModule.getServerName();
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverClusterName=" + this._serverClusterName);
                    }
                }
                this._workKey = this._serverClusterName + "#" + WSRMModule.getApplicationName(this.getContext()) + "#" + WSRMModule.getApplicationModuleName(this.getContext());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkKey", this._workKey);
        }
        return this._workKey;
    }

    public static String getWorkKey(String appName, String moduleName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkKey", new Object[]{appName, moduleName});
        }
        String workKey = null;
        String serverClusterName = null;
        serverClusterName = WSRMModule.getClusterName();
        if (serverClusterName == null) {
            serverClusterName = WSRMModule.getServerName();
        }
        workKey = serverClusterName + "#" + appName + "#" + moduleName;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkKey", workKey);
        }
        return workKey;
    }

    public void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        if (WSReliableMessagingStorageManagerMap.shutdownStorageManagerInstance(this.getMapKey())) {
            if (this.isStoreBeingUsed() && !this.isRunningInClientContainer() && this.isStoreBeingUsed() && this._applicationMBean != null) {
                WSRMApplicationMBean.deregisterAllMBeans();
            }
            super.shutdown();
            this.shutdownFinished();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected void shutdownFinished() {
    }

    public SandeshaThread getInvoker() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvoker");
        }
        SandeshaThread invoker = this.getApplicationStorageManager().getInvoker();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvoker", invoker);
        }
        return invoker;
    }

    public SandeshaThread getSender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSender");
        }
        SandeshaThread sender = this.getApplicationStorageManager().getSender();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSender", sender);
        }
        return sender;
    }

    public PollingManager getPollingManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getPollingManager");
        }
        PollingManager pollingManager = this.getApplicationStorageManager().getPollingManager();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPollingManager", pollingManager);
        }
        return pollingManager;
    }

    public SenderBeanMgr getSenderBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSenderBeanMgr");
        }
        SenderBeanMgr returnValue = this.getApplicationStorageManager().getSenderBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSenderBeanMgr", returnValue);
        }
        return returnValue;
    }

    public InvokerBeanMgr getInvokerBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getInvokerBeanMgr");
        }
        InvokerBeanMgr returnValue = this.getApplicationStorageManager().getInvokerBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvokerBeanMgr", returnValue);
        }
        return returnValue;
    }

    public void storeMessageContext(String storageKey, MessageContext msgContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeMessageContext", new Object[]{storageKey, msgContext, msgContext.getConfigurationContext()});
        }
        this.getApplicationStorageManager().storeMessageContext(storageKey, msgContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeMessageContext");
        }
    }

    public void setContext(ConfigurationContext context) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setContext", context);
        }
        this.getApplicationStorageManager().setContext(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setContext");
        }
    }

    public void registerMBean() {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "registerMBean");
            }
            try {
                if (!this.isRunningInClientContainer() && this.isStoreBeingUsed() && this._applicationMBean != null) {
                    ((WSRMApplicationMBean)this._applicationMBean).register();
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "Could not register storage manager Mbean due to exception " + e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "registerMBean");
        }
    }

    public void initStorage(AxisModule moduleDesc) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "initStorage", moduleDesc);
        }
        this.getApplicationStorageManager().initStorage(moduleDesc);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "initStorage");
        }
    }

    public Transaction getTransaction() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransaction");
        }
        Transaction returnValue = this.getApplicationStorageManager().getTransaction();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransaction", returnValue);
        }
        return returnValue;
    }

    public RMSBeanMgr getRMSBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBeanMgr");
        }
        RMSBeanMgr returnValue = this.getApplicationStorageManager().getRMSBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMSBeanMgr", returnValue);
        }
        return returnValue;
    }

    public RMDBeanMgr getRMDBeanMgr() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMDBeanMgr");
        }
        RMDBeanMgr returnValue = this.getApplicationStorageManager().getRMDBeanMgr();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMDBeanMgr", returnValue);
        }
        return returnValue;
    }

    public void updateMessageContext(String storageKey, MessageContext msgContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageContext", new Object[]{storageKey, msgContext, msgContext.getConfigurationContext()});
        }
        this.getApplicationStorageManager().updateMessageContext(storageKey, msgContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageContext");
        }
    }

    public MessageContext retrieveMessageContext(String storageKey, ConfigurationContext configContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveMessageContext", new Object[]{storageKey, configContext});
        }
        MessageContext ctx = this.getApplicationStorageManager().retrieveMessageContext(storageKey, configContext);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveMessageContext", ctx);
        }
        return ctx;
    }

    public void removeMessageContext(String storageKey) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeMessageContext", storageKey);
        }
        this.getApplicationStorageManager().removeMessageContext(storageKey);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeMessageContext");
        }
    }

    protected abstract boolean isStoreBeingUsed();

    protected abstract StorageManager getApplicationStorageManager();

    protected abstract String getMapKey();

    public abstract StorageManagerDetail getStorageManagerDetails(Locale var1);

    public boolean isRunningInClientContainer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isRunningInClientContainer");
        }
        boolean returnValue = WSRMModule.isRunningInClientJVM();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isRunningInClientContainer", new Boolean(returnValue));
        }
        return returnValue;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/WSReliableMessagingStorageManager.java, WAS.rm, WAS70.SERV1, q0834.18 1.32");
        }
    }
}

