/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.exceptions.MEXATransactionException;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.TransactionThreadMigrator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.ServiceDescriptionWSDL;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.SequenceEntry;

public final class TransactionImpl
implements Transaction {
    private static final TraceComponent tc = Tr.register(TransactionImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    private PersistentStorageManagerSingleton _storageManager;
    private String _sequenceToken = null;
    private HashMap<Object, Serializable> _sequences = new HashMap();
    private HashMap<String, MessageContext> _modifiedContexts = new HashMap();
    private volatile boolean _isActive = false;
    private boolean _isManagedPersistent = false;
    private boolean _sentMessages = false;
    private boolean _receivedMessages = false;
    private boolean _invokingTransaction = false;
    private InvokerBean _invokerBean;
    private SenderBean _senderBean;
    private long _retransmitInterval = -1L;

    public TransactionImpl(PersistentStorageManagerSingleton impl, boolean managedPersistent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionImpl", new Object[]{impl, managedPersistent});
        }
        this._isActive = true;
        this._isManagedPersistent = managedPersistent;
        this._storageManager = impl;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionImpl", this);
        }
    }

    /*
     * Loose catch block
     */
    public void commit() throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        if (this._isActive) {
            block31: {
                Iterator<MessageContext> msgContexts2222;
                this._isActive = false;
                try {
                    block30: {
                        if (!this._sequences.isEmpty()) {
                            this._sequences.put("TOKEN", (Serializable)((Object)this.getSequenceToken()));
                            this._sequences.put("PERSISTENT", Boolean.valueOf(this._isManagedPersistent));
                            this._sequences.put(WSRMConstants.WORK_KEY, (Serializable)((Object)this._storageManager.getWorkKey()));
                            this._sequences.put(WSRMConstants.APP_KEY, (Serializable)((Object)this._storageManager.getApplicationInstanceKey()));
                            if (this._retransmitInterval > -1L) {
                                this._sequences.put(WSRMConstants.RETRANSMISSION_INTERVAL, Long.valueOf(this._retransmitInterval));
                            }
                            String tempToken = this.getSequenceToken();
                            this.setSequenceToken(null);
                            try {
                                this._storageManager.getCommandInvoker().processTransactionCommit(this._sequences);
                            }
                            catch (MEXATransactionException e) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Caught XA Exception ", e);
                                }
                                if (this._invokingTransaction) {
                                    this._storageManager.getCommandInvoker().forceTransactionRollback(tempToken);
                                }
                                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                    Tr.exit(tc, "commit", e);
                                }
                                throw e;
                            }
                        } else if (this._sequenceToken != null) {
                            this._storageManager.getCommandInvoker().processTransactionRollback(this._sequenceToken);
                            this._sequenceToken = null;
                        }
                        if (!this._invokingTransaction) break block30;
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalGet(this._storageManager.getContext().getAxisConfiguration());
                    }
                    Object var4_5 = null;
                    this._storageManager.removeTransaction();
                    if (this._modifiedContexts == null) break block31;
                    msgContexts2222 = this._modifiedContexts.values().iterator();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this._storageManager.removeTransaction();
                    if (this._modifiedContexts != null) {
                        Iterator<MessageContext> msgContexts2222 = this._modifiedContexts.values().iterator();
                        while (msgContexts2222.hasNext()) {
                            try {
                                MessageContext nextContext = msgContexts2222.next();
                                TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut(nextContext);
                            }
                            catch (AxisFault e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.commit", "1:317:1.68", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "exception received when starting tx ctx " + e);
                            }
                        }
                    }
                    throw throwable;
                }
                while (msgContexts2222.hasNext()) {
                    try {
                        MessageContext nextContext = msgContexts2222.next();
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut(nextContext);
                    }
                    catch (AxisFault e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.commit", "1:317:1.68", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "exception received when starting tx ctx " + e);
                    }
                }
                {
                    break block31;
                    catch (SandeshaStorageException e) {
                        this.rollbackAddedContexts();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit", e);
                        }
                        throw e;
                    }
                    catch (RuntimeException e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.commit", "1:290:1.68", this);
                        this.rollbackAddedContexts();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit", e);
                        }
                        throw e;
                    }
                }
            }
            if (this._sentMessages && this._senderBean != null) {
                this.startSender();
                if (!(this._storageManager.getInvoker() == null || this._storageManager.getInvoker().isThreadStarted() && this._storageManager.getInvoker().getSequences().contains(new SequenceEntry(this._senderBean.getSequenceID(), false)))) {
                    this._storageManager.getInvoker().runThreadForSequence(this._storageManager.getContext(), this._senderBean.getSequenceID(), false);
                }
            }
            if (this._sentMessages) {
                this._storageManager.getSender().wakeThread();
            }
            if (!(this._invokerBean == null || this._storageManager.getInvoker().isThreadStarted() && this._storageManager.getInvoker().getSequences().contains(new SequenceEntry(this._invokerBean.getSequenceID(), false)))) {
                this._storageManager.getSender().runThreadForSequence(this._storageManager.getContext(), this._invokerBean.getSequenceID(), false);
                this._storageManager.getInvoker().runThreadForSequence(this._storageManager.getContext(), this._invokerBean.getSequenceID(), false);
            }
            if (this._receivedMessages) {
                this._storageManager.getInvoker().wakeThread();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    private void startSender() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startSender", this._senderBean);
        }
        String sequenceId = this._senderBean.getSequenceID();
        boolean isSource = false;
        if (this._senderBean.getMessageType() != 4 && this._senderBean.getMessageType() != 2 && this._senderBean.getMessageType() != 6 && this._senderBean.getMessageType() != 9) {
            isSource = true;
            sequenceId = this._senderBean.getInternalSequenceID();
        }
        if (!this._storageManager.getSender().isThreadStarted() || !this._storageManager.getSender().getSequences().contains(new SequenceEntry(sequenceId, isSource))) {
            this._storageManager.getSender().runThreadForSequence(this._storageManager.getContext(), sequenceId, isSource);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startSender");
        }
    }

    private void rollbackAddedContexts() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackAddedContexts");
        }
        if (this._modifiedContexts != null) {
            for (String msgKey : this._modifiedContexts.keySet()) {
                this._storageManager.removeMessageContextState(msgKey);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackAddedContexts");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SandeshaStorageException {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "rollback");
            }
            if (this._isActive) {
                Iterator<MessageContext> msgContexts2;
                this._isActive = false;
                try {
                    if (this._sequenceToken != null) {
                        try {
                            this._storageManager.getCommandInvoker().processTransactionRollback(this._sequenceToken);
                        }
                        catch (MEXATransactionException e) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Caught XA Exception ", e);
                            }
                            this._storageManager.getCommandInvoker().forceTransactionRollback(this._sequenceToken);
                        }
                        this._sequenceToken = null;
                    }
                    if (this._invokingTransaction) {
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalGetWithRollback(this._storageManager.getContext().getAxisConfiguration());
                    }
                    Object var3_2 = null;
                    this._storageManager.removeTransaction();
                    this.rollbackAddedContexts();
                    if (this._modifiedContexts == null) break block16;
                    msgContexts2 = this._modifiedContexts.values().iterator();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this._storageManager.removeTransaction();
                    this.rollbackAddedContexts();
                    if (this._modifiedContexts != null) {
                        Iterator<MessageContext> msgContexts2 = this._modifiedContexts.values().iterator();
                        while (msgContexts2.hasNext()) {
                            try {
                                MessageContext nextContext = msgContexts2.next();
                                TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut(nextContext);
                            }
                            catch (AxisFault e) {
                                FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.rollback", "1:460:1.68", this);
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                                Tr.debug(tc, "exception received when starting tx ctx " + e);
                            }
                        }
                    }
                    throw throwable;
                }
                while (msgContexts2.hasNext()) {
                    try {
                        MessageContext nextContext = msgContexts2.next();
                        TransactionThreadMigrator.getInstance().finishWSRMTransactionalPut(nextContext);
                    }
                    catch (AxisFault e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.rollback", "1:460:1.68", this);
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "exception received when starting tx ctx " + e);
                    }
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    private static byte[] serializeMessageContext(MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "serializeMessageContext", msgContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Serializing msg ctx " + msgContext + " with config ctx " + msgContext.getConfigurationContext());
        }
        SandeshaUtil.removeMustUnderstand(msgContext.getEnvelope());
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        ObjectOutputStream outObjStream = null;
        try {
            outObjStream = new ObjectOutputStream(outStream);
            outObjStream.writeObject(msgContext);
            outStream.flush();
            outStream.close();
        }
        catch (IOException e) {
            FFDCFilter.processException(e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.serializeMessageContext", "1:518:1.68");
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "serializeMessageContext", "RuntimeException");
            }
            throw new RuntimeException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"TransactionImpl", "1:523:1.68"}, null), e);
        }
        byte[] msgCtxByteArray = outStream.toByteArray();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "serializeMessageContext", msgCtxByteArray);
        }
        return msgCtxByteArray;
    }

    private void copyWSDLProperties(MessageContext msgContext) {
        AxisService service;
        Parameter endpointDesc;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "copyWSDLProperties", msgContext);
        }
        if ((endpointDesc = (service = msgContext.getAxisService()).getParameter("org.apache.axis2.jaxws.description.EndpointDescription")) != null) {
            EndpointDescription endPoint = (EndpointDescription)endpointDesc.getValue();
            ServiceDescriptionWSDL wsdlDesc = (ServiceDescriptionWSDL)((Object)endPoint.getServiceDescription());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "copyWSDLProperties for " + msgContext + "=\n**" + endpointDesc + "\n**" + wsdlDesc + "\n**" + endPoint);
            }
            if (wsdlDesc != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "wsdlLocation" + wsdlDesc.getWSDLLocation());
            }
            if (endPoint != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "endPoint" + endPoint.getServiceQName());
            }
            if (endPoint != null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "portQName" + endPoint.getPortQName());
            }
            msgContext.setProperty("WSDL_LOCATION", wsdlDesc.getWSDLLocation());
            msgContext.setProperty("SERVICE_QNAME", endPoint.getServiceQName());
            msgContext.setProperty("CLIENT_BINDING_ID", endPoint.getClientBindingID());
            msgContext.setProperty("PORT_QNAME", endPoint.getPortQName());
            msgContext.setProperty("EPR_ADDR", endPoint.getEndpointAddress());
            if (service.getParameter("CLIENT_SERVICE_CLASS") != null) {
                msgContext.setProperty("SERVICE_CLASS_NAME", service.getParameter("CLIENT_SERVICE_CLASS").getValue());
            }
            if (service.getParameter("CLIENT_SEI_CLASS") != null) {
                msgContext.setProperty("CLIENT_SEI_CLASS", service.getParameter("CLIENT_SEI_CLASS").getValue());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "copyWSDLProperties");
        }
    }

    void storeMessageContext(String key, MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "storeMessageContext", new Object[]{key, msgContext});
        }
        this.copyWSDLProperties(msgContext);
        byte[] msgContextByteArray = TransactionImpl.serializeMessageContext(msgContext);
        ArrayList deleteContexts = this.getDeleteMessageContextState(false);
        if (deleteContexts != null && deleteContexts.contains(key)) {
            deleteContexts.remove(key);
            if (deleteContexts.size() == 0) {
                HashMap contexts = (HashMap)this._sequences.get("MSG_CONTEXTS");
                contexts.remove("DELETE");
            }
            HashMap updateContexts = this.getUpdateMessageContextState(true);
            updateContexts.put(key, msgContextByteArray);
        } else {
            HashMap addContexts = this.getAddMessageContextState(true);
            addContexts.put(key, msgContextByteArray);
            if (this._modifiedContexts == null) {
                this._modifiedContexts = new HashMap();
            }
            this._modifiedContexts.put(key, msgContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "storeMessageContext");
        }
    }

    public void startTransactionalSend(MessageContext msgContext) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "startTransactionalSend", msgContext);
        }
        try {
            TransactionThreadMigrator.getInstance().startWSRMTransactionalPut(msgContext);
        }
        catch (AxisFault e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.impl.storage.TransactionImpl.startTransactionalSend", "1:659:1.68", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "startTransactionalSend", e);
            }
            throw new SandeshaStorageException(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "startTransactionalSend");
        }
    }

    private HashMap getAddMessageContextState(boolean create) {
        HashMap contexts;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddMessageContextState", create);
        }
        if ((contexts = (HashMap)this._sequences.get("MSG_CONTEXTS")) == null && create) {
            contexts = new HashMap();
            this._sequences.put("MSG_CONTEXTS", contexts);
        }
        HashMap addContexts = null;
        if (contexts != null && (addContexts = (HashMap)contexts.get("ADD")) == null && create) {
            addContexts = new HashMap();
            contexts.put("ADD", addContexts);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddMessageContextState", addContexts);
        }
        return addContexts;
    }

    void updateMessageContext(String key, MessageContext msgContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateMessageContext", new Object[]{key, msgContext});
        }
        byte[] msgContextByteArray = TransactionImpl.serializeMessageContext(msgContext);
        HashMap addContexts = this.getAddMessageContextState(false);
        if (addContexts != null && addContexts.containsKey(key)) {
            addContexts.put(key, msgContextByteArray);
        } else {
            HashMap updateContexts = this.getUpdateMessageContextState(true);
            updateContexts.put(key, msgContextByteArray);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateMessageContext");
        }
    }

    private HashMap getUpdateMessageContextState(boolean create) {
        HashMap contexts;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getUpdateMessageContextState", create);
        }
        if ((contexts = (HashMap)this._sequences.get("MSG_CONTEXTS")) == null && create) {
            contexts = new HashMap();
            this._sequences.put("MSG_CONTEXTS", contexts);
        }
        HashMap updateContexts = null;
        if (contexts != null && (updateContexts = (HashMap)contexts.get("UPDATE")) == null && create) {
            updateContexts = new HashMap();
            contexts.put("UPDATE", updateContexts);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getUpdateMessageContextState", updateContexts);
        }
        return updateContexts;
    }

    byte[] getMessageContext(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageContext", key);
        }
        byte[] result = null;
        HashMap addState = this.getAddMessageContextState(false);
        if (addState != null && addState.containsKey(key)) {
            result = (byte[])addState.get(key);
        } else {
            HashMap updateState = this.getUpdateMessageContextState(false);
            if (updateState != null && updateState.containsKey(key)) {
                result = (byte[])updateState.get(key);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageContext", result);
        }
        return result;
    }

    void deleteMessageContext(String key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteMessageContext", key);
        }
        ArrayList deleteContexts = this.getDeleteMessageContextState(true);
        deleteContexts.add(key);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteMessageContext");
        }
    }

    private ArrayList getDeleteMessageContextState(boolean create) {
        HashMap contexts;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeleteMessageContextState", create);
        }
        if ((contexts = (HashMap)this._sequences.get("MSG_CONTEXTS")) == null && create) {
            contexts = new HashMap();
            this._sequences.put("MSG_CONTEXTS", contexts);
        }
        ArrayList deleteContexts = null;
        if (contexts != null && (deleteContexts = (ArrayList)contexts.get("DELETE")) == null && create) {
            deleteContexts = new ArrayList();
            contexts.put("DELETE", deleteContexts);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeleteMessageContextState", deleteContexts);
        }
        return deleteContexts;
    }

    public void insertSenderBean(SenderBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertSenderBean", new Object[]{bean, bean.getSequenceID(), bean.getInternalSequenceID()});
        }
        ArrayList<SenderBean> senderBeans = null;
        String sequenceIdToApply = null;
        if (bean.getSequenceID() == null && bean.getInternalSequenceID() == null) {
            for (String string : this._sequences.keySet()) {
                if (!string.startsWith("Sandesha2InternalSequence")) continue;
                sequenceIdToApply = string;
                break;
            }
            bean.setInternalSequenceID(sequenceIdToApply);
        } else {
            sequenceIdToApply = bean.getInternalSequenceID();
            if (sequenceIdToApply == null) {
                sequenceIdToApply = bean.getSequenceID();
            }
        }
        this._retransmitInterval = this._storageManager.getRetransmissionInterval();
        HashMap addState = this.getSequenceAddTranState(sequenceIdToApply, true);
        senderBeans = (ArrayList<SenderBean>)addState.get(WSRMConstants.SENDER_BEAN);
        if (senderBeans == null) {
            senderBeans = new ArrayList<SenderBean>();
            addState.put(WSRMConstants.SENDER_BEAN, senderBeans);
        }
        senderBeans.add(bean);
        this._sentMessages = true;
        if (bean.getMessageType() != 1) {
            this._senderBean = bean;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertSenderBean", bean);
        }
    }

    public boolean insertRMDBean(RMDBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRMDBean", bean);
        }
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put(WSRMConstants.RMS_BEAN, bean);
        data.put("PERSISTENT", this._isManagedPersistent);
        data.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        data.put("TOKEN", this._sequenceToken);
        HashMap insertResult = this._storageManager.getCommandInvoker().insertRMDBean(data);
        Boolean result = null;
        if (insertResult == null) {
            result = Boolean.TRUE;
        } else {
            result = (Boolean)insertResult.get("INSERT_RESULT");
            if (result.booleanValue()) {
                this.setSequenceToken((String)insertResult.get("TOKEN"));
            }
        }
        if (result.booleanValue()) {
            HashMap properties = this.getSequenceAddTranState(bean.getSequenceID(), true);
            properties.put("RMD_BEAN", bean);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRMDBean", result);
        }
        return result;
    }

    public void updateRMDBean(RMDBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRMDBean", bean);
        }
        HashMap properties = this.getSequenceAddTranState(bean.getSequenceID(), true);
        properties.put("RMD_BEAN", bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRMDBean");
        }
    }

    public RMDBean getRMDBean(String sequenceId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMDBean", sequenceId);
        }
        RMDBean result = null;
        HashMap properties = this.getSequenceAddTranState(sequenceId, false);
        if (properties != null && properties.containsKey("RMD_BEAN")) {
            result = (RMDBean)properties.get("RMD_BEAN");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMDBean", result);
        }
        return result;
    }

    public boolean insertRMSBean(RMSBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRMSBean", bean);
        }
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put(WSRMConstants.RMS_BEAN, bean);
        data.put("PERSISTENT", this._isManagedPersistent);
        data.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        data.put("TOKEN", this._sequenceToken);
        HashMap insertResult = this._storageManager.getCommandInvoker().insertRMSBean(data);
        Boolean result = null;
        if (insertResult == null) {
            result = Boolean.TRUE;
        } else {
            result = (Boolean)insertResult.get("INSERT_RESULT");
            if (result.booleanValue()) {
                this.setSequenceToken((String)insertResult.get("TOKEN"));
            }
        }
        if (result.booleanValue()) {
            HashMap properties = this.getSequenceAddTranState(bean.getInternalSequenceID(), true);
            properties.put(WSRMConstants.RMS_BEAN, bean);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRMSBean", result);
        }
        return result;
    }

    public void updateRMSBean(RMSBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateRMSBean", bean);
        }
        HashMap properties = this.getSequenceAddTranState(bean.getInternalSequenceID(), true);
        properties.put(WSRMConstants.RMS_BEAN, bean);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateRMSBean");
        }
    }

    public RMSBean getRMSBean(RMSBean bean) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getRMSBean", bean);
        }
        RMSBean result = null;
        if (bean.getInternalSequenceID() == null) {
            Iterator<Serializable> keys = this._sequences.values().iterator();
            while (keys.hasNext() && result == null) {
                RMSBean resultBean;
                HashMap addState;
                HashMap properties;
                Serializable obj = keys.next();
                if (!(obj instanceof HashMap) || !(properties = (HashMap)obj).containsKey("ADD") || !(addState = (HashMap)properties.get("ADD")).containsKey(WSRMConstants.RMS_BEAN) || !(resultBean = (RMSBean)addState.get(WSRMConstants.RMS_BEAN)).getSequenceID().equals(bean.getSequenceID())) continue;
                result = resultBean;
            }
        } else {
            HashMap properties = this.getSequenceAddTranState(bean.getInternalSequenceID(), false);
            if (properties != null && properties.containsKey(WSRMConstants.RMS_BEAN)) {
                result = (RMSBean)properties.get(WSRMConstants.RMS_BEAN);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getRMSBean", result);
        }
        return result;
    }

    public boolean insertInvokerBean(InvokerBean bean) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "insertInvokerBean", bean);
        }
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        data.put(WSRMConstants.INVOKER_BEAN, bean);
        data.put("PERSISTENT", this._isManagedPersistent);
        data.put(WSRMConstants.WORK_KEY, this._storageManager.getWorkKey());
        data.put(WSRMConstants.APP_KEY, this._storageManager.getApplicationInstanceKey());
        data.put("TOKEN", this._sequenceToken);
        Boolean result = this._storageManager.getCommandInvoker().insertInvokerBean(data);
        if (result == null) {
            result = Boolean.TRUE;
        }
        if (result.booleanValue()) {
            HashMap addState = this.getSequenceAddTranState(bean.getSequenceID(), true);
            addState.put(WSRMConstants.INVOKER_BEAN, bean);
            this._invokerBean = bean;
        }
        this._receivedMessages = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "insertInvokerBean", result);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public void updateSenderBean(SenderBean bean) {
        void var4_7;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "updateSenderBean", bean);
        }
        String sequenceToApply = null;
        if (bean.getSequenceID() == null && bean.getInternalSequenceID() == null) {
            for (String string : this._sequences.keySet()) {
                if (!string.startsWith("Sandesha2InternalSequence")) continue;
                sequenceToApply = string;
                break;
            }
            bean.setInternalSequenceID(sequenceToApply);
        } else {
            sequenceToApply = bean.getInternalSequenceID();
            if (sequenceToApply == null) {
                sequenceToApply = bean.getSequenceID();
            }
        }
        HashMap updateState = this.getSequenceUpdateTranState(sequenceToApply, true);
        ArrayList arrayList = (ArrayList)updateState.get(WSRMConstants.SENDER_BEAN);
        if (arrayList == null) {
            ArrayList arrayList2 = new ArrayList();
            updateState.put(WSRMConstants.SENDER_BEAN, arrayList2);
        }
        var4_7.add(bean);
        this._sentMessages = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "updateSenderBean");
        }
    }

    private HashMap getSequenceAddTranState(String sequenceID, boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceAddTranState", new Object[]{sequenceID, create});
        }
        HashMap sequenceState = this.getSequenceState(sequenceID, create);
        HashMap addObjects = null;
        if (sequenceState != null && (addObjects = (HashMap)sequenceState.get("ADD")) == null && create) {
            addObjects = new HashMap();
            sequenceState.put("ADD", addObjects);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceAddTranState", addObjects);
        }
        return addObjects;
    }

    private HashMap getSequenceUpdateTranState(String sequenceID, boolean create) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceUpdateTranState", new Object[]{sequenceID, create});
        }
        HashMap sequenceState = this.getSequenceState(sequenceID, create);
        HashMap updateObjects = null;
        if (sequenceState != null && (updateObjects = (HashMap)sequenceState.get("UPDATE")) == null && create) {
            updateObjects = new HashMap();
            sequenceState.put("UPDATE", updateObjects);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceUpdateTranState", updateObjects);
        }
        return updateObjects;
    }

    private HashMap getSequenceDeleteTranState(boolean create) {
        HashMap deleteObjects;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceDeleteTranState");
        }
        if ((deleteObjects = (HashMap)this._sequences.get("DELETE")) == null && create) {
            deleteObjects = new HashMap();
            this._sequences.put("DELETE", deleteObjects);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceDeleteTranState", deleteObjects);
        }
        return deleteObjects;
    }

    private HashMap getSequenceState(String sequenceID, boolean create) {
        HashMap sequenceState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceState", sequenceID);
        }
        if ((sequenceState = (HashMap)this._sequences.get(sequenceID)) == null && create) {
            sequenceState = new HashMap();
            this._sequences.put(sequenceID, sequenceState);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceState", sequenceState);
        }
        return sequenceState;
    }

    public void deleteRMSBean(String msgId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteRMSBean", msgId);
        }
        HashMap deleteState = this.getSequenceDeleteTranState(true);
        deleteState.put(WSRMConstants.RMS_BEAN, msgId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteRMSBean");
        }
    }

    public void deleteRMDBean(String sequenceId) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteRMDBean", sequenceId);
        }
        HashMap deleteState = this.getSequenceDeleteTranState(true);
        deleteState.put("RMD_BEAN", sequenceId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteRMDBean");
        }
    }

    public void deleteInvokerBean(String key) {
        HashMap deleteState;
        ArrayList<String> list;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteInvokerBean", key);
        }
        if ((list = (ArrayList<String>)(deleteState = this.getSequenceDeleteTranState(true)).get(WSRMConstants.INVOKER_BEAN)) == null) {
            list = new ArrayList<String>();
            deleteState.put(WSRMConstants.INVOKER_BEAN, list);
        }
        list.add(key);
        this._invokingTransaction = true;
        TransactionThreadMigrator.getInstance().startWSRMTransactionalGet(this._storageManager.getContext().getAxisConfiguration());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteInvokerBean");
        }
    }

    public void deleteSenderBean(String messageId) {
        HashMap deleteState;
        ArrayList<String> senderBeansToDelete;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteSenderBean", messageId);
        }
        if ((senderBeansToDelete = (ArrayList<String>)(deleteState = this.getSequenceDeleteTranState(true)).get(WSRMConstants.SENDER_BEAN)) == null) {
            senderBeansToDelete = new ArrayList<String>();
            deleteState.put(WSRMConstants.SENDER_BEAN, senderBeansToDelete);
        }
        senderBeansToDelete.add(messageId);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteSenderBean");
        }
    }

    public ArrayList getDeletedSenderBeans() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getDeletedSenderBeans");
        }
        ArrayList deletedSenderBeans = null;
        HashMap deleteState = this.getSequenceDeleteTranState(false);
        if (deleteState != null) {
            deletedSenderBeans = (ArrayList)deleteState.get(WSRMConstants.SENDER_BEAN);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getDeletedSenderBeans", deletedSenderBeans);
        }
        return deletedSenderBeans;
    }

    public void setSequenceToken(String token) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setSequenceToken", token);
        }
        this._sequenceToken = token;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setSequenceToken");
        }
    }

    public String getSequenceToken() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceToken");
            Tr.exit(tc, "getSequenceToken", this._sequenceToken);
        }
        return this._sequenceToken;
    }

    public boolean isActive() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isActive");
            Tr.exit(tc, "isActive", this._isActive);
        }
        return this._isActive;
    }

    public boolean hasSentMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasSentMessages");
        }
        boolean result = false;
        if (this._senderBean != null && this._senderBean.getMessageType() != 4) {
            result = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasSentMessages", result);
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/TransactionImpl.java, WAS.rm, WAS70.SERV1, q0834.18 1.68");
        }
    }
}

