/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.impl.storage;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.websvcs.rm.impl.storage.PersistentStorageManagerSingleton;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManagerMap;
import com.ibm.ws.websvcs.rm.mbeans.dao.StorageManagerDetail;
import com.ibm.ws.websvcs.rm.policyset.RMServiceConfigPlugin;
import java.util.Locale;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;

public final class PersistentStorageManager
extends WSReliableMessagingStorageManager {
    private static final TraceComponent tc = Tr.register(PersistentStorageManager.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls;
    private final PersistentStorageManagerSingleton _applicationStorageManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PersistentStorageManager(ConfigurationContext context) throws SandeshaException {
        super(context, false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "PersistentStorageManager", context);
        }
        String mapKey = this.getMapKey();
        Class<WSReliableMessagingStorageManagerMap> clazz = WSReliableMessagingStorageManagerMap.class;
        synchronized (WSReliableMessagingStorageManagerMap.class) {
            if (WSReliableMessagingStorageManagerMap.isStorageManagerInMap(mapKey)) {
                StorageManager manager = WSReliableMessagingStorageManagerMap.getStorageManagerAndIncrementUsageCount(mapKey);
                if (!(manager instanceof PersistentStorageManagerSingleton)) throw new IllegalStateException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSKA0001", new Object[]{"PersistentStorageManager", "1:142:1.71"}, null));
                this._applicationStorageManager = (PersistentStorageManagerSingleton)manager;
            } else {
                PersistentStorageManagerSingleton persistentStorageManager = new PersistentStorageManagerSingleton(context);
                WSReliableMessagingStorageManagerMap.putStorageManagerInMap(mapKey, persistentStorageManager);
                this._applicationStorageManager = persistentStorageManager;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEntryEnabled()) return;
            Tr.exit(tc, "PersistentStorageManager", this);
            return;
        }
    }

    protected String getMapKey() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getMapKey");
        }
        String mapKey = this.getWorkKey() + "#PersistentStore";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getMapKey", mapKey);
        }
        return mapKey;
    }

    protected StorageManager getApplicationStorageManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationStorageManager");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationStorageManager", this._applicationStorageManager);
        }
        return this._applicationStorageManager;
    }

    public PersistentStorageManagerSingleton getSingletonInstance() {
        return (PersistentStorageManagerSingleton)this.getApplicationStorageManager();
    }

    public void shutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        super.shutdown();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    protected void shutdownFinished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdownFinished");
        }
        this.getSingletonInstance().closeConnectionsForShutdown();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdownFinished");
        }
    }

    public void persistentStoreChosen(ClassLoader classLoader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "persistentStoreChosen");
        }
        this._applicationStorageManager.persistentStoreChosen(classLoader);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "persistentStoreChosen");
        }
    }

    protected boolean isStoreBeingUsed() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isStoreBeingUsed");
        }
        boolean returnValue = RMServiceConfigPlugin.isManagedQOS(this.getContext().getAxisConfiguration());
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isStoreBeingUsed", new Boolean(returnValue));
        }
        return returnValue;
    }

    public synchronized StorageManagerDetail getStorageManagerDetails(Locale l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStorageManagerDetails", l);
        }
        StorageManagerDetail detail = this._applicationStorageManager.getStorageManagerDetails(l);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStorageManagerDetails", detail);
        }
        return detail;
    }

    public boolean requiresMessageSerialization() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "requiresMessageSerialization");
            Tr.exit(tc, "requiresMessageSerialization", Boolean.TRUE);
        }
        return true;
    }

    public boolean hasUserTransaction(MessageContext context) throws SandeshaStorageException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "hasUserTransaction");
        }
        boolean result = this._applicationStorageManager.hasUserTransaction(context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "hasUserTransaction");
        }
        return result;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/impl/storage/PersistentStorageManager.java, WAS.rm, WAS70.SERV1, q0834.18 1.71");
        }
        nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    }
}

