/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm.addressing;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.wsaddressing.jaxws.WSAConstants;

public class AddressingConfigHelper {
    private static final TraceComponent tc = Tr.register(AddressingConfigHelper.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    public static final int WS_ADDRESSING_OPTIONAL_SYNC = 0;
    public static final int WS_ADDRESSING_OPTIONAL_ASYNC = 1;
    public static final int WS_ADDRESSING_OPTIONAL_DC = 2;
    public static final int WS_ADDRESSING_MANDATORY_SYNC = 3;
    public static final int WS_ADDRESSING_MANDATORY_ASYNC = 4;
    public static final int WS_ADDRESSING_MANDATORY_DC = 5;
    public static final int WS_ADDRESSING_OFF = 6;

    public static boolean isAddressingRequired(PolicySetConfiguration pset) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isAddressingRequired", pset);
        }
        boolean returnValue = false;
        String wsaddressingFlag = (String)pset.getPolicyTypeConfiguration(WSAConstants.POLICY_TYPE_CONFIGURATION_KEY);
        if ("required".equals(wsaddressingFlag)) {
            returnValue = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isAddressingRequired", returnValue);
        }
        return returnValue;
    }

    public static int getAddressingMode(PolicySetConfiguration config2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAddressingMode", config2);
        }
        int returnValue = 6;
        if (config2 != null) {
            String wsaddressingFlag = (String)config2.getPolicyTypeConfiguration(WSAConstants.POLICY_TYPE_CONFIGURATION_KEY);
            String wsaMode = (String)config2.getPolicyTypeConfiguration("wsaMode");
            if ("optional".equals(wsaddressingFlag)) {
                returnValue = "WSA_SYNC".equals(wsaMode) ? 0 : ("WSA_ASYNC".equals(wsaMode) ? 1 : 2);
            } else if ("required".equals(wsaddressingFlag)) {
                returnValue = "WSA_SYNC".equals(wsaMode) ? 3 : ("WSA_ASYNC".equals(wsaMode) ? 4 : 5);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAddressingMode", returnValue);
        }
        return returnValue;
    }
}

