/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.wsspi.websvcs.TransportShutdownPluginBase;
import java.util.LinkedList;
import java.util.List;

public class WSRMShutdownHook
extends TransportShutdownPluginBase {
    private static final TraceComponent tc = Tr.register(WSRMShutdownHook.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static List<WSRMModule> _modules;

    public WSRMShutdownHook() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>");
        }
    }

    static synchronized void addModuleToShutdownList(WSRMModule module) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "addModuleToShutdownList", module);
        }
        if (WSRMModule.isRunningInClientJVM()) {
            _modules.add(module);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "addModuleToShutdownList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preShutdown() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "preShutdown");
        }
        if (WSRMModule.isRunningInClientJVM()) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                try {
                    for (WSRMModule module : _modules) {
                        module.shutdown(module.getConfigurationContext());
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMShutdownHook.preShutdown", "1:100:1.2", this);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "preShutdown");
        }
    }

    public String getName() {
        String name = this.getClass().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getName");
            Tr.exit(tc, "getName", name);
        }
        return name;
    }

    public int getWeight() {
        return 0;
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Source info: @(#)SERV1/ws/code/rm.impl/src/com/ibm/ws/websvcs/rm/WSRMShutdownHook.java, WAS.rm, WAS70.SERV1, q0834.18 1.2");
        }
        _modules = new LinkedList<WSRMModule>();
    }
}

