/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.rm;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.policyset.admin.deploy.PolicyResource;
import com.ibm.ws.policyset.runtime.PolicySetAttachments;
import com.ibm.ws.policyset.runtime.PolicySetConfiguration;
import com.ibm.ws.policyset.runtime.PolicySetUtil;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.sib.wsrm.MEStoreConnection;
import com.ibm.ws.sib.wsrm.MEStoreConnectionFactory;
import com.ibm.ws.sib.wsrm.WSRMConstants;
import com.ibm.ws.sib.wsrm.exceptions.MEStoreConnectionException;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.websvcs.client.WSClientConfigurationFactory;
import com.ibm.ws.websvcs.client.WSClientMetaDataNameHolder;
import com.ibm.ws.websvcs.rm.WSRMModule;
import com.ibm.ws.websvcs.rm.impl.storage.WSReliableMessagingStorageManager;
import com.ibm.wsspi.runtime.component.WsComponentImpl;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import javax.xml.namespace.QName;
import javax.xml.ws.Service;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.jaxws.description.DescriptionFactory;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;

public class WSRMComponentImpl
extends WsComponentImpl
implements DeployedObjectListener {
    private static final TraceComponent tc = Tr.register(WSRMComponentImpl.class, "WSRM", "com.ibm.ws.websvcs.rm.CWSKAMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS("com.ibm.ws.websvcs.rm.CWSKAMessages");
    ThreadPool _systemThreadPool = null;

    private synchronized ThreadPool getThreadPool() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getThreadPool");
        }
        if (this._systemThreadPool == null) {
            this._systemThreadPool = new ThreadPool("System RM Persistent store Threadpool", 1, 10);
            this._systemThreadPool.setGrowAsNeeded(true);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getThreadPool", this._systemThreadPool);
        }
        return this._systemThreadPool;
    }

    public void start() throws RuntimeError, RuntimeWarning {
        super.start();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        try {
            ApplicationMgr appMgr = this.getApplicationManagerService();
            appMgr.addDeployedObjectListener(this);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.start", "1:129:1.10", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "start", e);
            }
            throw new RuntimeError(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    private ApplicationMgr getApplicationManagerService() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationManagerService");
        }
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationManagerService", "ApplicationMgr");
            }
            return WsServiceRegistry.getService(this, ApplicationMgr.class);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.getApplicationManagerService", "1:160:1.10", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "getApplicationManagerService", null);
            }
            return null;
        }
    }

    public void stateChanged(DeployedObjectEvent deployedObjectEvent) {
        block21: {
            DeployedObject deployedObject;
            EARFile earFile;
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "stateChanged", new Object[]{deployedObjectEvent, deployedObjectEvent.getDeployedObject()});
            }
            if ("STARTED".equals(deployedObjectEvent.getNewValue()) && (earFile = (deployedObject = deployedObjectEvent.getDeployedObject()).getModuleFile().getEARFile()) != null && (earFile.getEJBJarFiles().size() > 0 || earFile.getWARFiles().size() > 0)) {
                ModuleMetaData moduleMetaData;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, earFile.getName() + " started");
                }
                if ((moduleMetaData = (ModuleMetaData)deployedObject.getMetaData()) != null) {
                    final String appName = moduleMetaData.getApplicationMetaData().getName();
                    final String moduleName = moduleMetaData.getName();
                    boolean decoratePSetConfigWithRMMandatory = false;
                    try {
                        Attributes attrs = deployedObject.getModuleFile().getManifest().getMainAttributes();
                        String value = attrs.getValue("strictlyEnforceWSRM");
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, appName + ", module " + moduleName + " has value for WSRM mandatory behaviour " + value);
                        }
                        if (value != null && Boolean.valueOf(value).booleanValue()) {
                            WSRMModule.addRMMandatoryModule(appName, moduleName);
                            decoratePSetConfigWithRMMandatory = true;
                        }
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.stateChanged", "1:217:1.10", this);
                    }
                    try {
                        PolicySetAttachments attachments = PolicySetUtil.getInstance(ClassLoader.getSystemClassLoader()).getClientAttachments(appName);
                        List<String> resourceNames = attachments.getResourceNames();
                        if (resourceNames != null) {
                            String busName = null;
                            String messagingEngineName = null;
                            boolean persistentFound = false;
                            Iterator<String> resourceNamesItr = resourceNames.iterator();
                            while (resourceNamesItr.hasNext() && !persistentFound) {
                                String resourceName = resourceNamesItr.next();
                                PolicyResource policyResource = new PolicyResource(resourceName);
                                if (policyResource.getModuleName() != null && !policyResource.getModuleName().equals(moduleName)) continue;
                                PolicySetConfiguration policySetConfiguration = attachments.getPolicySet(resourceName, ClassLoader.getSystemClassLoader(), ClassLoader.getSystemClassLoader());
                                String qos = (String)policySetConfiguration.getPolicyTypeConfiguration("qualityOfService");
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Got QoS " + qos);
                                }
                                if (qos == null) continue;
                                if (decoratePSetConfigWithRMMandatory) {
                                    policySetConfiguration.setPolicyTypeConfiguration("wsrmMandatoryOnService", Boolean.TRUE.toString());
                                }
                                if (!"managedPersistent".equals(qos) && !"managedNonPersistent".equals(qos)) continue;
                                persistentFound = true;
                                busName = (String)policySetConfiguration.getPolicyTypeBinding("busName");
                                messagingEngineName = (String)policySetConfiguration.getPolicyTypeBinding("messagingEngineName");
                            }
                            if (persistentFound && busName != null && messagingEngineName != null) {
                                final String finalBusName = busName;
                                final String finalMEName = messagingEngineName;
                                Runnable initialize = new Runnable(){

                                    public void run() {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                            Tr.entry(tc, "run", this);
                                        }
                                        try {
                                            WSRMComponentImpl.this.loadAvailableSequences(finalBusName, finalMEName, appName, moduleName, deployedObject.getClassLoader(), moduleMetaData);
                                        }
                                        catch (RuntimeError e) {
                                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.run", "1:307:1.10", this);
                                        }
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                                            Tr.exit(tc, "run");
                                        }
                                    }
                                };
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Executing " + initialize);
                                }
                                this.getThreadPool().execute(initialize);
                            } else if (persistentFound) {
                                throw new RuntimeError(nls.getFormattedMessage("MISSING_PROPERTY_ERROR_CWSKA0351", null, null));
                            }
                        }
                        break block21;
                    }
                    catch (Exception e) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "Caught Exception", e);
                        }
                        break block21;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Couldn't check for any policy set attachments as there is no application name");
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "stateChanged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAvailableSequences(String bus, String messagingEngine, String appName, String moduleName, ClassLoader classLoader, ModuleMetaData moduleMetaData) throws RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "loadAvailableSequences", new Object[]{bus, messagingEngine});
        }
        MEStoreConnectionFactory factory = MEStoreConnectionFactory.getInstance();
        MEStoreConnection meStoreConnection = factory.createMEStoreConnection(bus, messagingEngine, null, null);
        try {
            meStoreConnection.initialize();
            List sequences = (List)((Object)meStoreConnection.invokeCommand("13", (Serializable)((Object)WSReliableMessagingStorageManager.getWorkKey(appName, moduleName))));
            for (int i = 0; sequences != null && i < sequences.size(); ++i) {
                int mep;
                RMSequenceBean rmSequenceBean = (RMSequenceBean)sequences.get(i);
                if (!(rmSequenceBean instanceof RMSBean)) continue;
                RMSBean sourceSequence = (RMSBean)rmSequenceBean;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Located Source Sequence " + sourceSequence);
                }
                HashMap<Object, Object> data = new HashMap<Object, Object>();
                data.put(WSRMConstants.WORK_KEY, WSReliableMessagingStorageManager.getWorkKey(appName, moduleName));
                data.put(WSRMConstants.RMS_BEAN, sourceSequence);
                byte[] msgContextBytes = (byte[])meStoreConnection.invokeCommand("26", data);
                if (msgContextBytes == null) continue;
                MessageContext msgContext = this.deserializeMessageContext(msgContextBytes);
                AxisOperation axisOp = msgContext.getAxisOperation();
                if (axisOp != null && ((mep = axisOp.getAxisSpecificMEPConstant()) == 12 || mep == 16)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Recovered 2-way mep " + mep);
                    }
                    Tr.warning(tc, "PERSISTED_TWO_WAY_CWSKA0701");
                    break;
                }
                WSClientMetaDataNameHolder mdnh = new WSClientMetaDataNameHolder();
                mdnh.setApplicationName(moduleMetaData.getJ2EEName().getApplication());
                mdnh.setModuleName(moduleMetaData.getJ2EEName().getModule());
                WSClientConfigurationFactory.setClientMetaDataNameHolder(mdnh);
                ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                URL wsdlLocation = (URL)msgContext.getProperty("WSDL_LOCATION");
                QName serviceQName = (QName)msgContext.getProperty("SERVICE_QNAME");
                String serviceClassName = (String)msgContext.getProperty("SERVICE_CLASS_NAME");
                QName portQName = (QName)msgContext.getProperty("PORT_QNAME");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Recovered wsdl " + wsdlLocation + " : " + serviceQName + " : " + serviceClassName + " : " + portQName);
                }
                try {
                    if (serviceClassName == null) continue;
                    Class<?> serviceClass = classLoader.loadClass(serviceClassName);
                    Service service = null;
                    ServiceDescription description = DescriptionFactory.createServiceDescription(wsdlLocation, serviceQName, serviceClass);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loaded service description " + description);
                    }
                    if (wsdlLocation == null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "null wsdl url");
                        }
                        service = (Service)serviceClass.newInstance();
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "wsdl url=" + wsdlLocation);
                            Tr.debug(tc, "sei=" + msgContext.getProperty("CLIENT_SEI_CLASS"));
                        }
                        Constructor<?> constructor = serviceClass.getConstructor(URL.class, QName.class);
                        service = (Service)constructor.newInstance(wsdlLocation, serviceQName);
                    }
                    boolean portExists = false;
                    Iterator ports = service.getPorts();
                    while (ports.hasNext()) {
                        QName currentPortName = (QName)ports.next();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "port " + currentPortName);
                        }
                        if (!currentPortName.equals(portQName)) continue;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "port found");
                        }
                        portExists = true;
                        break;
                    }
                    if (portExists) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "getPort");
                        }
                        service.getPort(portQName, classLoader.loadClass((String)msgContext.getProperty("CLIENT_SEI_CLASS")));
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "add port");
                    }
                    service.addPort(portQName, (String)msgContext.getProperty("CLIENT_BINDING_ID"), (String)msgContext.getProperty("EPR_ADDR"));
                    continue;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.loadAvailableSequences", "1:512:1.10", this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Caught exception when trying to load a sequence", e);
                    continue;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(currentClassloader);
                }
            }
            meStoreConnection.close();
        }
        catch (MEStoreConnectionException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.loadAvailableSequences", "1:532:1.10", this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "loadAvailableSequences");
        }
    }

    private MessageContext deserializeMessageContext(byte[] msgContextBytes) throws RuntimeError {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "deserializeMessageContext", new Object[]{msgContextBytes});
        }
        MessageContext messageContext = null;
        try {
            if (msgContextBytes != null) {
                ByteArrayInputStream inStream = new ByteArrayInputStream(msgContextBytes);
                ObjectInputStream inObjStream = new ObjectInputStream(inStream);
                messageContext = (MessageContext)inObjStream.readObject();
                inStream.close();
            }
        }
        catch (IOException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.deserializeMessageContext", "1:579:1.10", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deserializeMessageContext", e);
            }
            throw new RuntimeError(e);
        }
        catch (ClassNotFoundException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.websvcs.rm.WSRMComponentImpl.deserializeMessageContext", "1:590:1.10", this);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "deserializeMessageContext", e);
            }
            throw new RuntimeError(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "deserializeMessageContext", messageContext);
        }
        return messageContext;
    }
}

