/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmStack;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.pmi.reqmetrics.PmiRmUtil;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterCfg;
import com.ibm.ws.pmi.reqmetrics.wsHandlers.WsFilterValue;
import com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsHandlerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class ReqMetricsServerHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register(ReqMetricsServerHandler.class.getName(), "pmi.rm", "com.ibm.ws.websvcs.pmi.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int NAMESPACE_ID = 3;
    public static final int INPUT_MESSAGE_ID = 4;
    public static final int METHOD_INFO_OFFSET = 0;
    public static final String RM_SRV_START = "REQMETRICS_WS_SERVER_START";
    public static final int num_webservices_ctx_names = 5;
    private static final String WSDL_PORT = "WsdlPort";
    private static final String WSDL_LOC = "WsdlLocation";

    public ReqMetricsServerHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReqMetricsServerHandler is initialized");
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        try {
            String MEP2 = msgCtx.getAxisOperation().getMessageExchangePattern();
            int FLOW = msgCtx.getFLOW();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message Exchange Pattern " + MEP2);
                Tr.debug(tc, "FLOW                     " + FLOW);
            }
            if ("http://www.w3.org/2004/08/wsdl/in-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/in-only".equals(MEP2)) {
                if (this.impl.isComponentEnabled(3)) {
                    Tr.info(tc, "Request Metrics does not instrument one-way webservice(JAX-WS) request");
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            if (msgCtx.getFLOW() == 1) {
                this.handleRequest(msgCtx);
            } else if (msgCtx.getFLOW() == 2) {
                this.handleResponse(msgCtx);
            } else if (msgCtx.getFLOW() == 4) {
                this.handleFault(msgCtx);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Tr.error(tc, "During the invocation of Request Metrics Server Handler, the following exception was encountered: " + e.toString() + "\n" + sw.toString());
            throw new AxisFault("An error occurred during the request in the Request Metrics server Handler.", e);
        }
    }

    public boolean handleRequest(MessageContext context) {
        boolean trDebugEnabled;
        block31: {
            block33: {
                block32: {
                    if (this.impl == null) {
                        return true;
                    }
                    if (!this.impl.isEnabled()) break block32;
                    if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block33;
                }
                return true;
            }
            boolean bl = trDebugEnabled = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            if (trDebugEnabled) {
                Tr.entry(tc, "handleRequest");
            }
            try {
                PmiRmThreadCtx ctx = this.impl.getThreadContext();
                ReqMetricsServerHandler reqMetricsServerHandler = this;
                PmiRmConfigData cfg = reqMetricsServerHandler.impl.getConfig();
                String[] ctxValues = null;
                byte[] armCor = null;
                Object rmCor = null;
                boolean hasCorrelatorInStack = false;
                boolean hasIncomingCorrelator = true;
                PmiRmArmTx armTx = PmiRmArmStack.peekTransaction();
                if (armTx != null) {
                    if (trDebugEnabled) {
                        Tr.debug(tc, "handleRequest: peekTransaction returns a PmiRmArmTx");
                    }
                    if (armTx instanceof PmiRmCallContext) {
                        PmiRmCallContext cc = (PmiRmCallContext)armTx;
                        PmiRmCorrelator thisCor = cc.getCorrelator();
                        if (trDebugEnabled) {
                            Tr.debug(tc, "PmiRmCorrelator is " + thisCor.formatAsParent());
                        }
                        hasCorrelatorInStack = true;
                        armCor = armTx.getCorrelatorBytes();
                    } else {
                        if (trDebugEnabled) {
                            Tr.debug(tc, "The parent correlator is not a PmiRmCallContext");
                        }
                        hasCorrelatorInStack = true;
                        armCor = armTx.getCorrelatorBytes();
                    }
                }
                if (!hasCorrelatorInStack) {
                    if (trDebugEnabled) {
                        Tr.debug(tc, "handleRequest: do not have correlator on the stack, check incoming correlator");
                    }
                    String[] correlators = this.getCorrelatorsFromContext(context);
                    boolean fTraceRequest = true;
                    if (correlators[0] == null && correlators[1] == null) {
                        ctxValues = this.getContextValues(context);
                        fTraceRequest = this.isFilterPassed(ctxValues, cfg);
                    }
                    this.impl.setInboundCorrelators((Object)ctx, 3, correlators, fTraceRequest);
                    int incomingCorStatus = ctx.getInboundCorrelatorType();
                    if (incomingCorStatus == 1) {
                        hasIncomingCorrelator = false;
                    } else {
                        if (incomingCorStatus == 2) {
                            if (trDebugEnabled) {
                                Tr.exit(tc, "handleRequest: request not pass filter at upstream, stop instrumentation now");
                            }
                            return true;
                        }
                        hasIncomingCorrelator = true;
                    }
                    if (trDebugEnabled) {
                        Tr.debug(tc, "handleRequest: pushIncomingCorrelators return status=" + incomingCorStatus + ", hasIncomingCorrelator=" + hasIncomingCorrelator);
                    }
                }
                if (!ctx.getTrace()) {
                    return true;
                }
                if (!this.impl.isComponentEnabled(3) && (hasCorrelatorInStack || hasIncomingCorrelator)) {
                    if (trDebugEnabled) {
                        Tr.exit(tc, "handleRequest: Web Sevices component is not enabled for request metrics instrumentation. Do not create sub-transaction");
                    }
                    return true;
                }
                boolean needTransactionTrace = this.isTraceEnabled(armCor);
                if (!needTransactionTrace && !this.impl.isLogEnabled()) {
                    if (trDebugEnabled) {
                        Tr.exit(tc, "handleRequest: stop tracing because this transaction is not enabled for ARM and log tracing");
                    }
                    return true;
                }
                if (ctxValues == null) {
                    ctxValues = this.getContextValues(context);
                }
                String tranName = this.getTranName(ctxValues);
                this.impl.reqStart(ctx, 3, needTransactionTrace, tranName, ctxValues);
                if (needTransactionTrace) {
                    int startHandle = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)ctx);
                    if (trDebugEnabled) {
                        Tr.debug(tc, "calling MessageContext.setProperty for startHandler=" + startHandle);
                    }
                    context.setProperty(RM_SRV_START, new Integer(startHandle));
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler.handleRequest", FFDC_ID_1);
                Tr.warning(tc, "PMRM0108E", ex.toString());
                if (!trDebugEnabled) break block31;
                ex.printStackTrace();
            }
        }
        if (trDebugEnabled) {
            Tr.exit(tc, "handleRequest");
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        boolean trDebug;
        block7: {
            block6: {
                if (this.impl == null) {
                    return true;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block7;
            }
            return true;
        }
        boolean bl = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            Tr.entry(tc, "handleResponse");
        }
        this.tranEnd(context, 0);
        if (trDebug) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext context) {
        boolean trDebug;
        block7: {
            block6: {
                if (this.impl == null) {
                    return true;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block7;
            }
            return true;
        }
        boolean bl = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            Tr.entry(tc, "handleFault");
        }
        this.tranEnd(context, 2);
        if (trDebug) {
            Tr.exit(tc, "handleFault");
        }
        return true;
    }

    public void handleClosure(MessageContext context) {
        boolean trDebug;
        block7: {
            block6: {
                if (this.impl == null) {
                    return;
                }
                if (!this.impl.isEnabled()) break block6;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)3)) break block7;
            }
            return;
        }
        boolean bl = trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (trDebug) {
            Tr.entry(tc, "handleClosure");
        }
        this.tranEnd(context, 0);
        if (trDebug) {
            Tr.exit(tc, "handleClosure");
        }
    }

    private void tranEnd(MessageContext context, int status) {
        block12: {
            Tr.entry(tc, "tranEnd");
            try {
                PmiRmArmTx armTx;
                PmiRmThreadCtx threadCtx = this.impl.getThreadContext();
                if (!this.impl.isComponentEnabled(3)) {
                    if (threadCtx.getInboundComponent() != 3) {
                        return;
                    }
                    if (!threadCtx.isInboundInstrumented()) {
                        return;
                    }
                }
                if ((armTx = PmiRmArmWrapper.peekArmTransaction((PmiRmThreadCtx)threadCtx)) == null) {
                    if (this.impl.isLogEnabled() || this.impl.isARMEnabled()) {
                        Tr.error(tc, "PMRM0030E");
                    }
                    Tr.exit(tc, "tranEnd");
                    return;
                }
                boolean armStartCalled = false;
                Integer handleObj = (Integer)context.getProperty(RM_SRV_START);
                if (handleObj != null) {
                    int startHandleAtStack;
                    int startHandle = handleObj;
                    if (startHandle != (startHandleAtStack = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)threadCtx))) {
                        Tr.warning(tc, "PMRM0213W", "tranEnd");
                    } else {
                        armStartCalled = true;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "tranEnd: armStartCalled=" + armStartCalled);
                }
                Properties props = null;
                if (armStartCalled) {
                    // empty if block
                }
                this.impl.reqStop((Object)threadCtx, armStartCalled, status, props);
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler.tranEnd", FFDC_ID_2);
                Tr.warning(tc, "PMRM0108E", ex.toString());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                ex.printStackTrace();
            }
        }
        Tr.exit(tc, "tranEnd");
    }

    private String getTranName(String[] ctxValues) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTranName");
        }
        StringBuffer ret = new StringBuffer();
        ret.append("wsprovider:");
        ret.append(ctxValues[0]);
        if (ctxValues[1] == null) {
            ret.append(".");
        } else {
            ret.append(".").append(ctxValues[1]);
        }
        ret.append("?transport=").append(ctxValues[2]);
        if (ctxValues[3] == null) {
            ret.append("&namespace=");
        } else {
            ret.append("&namespace=").append(ctxValues[3]);
        }
        ret.append("&input=").append(ctxValues[4]);
        String retStr = ret.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranName returns " + retStr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTranName");
        }
        return retStr;
    }

    private String[] getContextValues(MessageContext msgctx) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getContextValues");
        }
        String[] ret = new String[5];
        if (msgctx == null) {
            return ret;
        }
        AxisService axisSvc = msgctx.getAxisService();
        Parameter port = axisSvc.getParameter(WSDL_PORT);
        QName operation = msgctx.getAxisOperation().getName();
        if (port == null) {
            ret[0] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: portQName is null");
            }
        } else {
            ret[0] = (String)port.getValue();
        }
        if (operation == null) {
            ret[1] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: operationName is null");
            }
        } else {
            ret[1] = operation.getLocalPart();
        }
        ret[2] = msgctx.getIncomingTransportName();
        ret[3] = axisSvc.getTargetNamespace();
        AxisMessage inputMsg = msgctx.getAxisOperation().getMessage("In");
        if (inputMsg == null) {
            ret[4] = "";
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "ReqMetricsServerHandler.getContextValues: inputMsg is null");
            }
        } else {
            ret[4] = inputMsg.getName();
        }
        return ret;
    }

    protected Properties getMetricsData(MessageContext msgctx, int level, boolean showPrivateContent) {
        Properties props;
        block13: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.entry(tc, "getMetricsData: level=" + level);
            }
            if (msgctx == null) {
                return null;
            }
            AxisService axisSvc = msgctx.getAxisService();
            props = new Properties();
            if (level >= 2) {
                Parameter port = axisSvc.getParameter(WSDL_PORT);
                if (port != null) {
                    props.put("WS_PORT_NM", port.getValue());
                } else {
                    props.put("WS_PORT_NM", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getMetricsData: WSDLPort QName is null");
                    }
                }
                QName operation = msgctx.getAxisOperation().getName();
                props.put("WS_OP_NM", operation.getLocalPart());
                props.put("WS_TRAN_NM", msgctx.getIncomingTransportName());
                props.put("WS_TGT_NS", axisSvc.getTargetNamespace());
                AxisMessage inputMsg = msgctx.getAxisOperation().getMessage("In");
                if (inputMsg != null) {
                    props.put("WS_IN_MSG_NM", inputMsg.getName());
                } else {
                    props.put("WS_IN_MSG_NM", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getMetricsData: inputMsg QName is null");
                    }
                }
            }
            if (level == 3) {
                Parameter param = axisSvc.getParameter(WSDL_LOC);
                props.put("WS_WSDL_LOC", param != null ? param.getValue() : null);
                if (showPrivateContent) {
                    try {
                        SOAPEnvelope envelope = msgctx.getEnvelope();
                        SOAPBody soapbody = envelope.getBody();
                        props.put("WS_SOAP_BD", soapbody);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsServerHandler.getMetricsData", FFDC_ID_4);
                        Tr.warning(tc, "PMRM0108E", ex.toString());
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block13;
                        ex.printStackTrace();
                    }
                }
            }
        }
        return props;
    }

    private String[] getCorrelatorsFromContext(MessageContext context) {
        try {
            boolean trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
            SOAPEnvelope se = context.getEnvelope();
            SOAPHeader sh = se.getHeader();
            String armCorStr = null;
            String rmCorStr = null;
            if (sh != null) {
                QName rmCorName = new QName("", "rm_correlator", "");
                Iterator iter = sh.extractHeaderBlocks("reqmetricsURI");
                boolean found = false;
                QName headerElementName = null;
                String localName = null;
                while (iter.hasNext()) {
                    SOAPHeaderBlock shb;
                    if (trDebug) {
                        Tr.debug(tc, "ReqMetricsServerHandler.getCorrelatorsFromContext: find a header element");
                    }
                    if ((localName = (headerElementName = (shb = (SOAPHeaderBlock)iter.next()).getQName()).getLocalPart()).indexOf("arm_correlator") != -1 || localName.indexOf("correlator") != -1) {
                        armCorStr = shb.getText();
                        rmCorStr = shb.getAttributeValue(rmCorName);
                        found = true;
                    }
                    if (found && trDebug) {
                        Tr.debug(tc, "getCorrelatorsFromContext armCorStr=" + armCorStr + ", rmCorStr=" + rmCorStr);
                    }
                    if (!found) continue;
                    break;
                }
            }
            return new String[]{armCorStr, rmCorStr};
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsServerHandler.getCorrelatorsFromContext", FFDC_ID_5, this);
            ex.printStackTrace();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                ex.printStackTrace();
            }
            return new String[]{null, null};
        }
    }

    private boolean isFilterPassed(String[] ctxValues, PmiRmConfigData cfg) {
        WsFilterCfg wsCfg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isFilterPassed");
        }
        if (!(wsCfg = (WsFilterCfg)cfg.getWSFilterConfig()).isEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFilterPassed returns true because this filter is not enabled");
            }
            return true;
        }
        for (int i = 0; i < wsCfg.getParsedValues().length; ++i) {
            WsFilterValue v = wsCfg.getParsedValues()[i];
            if (!v.isEnabled() || !PmiRmUtil.isStrMatched((String)v.getPort(), (String)ctxValues[0]) || !PmiRmUtil.isStrMatched((String)v.getOperation(), (String)ctxValues[1]) || !PmiRmUtil.isStrMatched((String)v.getNameSpace(), (String)ctxValues[3])) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isFilterPassed returns true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isFilterPassed returns false");
        }
        return false;
    }

    public Properties getTranDetailProps(PmiRmThreadCtx threadCtx, int regId, MessageContext msgCtx, boolean armStartCalled) {
        int level = this.impl.getTranDetailLevel((Object)threadCtx, 3);
        if (level < 2 || msgCtx == null) {
            return null;
        }
        return this.getContextInfo(threadCtx, msgCtx);
    }
}

