/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.pmi.reqmetrics;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTx;
import com.ibm.websphere.pmi.reqmetrics.PmiRmArmTxFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.reqmetrics.PmiReqMetricsImpl;
import com.ibm.ws.pmi.reqmetrics.PmiRmArmWrapper;
import com.ibm.ws.pmi.reqmetrics.PmiRmCallContext;
import com.ibm.ws.pmi.reqmetrics.PmiRmConfigData;
import com.ibm.ws.pmi.reqmetrics.PmiRmCorrelator;
import com.ibm.ws.pmi.reqmetrics.PmiRmThreadCtx;
import com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsHandlerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;

public class ReqMetricsClientHandler
extends ReqMetricsHandlerBase {
    private static final TraceComponent tc = Tr.register(ReqMetricsClientHandler.class.getName(), "pmi.rm", "com.ibm.ws.websvcs.pmi.reqmetrics");
    private static final String SOURCE_FILE = "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler";
    private static final String FFDC_ID_1 = "FFDC-1";
    private static final String FFDC_ID_2 = "FFDC-2";
    private static final String FFDC_ID_3 = "FFDC-3";
    private static final String FFDC_ID_4 = "FFDC-4";
    private static final String FFDC_ID_5 = "FFDC-5";
    public static final String PORT_NAME = "wsdlPort";
    public static final String OP_NAME = "opName";
    public static final String TRANSPORT_NAME = "transportName";
    public static final String TARGET_ENDPOINRT = "targetEndpoint";
    public static final String PARAM_NAMES = "paramNames";
    public static final String SERVICE_REF_NAME = "serviceReferenceName";
    public static final String RESPONSE_MSG = "responseMessage";
    public static final int PORT_ID = 0;
    public static final int OP_ID = 1;
    public static final int TRANSPORT_ID = 2;
    public static final int PARAMS_ID = 3;
    public static final String RM_CLNT_START = "REQMETRICS_WS_CLIENT_START";
    private static final boolean trDebug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    private static final String TGT_ENDPT_ADDR = "javax.xml.ws.service.endpoint.address";
    private static final String WSDL_SVC_NM = "WSDL_SERVICE_QNAME";
    private static final String WSDL_PORT = "WSDL_PORT";

    public ReqMetricsClientHandler() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "ReqMetricsClientHandler is initialized");
        }
    }

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        try {
            if (this.impl == null) {
                return Handler.InvocationResponse.CONTINUE;
            }
            String MEP2 = msgCtx.getAxisOperation().getMessageExchangePattern();
            int FLOW = msgCtx.getFLOW();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Message Exchange Pattern " + MEP2);
                Tr.debug(tc, "FLOW                     " + FLOW);
            }
            if ("http://www.w3.org/2004/08/wsdl/out-only".equals(MEP2) || "http://www.w3.org/2006/01/wsdl/out-only".equals(MEP2)) {
                if (this.impl.isComponentEnabled(4)) {
                    Tr.info(tc, "Request Metrics does not instrument one-way webservice(JAX-WS) requests");
                }
                return Handler.InvocationResponse.CONTINUE;
            }
            if (msgCtx.getFLOW() == 2) {
                this.handleRequest(msgCtx);
            } else if (msgCtx.getFLOW() == 1) {
                this.handleResponse(msgCtx);
            } else if (msgCtx.getFLOW() == 3) {
                this.handleFault(msgCtx);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Tr.error(tc, "During the invocation of Request Metrics Client Handler, the following exception was encountered: " + e.toString() + "\n" + sw.toString());
            throw new AxisFault("An error occurred during the request in the Request Metrics client Handler.", e);
        }
    }

    public boolean handleRequest(MessageContext msgCtx) {
        block27: {
            block29: {
                block28: {
                    if (this.impl == null) {
                        this.impl = PmiReqMetricsImpl.getInstance();
                        if (this.impl == null) {
                            return true;
                        }
                    }
                    if (trDebug) {
                        Tr.entry(tc, "handleRequest");
                    }
                    if (!this.impl.isReallyEnabled()) break block28;
                    if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4)) break block29;
                }
                return true;
            }
            if (trDebug) {
                Tr.debug(tc, "handleRequest");
            }
            PmiRmArmTx armTx = null;
            PmiRmThreadCtx threadCtx = null;
            try {
                threadCtx = this.impl.getThreadContext();
                if (!this.impl.isComponentEnabled(4)) {
                    if (trDebug) {
                        Tr.debug(tc, "handleRequest: Web Sevices component is not enabled for request metrics instrumentation. Do not create sub-transaction");
                    }
                } else {
                    if (!threadCtx.getTrace()) {
                        return true;
                    }
                    byte[] parentArmCorBytes = PmiRmArmWrapper.getArmCorrelator((PmiRmThreadCtx)threadCtx);
                    boolean needTransactionTrace = this.isTraceEnabled(parentArmCorBytes);
                    if (needTransactionTrace || this.impl.isLogEnabled()) {
                        String tranName = this.getTranName(msgCtx);
                        PmiRmConfigData cfg = threadCtx.getConfig();
                        if (cfg == null) {
                            ReqMetricsClientHandler reqMetricsClientHandler = this;
                            cfg = reqMetricsClientHandler.impl.getConfig();
                        }
                        String[] ctxValues = null;
                        if (cfg.isTraceDebugEnabled() && cfg.isARMEnabled() && this.impl.getArmType() == PmiRmArmTxFactory.ARM4_TYPE) {
                            ctxValues = this.getContextValues(msgCtx);
                        }
                        this.impl.updateBegin((Object)threadCtx, 4, needTransactionTrace, "Web Services Requestor", tranName, ctxValues);
                        if (!needTransactionTrace) {
                            int startHandle = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)threadCtx);
                            msgCtx.getOperationContext().setProperty(RM_CLNT_START, new Integer(startHandle));
                            if (trDebug) {
                                Tr.debug(tc, "calling MessageContext.setProperty for startHandle=" + startHandle);
                            }
                        }
                    }
                }
                armTx = PmiRmArmWrapper.peekArmTransaction((PmiRmThreadCtx)threadCtx);
                PmiRmCallContext cc = null;
                PmiRmCorrelator cor = null;
                if (armTx == null) {
                    if (this.impl.isLogEnabled() || this.impl.isARMEnabled()) {
                        Tr.warning(tc, "PMRM0210W", "handleRequest");
                    }
                    return true;
                }
                if (trDebug) {
                    Tr.debug(tc, "handleRequest: find a correlator on stack");
                }
                if (armTx instanceof PmiRmCallContext) {
                    if (trDebug) {
                        Tr.debug(tc, "handleRequest: get PmiRmCallContext");
                    }
                    cc = (PmiRmCallContext)armTx;
                    cor = cc.getCorrelator();
                } else if (trDebug) {
                    Tr.debug(tc, "handleRequest: get armTx");
                }
                byte[] armCor = armTx.getCorrelatorBytes();
                this.impl.getArmWrapper();
                String armCorStr = PmiRmArmWrapper.toHexString((byte[])armCor);
                String rmCorStr = PmiRmCorrelator.getStringFromPmiRmCorrelator((PmiRmCorrelator)cor);
                if (armCorStr == null && rmCorStr == null) {
                    Tr.warning(tc, "both ARM and request metrics correlators are null");
                    Tr.exit(tc, "handleRequest");
                    return true;
                }
                this.addCorrelatorsToSoapHeader(msgCtx, armCorStr, rmCorStr);
                ReqMetricsClientHandler reqMetricsClientHandler = this;
                this.updateHttpHeader(msgCtx, reqMetricsClientHandler.impl.getConfig().getArmCorrelatorHeaderName(), "DoNotTraceLowerProtocol");
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler.handleRequest", FFDC_ID_1);
                Tr.warning(tc, "PMRM0108E", ex.toString());
                if (!trDebug) break block27;
                ex.printStackTrace();
            }
        }
        Tr.exit(tc, "handleRequest");
        return true;
    }

    private void addCorrelatorsToSoapHeader(MessageContext msgCtx, String armCorStr, String rmCorStr) {
        block7: {
            try {
                if (trDebug) {
                    Tr.entry(tc, "addCorrelatorsToSoapHeader");
                }
                SOAPEnvelope se = msgCtx.getEnvelope();
                SOAPHeader sh = se.getHeader();
                SOAP12Factory sf = new SOAP12Factory();
                if (sh == null) {
                    sh = sf.createSOAPHeader();
                }
                OMFactory factory = OMAbstractFactory.getOMFactory();
                OMNamespace ns1 = factory.createOMNamespace("http://websphere.ibm.com", "reqmetrics");
                SOAPHeaderBlock shb = sh.addHeaderBlock("arm_correlator", ns1);
                shb.setText(armCorStr);
                shb.setRole("reqmetricsURI");
                if (rmCorStr != null) {
                    OMNamespace ns2 = shb.declareNamespace("", "");
                    shb.addAttribute("rm_correlator", rmCorStr, ns2);
                    QName rmCorName = new QName("", "rm_correlator", "");
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug(tc, "addCorrelatorsToSoapHeader: add rm cor attribute=" + shb.getAttributeValue(rmCorName));
                    }
                }
                if (trDebug) {
                    Tr.exit(tc, "addCorrelatorsToSoapHeader: add arm cor value=" + shb.getText());
                }
            }
            catch (Exception ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.pmi.reqmetrics.wsHandlers.ReqMetricsClientHandler.addCorrelatorsToSoapHeader", FFDC_ID_5, this);
                ex.printStackTrace();
                if (!trDebug) break block7;
                ex.printStackTrace();
            }
        }
    }

    private void updateHttpHeader(MessageContext msgCtx, String headerName, String headerValue) {
        HashMap<String, String> requestHeaders;
        if (trDebug) {
            Tr.entry(tc, "updateHttpHeader");
        }
        if ((requestHeaders = (HashMap<String, String>)msgCtx.getProperty("com.ibm.websphere.webservices.requestTransportProperties")) == null) {
            requestHeaders = new HashMap<String, String>();
            if (trDebug) {
                Tr.debug(tc, "updateHttpHeader: no HashMap is found, create a new one");
            }
        } else if (trDebug) {
            Tr.debug(tc, "updateHttpHeader: HashMap is found, use the existing one");
        }
        if (trDebug) {
            Tr.debug(tc, "updateHttpHeader: requestheaders.put name=" + headerName + ", value=" + headerValue);
        }
        requestHeaders.put(headerName, headerValue);
        msgCtx.setProperty("com.ibm.websphere.webservices.requestTransportProperties", requestHeaders);
        if (trDebug) {
            Tr.exit(tc, "udpateHttpHeader");
        }
    }

    public boolean handleResponse(MessageContext msgCtx) {
        block6: {
            block5: {
                if (this.impl == null || !this.impl.isEnabled()) break block5;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4) && this.impl.isComponentEnabled(4)) break block6;
            }
            return true;
        }
        if (trDebug) {
            Tr.entry(tc, "handleResponse");
        }
        this.tranEnd(msgCtx, 0);
        if (trDebug) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    public boolean handleFault(MessageContext msgCtx) {
        block6: {
            block5: {
                if (this.impl == null || !this.impl.isEnabled()) break block5;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4) && this.impl.isComponentEnabled(4)) break block6;
            }
            return true;
        }
        if (trDebug) {
            Tr.entry(tc, "handleFault");
        }
        this.tranEnd(msgCtx, 2);
        if (trDebug) {
            Tr.exit(tc, "handleFault");
        }
        return true;
    }

    public void handleClosure(MessageContext msgCtx) {
        block5: {
            block4: {
                if (this.impl == null || !this.impl.isEnabled()) break block4;
                if (PmiReqMetricsImpl.isComponentEnabledInArmCallback((int)4) && this.impl.isComponentEnabled(4)) break block5;
            }
            return;
        }
        if (trDebug) {
            Tr.debug(tc, "handleClosure");
        }
        this.tranEnd(msgCtx, 0);
    }

    private void tranEnd(MessageContext msgCtx, int status) {
        block10: {
            if (trDebug) {
                Tr.entry(tc, "tranEnd");
            }
            try {
                PmiRmThreadCtx threadCtx = this.impl.getThreadContext();
                if (!threadCtx.getTrace()) {
                    return;
                }
                boolean armStartCalled = false;
                Integer handleObj = (Integer)msgCtx.getOperationContext().getProperty(RM_CLNT_START);
                if (trDebug) {
                    Tr.debug(tc, "HandleObj from MessageContext  " + msgCtx + "  handle   " + handleObj);
                }
                if (handleObj != null) {
                    int startHandleAtStack;
                    int startHandle = handleObj;
                    if (startHandle != (startHandleAtStack = PmiRmArmWrapper.getStartHandle((PmiRmThreadCtx)threadCtx))) {
                        Tr.warning(tc, "PMRM0213W", "tranEnd");
                    } else {
                        armStartCalled = true;
                    }
                }
                Properties props = null;
                if (armStartCalled) {
                    props = this.getContextInfo(threadCtx, msgCtx);
                }
                this.impl.updateEnd((Object)threadCtx, armStartCalled, status, props);
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler.tranEnd", FFDC_ID_2);
                Tr.warning(tc, "PMRM0108E", ex.toString());
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                ex.printStackTrace();
            }
        }
        if (trDebug) {
            Tr.exit(tc, "tranEnd");
        }
    }

    protected Properties getMetricsData(MessageContext msgCtx, int level, boolean showPrivateContent) {
        Properties props;
        block11: {
            if (trDebug) {
                Tr.debug(tc, "getMetricsData: level=" + level);
            }
            props = new Properties();
            if (level >= 2) {
                String opName = "";
                Object[] params = this.getOperation(msgCtx.getEnvelope());
                StringBuffer paramList = new StringBuffer();
                if (params.length > 0) {
                    opName = params[0].toString();
                    for (int i = 1; i < params.length; ++i) {
                        paramList.append(params[i].toString());
                        if (i >= params.length - 1) continue;
                        paramList.append(",");
                    }
                }
                Parameter portName = msgCtx.getAxisService().getParameter(WSDL_PORT);
                String transport = msgCtx.getTransportOut().getName();
                if (portName != null) {
                    props.put("WS_PORT_NM", portName.getValue().toString());
                } else {
                    props.put("WS_PORT_NM", "");
                }
                props.put("WS_OP_NM", opName);
                props.put("WS_TRAN_NM", transport);
                props.put("WS_PRM_Q_NM_LST", paramList.toString());
            }
            if (level == 3) {
                String endptAddr = (String)msgCtx.getOptions().getProperties().get(TGT_ENDPT_ADDR);
                Parameter svcName = msgCtx.getAxisService().getParameter(WSDL_SVC_NM);
                props.put("WS_TGT_E_ADR", endptAddr);
                if (svcName != null) {
                    props.put("WS_SVC_REF_NM", svcName.getValue().toString());
                }
                if (showPrivateContent) {
                    try {
                        SOAPEnvelope envelope = msgCtx.getEnvelope();
                        SOAPBody soapbody = envelope.getBody();
                        props.put("WS_RESP_MSG", soapbody);
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException(ex, "com.ibm.ws.websvcs.pmi.reqmetrics.ReqMetricsClientHandler.getMetricsData", FFDC_ID_4);
                        Tr.warning(tc, "PMRM0108E", ex.toString());
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                        ex.printStackTrace();
                    }
                }
            }
        }
        return props;
    }

    protected String getTranName(MessageContext msgCtx) {
        Parameter portName = msgCtx.getAxisService().getParameter(WSDL_PORT);
        String transport = msgCtx.getTransportOut().getName();
        String opName = "";
        Object[] params = this.getOperation(msgCtx.getEnvelope());
        StringBuffer paramList = new StringBuffer();
        if (params.length > 0) {
            opName = params[0].toString();
            for (int i = 1; i < params.length; ++i) {
                paramList.append(params[i].toString());
                if (i >= params.length - 1) continue;
                paramList.append(",");
            }
        }
        StringBuffer ret = new StringBuffer();
        ret.append("wsrequestor:");
        if (portName != null) {
            ret.append(portName.getValue());
        } else {
            if (trDebug) {
                Tr.debug(tc, "getTranName, portQName is null");
            }
            ret.append("");
        }
        if (opName == null) {
            ret.append(".");
        } else {
            ret.append(".").append(opName);
        }
        ret.append("?transport=").append(transport);
        ret.append("&parameters=").append(paramList.toString());
        String retStr = ret.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "getTranName returns " + retStr);
        }
        return retStr;
    }

    protected String[] getContextValues(MessageContext msgCtx) {
        String[] retVal = new String[4];
        AxisService axisSvc = msgCtx.getAxisService();
        Parameter portName = axisSvc.getParameter(WSDL_PORT);
        Object[] params = this.getOperation(msgCtx.getEnvelope());
        if (params.length > 0) {
            retVal[1] = params[0].toString();
            StringBuffer paramList = new StringBuffer();
            for (int i = 1; i < params.length; ++i) {
                paramList.append(params[i].toString());
                if (i >= params.length - 1) continue;
                paramList.append(",");
            }
            retVal[3] = paramList.toString();
        }
        retVal[0] = portName != null ? (String)portName.getValue() : "";
        retVal[2] = msgCtx.getTransportOut().getName();
        return retVal;
    }

    public Properties getTranDetailProps(PmiRmThreadCtx threadCtx, int regId, MessageContext msgCtx, boolean armStartCalled) {
        int level = this.impl.getTranDetailLevel((Object)threadCtx, 4);
        if (level < 2 || msgCtx == null) {
            return null;
        }
        return this.getContextInfo(threadCtx, msgCtx);
    }

    private Object[] getOperation(SOAPEnvelope envelope) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            SOAPBody body = envelope.getBody();
            OMElement methName = body.getFirstElement();
            list.add(methName.getLocalName());
            Iterator children = methName.getChildElements();
            while (children.hasNext()) {
                OMElement arg = (OMElement)children.next();
                list.add(arg.getLocalName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list.toArray();
    }
}

