/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaDataSlot;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.runtime.service.MetaDataService;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.websvcs.Constants;
import com.ibm.ws.websvcs.metadata.ClientMetaData;
import com.ibm.ws.websvcs.metadata.MetaDataHolder;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.metadata.WSApplicationMetaDataHolder;

public class WASAxis2MetaDataImpl
implements Constants {
    private static final TraceComponent _tc = Tr.register(WASAxis2MetaDataImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private MetaDataSlot moduleSlot = null;
    private MetaDataSlot applicationSlot = null;
    private MetaDataSlot componentSlot = null;

    public WASAxis2MetaDataImpl(MetaDataService service) {
        if (service != null) {
            this.moduleSlot = service.reserveSlot(ModuleMetaData.class);
            this.applicationSlot = service.reserveSlot(ApplicationMetaData.class);
            this.componentSlot = service.reserveSlot(ComponentMetaData.class);
        }
    }

    public void destroy() {
        ModuleMetaData mmd = this.getModuleMetaData();
        if (mmd != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Destroying webservices module " + mmd + " metadata");
            }
            mmd.setMetaData(this.moduleSlot, null);
        }
    }

    public void setClientModuleMetaData(ClientMetaData clientMetaData, ModuleMetaData mmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setClientModuleMetaData, mmd.name= " + mmd.getName() + ", clientMetaData= " + clientMetaData);
        }
        if (mmd != null) {
            MetaDataHolder holder = (MetaDataHolder)mmd.getMetaData(this.moduleSlot);
            if (holder == null) {
                holder = new MetaDataHolder();
            }
            clientMetaData.setModuleName(mmd.getName());
            holder.setClientMetaData(clientMetaData);
            mmd.setMetaData(this.moduleSlot, holder);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setClientModuleMetaData");
        }
    }

    public void setClientComponentMetaData(ClientMetaData clientMetaData, ComponentMetaData cmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setClientMetadata, cmd.name= " + cmd.getName() + ", clientMetaData= " + clientMetaData);
        }
        if (cmd != null) {
            MetaDataHolder holder;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting ClientModuleMetaData on ComponentMetaData instance: " + cmd);
            }
            if ((holder = (MetaDataHolder)cmd.getMetaData(this.componentSlot)) == null) {
                holder = new MetaDataHolder();
            }
            holder.setClientMetaData(clientMetaData);
            cmd.setMetaData(this.componentSlot, holder);
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Could not set ClientModuleMetaData because ComponentMetaData is null");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setClientMetadata");
        }
    }

    public Object getClientComponentMetaData() {
        ComponentMetaData cmd = this.getComponentMetaData();
        return this.getClientComponentMetaData(cmd);
    }

    public Object getClientComponentMetaData(ComponentMetaData cmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClientComponentMetaData");
        }
        ClientMetaData clientMetaData = null;
        if (cmd != null) {
            MetaDataHolder mdh;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Looking for client metadata on ComponentMetaData instance: " + cmd);
            }
            if ((mdh = (MetaDataHolder)cmd.getMetaData(this.componentSlot)) != null) {
                clientMetaData = mdh.getClientMetaData();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClientComponentMetaData, clientMetaData= " + clientMetaData);
        }
        return clientMetaData;
    }

    public Object getClientModuleMetaData() {
        ModuleMetaData mmd = this.getModuleMetaData();
        return this.getClientModuleMetaData(mmd);
    }

    public Object getClientModuleMetaData(ModuleMetaData mmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClientModuleMetaData");
        }
        ClientMetaData clientMetaData = null;
        if (mmd != null) {
            MetaDataHolder mdh;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting client metadata from module metadata slot");
            }
            if ((mdh = (MetaDataHolder)mmd.getMetaData(this.moduleSlot)) != null) {
                clientMetaData = mdh.getClientMetaData();
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getClientModuleMetaData, clientMetaData= " + clientMetaData);
        }
        return clientMetaData;
    }

    public Object getServerModuleMetaData() {
        ModuleMetaData mmd = this.getModuleMetaData();
        return this.getServerModuleMetaData(mmd);
    }

    public Object getServerModuleMetaData(ModuleMetaData mmd) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServerModuleMetaData");
        }
        Object obj = null;
        if (mmd != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting meta data with moduleSlot = " + this.moduleSlot.toString());
            }
            if ((obj = mmd.getMetaData(this.moduleSlot)) == null) {
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "Object returned from getMetaData is null... looking in application metadata for module: " + mmd.getName() + " : " + mmd.getApplicationMetaData());
                }
                ApplicationMetaData amd = mmd.getApplicationMetaData();
                obj = this.getServerModuleMetaData(mmd.getName(), amd);
                if (_tc.isDebugEnabled() && obj != null) {
                    Tr.debug(_tc, "Found metadata in application metadata slot");
                }
                return obj;
            }
            MetaDataHolder mdh = (MetaDataHolder)obj;
            return mdh.getServerModuleMetaData();
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServerModuleMetaData");
        }
        return obj;
    }

    public Object getServerModuleMetaData(String moduleName, ApplicationMetaData amd) {
        WSApplicationMetaDataHolder holder;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getServerModuleMetaData= " + moduleName);
        }
        ServerModuleMetaData obj = null;
        if (amd != null && (holder = (WSApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot)) != null) {
            obj = holder.getServerModuleMetaData(moduleName);
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getServerModuleMetaData= " + moduleName);
        }
        return obj;
    }

    public void setServerModuleMetaData(ModuleMetaData mmd, Object cfgObj) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setServerModuleMetaData");
        }
        if (mmd == null) {
            mmd = this.getModuleMetaData();
        }
        if (mmd == null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "ModuleMetaData is null in setServerModuleMetaData");
        }
        if (cfgObj == null && _tc.isDebugEnabled()) {
            Tr.debug(_tc, "cfgObj is null in setServerModuleMetaData");
        }
        if (cfgObj != null && mmd != null) {
            MetaDataHolder holder;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Setting meta data slot with moduleSlot = " + this.moduleSlot.toString());
            }
            if ((holder = (MetaDataHolder)mmd.getMetaData(this.moduleSlot)) == null) {
                holder = new MetaDataHolder();
            }
            holder.setServerModuleMetaData((ServerModuleMetaData)cfgObj);
            mmd.setMetaData(this.moduleSlot, holder);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Server Module Metadata saved into module.");
            }
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setServerModuleMetaData");
        }
    }

    public MetaDataSlot getApplicationMetaDataSlot() {
        return this.applicationSlot;
    }

    public MetaDataSlot getMetaDataSlot() {
        return this.moduleSlot;
    }

    public ComponentMetaData getComponentMetaData() {
        ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ComponentMetaData object is " + (cmd == null ? "null" : "not null"));
        }
        return cmd;
    }

    public ModuleMetaData getModuleMetaData() {
        ComponentMetaData cmd = this.getComponentMetaData();
        ModuleMetaData mmd = null;
        if (cmd != null) {
            mmd = cmd.getModuleMetaData();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "ModuleMetaData object is " + (mmd == null ? "null" : "not null"));
        }
        return mmd;
    }

    public void addServerModuleMetaData(ApplicationMetaData amd, ServerModuleMetaData smmd) {
        WSApplicationMetaDataHolder holder = (WSApplicationMetaDataHolder)amd.getMetaData(this.applicationSlot);
        if (holder == null) {
            holder = new WSApplicationMetaDataHolder();
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Storing ServerModuleMetadata for module: " + smmd.getModuleKeyName() + " : " + amd);
        }
        holder.addServerModuleMetaData(smmd);
        amd.setMetaData(this.applicationSlot, holder);
    }
}

