/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.handler.lifecycle;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.metadata.ServerModuleMetaData;
import com.ibm.ws.websvcs.resources.NLSProvider;
import com.ibm.wsspi.injectionengine.InjectionException;
import com.ibm.wsspi.injectionengine.InjectionTarget;
import com.ibm.wsspi.injectionengine.InjectionUtil;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import com.ibm.wsspi.websvcs.WASAxis2Service;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.xml.ws.handler.Handler;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.axis2.jaxws.description.ServiceDescription;
import org.apache.axis2.jaxws.handler.lifecycle.factory.HandlerLifecycleManager;
import org.apache.axis2.jaxws.handler.lifecycle.impl.HandlerLifecycleManagerImpl;
import org.apache.axis2.jaxws.injection.ResourceInjectionException;
import org.apache.axis2.jaxws.lifecycle.LifecycleException;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescription;
import org.apache.axis2.jaxws.runtime.description.injection.ResourceInjectionServiceRuntimeDescriptionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSHandlerLifecycleManager
extends HandlerLifecycleManagerImpl
implements HandlerLifecycleManager {
    private static TraceComponent tc = Tr.register(WSHandlerLifecycleManager.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    @Override
    public Handler createHandlerInstance(MessageContext messageContext, Class handlerClass) throws LifecycleException, ResourceInjectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createHandlerInstance, handlerClass= " + handlerClass.getName());
        }
        if (handlerClass == null) {
            String msg = NLSProvider.getNLS().getFormattedMessage("createHandlerFail00", new Object[0], "Internal error. A JAX-WS handler instance could not be created because the handler class is null.");
            throw new LifecycleException(msg);
        }
        try {
            HashMap<Class<?>, InjectionTarget[]> injectionTargets = this.getInjectionTargets();
            this.instance = InjectionUtil.createInjectedInstance((Class)handlerClass, injectionTargets);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Created the following handler instance: " + this.instance);
            }
            ServiceDescription serviceDesc = messageContext.getEndpointDescription().getServiceDescription();
            ResourceInjectionServiceRuntimeDescription injectionDesc = null;
            if (serviceDesc != null) {
                injectionDesc = ResourceInjectionServiceRuntimeDescriptionFactory.get(serviceDesc, handlerClass);
            }
            if (injectionDesc != null && injectionDesc.getPostConstructMethod() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found @PostConstruct method on JAX-WS handler class: " + handlerClass.getName());
                }
                this.invokePostConstruct(injectionDesc.getPostConstructMethod());
            }
        }
        catch (InjectionException injectException) {
            String msg = NLSProvider.getNLS().getFormattedMessage("createHandlerFail01", new Object[]{handlerClass.getName(), injectException}, "An instance of the {0} JAX-WS handler class could not be created due to the following error: {1}");
            throw new ResourceInjectionException(msg);
        }
        catch (IllegalAccessException iae) {
            String msg = NLSProvider.getNLS().getFormattedMessage("createHandlerFail01", new Object[]{handlerClass.getName(), iae}, "An instance of the {0} JAX-WS handler class could not be created due to the following error: {1}");
            throw new LifecycleException(msg);
        }
        catch (InstantiationException instantationException) {
            String msg = NLSProvider.getNLS().getFormattedMessage("createHandlerFail01", new Object[]{handlerClass.getName(), instantationException}, "An instance of the {0} JAX-WS handler class could not be created due to the following error: {1}");
            throw new LifecycleException(msg);
        }
        catch (Exception e) {
            String msg = NLSProvider.getNLS().getFormattedMessage("createHandlerFail01", new Object[]{handlerClass.getName(), e}, "An instance of the {0} JAX-WS handler class could not be created due to the following error: {1}");
            throw new LifecycleException(msg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createHandlerInstance, handlerInstance= " + this.instance);
        }
        return (Handler)this.instance;
    }

    private HashMap<Class<?>, InjectionTarget[]> getInjectionTargets() throws Exception {
        try {
            ServerModuleMetaData smmd;
            WASAxis2Service service = AccessController.doPrivileged(new PrivilegedExceptionAction<WASAxis2Service>(){

                @Override
                public WASAxis2Service run() throws Exception {
                    return WsServiceRegistry.getService(this, WASAxis2Service.class);
                }
            });
            ServerModuleMetaData serverModuleMetaData = smmd = service != null ? (ServerModuleMetaData)service.getModuleMetaData() : null;
            if (smmd != null) {
                HashMap injectionTargets;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found ServerModuleMetaData for WAR endpoint creation");
                }
                if ((injectionTargets = (HashMap)smmd.getInjectionTargets()) != null && !injectionTargets.isEmpty() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found non-empty injection targets in module: " + smmd.getModuleName());
                }
                return injectionTargets;
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof PrivilegedActionException) {
                e = ((PrivilegedActionException)e).getException();
            }
            String msg = NLSProvider.getNLS().getFormattedMessage("injectionMetaDataFail", new Object[]{e}, "Internal error. Injection targets could not be retrieved due to the following error: {0}.");
            throw new Exception(msg);
        }
    }
}

